#!/bin/bash

read -p "Enter replicaCount number to scale as number greater than 1:" NUM

if [[ -z "$NUM" ]]; then
   printf '%s\n' "No input entered"
   exit 1
else
   printf "You entered ZONE %s " "$NUM"
   ls -l
fi

echo "========================================================================"
echo "Scaling out"
echo "========================================================================"

SCALE_OUT_OP_ID=`osm ns-action --action_name upgrade --vnf_name $VNF_NAME  --kdu_name $KDU_NAME --params "{'replicaCount':$NUM,}" $PDNS_NS_NAME`

echo "========================================================================"
echo "Showing action status"
echo "========================================================================"
osm ns-op-show $PDNS_NS_NAME --literal | yq .operationState

echo "========================================================================"
echo "Showing replicaCount number"
echo "========================================================================"
osm vnf-show $VNF_ID --kdu $KDU_NAME | yq .config.replicaCount
