#!/bin/bash
echo $0 started at $(date)

sudo sed -i "s/127.0.0.1 /127.0.0.1 $HOSTNAME /" /etc/hosts
echo 'ubuntu:hackfest'| sudo chpasswd
sudo sed -i "s/^PasswordAuthentication.*/PasswordAuthentication yes/" /etc/ssh/sshd_config
sudo service ssh restart
echo "Acquire::http::Proxy \"http://172.21.1.1:3142\";" | sudo tee /etc/apt/apt.conf.d/proxy.conf
echo "Acquire::https::Proxy \"http://172.21.1.1:3142\";" | sudo tee -a /etc/apt/apt.conf.d/proxy.conf

sudo apt update
sudo apt full-upgrade -y

sudo snap install code --classic
sudo snap install openstackclients yq jq

echo net.ipv4.ip_forward=1 | sudo tee -a /etc/sysctl.conf
sudo sysctl net.ipv4.ip_forward=1
sudo iptables -t nat -A POSTROUTING -o ens3 -j MASQUERADE
cat << EOF |  sudo tee /etc/rc.local
#!/bin/sh -e
echo iptables -t nat -A POSTROUTING -o ens3 -j MASQUERADE
EOF
sudo chmod +x /etc/rc.local

git clone --recurse-submodules -j8 https://osm.etsi.org/gitlab/vnf-onboarding/osm-packages.git

# Clone OSM code
mkdir $HOME/OSM/
pushd $HOME/OSM
BRANCH=master
for MDG in common devops IM LCM MON N2VC NBI NG-SA NG-UI osmclient PLA POL RO tests; do
 git clone https://osm.etsi.org/gerrit/osm/${MDG}
 git -C ${MDG} checkout ${BRANCH}
done
popd

# Export Module paths
cat << 'EOF' > $HOME/osm-vars.sh
export GIT_PATH=$HOME/OSM
export COMMON_LOCAL_PATH="$GIT_PATH/common"
export LCM_LOCAL_PATH="$GIT_PATH/LCM"
export MON_LOCAL_PATH="$GIT_PATH/MON"
export N2VC_LOCAL_PATH="$GIT_PATH/N2VC"
export NBI_LOCAL_PATH="$GIT_PATH/NBI"
export POL_LOCAL_PATH="$GIT_PATH/POL"
export RO_LOCAL_PATH="$GIT_PATH/RO"
EOF

echo ". $HOME/osm-vars.sh" >> $HOME/.bashrc
. $HOME/osm-vars.sh

echo $0 $@ complete at $(date)
