# Hackfest Magma

## Diagram

![osm9hackfest_diagram](/uploads/9d9d85dc23d87ae30de57115b413388b/Screen_Shot_2020-05-23_at_17.27.58.png)

## Preparation

This example requires a PNF, emulated with a VyOS router (image [here](http://osm-download.etsi.org/ftp/osm-6.0-six/7th-hackfest/images/vyos-1.1.7-cloudinit.qcow2.tgz)), connected to a shared management network (osm-ext in this example) and to a shared internal "sgi" network where the Slice will be placed.

1. Add the PDU with the yaml file (emulated by a VyOS VM in this environment)
1. Upload the packages to OSM, the "build_slice.sh" file contain some useful commands.
1. Make sure you got the images for AGW and srsLTE emulator, available at ETSI VIM or at the hackfest@172.21.248.19 home directory.

Note: a sandbox for testing is available at hackfest@172.21.248.19 (~/osm-packages/magma is synced with this repo)

## Launching the Slice

1. Edit the params.yaml and set an address for your Magma Orc8r-proxy service, which AGW will connect to. Same IP address should go to 'proxyserviceloadBalancerIP' and 'orch_ip', and should belong to your K8 Cluster MetalLB pool.
1. In the same file, set a name and ID for the first AGW, in parameters agw_id and agw_name (they need to be different each time you launch a new slice)
1. Launch the slice with:
`osm nsi-create --nsi_name magma_slice --nst_name magma_slice_hackfest_nst --config_file params.yaml --ssh_keys <your_key> --vim_account <vim_account>`

## Verifying the services

1. Visit the Orc8r dashboard at the KNF's nginx-proxy svc IP, with https and credentials admin@magma.test / password1234, then check that your AGW has been registered successfully under the list of Gateways in this path: https://<orc8r-nginx-proxy-ip>/nms/osmnet/gateways) (after proxy charms are finished)
2. Via this same dashboard, add the test subscriber with the following parameters (this will migrate to Day-2 primitive)
    - IMSI: 722070000000008
    - KEY: c8eba87c1074edd06885cb0486718341
    - OPC: 17b6c0157895bcaa1efc1cef55033f5f

3. The emulator is ready to connect, Day-2 primitives for this is WIP, in the meantime, the following commands can be used to connect the eNB and UE, respectively and in that order (from different terminals)

### Configuring eNodeB example

`srsenb --enb.name=dummyENB01 --enb.mcc=901 --enb.mnc=70  --enb.mme_addr=192.168.100.254 --enb.gtp_bind_addr=192.168.100.10 --enb.s1c_bind_addr=192.168.100.10  --enb_files.rr_config=/config/rr.conf --enb_files.sib_config=/config/sib.conf --enb_files.drb_config=/config/drb.conf /config/enb.conf.fauxrf`

### Attaching UE example

`sudo srsue --usim.imsi=722070000000008 --usim.k=c8eba87c1074edd06885cb0486718341 --usim.algo=milenage --usim.opc=17b6c0157895bcaa1efc1cef55033f5f --nas.apn=oai.ipv4 /config/ue.conf.fauxrf`

## Testing traffic

After UE is attached (at emulator machine), the "tun_srsue" will appear, and a default route should be added (pending to put as Day-2 primitive), pointing to the GTP tunnel endpoint:

`sudo route add -net 0.0.0.0/0 gw 192.168.128.1`

Finally, a Day-2 primitive must be executed against the PNF (VyOS) to allow traffic from the specific Magma SGI IP address, for example, if it's 192.168.239.10:

`osm ns-action magma_slice.slice_hackfest_nsd_epc --vnf_name 2 --action_name configure-remote --params '{magmaIP: "192.168.239.10"}'`

With this, the UE machine will have access to Internet through the AGW and then the VyOS PNF.

## Additional tests

- Additional slice instances can be launched (changing agw_id and agw_name), and we should see that just the AGW+emulator NS is launched (Orc8r NS is shared)

## Pending additions

- Navigating from a desktop browser (VNC not working properly)
- Placement tests
- Metrics collection
- Automatic and manual scaling
- KNF Primitives (via additional Webhost NS that will be added)
- SDN Assist in the internal S1 VLD
