#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [K8s-07] Openldap Helm in isolated cluster with dummy VIM.

Library   OperatingSystem
Library   String
Library   Collections
Library   Process

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vim_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/connectivity_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/k8scluster_lib.robot

Force Tags   k8s_07   cluster_k8s   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# VIM Configuration
${vim_name}   k8s07_dummy
${vim_user}   user
${vim_password}   pass
${vim_auth_url}   http://localhost/dummy
${vim_tenant}   tenant
${vim_account_type}   dummy

# K8s cluster data
${k8scluster_name}   k8s07
${k8scluster_version}   v1
${k8scluster_net}   null

# NS and VNF descriptor package files
${vnfd_pkg}   openldap_knf
${nsd_pkg}   openldap_ns
${vnfd_name}   openldap_knf
${nsd_name}   openldap_ns

# NS instance name
${ns_name}   ldap

${ns_id}   ${EMPTY}
${ns_config}   ${EMPTY}
${publickey}   ${EMPTY}


*** Test Cases ***
Create Package For OpenLDAP CNF
    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'

Create Package For OpenLDAP NS
    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'

Create Dummy VIM
    ${created_vim_account_id}=   Create VIM Target   ${vim_name}   ${vim_user}   ${vim_password}   ${vim_auth_url}   ${vim_tenant}   ${vim_account_type}

Add K8s Cluster To OSM
    Create K8s Cluster   %{K8S_CREDENTIALS}   ${k8scluster_version}   ${vim_name}   ${k8scluster_net}   ${k8scluster_name}

Create Network Service Instance
    ${id}=   Create Network Service   ${nsd_name}   ${vim_name}   ${ns_name}   ${ns_config}   ${publickey}
    Set Suite Variable   ${ns_id}   ${id}

Delete Network Service Instance
    [Tags]   cleanup
    Delete NS   ${ns_name}

Remove K8s Cluster from OSM
    [Tags]   cleanup
    Delete K8s Cluster   ${k8scluster_name}

Delete VIM
    [Tags]   cleanup
    Delete VIM Target   ${vim_name}

Delete NS Descriptor Test
    [Tags]   cleanup
    Delete NSD   ${nsd_name}

Delete VNF Descriptor Test
    [Tags]   cleanup
    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting Descriptor, instance, cluster and vim
    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}
    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}
    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}
    Run Keyword If Any Tests Failed   Delete K8s Cluster   ${k8scluster_name}
    Run Keyword If Any Tests Failed   Delete VIM Target   ${vim_name}
