#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [BASIC-26] Secure connection to helm execution environments.

Library   OperatingSystem
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot

Force Tags   basic_26   cluster_ee_config   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   simple_secure_ee_vnf
${vnfd_name}   simple_secure_ee-vnf
${nsd_pkg}   simple_secure_ee_ns
${nsd_name}   simple_secure_ee-ns

# NS instance name and configuration
${ns_name}   basic_26_secure_helm_ee_test
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa
${username}   ubuntu
${password}   ${EMPTY}

${action_name}   touch
${new_action_name}   mkdir
${vnf_member_index}   simple
${day_1_file_name}   /home/ubuntu/first-touch
${ns_timeout}   15min


*** Test Cases ***
Create VNF Descriptor

    ${id}=   Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'
    Set Suite Variable   ${vnfd_id}   ${id}


Create NS Descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Instantiate Network Service

    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}   ${ns_timeout}
    Set Suite Variable   ${ns_id}   ${id}


Get Management Ip Address

    ${ip_addr}   Get Vnf Management Ip Address   ${ns_id}   ${vnf_member_index}
    log   ${ip_addr}
    Set Suite Variable   ${vnf_ip_addr}   ${ip_addr}


Test SSH Access

    Variable Should Exist   ${vnf_ip_addr}   msg=IP address of the management VNF '${vnf_member_index}' is not available
    Sleep   30s   Waiting ssh daemon to be up
    Test SSH Connection   ${vnf_ip_addr}   ${username}   ${password}   ${privatekey}


Check Remote File Created Via Day 1 Operation
    [Documentation]   Check whether the file created in the previous test via Day 1 operations exist or not.

    Check If remote File Exists   ${vnf_ip_addr}   ${username}   ${password}   ${privatekey}   ${day_1_file_name}


Delete NS Instance
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suite Cleanup: Deleting descriptors and NS instance

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}

