#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [BASIC-24] VNF with two VDUs belonging to an Openstack server group

Library   OperatingSystem
Library   String
Library   Collections
Library   Process

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnf_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/openstack_lib.robot

Force Tags   basic_24   cluster_main   daily   regression


Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   affinity_basic_vnf
${vnfd_name}   affinity_basic-vnf
${nsd_pkg}   affinity_basic_ns
${nsd_name}   affinity_basic-ns

# NS instance name and configuration
${ns_name}   basic_24
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa
${username}   ubuntu
${password}   ${EMPTY}

${ns_id}   ${EMPTY}
${vnf_member_index}   affinity-basic-1
${success_return_code}   0

*** Test Cases ***
Create VNF Package

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create NS Package

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Network Service Instance Test

    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}
    Set Suite Variable   ${ns_id}   ${id}


Check Vnf Affinity Groups

    Variable Should Exist   ${ns_id}   msg=NS is not available
    ${vnf_id}   Get Vnf Id   ${ns_id}   ${vnf_member_index}
    @{vdur_id_list}   Get VDU list from VNF   ${vnf_id}
    FOR   ${vdur_id}   IN   @{vdur_id_list}
        ${server_group_name}   Get VDU Affinity Group Name   ${ns_name}   ${vnf_id}   ${vdur_id}
        ${vm_vim_id}   Get VDU VIM Id   ${vnf_id}   ${vdur_id}
        Check VM In Server Group   ${vm_vim_id}   ${server_group_name}
    END


Delete NS Instance Test
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor Test
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor Test
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting Descriptor, instance and vim

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}

