#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [BASIC-21] NS with only one VDU and several volumes

Library   OperatingSystem
Library   String
Library   Collections
Library   Process
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnf_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/openstack_lib.robot

Force Tags   basic_21   cluster_main   daily   regression


Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   several_volumes_vnf
${vnfd_name}   several_volumes-vnf
${nsd_pkg}   several_volumes_ns
${nsd_name}   several_volumes-ns

# NS instance name and configuration
${ns_name}   basic_21
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa
${username}   ubuntu
${password}   ${EMPTY}

${vnf_member_index}   vnf-several-volumes
${success_return_code}   0


*** Test Cases ***
Create VNF Descriptor
    [Tags]   prepare
    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create NS Descriptor
    [Tags]   prepare
    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Network Service Instance Test
    [Tags]   prepare
    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}
    Set Suite Variable   ${ns_id}   ${id}

Get NS Id
    [Tags]   verify   cleanup
    ${variables}   Get Variables
    IF   not "\${ns_id}" in "${variables}"
        ${id}=   Get Ns Id   ${ns_name}
        Set Suite Variable   ${ns_id}   ${id}
    END

Get Volumes From VNFD
    [Tags]   verify
    ${rc}   ${stdout}=   Run and Return RC and Output   osm vnfpkg-show ${vnfd_name} --literal | yq '.vdu[0]."virtual-storage-desc" | length'
    Should Be Equal As Integers   ${rc}   ${success_return_code}   msg=${stdout}   values=False
    ${num_virtual_storage}=   Convert To Integer   ${stdout}
    Set Suite Variable   ${vnf_num_volumes}   ${num_virtual_storage}
    log   ${vnf_num_volumes}


Get VNF IP Address
    [Tags]   verify
    Variable Should Exist   ${ns_id}   msg=NS is not available
    ${ip_addr}=   Get Vnf Management Ip Address   ${ns_id}   ${vnf_member_index}
    log   ${ip_addr}
    Set Suite Variable   ${vnf_ip_addr}   ${ip_addr}


#Get Persistent Volume Id
#    [Tags]   cleanup
#    Variable Should Exist   ${ns_id}   msg=NS is not available
#    ${vnfs_list}=   Get Ns Vnf List   ${ns_id}
#    ${vim_id}=   Get VNF VIM ID   ${vnfs_list}[0]
#    ${volumes_attached}=   Get Server Property   ${vim_id}   volumes_attached
#    ${match}=   Get Regexp Matches   ${volumes_attached}   '([0-9a-f\-]+)'   1
#    Set Suite Variable   ${volume_id}   ${match}[0]


Check VDU disks
    [Tags]   verify
    Variable Should Exist   ${vnf_ip_addr}   msg=VNF is not available
    Sleep   30 seconds   Wait for SSH daemon to be up
    ${stdout}=   Execute Remote Command Check Rc Return Output   ${vnf_ip_addr}   ${username}   ${password}   ${privatekey}   sudo lsblk -l
    log   ${stdout}
    ${lines}=   Get Lines Containing String   ${stdout}   disk
    ${num_lines}=   Get Line Count   ${lines}
    Run Keyword If   ${num_lines} < ${vnf_num_volumes}   Fail   msg=Number of disks (${num_lines}) is less than specified in VDU (${vnf_num_volumes})


Delete NS Instance Test
    [Tags]   cleanup
    Delete NS   ${ns_name}


#Check Persistent Volume Was Deleted
#    [Tags]   cleanup
#    Variable Should Exist   ${volume_id}   msg=Volume is not available
#    ${exists}=   Check If Volume Exists   ${volume_id}
#    log   ${exists}
#    IF   ${exists}==0
#        Fail   msg=Persistent volume was deleted
#        Set Suite Variable   ${volume_id}   ${EMPTY}}
#    ELSE
#        log   Persistent volume still exists, deleting...
#        Delete Volume   ${volume_id}
#        Set Suite Variable   ${volume_id}   ${EMPTY}}
#    END


Delete NS Descriptor Test
    [Tags]   cleanup
    Delete NSD   ${nsd_name}


Delete VNF Descriptor Test
    [Tags]   cleanup
    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting Descriptor, instance and vim

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}

#    Run Keyword If Any Tests Failed   Check Volume Was Deleted
