#   Copyright 2020 Canonical Ltd.
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [BASIC-12] NS Primitives

Library   OperatingSystem
Library   String
Library   Collections
Library   Process
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/package_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/juju_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot

Force Tags   basic_12   cluster_ee_config   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg1}   nscharm_policy_vnf
${vnfd_pkg2}   nscharm_user_vnf
${vnfd_name1}   nscharm-policy-vnf
${vnfd_name2}   nscharm-user-vnf
${nsd_pkg}   nscharm_ns
${new_nsd_pkg}   new_nscharm_ns
${nsd_name}   nscharm-ns
${nsd_file}   nscharm_nsd.yaml

# NS instance name and configuration
${ns_name}   test_nscharm
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }
${ns_timeout}   15min

${old_juju_password}   a5611fc6452349cc6e45705d34c501d4
${publickey}   ${EMPTY}
${success_return_code}   0

# VDU profile id, execution environment name to check vdu level charm naming structure
${vdu_profile_id}   PolicyVM
${ee_name}   vnf-policy

# # Username and SSH private key for accessing OSM host
${privatekey}   %{OSM_RSA_FILE}
${username}   ubuntu
${password}   ${EMPTY}

# Charm name to check ns level charm naming structure
${charm_name}   ns


*** Test Cases ***
Change Juju Password
    [Documentation]   NS package needs to be updated with the Juju credentials for your OSM installation

    ${rc}   ${stdout}=   Run and Return RC and Output   cp -r '%{PACKAGES_FOLDER}/${nsd_pkg}' '%{PACKAGES_FOLDER}/${new_nsd_pkg}'
    Should Be Equal As Integers   ${rc}   ${success_return_code}
    ${nsd_yaml}=   OperatingSystem.Get File   %{PACKAGES_FOLDER}/${new_nsd_pkg}/${nsd_file}
    ${changed_nsd_yaml}=   Replace String   ${nsd_yaml}   ${old_juju_password}   %{JUJU_PASSWORD}
    Create File   %{PACKAGES_FOLDER}/${new_nsd_pkg}/${nsd_file}   ${changed_nsd_yaml}


Upload Vnfds

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg1}'
    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg2}'


Upload Nsd

    Create NSD   %{PACKAGES_FOLDER}/${new_nsd_pkg}/


Instantiate NS

    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}   ns_launch_max_wait_time=${ns_timeout}
    Set Suite Variable   ${ns_id}   ${id}
    Set Suite Variable   ${model_name}   ${id}


Check NS Charm Application Name

    ${ns_charm_app_name}=   Get Application Name NS Level Charm   %{OSM_HOSTNAME}   ${username}   ${password}   ${privatekey}   ${model_name}   ${charm_name}
    ${length}=   Get Length   ${ns_charm_app_name}
    Should Be True   ${length} <50


Check VDU Charm Application Name

    ${vdu_charm_app_name}=   Get Application Name VDU Level Charm   %{OSM_HOSTNAME}   ${username}   ${password}   ${privatekey}   ${model_name}   ${vdu_profile_id}   ${ee_name}
    ${length}=   Get Length   ${vdu_charm_app_name}
    Should Be True   ${length} <50

# TODO: Check Initial Config Primitives Status

Delete NS
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor
    [Tags]   cleanup

    Delete NSD   ${nsd_name}
    Delete Temporary Descriptor Folder   '%{PACKAGES_FOLDER}/${new_nsd_pkg}'


Delete VNF Descriptors
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name1}
    Delete VNFD   ${vnfd_name2}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting Descriptor and instance

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}
    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}
    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name1}
    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name2}
    Delete Temporary Descriptor Folder   '%{PACKAGES_FOLDER}/${new_nsd_pkg}'


Delete Temporary Descriptor Folder
    [Documentation]   Removes the temporary package folder created for the test
    [Arguments]   ${folder_name}

    ${rc}   ${stdout}=   Run and Return RC and Output   rm -rf '${folder_name}'
    log   ${stdout}


