#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Variables ***
${success_return_code}   0
${connectivity_pol_time}   5sec
${connectivity_max_wait_time}   30sec

*** Keywords ***
Test Ping Host
    [Documentation]   Run Ping
    ...               Parameters:
    ...                  host: IP or name of the host
    ...               Execution example:
    ...                  Ping Test   \${host}

    [Arguments]   ${host}

    ${rc}   ${stdout}=   Run and Return RC and Output   ping -c 2 -W 1 ${host}
    log   ${stdout}
    Should Be Equal As Integers   ${rc}   ${success_return_code}

Test Connectivity
    [Arguments]   ${host}

    WAIT UNTIL KEYWORD SUCCEEDS   ${connectivity_max_wait_time}   ${connectivity_pol_time}   Test Ping Host   ${host}
