#   Copyright 2020 Canonical Ltd.
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation     [K8s-09] Pebble Charm.

Library   OperatingSystem
Library   String
Library   Collections
Library   Process

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/package_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/connectivity_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/k8scluster_lib.robot

Force Tags   k8s_09   cluster_k8s   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# K8s cluster name and version
${k8scluster_name}   k8s-test
${k8scluster_version}   v1

# NS and VNF descriptor package folder and ids
${vnfd_pkg}   charm-packages/pebble_charm_vnf
${vnfd_name}   pebble_charm-vnf
${nsd_pkg}   charm-packages/pebble_charm_ns
${nsd_name}   pebble_charm-ns

# NS instance name and configuration
${ns_name}   pebble-charm-k8s
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

${ns_id}   ${EMPTY}
${publickey}   ${EMPTY}
${vnf_member_index}   pebble_charm-vnf
${action_name}   list-available-apps
${kdu_name}   onos-kdu
${application_name}   onos
${customtitle}   Day 2 Action

*** Test Cases ***
Create Simple K8s VNF Descriptor
    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'

Create Simple K8s Descriptor
    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'

Add K8s Cluster To OSM
    Create K8s Cluster  %{K8S_CREDENTIALS}  ${k8scluster_version}  %{VIM_TARGET}  %{VIM_MGMT_NET}  ${k8scluster_name}

Network Service K8s Instance Test
    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}  ${publickey}
    Set Suite Variable   ${ns_id}   ${id}

Execute Day 2 Operations
    [Documentation]     Performs one Day 2 operation per VNF that creates a new file.

    Variable Should Exist  ${ns_id}  msg=Network service instance is not available
    ${ns_op_id}=  Execute NS K8s Action  ${ns_name}  ${action_name}  ${vnf_member_index}  ${kdu_name}  application-name=${application_name}

Delete NS K8s Instance Test
    [Tags]   cleanup
    Delete NS   ${ns_name}

Remove K8s Cluster from OSM
    [Tags]   cleanup
    Delete K8s Cluster  ${k8scluster_name}

Delete NS Descriptor Test
    [Tags]   cleanup
    Delete NSD   ${nsd_name}

Delete VNF Descriptor Test
    [Tags]   cleanup
    Delete VNFD   ${vnfd_name}

Delete VNF NS Packages
    [Tags]   cleanup
    Delete Package   '%{PACKAGES_FOLDER}/${vnfd_pkg}'
    Delete Package   '%{PACKAGES_FOLDER}/${nsd_pkg}'


*** Keywords ***
Suite Cleanup
    [Documentation]  Test Suit Cleanup: Deleting Descriptor, instance and vim
    Run Keyword If Any Tests Failed  Delete NS   ${ns_name}
    Run Keyword If Any Tests Failed  Delete NSD   ${nsd_name}
    Run Keyword If Any Tests Failed  Delete VNFD   ${vnfd_name}
    Run Keyword If Any Tests Failed  Delete K8s Cluster   ${k8scluster_name}
