#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation     [HACKFEST-BASIC] Basic NS with a single-VDU VNF

Library   OperatingSystem
Library   String
Library   Collections
Library   Process
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/connectivity_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot

Force Tags   hackfest_basic   cluster_main   daily   regression   sanity

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   hackfest_basic_vnf
${vnfd_name}   hackfest_basic-vnf
${nsd_pkg}   hackfest_basic_ns
${nsd_name}   hackfest_basic-ns

# NS instance name and configuration
${ns_name}   hfbasic
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa
${username}   ubuntu
${password}   ${EMPTY}

${ns_id}   ${EMPTY}
${vnf_member_index}   vnf
${vnf_ip_addr}   ${EMPTY}


*** Test Cases ***
Create Hackfest Basic VNF Descriptor

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create Hackfest Basic NS Descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'

Network Service Instance Test

    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}
    Set Suite Variable   ${ns_id}   ${id}


Get Vnf Ip Address

    ${ip_addr}  Get Vnf Management Ip Address   ${ns_id}   ${vnf_member_index}
    log   ${ip_addr}
    Set Suite Variable   ${vnf_ip_addr}   ${ip_addr}

Test Ping
    Test Connectivity  ${vnf_ip_addr}

Test SSH Access
    Sleep   30s   Waiting ssh daemon to be up
    Test SSH Connection  ${vnf_ip_addr}  ${username}  ${password}  ${privatekey} 

Delete NS Instance Test
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor Test
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor Test
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]  Test Suit Cleanup: Deleting Descriptor, instance and vim

    Run Keyword If Any Tests Failed  Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed  Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed  Delete VNFD   ${vnfd_name}


