#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation     [EPA-04] EPA underlay SR-IOV.

Library   OperatingSystem
Library   String
Library   Collections
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnf_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/openstack_lib.robot

Force Tags   epa_04   cluster_epa   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   epa_1vm_sriov_vnf
${vnfd_name}   epa_1vm_sriov-vnf
${nsd_pkg}   epa_1vm_sriov_ns
${nsd_name}   epa_1vm_sriov-ns
${ns_name}   epa_04

# Fixed IPs and subnet for datanet VL
${datanet_subnet}   192.168.100.0/24
${datanet_ip1}   192.168.100.11
${datanet_ip2}   192.168.100.22

${vnf_member_index_1}   vnf1
${vnf_member_index_2}   vnf2
${username}   ubuntu
${password}   osm4u
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} , {name: datanet, ip-profile: {ip-version: ipv4, subnet-address: "${datanet_subnet}"}, vnfd-connection-point-ref: [ {member-vnf-index-ref: "${vnf_member_index_1}", vnfd-connection-point-ref: vnf-data-ext, ip-address: "${datanet_ip1}"}, {member-vnf-index-ref: "${vnf_member_index_2}", vnfd-connection-point-ref: vnf-data-ext, ip-address: "${datanet_ip2}"}]} ] }
${success_return_code}   0


*** Test Cases ***
Create VNF Descriptor

    Remove Environment Variable  OVERRIDES
    Create VNFD  '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create NS Descriptor

    Create NSD  '%{PACKAGES_FOLDER}/${nsd_pkg}'


Instantiate Network Service

    ${id}=  Create Network Service  ${nsd_name}  %{VIM_TARGET}  ${ns_name}  ${ns_config}  ${EMPTY}
    Set Suite Variable  ${ns_id}  ${id}


Get Management Ip Addresses

    Variable Should Exist  ${ns_id}  msg=Network service instance is not available
    ${ip}  Get Vnf Management Ip Address  ${ns_id}  ${vnf_member_index_1}
    Set Suite Variable  ${ip_mgmt_1}  ${ip}
    log  ${ip_mgmt_1}

    ${ip}  Get Vnf Management Ip Address  ${ns_id}  ${vnf_member_index_2}
    Set Suite Variable  ${ip_mgmt_2}  ${ip}
    log  ${ip_mgmt_2}


Ping from Vnf1 to Vnf2

    Variable Should Exist  ${ip_mgmt_1}  msg=IP address of the data VNF '${vnf_member_index_1}' is not available
    Sleep   30 seconds   Wait for SSH daemon to be up
    ${stdout}=   Execute Remote Command Check Rc Return Output   ${ip_mgmt_1}   ${username}   ${password}   ${EMPTY}   ip addr ; ping -c 5 ${datanet_ip2}
    log  ${stdout}


Ping from Vnf2 to Vnf1

    Variable Should Exist  ${ip_mgmt_2}  msg=IP address of the data VNF '${vnf_member_index_2}' is not available
    ${stdout}=   Execute Remote Command Check Rc Return Output   ${ip_mgmt_2}   ${username}   ${password}   ${EMPTY}   ip addr ; ping -c 5 ${datanet_ip1}
    log  ${stdout}


Delete NS Instance
    [Tags]   cleanup

    Delete NS  ${ns_name}


Delete NS Descriptor
    [Tags]   cleanup

    Delete NSD  ${nsd_name}


Delete VNF Descriptor
    [Tags]   cleanup

    Delete VNFD  ${vnfd_name}



*** Keywords ***
Suite Cleanup
    [Documentation]  Test Suite Cleanup: Deleting descriptors and NS instance

    Run Keyword If Any Tests Failed  Delete NS  ${ns_name}

    Run Keyword If Any Tests Failed  Delete NSD  ${nsd_name}

    Run Keyword If Any Tests Failed  Delete VNFD  ${vnfd_name}

