#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation     [EPA-02] Support for additional EPA capabilities.

Library   OperatingSystem
Library   String
Library   Collections
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnf_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/openstack_lib.robot

Force Tags   epa_02   cluster_epa   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   epa_quota_vnf
${vnfd_name}   epa_quota-vnf
${nsd_pkg}   epa_quota_ns
${nsd_name}   epa_quota-ns

# NS instance name and configuration
${ns_name}   epa_02-epa_quota_test
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

# SSH public keys file
${publickey}   %{HOME}/.ssh/id_rsa.pub

${ns_id}   ${EMPTY}
${vnf_server_id}   ${EMPTY}
${flavor_properties}   ${EMPTY}
${success_return_code}   0


*** Test Cases ***
Create VNF Descriptor

    Remove Environment Variable  OVERRIDES
    Create VNFD  '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create NS Descriptor

    Create NSD  '%{PACKAGES_FOLDER}/${nsd_pkg}'


Instantiate Network Service

    ${id}=  Create Network Service  ${nsd_name}  %{VIM_TARGET}  ${ns_name}  ${ns_config}  ${publickey}
    Set Suite Variable  ${ns_id}  ${id}


Get VNF Server ID

    ${vnfs_list}=  Get Ns Vnf List   ${ns_id}
    ${vim_id}=  Get VNF VIM ID   ${vnfs_list}[0]
    log   ${vim_id}
    Set Suite Variable   ${vnf_server_id}   ${vim_id}


Get Server Flavor Properties

    ${flavor_id}=  Get Server Flavor ID   ${vnf_server_id}
    ${properties}=  Get Flavor Properties   ${flavor_id}
    log   ${properties}
    Set Suite Variable   ${flavor_properties}   ${properties}


Check Flavor Quota Properties

    ${rc}=   Run and Return RC   echo ${flavor_properties} | grep "cpu_shares_level=custom"
    Should Be Equal As Integers   ${rc}   ${success_return_code}
    ${rc}=   Run and Return RC   echo ${flavor_properties} | grep "disk_io_shares_level=custom"
    Should Be Equal As Integers   ${rc}   ${success_return_code}
    ${rc}=   Run and Return RC   echo ${flavor_properties} | grep "memory_shares_level=custom"
    Should Be Equal As Integers   ${rc}   ${success_return_code}


Delete NS Instance
    [Tags]   cleanup

    Delete NS  ${ns_name}


Delete NS Descriptor
    [Tags]   cleanup

    Delete NSD  ${nsd_name}


Delete VNF Descriptor
    [Tags]   cleanup

    Delete VNFD  ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]  Test Suite Cleanup: Deleting descriptors and NS instance

    Run Keyword If Any Tests Failed  Delete NS  ${ns_name}

    Run Keyword If Any Tests Failed  Delete NSD  ${nsd_name}

    Run Keyword If Any Tests Failed  Delete VNFD  ${vnfd_name}

