#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

from pathlib import Path

from common_helpers import get_prometheus_info


# Prometheus host and port
(prometheus_host, prometheus_port) = get_prometheus_info()

# Prometheus polling interval and retries
prometheus_poll_retries = '15 times'
prometheus_poll_timeout = '1 minute'
# Prometheus metric
metric_name = 'osm_cpu_utilization'
# Get ${HOME} from local machine
home = str(Path.home())
# NS and VNF descriptor package folder
vnfd_pkg = 'hackfest_basic_metrics_vnf'
nsd_pkg = 'hackfest_basic_metrics_ns'
# NS and VNF descriptor id
vnfd_name = 'hackfest_basic_metrics-vnf'
nsd_name = 'hackfest_basic-ns-metrics'
# NS instance name
ns_name = 'sa_02'
# SSH keys to be used
publickey = home + '/.ssh/id_rsa.pub'
privatekey = home + '/.ssh/id_rsa'
