#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation     [BASIC-17] Delete VNF Package Before NS Package.

Library   OperatingSystem
Library   String
Library   Collections
Library   Process
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot

Force Tags   basic_17   cluster_main   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   hackfest_basic_vnf
${vnfd_name}   hackfest_basic-vnf
${nsd_pkg}   hackfest_basic_ns
${nsd_name}   hackfest_basic-ns


*** Test Cases ***
Create VNF Package

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create NS Package

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Cannot Delete VNF Package

    Assert Failure Delete VNFD   ${vnfd_name}


Delete NS Package
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Package
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]  Test Suit Cleanup: Deleting NS and VNF packages

    Run Keyword If Any Tests Failed  Delete NSD   ${nsd_name}
    Run Keyword If Any Tests Failed  Delete VNFD   ${vnfd_name}


