#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation     [BASIC-15] RBAC Configurations.

Library   OperatingSystem
Library   String
Library   Collections

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/user_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/project_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/role_lib.robot

Force Tags   basic_15   cluster_main   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# User, project and roles to use
${user_name}   basic_15_test_user
${user_password}   basic_15_user_pass
${user_role}   project_user
${user_project}   admin
${project_name}   basic_15_test_project
${new_project_name}   basic_15_project_test
${role_name}   test_role
${success_return_code}   0


*** Test Cases ***
Create And Validate User

    Create User   ${user_name}   ${user_password}
    Check If User Exists   ${user_name}


Assign Role To User

    Update User Role   ${user_name}  ${user_project}  ${user_role}
    Check If User Is Assigned To Project   ${user_name}   ${user_project}
    Check If User Has Role   ${user_name}  ${user_role}  ${user_project}


Run Action As User

    ${rc}   ${stdout}=   Run And Return RC And Output   OSM_USER=${user_name} OSM_PROJECT=${user_project} OSM_PASSWORD=${user_password} osm ns-list
    Should Be Equal As Integers   ${rc}   ${success_return_code}


Create And Update Project

    Create Project   ${project_name}
    Update Project Name   ${project_name}   ${new_project_name}


Create And Validate Role

    Create Role   ${role_name}
    Check If Role Exists   ${role_name}


Update Role Information

    Update Role   ${role_name}   add='vims: true'
    Check If Role Exists   ${role_name}


Delete Allocated Resources
    [Tags]   cleanup

    Delete User   ${user_name}
    Delete Project   ${new_project_name}
    Delete Role   ${role_name}


*** Keywords ***
Suite Cleanup
    Run Keyword If Any Tests Failed  Run Keyword And Ignore Error  Delete User  ${user_name}
    Run Keyword If Any Tests Failed  Run Keyword And Ignore Error  Delete Role  ${role_name}
    Run Keyword If Any Tests Failed  Run Keyword And Ignore Error  Delete Project  ${project_name}
    Run Keyword If Any Tests Failed  Run Keyword And Ignore Error  Delete Project  ${new_project_name}
