#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

import os
from pathlib import Path
import yaml

from common_helpers import get_prometheus_info


# Prometheus host and port
(
    prometheus_host,
    prometheus_port,
    prometheus_user,
    prometheus_password,
) = get_prometheus_info()

# VIM Configuration
vim_account_type = "openstack"
vim_name = "basic_08_vim_test"

# Get credentials from Openstack clouds file
os_cloud = os.environ.get("OS_CLOUD")
clouds_file_paths = [
    "./clouds.yaml",
    str(Path.home()) + "/.config/openstack/clouds.yaml",
    "/etc/openstack/clouds.yaml",
]
for path in clouds_file_paths:
    clouds_file_path = Path(path)
    if clouds_file_path.exists():
        break
if not clouds_file_path.exists():
    raise Exception("Openstack clouds file not found")
with clouds_file_path.open() as clouds_file:
    clouds = yaml.safe_load(clouds_file)
    if os_cloud not in clouds["clouds"]:
        raise Exception("Openstack cloud '" + os_cloud + "' not found")
    cloud = clouds["clouds"][os_cloud]
    if "username" not in cloud["auth"]:
        raise Exception("Username not found in Openstack cloud '" + os_cloud + "'")
    vim_user = cloud["auth"]["username"]
    if "password" not in cloud["auth"]:
        raise Exception("Password not found in Openstack cloud '" + os_cloud + "'")
    vim_password = cloud["auth"]["password"]
    if "auth_url" not in cloud["auth"]:
        raise Exception("Auth url not found in Openstack cloud '" + os_cloud + "'")
    vim_auth_url = cloud["auth"]["auth_url"]
    if "project_name" not in cloud["auth"]:
        raise Exception("Project name not found in Openstack cloud '" + os_cloud + "'")
    vim_tenant = cloud["auth"]["project_name"]
    vim_user_domain_name = (
        cloud["auth"]["user_domain_name"]
        if "user_domain_name" in cloud["auth"]
        else None
    )
    vim_project_domain_name = (
        cloud["auth"]["project_domain_name"]
        if "project_domain_name" in cloud["auth"]
        else None
    )
    vim_insecure = True if "verify" in cloud and not cloud["verify"] else None

# Extra VIM config
vim_config_dict = {}
vim_config_dict["vim_network_name"] = os.environ.get("VIM_MGMT_NET")
if vim_project_domain_name:
    vim_config_dict["project_domain_name"] = vim_project_domain_name
if vim_user_domain_name:
    vim_config_dict["user_domain_name"] = vim_user_domain_name
if vim_insecure:
    vim_config_dict["insecure"] = True
vim_config_dict["disable_network_port_security"] = True
vim_config_dict["management_network_name"] = os.environ.get("VIM_MGMT_NET")
vim_config = "'{}'".format(
    yaml.safe_dump(vim_config_dict, default_flow_style=True, width=10000).rstrip("\r\n")
)

# Get ${HOME} from local machine
home = str(Path.home())
# NS and VNF descriptor package folder
vnfd_pkg = "hackfest_multivdu_vnf"
nsd_pkg = "hackfest_multivdu_ns"
# NS and VNF descriptor id
vnfd_name = "hackfest_multivdu-vnf"
nsd_name = "hackfest_multivdu-ns"
# NS instance name
ns_name = "basic_08_disable_port_security_network_level_test"
# SSH keys to be used
publickey = home + "/.ssh/id_rsa.pub"
privatekey = home + "/.ssh/id_rsa"
