#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [EPA-03] CRUD operations on SDNC accounts.

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/sdnc_lib.robot

Variables   %{ROBOT_DEVOPS_FOLDER}/resources/epa_03-crud_operations_on_sdnc_data.py

Force Tags   epa_03   cluster_epa   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Delete Basic SDNC


*** Variables ***
${sdnc_enabled_max_wait_time}   1min
${sdnc_enabled_pol_time}   10


*** Test Cases ***
Create Basic SDNC

    ${created_sdnc_id}=   Create SDNC   ${sdnc_name}   ${sdnc_user}   ${sdnc_password}   ${sdnc_url}   ${sdnc_type}
    Set Suite Variable   ${sdnc_id}   ${created_sdnc_id}
    Wait Until Keyword Succeeds   ${sdnc_enabled_max_wait_time}   ${sdnc_enabled_pol_time}   Check for SDNC   ${sdnc_id}


Check SDNC Status Is Healthy

    Check for SDNC Status   ${sdnc_id}   ${prometheus_host}   ${prometheus_port}   ${prometheus_user}   ${prometheus_password}


Delete Basic SDNC
    [Tags]   cleanup

    Delete SDNC   ${sdnc_name}
