#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License

*** Settings ***
Documentation   Library with sol003 keywords and variables .

Library   RequestsLibrary
Library   JsonValidator
Library   yaml
Library   JSONLibrary
Library   String
Library   OperatingSystem
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vim_lib.robot
Variables   %{ROBOT_DEVOPS_FOLDER}/resources/sol003_01-vnf_lifecycle_management.py

*** Variables ***
@{success_status_code_list}   200   201   202   204
${auth_token_uri}   /osm/admin/v1/tokens
${HOST}   ${EMPTY}

*** Keywords ***
Get Auth Token
    [Tags]   auth_token
    Get Hostname
    Create Session   osmhit   ${HOST}   disable_warnings=1
    &{headers}   Create Dictionary   Content-Type=application/json   Accept=application/json
    &{data}   Create Dictionary   username=${osm_user}   password=${osm_password}   project-id=${osm_project}
    ${resp}=   Post On Session   osmhit   ${auth_token_uri}   json=${data}   headers=${headers}
    Log   ${resp}
    Pass Execution If   ${resp.status_code} in ${success_status_code_list}   Get Auth Token completed
    Set Suite Variable   ${token_status_code}   ${resp.status_code}
    ${access_token}=   Get Value From Json   ${resp.json()}   $..id
    Set Test Variable   ${access_token}   ${access_token[0]}
    Set Test Variable   ${token_response}   ${resp}
    sleep   2s

Set Dockerized Host
    [Arguments]   ${env_host}
    Set Suite Variable   ${HOST}   https://${env_host}

Set Standalone Host
    [Arguments]   ${env_host}
    Set Suite Variable   ${HOST}   https://${env_host}:9999

Read Directory
    [Documentation]   To Read Current Direct ory
    ${Directory}=   Replace String   ${CURDIR}   lib   resources/
    ${json_path}=   Set Variable   ${Directory}
    [Return]   ${JsonPath}

Post Api Request
    [Arguments]   ${PostApi}
    [Documentation]   Keword to Post API Request
    Create Session   APISession   ${HOST}
    &{headers}   Create Dictionary   Content-Type=application/json   Accept=application/json   Authorization=Bearer ${access_token}
    ${request_response}=   Post On Session   APISession   ${PostApi}   json=${updated_json_obj}   headers=${headers}
    Set Suite Variable   ${request_response}
    ${response_statuscode}   Convert To String   ${request_response.status_code}
    Set Suite Variable   ${response_statuscode}

Get Hostname
    [Documentation]   Keyword to get the default osm Hostname
    ${nbi_host}=   Get Environment Variable   OSM_HOSTNAME
    ${passed}=   Run Keyword And Return Status   Should Contain   ${nbi_host}   :
    Run Keyword If   ${passed}   Set Dockerized Host   ${nbi_host}
    ...    ELSE   Set Standalone Host   ${nbi_host}

Get ID
    [Arguments]   ${Key}
    Pass Execution If   ${request_response.status_code} in ${success_status_code_list}   Get Auth Token completed
    ${id}=   Get Value From Json   ${request_response.json()}   $..${Key}
    Set Suite Variable   ${value}   ${id[0]}
    [Return]   ${value}

Update Json Value
    [Arguments]   ${JsonInput}   ${key}
    ${json_path}=   Read Directory
    ${json_obj}=   Load JSON From File   ${json_path}/${JsonInput}
    ${updated_json_obj}=   JSONLibrary.Update Value To Json   ${json_obj}   $..${key}   ${created_vim_account_id}
    Set Suite Variable   ${updated_json_obj}

Get Api Request
    [Arguments]   ${uri}
    [Documentation]   Keyword to Get API Request
    Create Session   Session   ${HOST}
    &{headers}   Create Dictionary   Content-Type=application/json   Accept=application/json   Authorization=Bearer ${access_token}
    ${request_response}=   Get On Session   Session   ${uri}   headers=${Headers}
    Set Suite Variable   ${request_response}
    ${response_statuscode}   Convert To String   ${request_response.status_code}
    Set Suite Variable   ${response_statuscode}
