#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [K8s-04] Openldap Helm chart.

Library   OperatingSystem
Library   String
Library   Collections
Library   Process

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/connectivity_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/k8scluster_lib.robot

Force Tags   k8s_04   cluster_k8s   daily   regression   sanity

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   openldap_knf
${vnfd_name}   openldap_knf
${nsd_pkg}   openldap_ns
${nsd_name}   openldap_ns

# NS instance name and configuration
${ns_name}   ldap
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}}], additionalParamsForVnf: [ {member-vnf-index: openldap, additionalParamsForKdu: [ {kdu_name: ldap, additionalParams: {service: {type: LoadBalancer }, adminPassword: admin}} ] } ] }

${ns_id}   ${EMPTY}
${publickey}   ${EMPTY}
${vnf_member_index}   openldap
${kdu_name}   ldap
${upgrade_action}   upgrade
${rollback_action}   rollback
${replica_count}   3

*** Test Cases ***
Create Package For OpenLDAP CNF
    [Tags]   prepare
    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'

Create Package For OpenLDAP NS
    [Tags]   prepare
    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'

Create Network Service Instance
    [Tags]   prepare
    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}

Get Ns Id
    [Tags]   verify
    ${id}=   Get Ns Id   ${ns_name}
    Set Suite Variable   ${ns_id}   ${id}

Get Vnf Id
    [Tags]   verify
    Variable Should Exist   ${ns_id}   msg=Network service instance is not available
    @{vnfr_list}=   Get Ns Vnfr Ids   ${ns_id}
    Log List   ${vnfr_list}
    Set Suite Variable   ${vnf_id}   ${vnfr_list}[0]

Execute Upgrade Operation
    [Tags]   verify
    Variable Should Exist   ${ns_id}   msg=Network service instance is not available
    ${ns_op_id}=   Execute NS K8s Action   ${ns_name}   ${upgrade_action}   ${vnf_member_index}   ${kdu_name}   replicaCount=${replica_count}

Check Replicas After Upgrade Operation
    [Tags]   verify
    Variable Should Exist   ${ns_id}   msg=Network service instance is not available
    ${count}=   Get Vnf Kdu Replica Count   ${vnf_id}   ${kdu_name}
    Log   ${count}
    Should Be Equal As Integers   ${count}   ${replica_count}

Execute Rollback Operation
    [Tags]   verify
    Variable Should Exist   ${ns_id}   msg=Network service instance is not available
    ${ns_op_id}=   Execute NS K8s Action   ${ns_name}   ${rollback_action}   ${vnf_member_index}   ${kdu_name}

Check Replicas After Rollback Operation
    [Tags]   verify
    Variable Should Exist   ${ns_id}   msg=Network service instance is not available
    ${count}=   Get Vnf Kdu Replica Count   ${vnf_id}   ${kdu_name}
    Log   ${count}
    Should Be Empty   ${count}

Delete Network Service Instance
    [Tags]   cleanup
    Delete NS   ${ns_name}

Delete NS Descriptor Test
    [Tags]   cleanup
    Delete NSD   ${nsd_name}

Delete VNF Descriptor Test
    [Tags]   cleanup
    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting Descriptor, instance and vim
    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}
    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}
    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}
