# Copyright 2020 Canonical Ltd.
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [K8s-02] K8s cluster addition.

Library   OperatingSystem
Library   String
Library   Collections
Library   Process

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/k8scluster_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vim_lib.robot

Variables   %{ROBOT_DEVOPS_FOLDER}/resources/basic_01-crud_operations_on_vim_targets_data.py

Force Tags   k8s_02   cluster_k8s   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# K8s cluster name and version
${k8scluster_name}   k8s02
${k8scluster_version}   v1

*** Test Cases ***
Create VIM Target Basic
    [Documentation]   Creates a VIM for the K8s cluster to be anchored against

    ${rand}=   Generate Random String   6   [NUMBERS]
    ${vim_name}=   Catenate   SEPARATOR=_   ${vim_name_prefix}   ${rand}
    Set Suite Variable   ${vim_name}
    ${created_vim_account_id}=   Create VIM Target   ${vim_name}   ${vim_user}   ${vim_password}   ${vim_auth_url}   ${vim_tenant}   ${vim_account_type}
    Set Suite Variable   ${created_vim_account_id}

Add K8s Cluster To OSM

    Create K8s Cluster   %{K8S_CREDENTIALS}   ${k8scluster_version}   ${vim_name}   %{VIM_MGMT_NET}   ${k8scluster_name}

Remove K8s Cluster from OSM
    [Tags]   cleanup

    Delete K8s Cluster   ${k8scluster_name}

Delete VIM Target By ID
    [Documentation]   Delete the VIM Target created in previous test-case by its ID.
    ...               Checks whether the VIM Target was created or not before perform the deletion.
    [Tags]   cleanup

    ${vim_account_id}=   Get VIM Target ID   ${vim_name}
    Should Be Equal As Strings   ${vim_account_id}   ${created_vim_account_id}
    Delete VIM Target   ${vim_account_id}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting K8s Cluster

    Run Keyword If Any Tests Failed   Delete K8s Cluster   ${k8scluster_name}
