#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [BASIC-28] NS with one VDU which has 2 persistent volumes with keep flag

Library   OperatingSystem
Library   String
Library   Collections
Library   Process
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnf_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/openstack_lib.robot

Force Tags   basic_28   cluster_main   daily


Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   keep_persistent_volume_vnf
${vnfd_name}   keep_persistent-volumes-vnf
${nsd_pkg}   keep_persistent_volume_ns
${nsd_name}   persistent_volumes-ns

# NS instance name and configuration
${ns_name}   basic_28
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa
${username}   ubuntu
${password}   ${EMPTY}

${vnf_member_index}   vnf-persistent-volumes
${vdu_id}   keep-persistent-vol-VM
${root_disk}   root-volume
${ordinary_disk}   persistent-volume
${success_return_code}   0


*** Test Cases ***
Create VNF Descriptor
    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create NS Descriptor
    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Network Service Instance Test
    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}
    Set Suite Variable   ${ns_id}   ${id}


Check Persistent Volume Counts
    Variable Should Exist   ${ns_id}   msg=NS is not available
    ${volume_match}=   Get Persistent Volumes Attached To Vm   ${ns_id}
    Set Suite Variable   ${volume_match}
    ${volume_counts}=   Get Length   ${volume_match}
    Set Suite Variable   ${volume_counts}
    Run Keyword If   ${volume_counts} != 2   Fail   msg=There were not 2 volumes attached to VM


Set Persistent Volume Ids
    Variable Should Exist   ${volume_match}   msg=NS is not available
    Set Volume Id   ${volume_match}   0
    Set Volume Id   ${volume_match}   1


Delete NS Instance Test
    [Tags]   cleanup
    Delete NS   ${ns_name}


Check Persistent Root Volume in VIM after NS Deleted
    Variable Should Exist   ${root_vol_id}   msg=Root volume is not available
    ${root_vol_exists}=   Check If Volume Exists   ${root_vol_id}
    log   ${root_vol_exists}
    IF   ${root_vol_exists}==0
        Fail   msg=Persistent root volume was deleted
        Set Suite Variable   ${root_vol_id}   ${EMPTY}
    ELSE
        log   Persistent root volume still exists
    END


Check Persistent Ordinary Volume in VIM after NS Deleted
    Variable Should Exist   ${ordinary_vol_id}   msg=Ordinary persistent volume is not available
    ${ordinary_vol_exists}=   Check If Volume Exists   ${ordinary_vol_id}
    log   ${ordinary_vol_exists}
    IF   ${ordinary_vol_exists}==0
        Fail   msg=Persistent ordinary volume was deleted
        Set Suite Variable   ${ordinary_vol_id}   ${EMPTY}
    ELSE
        log   Persistent ordinary volume still exists
    END


Prepare Ns Config With Volume Id
    Set Suite Variable   ${ns_config_with_vim_id}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ], vnf: [ {member-vnf-index: ${vnf_member_index}, vdu: [ {id: ${vdu_id}, volume: [{"name": ${root_disk}, vim-volume-id: ${root_vol_id}}, {"name": ${ordinary_disk}, vim-volume-id: ${ordinary_vol_id}}] } ] } ] }


Network Service Instance With Existing Volumes Test
    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config_with_vim_id}   ${publickey}
    Set Suite Variable   ${ns_id}   ${id}


Verify the Attachment Of Existing Persistent Volumes
    Set Suite Variable   ${prev_root_vol_id}   ${root_vol_id}
    Set Suite Variable   ${prev_ordinary_vol_id}   ${ordinary_vol_id}
    ${volume_match}=   Get Persistent Volumes Attached To Vm   ${ns_id}
    Set Suite Variable   ${volume_match}
    Set Volume Id   ${volume_match}   0
    Set Volume Id   ${volume_match}   1
    Should Be Equal As Strings   ${root_vol_id}   ${prev_root_vol_id}   msg=Existing root volume is not attached to server
    Should Be Equal As Strings   ${ordinary_vol_id}   ${prev_ordinary_vol_id}   msg=Existing ordinary volume is not attached to server


Delete NS Instance With Existing Volumes Test
    [Tags]   cleanup
    Delete NS   ${ns_name}


Check Existence of Persistent Volumes
    Variable Should Exist   ${root_vol_id}   msg=Volume is not available
    Variable Should Exist   ${ordinary_vol_id}   msg=Volume is not available
    ${root_vol_exists}=   Check If Volume Exists   ${root_vol_id}
    Run Keyword If   ${root_vol_exists} == 0   Fail   msg=Existing root volume is deleted
    ${ordinary_vol_exists}=   Check If Volume Exists   ${ordinary_vol_id}
    Run Keyword If   ${ordinary_vol_exists} == 0   Fail   msg=Existing ordinary volume is deleted


Delete Persistent Volumes
    [Tags]   cleanup
    Delete Volume   ${root_vol_id}
    Delete Volume   ${ordinary_vol_id}


Delete NS Descriptor Test
    [Tags]   cleanup
    Delete NSD   ${nsd_name}


Delete VNF Descriptor Test
    [Tags]   cleanup
    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting Descriptor, instance and vim

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}

    Run Keyword If Any Tests Failed   Delete Persistent Volumes
