#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

import os

from common_helpers import get_prometheus_info


# Prometheus host and port
(
    prometheus_host,
    prometheus_port,
    prometheus_user,
    prometheus_password,
) = get_prometheus_info()


# SDNC Configuration
sdnc_name = "epa_03"
sdnc_user = os.environ.get("SDNC_USER")
if not sdnc_user:
    raise Exception("'SDNC_USER' environment variable not found")
sdnc_password = os.environ.get("SDNC_PASSWORD")
if not sdnc_password:
    raise Exception("'SDNC_PASSWORD' environment variable not found")
sdnc_url = os.environ.get("SDNC_URL")
if not sdnc_url:
    raise Exception("'SDNC_URL' environment variable not found")
sdnc_type = os.environ.get("SDNC_TYPE")
if not sdnc_type:
    raise Exception("'SDNC_TYPE' environment variable not found")
