#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Variables ***
${success_return_code}   0


*** Keywords ***
Get Vnf List
    ${rc}   ${stdout}=   Run and Return RC and Output   osm vnf-list 2>&1
    Log   ${stdout}
    Should Be Equal As Integers   ${rc}   ${success_return_code}
    [Return]   ${stdout}


Get VNF VIM ID
    [Arguments]   ${vnf_id}

    Should Not Be Empty   ${vnf_id}
    ${rc}   ${stdout}=   Run and Return RC and Output   osm vnf-show ${vnf_id} --literal | grep vim-id | awk '{print $2}'
    Log   ${stdout}
    Should Be Equal As Integers   ${rc}   ${success_return_code}
    [Return]   ${stdout}


Get VDU list from VNF
    [Documentation]   Return a list of the VDUr ids for a VNF

    [Arguments]   ${vnf_id}

    Should Not Be Empty   ${vnf_id}
    ${rc}   ${stdout}=   Run and Return RC and Output   osm vnf-show ${vnf_id} --literal | yq '.vdur[].id'
    Log   ${stdout}
    Should Be Equal As Integers   ${rc}   ${success_return_code}   msg=${stdout}   values=False
    @{vdur_ids}=   Split String   ${stdout}
    [Return]   @{vdur_ids}


Get VDU VIM Id
    [Documentation]   Return the VIM VM ID for a VDU

    [Arguments]   ${vnf_id}   ${vdur_id}

    Should Not Be Empty   ${vnf_id}
    ${rc}   ${vm_vim_id}=   Run and Return RC and Output   osm vnf-show ${vnf_id} --literal | yq '.vdur[] | select(.id == "'${vdur_id}'")' | yq '."vim-id"' | tr -d \\"
    Log   ${vm_vim_id}
    Should Be Equal As Integers   ${rc}   ${success_return_code}   msg=${vm_vim_id}   values=False
    [Return]   ${vm_vim_id}


Get Vnf Vdur IPs
    [Documentation]   Return a list with the IP addresses of the VDU records of a VNF instance.

    [Arguments]   ${vnf_id}

    Should Not Be Empty   ${vnf_id}
    ${rc}   ${stdout}=   Run and Return RC and Output   osm vnf-show ${vnf_id} --literal | yq '.vdur[].interfaces[]."ip-address"' | tr -d \\"
    Should Be Equal As Integers   ${rc}   ${success_return_code}   msg=${stdout}   values=False
    @{ip} =   Split String   ${stdout}
    [Return]   @{ip}


Get Vdu Attribute
    [Documentation]   Return an attribute from VDU records selected by count_index of a VNF instance.

    [Arguments]   ${vnf_id}   ${attribute}   ${count_index}=0

    Should Not Be Empty   ${vnf_id}
    Should Not Be Empty   ${attribute}
    ${rc}   ${stdout}=   Run and Return RC and Output   osm vnf-show ${vnf_id} --literal | yq '.vdur[] | select(."count-index" == ${count_index})' | yq '."${attribute}"' | tr -d \\"
    Should Be Equal As Integers   ${rc}   ${success_return_code}   msg=${stdout}   values=False
    [Return]   ${stdout}
