#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License

*** Settings ***
Documentation Sol003-02 Sol003   This script launches dual-stack IP addresses NS in VIM and verify the dualstack ip

Library   OperatingSystem
Library   String
Library   Collections
Library   RequestsLibrary
Library   yaml
Library   JsonValidator
Library   JSONLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/rest_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnf_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vim_lib.robot

Force Tags   sol003_02   cluster_osm_rest   daily

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# SOL003 API URI paths
${vnf_instance_uri}   /osm/vnflcm/v1/vnf_instances
${vnf_instantiate_uri}   /osm/vnflcm/v1/vnf_instances
${vnf_instance_lcm_ops}   /osm/vnflcm/v1/vnf_lcm_op_occs

# NS and VNF descriptor package folder and ids
${vnfd_pkg}   hackfest_basic_vnf
${vnfd_name}   hackfest_basic-vnf


*** Test Cases ***

Create VNFD Descriptor
    [Documentation]   Test case to create a VNF Identifier
    ${vnfd_id}=   Create VNFD   %{PACKAGES_FOLDER}/${vnfd_pkg}
    Set Suite Variable   ${vnfd_id}
    ${created_vim_account_id}=   Get VIM Target ID   %{VIM_TARGET}
    Set Suite Variable   ${created_vim_account_id}
    Get Auth Token
    ${json_path}=   Read Directory
    ${json_obj}=   Load JSON From File   ${json_path}/sol003_DualStackip.json
    ${json_obj}=   Get Variable Value   ${json_obj['data'][0]}
    ${ns_name}=   Get Variable Value   ${json_obj['vnfInstanceName']}
    Set Suite Variable   ${ns_name}
    ${Value1}=   Get Variable Value   ${json_obj['additionalParams']['ip-address']}
    Set Suite Variable   ${Value1}
    ${updated_json_obj}=   JSONLibrary.Update Value To Json   ${json_obj}   $..vimAccountId   ${created_vim_account_id}
    Log   ${updated_json_obj}
    ${updated_json_obj}=   JSONLibrary.Update Value To Json   ${updated_json_obj}   $..additionalParams.virtual-link-desc[0][id]   %{VIM_MGMT_NET}
    Log   ${updated_json_obj}
    ${updated_json_obj}=   JSONLibrary.Update Value To Json   ${updated_json_obj}   $..additionalParams.virtual-link-profile-id   %{VIM_MGMT_NET}
    Log   ${updated_json_obj}
    Set Test Variable   ${updated_json_obj}
    Post API Request   ${vnf_instance_uri}
    Pass Execution If   ${request_response.status_code} in ${success_status_code_list}   Query VNF Instance completed
    ${id}=   Get Value From Json   ${request_response.json()}   $..id
    Set Suite Variable   ${createid}   ${id[0]}
    Get VNFDs List

Instantiate VNF
    [Documentation]   Test case to Instantiate a VNF
    Get Ns List
    Get Vnf List
    Get Auth Token
    ${json_path}=   Read Directory
    ${json_obj}=   Load JSON From File   ${json_path}/sol003_DualStackip.json
    ${json_obj}=   Get Variable Value   ${json_obj['data'][1]}
    ${updated_json_obj}=   JSONLibrary.Update Value To Json   ${json_obj}   $..vimAccountId   ${created_vim_account_id}
    ${updated_json_obj}=   JSONLibrary.Update Value To Json   ${updated_json_obj}   $..vnfId   ${createid}
    Set Test Variable   ${updated_json_obj}
    Post API Request   ${vnf_instantiate_uri}/${createid}/instantiate
    Pass Execution If   ${request_response.status_code} in ${success_status_code_list}   Instantiate VNF Instance completed
    ${id}=   Get Value From Json   ${request_response.json()}   $..id
    Set Suite Variable   ${instantiateid}   ${id[0]}
    Sleep   12s
    Get Ns List
    Get Vnf List

Get Ns Id
    [Documentation]   Get the ns id from the ns list
    ${id}=   Get Ns Id   ${ns_name}
    Set Suite Variable   ${ns_id}   ${id}

Get Dual Ip
    [Documentation]   Get the ip from the ns list
    ${id}=   Get Dual Ip   ${ns_id}
    Set Suite Variable   ${ip}   ${id}

Query VNF Instances
    [Documentation]   Test case to query VNF Instance
    Get Auth Token
    Get Api Request   ${vnf_instance_uri}
    ${value}=   Get ID   nsState
    Should Be Equal   ${value}   INSTANTIATED
    Pass Execution If   ${request_response.status_code} in ${success_status_code_list}   Query VNF Instance completed
    ${id}=   Get Value From Json   ${request_response.json()}   $.._id
    Set Suite Variable   ${Queryid}   ${id[0]}

Query VNF Instance ID
    [Documentation]   Test case to query Vnf instance ID
    Get Auth Token
    Get Api Request   ${vnf_instance_uri}/${Queryid}
    ${value}=   Get ID   nsState
    Should Be Equal   ${value}   INSTANTIATED
    Should Be Equal As Strings   ${RequestResponse.status_code}   200
    ${id}=   Get Value From Json   ${request_response.json()}   $.._id
    Set Suite Variable   ${Instanceid}   ${id[0]}

Query VNF LCM Ops
    [Documentation]   Test case to Query VNF LCM operation
    Get Auth Token
    Get Api Request   ${vnf_instance_lcm_ops}
    ${ID1}=   Get Value From Json   ${request_response.json()}   $.._id
    Set Suite Variable   ${lcmops}   ${ID1[0]}
    FOR   ${Index}   IN RANGE   0   15
    Get Api Request   ${vnf_instance_lcm_ops}
    ${value}=   Get ID   operationState
    ${status}=   Run Keyword And Return Status   Should Be Equal   ${value}   COMPLETED
    Run Keyword If   ${status}   Exit For Loop
    ...   ELSE   Sleep   10s
    END

Query VNF LCM Ops ID
    [Documentation]   Test case to Query VNF LCM operation id
    Get Auth Token
    Get Api Request   ${vnf_instance_lcm_ops}/${lcmops}
    ${ID1}=   Get Value From Json   ${request_response.json()}   $.._id
    Set Suite Variable   ${lcmopsid}   ${ID1[0]}
    FOR   ${Index}   IN RANGE   0   15
        Get Api Request   ${vnf_instance_lcm_ops}/${lcmops}
        ${value}=   Get ID   operationState
        ${status}=   Run Keyword And Return Status   Should Be Equal   ${value}   COMPLETED
        Run Keyword If   ${status}   Exit For Loop
        ...   ELSE   Sleep   10s
    END

Verify Dual Ip
    Should Be Equal   ${ip}   ${Value1}


Terminate VNF
    [Documentation]   Test case to terminate the VNF
    Get Auth Token
    ${json_path}=   Read Directory
    ${updated_json_obj}=   Load JSON From File   ${json_path}/sol003_DualStackip.json
    ${updated_json_obj}=   Get Variable Value   ${updated_json_obj['data'][3]}
    Set Suite Variable   ${updated_json_obj}
    Post API Request   ${vnf_instance_uri}/${createid}/terminate
    ${id}=   Get Value From Json   ${request_response.json()}   $..id
    Set Suite Variable   ${terminateid}   ${id[0]}
    Get Api Request   ${vnf_instance_lcm_ops}/${terminateid}
    ${LcmopsTerminate}=   Get Value From Json   ${request_response.json()}   $.._id
    Set Suite Variable   ${lcmopsscaleid}   ${LcmopsTerminate[0]}
    FOR   ${Index}   IN RANGE   0   15
        Get Api Request   ${vnf_instance_lcm_ops}/${terminateid}
        ${value}=   Get ID   operationState
        ${status}=   Run Keyword And Return Status   Should Be Equal   ${value}   COMPLETED
        Run Keyword If   ${status}   Exit For Loop
        ...   ELSE   Sleep   10s
    END
    Pass Execution If   ${request_response.status_code} in ${success_status_code_list}   Terminate VNF instance completed

Delete VNF
    [Documentation]   Test case to delete VNF
    Get Auth Token
    Create Session   APISession   ${HOST}
    &{Headers}   Create Dictionary   Content-Type=application/json   Accept=application/json   Authorization=Bearer ${AccessToken}
    ${resp}=   DELETE On Session   APISession   ${vnf_instance_uri}/${createid}   headers=${Headers}
    Pass Execution If   ${resp.status_code} in ${success_status_code_list}   Delete VNF Instance completed

Delete VNF Descriptor Test
    [Documentation]   Test case to delete the VNF descriptor test
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting Descriptor

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}




