#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [LCMOP_01] Cancel an ongoing NS operation

Library   OperatingSystem
Library   String
Library   Collections
Library   Process
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/connectivity_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot

Force Tags   lcmop_01   cluster_lcmop   daily

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   simple_ee_vnf
${vnfd_name}   simple_ee-vnf
${nsd_pkg}   simple_ee_ns
${nsd_name}   simple_ee-ns

# NS instance name and configuration
${ns_name}   lcmop_01_cancel_operation_basic
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }


*** Test Cases ***
Create VNF Descriptor
    [Documentation]   Create the VNF descriptor

    ${id}=   Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'
    Set Suite Variable   ${vnfd_id}   ${id}


Create NS Descriptor
    [Documentation]   Create the NS descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Instantiate Network Service
    [Documentation]   Instantiate the Network service

    ${id}=   Instantiate Network Service   ${ns_name}   ${nsd_name}   %{VIM_TARGET}   --config '${ns_config}'
    Set Suite Variable   ${ns_id}   ${id}


Get operation ID
    [Documentation]   Obtain the operation ID of the NS instantiation

    ${id}=   Get Operations By Type   ${ns_id}   instantiate
    Set Suite Variable   ${op_id}   ${id}


Cancel operation
    [Documentation]   Cancel the ongoing NS instantiation

    Sleep   5s   Waiting before cancelling the operation
    Cancel operation By Id   ${op_id}


Check that operation is cancelled
    [Documentation]   Check that the operation is succesfully cancelled

    Check For NS Operation Cancelled   ${op_id}


Delete NS Instance Test
    [Documentation]   Delete the cancelled NS instance
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor Test
    [Documentation]   Delete the NS descriptor
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor Test
    [Documentation]   Delete the VNF descriptor
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting Descriptor, instance and vim

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}
