#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [BASIC-13] NS Relations

Library   OperatingSystem
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot

Force Tags   basic_13   cluster_ee_config   cluster_relations   regression   azure

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg1}   charm-packages/ns_relations_provides_vnf
${vnfd_pkg2}   charm-packages/ns_relations_requires_vnf
${vnfd_name1}   ns_relations_provides-vnf
${vnfd_name2}   ns_relations_requires-vnf
${nsd_pkg}   charm-packages/ns_relations_ns
${nsd_name}   ns_relations-ns

# NS instance name and configuration
${ns_name}   basic_13_ns_relations_test
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }
${ns_timeout}   15min

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa
${username}   ubuntu
${password}   ${EMPTY}

${action_name}   touch
${vnf_member_index_1}   vnf1
${vnf_member_index_2}   vnf2
${day_1_file_name}   /home/ubuntu/first-touch
${day_2_file_name_1}   /home/ubuntu/mytouch1
${day_2_file_name_2}   /home/ubuntu/mytouch2


*** Test Cases ***
Create Charm VNF Descriptor Provides

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg1}'


Create Charm VNF Descriptor Requires

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg2}'


Create Charm NS Descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Instantiate Charm Network Service

    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}   ${ns_timeout}
    Set Suite Variable   ${ns_id}   ${id}


# TODO Check juju status for relations


Delete NS Instance
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor Provides
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name1}


Delete VNF Descriptor Requires
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name2}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suite Cleanup: Deleting descriptors and NS instance

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}

