#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   Library to deploy and delete OSM repos.


*** Variables ***
${success_return_code}   0

*** Keywords ***
Get Repos List
    ${rc}   ${stdout}=   Run and Return RC and Output   osm repo-list
    Log   ${stdout}
    Should Be Equal As Integers   ${rc}   ${success_return_code}


Create Repo
    [Arguments]   ${repo_name}   ${repo_uri}   ${repo_type}   ${user}   ${password}   ${additional_options}=""

    ${user_attr}   Set Variable If   '${user}'!='${EMPTY}'   --user ${user}   \
    ${password_attr}   Set Variable If   '${password}'!='${EMPTY}'   --password ${password}   \

    ${rc}   ${stdout}=   Run and Return RC and Output   osm repo-add --type ${repo_type} ${user_attr} ${password_attr} ${additional_options} ${repo_name} ${repo_uri}
    Log   ${stdout}
    Should Be Equal As Integers   ${rc}   ${success_return_code}
    [Return]   ${stdout}


Delete Repo
    [Arguments]   ${repo_id}

    ${rc}   ${stdout}=   Run Keyword And Continue On Failure   Run and Return RC and Output   osm repo-delete ${repo_id}
    Should Be Equal As Integers   ${rc}   ${success_return_code}
    Log   ${stdout}
    WAIT UNTIL KEYWORD SUCCEEDS   ${delete_max_wait_time}   ${delete_pol_time}   Check For NSD   ${repo_id}


Check For Repo
    [Arguments]   ${repo_id}

    ${rc}   ${stdout}=   Run and Return RC and Output   osm repo-list | awk '{print $2}' | grep ${repo_id}
    Should Not Be Equal As Strings   ${stdout}   ${repo_id}
