#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [BASIC-25] Update Charms in Running VNF Instance.

Library   OperatingSystem
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot

Force Tags   basic_25   cluster_ee_config   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   charm-packages/ha_proxy_charm_vnf
${updated_vnfd_pkg}   charm-packages/updated_vnfds/ha_proxy_charm_vnf
${vnfd_name}   ha_proxy_charm-vnf
${nsd_pkg}   charm-packages/ha_proxy_charm_ns
${nsd_name}   ha_proxy_charm-ns

# NS instance name and configuration
${ns_name}   basic_25_charm_update_test
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa
${username}   ubuntu
${password}   ${EMPTY}

${action_name}   touch
${new_action_name}   mkdir
${vnf_member_index}   vnf1
${day_1_file_name}   /home/ubuntu/first-touch
${day_2_file_name}   /home/ubuntu/mytouch1
${day_2_folder_name}   /home/ubuntu/myfolder1
${ns_timeout}   15min

# NS update operation configuration
${update_type}   CHANGE_VNFPKG
${ns_update_timeout}   500


*** Test Cases ***
Create Charm VNF Descriptor

    ${id}=   Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'
    Set Suite Variable   ${vnfd_id}   ${id}


Create Charm NS Descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Instantiate Charm Network Service

    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}   ${ns_timeout}
    Set Suite Variable   ${ns_id}   ${id}


Set NS Update Config

    Variable Should Exist   ${ns_id}   msg=NS is not available
    ${id}   Get Vnf Id   ${ns_id}   ${vnf_member_index}
    Log   ${id}
    Set Suite Variable   ${vnf_id}   ${id}
    Set Suite Variable   ${ns_update_config}   '{changeVnfPackageData: [{vnfInstanceId: "${vnf_id}", vnfdId: "${vnfd_id}"}]}'


Get Management Ip Address

    ${ip_addr}   Get Vnf Management Ip Address   ${ns_id}   ${vnf_member_index}
    Log   ${ip_addr}
    Set Suite Variable   ${vnf_ip_addr}   ${ip_addr}


Test SSH Access

    Variable Should Exist   ${vnf_ip_addr}   msg=IP address of the management VNF '${vnf_member_index}' is not available
    Sleep   30s   Waiting ssh daemon to be up
    Test SSH Connection   ${vnf_ip_addr}   ${username}   ${password}   ${privatekey}


Check Remote Files Created Via Day 1 Operation
    [Documentation]   The Charm VNF has a Day 1 operation that creates a file named ${day_1_file_name}.
    ...               This test checks whether that files have been created or not.

    Check If remote File Exists   ${vnf_ip_addr}   ${username}   ${password}   ${privatekey}   ${day_1_file_name}


Execute Day 2 Operation
    [Documentation]   Performs one Day 2 operation on the VNF that creates a new file.

    Variable Should Exist   ${ns_id}   msg=Network service instance is not available
    ${ns_op_id_1}=   Execute NS Action   ${ns_name}   ${action_name}   ${vnf_member_index}   filename=${day_2_file_name}


Check Remote File Created Via Day 2 Operation
    [Documentation]   Check whether the file created in the previous test via Day 2 operations exist or not.

    Check If remote File Exists   ${vnf_ip_addr}   ${username}   ${password}   ${privatekey}   ${day_2_file_name}


Update VNFD Package
    [Documentation]   Updates the VNFD by using new VNFD package which includes the Charm
    ...               which has new day2 operation.

    Update VNFD   '%{PACKAGES_FOLDER}/${updated_vnfd_pkg}'   ${vnfd_name}


Update Running VNF Instance
    [Documentation]   Updates the running VNF instance by using new VNFD package.
    ...               As the VNFD has an updated charm, this operation will trigger the upgrade of existing charm
    ...               for the specific VNF.

    Update Network Service   ${ns_id}   ${update_type}   ${ns_update_config}   ${ns_update_timeout}


Execute Day 2 Operation on Upgraded Charm
    [Documentation]   Performs one Day 2 operation on the updated VNF that creates a new folder.

    Variable Should Exist   ${ns_id}   msg=Network service instance is not available
    ${ns_op_id_2}=   Execute NS Action   ${ns_name}   ${new_action_name}   ${vnf_member_index}   foldername=${day_2_folder_name}


Check Remote Folder Created Via Day 2 Operation
    [Documentation]   Check whether the folder created in the previous test via Day 2 operations exist or not.

    Check If remote Folder Exists   ${vnf_ip_addr}   ${username}   ${password}   ${privatekey}   ${day_2_folder_name}


Delete NS Instance
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suite Cleanup: Deleting descriptors and NS instance

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}

