#   Copyright 2020 Canonical Ltd.
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [K8s-01] Create K8s cluster.

Library   OperatingSystem
Library   String
Library   Collections
Library   Process
Library   SSHLibrary
Library   %{ROBOT_DEVOPS_FOLDER}/lib/renderTemplate.py

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot

Force Tags   k8s_01   cluster_k8s

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package files
${vnfd_pkg1}   k8s_jujucontroller_vnf.tar.gz
${vnfd_pkg2}   k8s_jujumachine_vnf.tar.gz
${nsd_pkg}   k8s_juju_ns.tar.gz
${vnfd_name1}   k8s_jujucontroller_vnf
${vnfd_name2}   k8s_jujumachine_vnf
${nsd_name}   k8s_juju

# VNF Member indexes
${vnf_member_index_1}   k8s_vnf1
${vnf_member_index_2}   k8s_vnf2
${vnf_member_index_3}   k8s_vnf3
${vnf_member_index_4}   k8s_vnf4
${vnf_member_index_5}   k8s_juju

# Username
${username}   ubuntu

# Kubeconfig file
${kubeconfig_file}   /home/ubuntu/.kube/config

# NS instance name
${ns_name}   k8s-cluster

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa
${username}   ubuntu
${password}   ${EMPTY}

# Template and config file to use
${template}   k8s_juju_template.yaml
${config_file}   config.yaml


*** Test Cases ***
Render a template

    ${stdout}=   Render template   %{ROBOT_DEVOPS_FOLDER}/resources/${template}   %{ROBOT_DEVOPS_FOLDER}/resources/${config_file}   IP_VM1=%{IP_VM1}   IP_VM2=%{IP_VM2}   IP_VM3=%{IP_VM3}   IP_VM4=%{IP_VM4}   IP_JUJU=%{IP_JUJU}   NETWORK=%{VIM_MGMT_NET}
    Log To Console   \n${stdout}


Create Controller VNF Descriptor

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg1}'


Create Machines VNF Descriptor

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg2}'


Create K8s Cluster NS Descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Instantiate K8s Cluster Network Service

    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ns_config=${EMPTY}   publickey=${publickey}   ns_launch_max_wait_time=70min   config_file=%{ROBOT_DEVOPS_FOLDER}/resources/${config_file}
    Set Suite Variable   ${ns_id}   ${id}


Get Management Ip Addresses

    ${ip_addr_1}   Get Vnf Management Ip Address   ${ns_id}   ${vnf_member_index_1}
    Log   ${ip_addr_1}
    Set Suite Variable   ${vnf_1_ip_addr}   ${ip_addr_1}
    ${ip_addr_2}   Get Vnf Management Ip Address   ${ns_id}   ${vnf_member_index_2}
    Log   ${ip_addr_2}
    Set Suite Variable   ${vnf_2_ip_addr}   ${ip_addr_2}
    ${ip_addr_3}   Get Vnf Management Ip Address   ${ns_id}   ${vnf_member_index_3}
    Log   ${ip_addr_3}
    Set Suite Variable   ${vnf_3_ip_addr}   ${ip_addr_3}
    ${ip_addr_4}   Get Vnf Management Ip Address   ${ns_id}   ${vnf_member_index_4}
    Log   ${ip_addr_4}
    Set Suite Variable   ${vnf_4_ip_addr}   ${ip_addr_4}
    ${ip_addr_5}   Get Vnf Management Ip Address   ${ns_id}   ${vnf_member_index_5}
    Log   ${ip_addr_5}
    Set Suite Variable   ${vnf_5_ip_addr}   ${ip_addr_5}


Test SSH Access

    Variable Should Exist   ${vnf_1_ip_addr}   msg=IP address of the management VNF '${vnf_member_index_1}' is not available
    Variable Should Exist   ${vnf_2_ip_addr}   msg=IP address of the management VNF '${vnf_member_index_2}' is not available
    Variable Should Exist   ${vnf_3_ip_addr}   msg=IP address of the management VNF '${vnf_member_index_3}' is not available
    Variable Should Exist   ${vnf_4_ip_addr}   msg=IP address of the management VNF '${vnf_member_index_4}' is not available
    Variable Should Exist   ${vnf_5_ip_addr}   msg=IP address of the management VNF '${vnf_member_index_5}' is not available
    Sleep   30s   Waiting ssh daemon to be up
    Test SSH Connection   ${vnf_1_ip_addr}   ${username}   ${password}   ${privatekey}
    Test SSH Connection   ${vnf_2_ip_addr}   ${username}   ${password}   ${privatekey}
    Test SSH Connection   ${vnf_3_ip_addr}   ${username}   ${password}   ${privatekey}
    Test SSH Connection   ${vnf_4_ip_addr}   ${username}   ${password}   ${privatekey}
    Test SSH Connection   ${vnf_5_ip_addr}   ${username}   ${password}   ${privatekey}


Check kubeconfig file

    Check If remote File Exists   ${vnf_5_ip_addr}   ${username}   ${password}   ${privatekey}   ${kubeconfig_file}


Delete NS Instance
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete Controller VNF Descriptor
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name1}

Delete Machines VNF Descriptor
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name2}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suite Cleanup: Deleting descriptors and NS instance

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}
    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}
    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}
