#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [BASIC-31] Basic NS with two multi-VDU VNF

Library   OperatingSystem
Library   String
Library   Collections
Library   Process
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/connectivity_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot

Force Tags   basic_31   cluster_main   daily

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   multivdu_multiattach_vnf
${vnfd_name}   multivdu_multiattach-vnf
${nsd_pkg}   multivdu_multiattach_ns
${nsd_name}   multivdu_multiattach-ns

# NS instance name and configuration
${ns_name}   multivdu_multiattach
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa
${username}   ubuntu
${password}   ${EMPTY}

${ns_id}   ${EMPTY}
${vnf_member_index}   vnf
${vnf_ip_addr}   ${EMPTY}
${wait_guard_for_vm_boot}   50s


*** Test Cases ***
Create Hackfest multivdu VNF Descriptor

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create Hackfest Multivdu NS Descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Network Service Instance Test

    ${status}   ${message}=   Run Keyword And Ignore Error   Variable Should Exist   ${publickey}
        Run Keyword If   "${status}" == "FAIL"   Set Global Variable   ${publickey}   ${EMPTY}
    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}
    Set Suite Variable   ${ns_id}   ${id}
    Sleep   ${wait_guard_for_vm_boot}   Waiting for VM's daemons to be up and running


Get Vnf ID

    ${_vnf_id}=   Get Vnf Id   ${ns_id}   ${vnf_member_index}
    Set Suite Variable   ${vnf_id}   ${_vnf_id}


Get Vnf Management Ip Addresses

    ${rc}   ${vdu0_ip}=   Run and Return RC and Output   osm vnf-show ${vnf_id} --literal | yq -r '.vdur[0].interfaces[]."ip-address"'
    ${rc}   ${vdu1_ip}=   Run and Return RC and Output   osm vnf-show ${vnf_id} --literal | yq -r '.vdur[1].interfaces[]."ip-address"'
    Set Suite Variable   ${mgmnt_ip_addr_0}   ${vdu0_ip}
    Set Suite Variable   ${mgmnt_ip_addr_1}   ${vdu1_ip}


Ensure that VDUs can share data

    Execute Remote Command Check Rc Return Output   ${mgmnt_ip_addr_0}   ${username}   ${EMPTY}   ${privatekey}   sudo mkfs.ext3 -F /dev/vdb && sudo mkdir /shared && sudo mount /dev/vdb /shared && sudo chown ubuntu /shared && echo "osmtest" > /shared/test_file
    Execute Remote Command Check Rc Return Output   ${mgmnt_ip_addr_1}   ${username}   osmpass   ${privatekey}   sudo mkdir /shared && sudo mount /dev/vdb /shared && cat /shared/test_file
    ${stdout}=   Execute Remote Command Check Rc Return Output   ${mgmnt_ip_addr_0}   ${username}   ${EMPTY}   ${privatekey}   cat /shared/test_file
    Log   ${stdout}
    Should Be Equal   ${stdout}   osmtest   Shared data can't be read


Delete NS Instance Test
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor Test
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor Test
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting Descriptor, instance and vim

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}
