#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

*** Settings ***
Documentation   [BASIC-22] Cross-model relations

Library   OperatingSystem
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/k8scluster_lib.robot

Force Tags   basic_22   cluster_ee_config   cluster_relations   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# K8s cluster name and version
${k8scluster_name}   k8sbasic_22
${k8scluster_version}   v1

# NS and VNF descriptor package folder and ids
${vnfd_pkg_1}   charm-packages/cmr_relation_vnf
${vnfd_pkg_2}   charm-packages/cmr_no_relation_vnf
${nsd_pkg}   charm-packages/cmr_relation_ns
${vnfd_name_1}   cross_model_relation-vnf
${vnfd_name_2}   cross_model_no_relation-vnf
${nsd_name}   cross_model_relation-ns

# NS instance name and configuration
${ns_name}   basic_22
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }
${ns_timeout}   15min

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa
${username}   ubuntu
${password}   ${EMPTY}


*** Test Cases ***
Create Charm VNF Descriptor 1

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg_1}'

Create Charm VNF Descriptor 2

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg_2}'

Create Charm NS Descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'

Add K8s Cluster To OSM
    Create K8s Cluster   %{K8S_CREDENTIALS}   ${k8scluster_version}   %{VIM_TARGET}   %{VIM_MGMT_NET}   ${k8scluster_name}

Instantiate Charm Network Service

    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}   ${ns_timeout}
    Set Suite Variable   ${ns_id}   ${id}


# TODO Check juju status for relations


Delete NS Instance
    [Tags]   cleanup

    Delete NS   ${ns_name}

Remove K8s Cluster from OSM
    [Tags]   cleanup
    Delete K8s Cluster   ${k8scluster_name}

Delete NS Descriptor
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor 1
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name_1}

Delete VNF Descriptor 2
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name_2}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suite Cleanup: Deleting descriptors and NS instance

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD 1   ${vnfd_name_1}

    Run Keyword If Any Tests Failed   Delete VNFD 2   ${vnfd_name_2}

