#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [SA-01] VNF with VIM-based metrics.

Library   OperatingSystem
Library   String
Library   Collections

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/prometheus_lib.robot

Force Tags   sa_01   cluster_sa   daily   regression

Suite Setup   Run Keyword And Ignore Error   Suite Preparation
Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS instantiation parameters
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

# NS and VNF descriptor package folder and ids
${vnfd_pkg}   hackfest_basic_metrics_vnf
${vnfd_name}   hackfest_basic_metrics-vnf
${nsd_pkg}   hackfest_basic_metrics_ns
${nsd_name}   hackfest_basic-ns-metrics

# NS instance name
${ns_name}   sa_01-vnf_with_vim_metrics_test

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa

# Prometheus polling interval and retries
${prometheus_poll_retries}   15 times
${prometheus_poll_timeout}   1 minute

# Prometheus metrics to retrieve
${metric_1_name}   osm_cpu_utilization
${metric_2_name}   osm_average_memory_utilization


*** Test Cases ***
Create VNF Descriptor

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create NS Descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Instantiate Network Service

    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${publickey}
    Set Suite Variable   ${ns_id}   ${id}


Get VNF VIM-based Metrics

    Variable Should Exist   ${prometheus_poll_retries}   msg=Metric polling retries is not available
    Variable Should Exist   ${prometheus_poll_timeout}   msg=Metric polling timeout is not available
    Variable Should Exist   ${prometheus_host}   msg=Prometheus address is not available
    Variable Should Exist   ${prometheus_port}   msg=Prometheus port is not available
    Variable Should Exist   ${metric_1_name}   msg=Prometheus first metric name is not available
    Variable Should Exist   ${metric_2_name}   msg=Prometheus second metric name is not available
    ${metric_filter}=   Set Variable   ns_id=${ns_id}
    ${metric_1_value}=   Wait Until Keyword Succeeds   ${prometheus_poll_retries}   ${prometheus_poll_timeout}   Get Metric   ${prometheus_host}   ${prometheus_port}   ${prometheus_user}   ${prometheus_password}   ${metric_1_name}   ${metric_filter}
    Run Keyword If   ${metric_1_value} <= 0   Fail   msg=The metric '${metric_1_name}' value is '${metric_1_value}'
    ${metric_2_value}=   Wait Until Keyword Succeeds   ${prometheus_poll_retries}   ${prometheus_poll_timeout}   Get Metric   ${prometheus_host}   ${prometheus_port}   ${prometheus_user}   ${prometheus_password}   ${metric_2_name}   ${metric_filter}
    Run Keyword If   ${metric_2_value} <= 0   Fail   msg=The metric '${metric_2_name}' value is '${metric_2_value}'


Delete NS Instance
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Preparation
    [Documentation]   Test Suite Preparation: Setting Prometheus Testsuite Variables

    Set Testsuite Prometheus Variables


Suite Cleanup
    [Documentation]   Test Suite Cleanup: Deleting descriptors and NS instance

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}
