#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [BASIC-05] Instantiation parameters in cloud-init.

Library   OperatingSystem
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ssh_lib.robot

Force Tags   basic_05   cluster_main   daily   regression

Suite Teardown   Run Keyword And Ignore Error   Suite Cleanup


*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   ubuntu_cloudinit_vnf
${vnfd_name}   ubuntu_cloudinit-vnf
${nsd_pkg}   ubuntu_cloudinit_ns
${nsd_name}   ubuntu_cloudinit-ns

# NS instance name and configuration
${ns_name}   basic_05_instantiation_params_cloud_init
${vnf_member_index}   vnf
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ], additionalParamsForVnf: [ { member-vnf-index: "${vnf_member_index}", additionalParams: { password: "${new_password}" } } ] }

# SSH user and password
${username}   ubuntu
${new_password}   newpassword


*** Test Cases ***
Create Cloudinit VNF Descriptor

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create Cloudinit NS Descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Instantiate Cloudinit Network Service Using Instantiation Parameters
    [Documentation]   Instantiates the NS using the instantiation parameter 'additionalParamsForVnf' to change the password of the default user.

    ${id}=   Create Network Service   ${nsd_name}   %{VIM_TARGET}   ${ns_name}   ${ns_config}   ${EMPTY}
    Set Suite Variable   ${ns_id}   ${id}


Get Management Ip Addresses

    ${ip_addr}   Get Vnf Management Ip Address   ${ns_id}   ${vnf_member_index}
    Log   ${ip_addr}
    Set Suite Variable   ${vnf_ip_addr}   ${ip_addr}


Test SSH Access With The New Password
    [Documentation]   Test SSH access with the new password configured via cloud-init.

    Variable Should Exist   ${vnf_ip_addr}   msg=IP address of the management VNF is not available
    Sleep   30s   Waiting ssh daemon to be up
    Test SSH Connection   ${vnf_ip_addr}   ${username}   ${new_password}   ${EMPTY}


Delete NS Instance
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suite Cleanup: Deleting descriptors and NS instance

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}

