#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

*** Settings ***
Documentation   [BASIC-32] Basic NS with a volume in different availability zone

Library   OperatingSystem
Library   String
Library   Collections
Library   Process
Library   SSHLibrary

Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vim_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/prometheus_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/vnfd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/nsd_lib.robot
Resource   %{ROBOT_DEVOPS_FOLDER}/lib/ns_lib.robot

Variables   %{ROBOT_DEVOPS_FOLDER}/resources/basic_32-volume_with_different_az.py

Force Tags   basic_32

Suite Setup   Run Keyword And Ignore Error   Suite Preparation

*** Variables ***
# NS and VNF descriptor package folder and ids
${vnfd_pkg}   several_volumes_vnf
${vnfd_name}   several_volumes-vnf
${nsd_pkg}   several_volumes_ns
${nsd_name}   several_volumes-ns

# NS instance name and configuration
${ns_name}   basic_32
${ns_config}   {vld: [ {name: mgmtnet, vim-network-name: %{VIM_MGMT_NET}} ] }

# SSH keys and username to be used
${publickey}   %{HOME}/.ssh/id_rsa.pub
${privatekey}   %{HOME}/.ssh/id_rsa


*** Test Cases ***
Create VIM Target Basic
    [Documentation]   Create a VIM Target only with the az parameters.
    ...               Checks the status of the VIM in Prometheus after it creation.

    Pass Execution If   '${vim_account_type}' != 'openstack'   Not applicable for ${vim_account_type} VIM
    ${rand}=   Generate Random String   6   [NUMBERS]
    ${vim_name_az}=   Catenate   SEPARATOR=_   ${vim_name_prefix}   ${rand}
    Set Suite Variable   ${vim_name_az}
    ${created_vim_account_id}=   Create VIM Target   ${vim_name_az}   ${vim_user}   ${vim_password}   ${vim_auth_url}   ${vim_tenant}   ${vim_account_type}   config=${vim_config}
    Set Suite Variable   ${created_vim_account_id}


Create VNF Descriptor

    Create VNFD   '%{PACKAGES_FOLDER}/${vnfd_pkg}'


Create NS Descriptor

    Create NSD   '%{PACKAGES_FOLDER}/${nsd_pkg}'


Network Service Instance Test
    [Tags]   prepare
    ${id}=   Create Network Service   ${nsd_name}   ${vim_name_az}   ${ns_name}   ${ns_config}   ${publickey}
    Set Suite Variable   ${ns_id}   ${id}


Delete NS Instance Test
    [Tags]   cleanup

    Delete NS   ${ns_name}


Delete NS Descriptor Test
    [Tags]   cleanup

    Delete NSD   ${nsd_name}


Delete VNF Descriptor Test
    [Tags]   cleanup

    Delete VNFD   ${vnfd_name}


Delete VIM Target By ID
    [Documentation]   Delete the VIM Target created in previous test-case by its ID.
    ...               Checks whether the VIM Target was created or not before perform the deletion.
    [Tags]   cleanup

    ${vim_account_id}=   Get VIM Target ID   ${vim_name_az}
    Should Be Equal As Strings   ${vim_account_id}   ${created_vim_account_id}
    Delete VIM Target   ${vim_account_id}


*** Keywords ***
Suite Cleanup
    [Documentation]   Test Suit Cleanup: Deleting Descriptor, instance and vim

    Run Keyword If Any Tests Failed   Delete NS   ${ns_name}

    Run Keyword If Any Tests Failed   Delete NSD   ${nsd_name}

    Run Keyword If Any Tests Failed   Delete VNFD   ${vnfd_name}