*** Comments ***
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.


*** Settings ***
Documentation   [EPA-03] CRUD operations on SDNC accounts.

Resource   ../lib/prometheus_lib.resource
Resource   ../lib/sdnc_lib.resource

Variables   ../resources/epa_03-crud_operations_on_sdnc_data.py

Test Tags   epa_03   cluster_epa   daily   regression

Suite Setup   Run Keyword And Ignore Error   Suite Preparation
Suite Teardown   Run Keyword And Ignore Error   Delete Basic SDNC


*** Variables ***
${SDNC_ENABLED_MAX_WAIT_TIME}   1min
${SDNC_ENABLED_POL_TIME}   10


*** Test Cases ***
Create Basic SDNC
    [Documentation]   Register SDN controller in OSM.
    ${created_sdnc_id}=   Create SDNC   ${sdnc_name}   ${sdnc_user}   ${sdnc_password}   ${sdnc_url}   ${sdnc_type}
    Set Suite Variable   ${SDNC_ID}   ${created_sdnc_id}
    Wait Until Keyword Succeeds   ${SDNC_ENABLED_MAX_WAIT_TIME}   ${SDNC_ENABLED_POL_TIME}   Check For SDNC   ${SDNC_ID}

Check SDNC Status Is Healthy
    [Documentation]   Check in Prometheus that the SDN controller is in healthy state.
    Check For SDNC Status   ${SDNC_ID}   ${PROMETHEUS_HOST}   ${PROMETHEUS_PORT}   ${PROMETHEUS_USER}   ${PROMETHEUS_PASSWORD}

Delete Basic SDNC
    [Documentation]   Delete SDN controller from OSM.
    [Tags]   cleanup
    Delete SDNC   ${sdnc_name}


*** Keywords ***
Suite Preparation
    [Documentation]   Test Suite Preparation: Setting Prometheus Testsuite Variables.
    Set Testsuite Prometheus Variables
