
# Copyright 2019 ArctosLabs Scandinavia AB
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Note:
# This unit test file is generated - 
# from: c:\Users\LG\Desktop\plarepo\documents\Test\pla_algo_test (pr_update_4).xlsx
# by code generator: mzntestcasegenerator.py
# at: 2019-12-04 09:26:38.412430
#############

import datetime
import logging
from unittest import TestCase

from osm_pla.placement.mznplacement import MznPlacementConductor, MznModelGenerator


class TestMznModels(TestCase):
    def test_mznmodel_scenario1_subtestcase1(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 120, 'jitter': 20}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario1_subtestcase2(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim33333333_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 120, 'jitter': 20}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '33333333-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim33333333_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario1_subtestcase3(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim22222222_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 120, 'jitter': 20}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '22222222-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim22222222_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario1_subtestcase4(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim44444444_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 120, 'jitter': 20}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '44444444-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '22222222-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim44444444_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario1_subtestcase5(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim88888888_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 120, 'jitter': 20}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '88888888-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim88888888_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario1_subtestcase6(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim99999999_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 120, 'jitter': 20}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '99999999-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim99999999_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario1_subtestcase7(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim11111111_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim33333333_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170'], 'vim_account': 'vim77777777_38f5_438d_b8ee_3f93b3531f87'}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 120, 'jitter': 20}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim11111111_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim33333333_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170'], 'vim_account': 'vim77777777_38f5_438d_b8ee_3f93b3531f87'}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario1_subtestcase8(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim77777777_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 120, 'jitter': 20}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim77777777_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario2_subtestcase1(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 20, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario2_subtestcase2(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim44444444_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 20, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '44444444-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '22222222-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '22222222-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim44444444_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario2_subtestcase3(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 20, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '55555555-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '66666666-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '66666666-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario2_subtestcase4(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 20, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '55555555-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '55555555-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '55555555-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario2_subtestcase5(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim33333333_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim44444444_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 20, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim33333333_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim44444444_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario2_subtestcase6(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170'], 'vim_account': 'vim66666666_38f5_438d_b8ee_3f93b3531f87'}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '3'], 'latency': 20, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170'], 'vim_account': 'vim66666666_38f5_438d_b8ee_3f93b3531f87'}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario3_subtestcase1(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 3}, {'cp_refs': ['2', '3'], 'latency': 25, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario3_subtestcase2(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim44444444_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim22222222_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 3}, {'cp_refs': ['2', '3'], 'latency': 25, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim44444444_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim22222222_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario3_subtestcase3(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim77777777_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 3}, {'cp_refs': ['2', '3'], 'latency': 25, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim77777777_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario3_subtestcase4(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim88888888_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 3}, {'cp_refs': ['2', '3'], 'latency': 25, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '88888888-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim88888888_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150']}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario3_subtestcase5(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim99999999_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim77777777_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170'], 'vim_account': 'vim88888888_38f5_438d_b8ee_3f93b3531f87'}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 3}, {'cp_refs': ['2', '3'], 'latency': 25, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim99999999_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim77777777_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170'], 'vim_account': 'vim88888888_38f5_438d_b8ee_3f93b3531f87'}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario3_subtestcase6(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim77777777_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim99999999_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 3}, {'cp_refs': ['2', '3'], 'latency': 25, 'jitter': 6}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '99999999-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '77777777-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim77777777_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['10,15,30,30,100,70,40,150,150,150'], 'vim_account': 'vim99999999_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '3', 'vnf_price_per_vim': ['30,30,60,40,100,90,40,150,200,170']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario4_subtestcase1(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '2', 'vnf_price_per_vim': ['15,20,40,40,110,80,50,110,160,210']}, {'vnf_id': '3', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '4', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '4'], 'latency': 50, 'jitter': 10}, {'cp_refs': ['2', '3'], 'latency': 20, 'jitter': 10}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}, {'vimAccountId': '00000000-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '4'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '2', 'vnf_price_per_vim': ['15,20,40,40,110,80,50,110,160,210']}, {'vnf_id': '3', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '4', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario4_subtestcase2(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim22222222_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['15,20,40,40,110,80,50,110,160,210']}, {'vnf_id': '3', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '4', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '4'], 'latency': 50, 'jitter': 10}, {'cp_refs': ['2', '3'], 'latency': 20, 'jitter': 10}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '22222222-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '44444444-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '55555555-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}, {'vimAccountId': '66666666-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '4'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim22222222_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['15,20,40,40,110,80,50,110,160,210']}, {'vnf_id': '3', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '4', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario4_subtestcase3(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['15,20,40,40,110,80,50,110,160,210']}, {'vnf_id': '3', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '4', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '4'], 'latency': 50, 'jitter': 10}, {'cp_refs': ['2', '3'], 'latency': 20, 'jitter': 10}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{'vimAccountId': '55555555-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '1'}, {'vimAccountId': '66666666-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '2'}, {'vimAccountId': '66666666-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '3'}, {'vimAccountId': '55555555-38f5-438d-b8ee-3f93b3531f87', 'member-vnf-index': '4'}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['15,20,40,40,110,80,50,110,160,210']}, {'vnf_id': '3', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}, {'vnf_id': '4', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim55555555_38f5_438d_b8ee_3f93b3531f87'}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')
    def test_mznmodel_scenario4_subtestcase4(self):
        # generate the model
        ns_placement_data = {'vim_accounts': ['vim00000000_38f5_438d_b8ee_3f93b3531f87', 'vim11111111_38f5_438d_b8ee_3f93b3531f87', 'vim22222222_38f5_438d_b8ee_3f93b3531f87', 'vim33333333_38f5_438d_b8ee_3f93b3531f87', 'vim44444444_38f5_438d_b8ee_3f93b3531f87', 'vim55555555_38f5_438d_b8ee_3f93b3531f87', 'vim66666666_38f5_438d_b8ee_3f93b3531f87', 'vim77777777_38f5_438d_b8ee_3f93b3531f87', 'vim88888888_38f5_438d_b8ee_3f93b3531f87', 'vim99999999_38f5_438d_b8ee_3f93b3531f87'],
                             'trp_link_latency' : [[0, 30, 70, 80, 32767, 32767, 32767, 32767, 32767, 32767], [30, 0, 75, 60, 32767, 32767, 32767, 32767, 32767, 32767], [70, 75, 0, 40, 100, 32767, 32767, 32767, 32767, 32767], [80, 60, 40, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 100, 32767, 0, 5, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 0, 5, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 5, 5, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 30, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 30, 0, 20], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 20, 20, 0]],
                             'trp_link_jitter' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 5, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 5, 32767, 0, 4, 4, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 0, 10, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 4, 10, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 1, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 0, 1], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 1, 1, 0]],
                             'trp_link_price_list' : [[0, 5, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 0, 5, 10, 32767, 32767, 32767, 32767, 32767, 32767], [5, 5, 0, 10, 10, 32767, 32767, 32767, 32767, 32767], [10, 10, 10, 0, 32767, 32767, 32767, 32767, 32767, 32767], [32767, 32767, 10, 32767, 0, 20, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 0, 20, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 20, 20, 0, 32767, 32767, 32767], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 0, 15, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 0, 15], [32767, 32767, 32767, 32767, 32767, 32767, 32767, 15, 15, 0]],
                             'ns_desc' : [{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim00000000_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['15,20,40,40,110,80,50,110,160,210']}, {'vnf_id': '3', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim44444444_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '4', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}],
                             'vld_desc' : [{'cp_refs': ['1', '2'], 'latency': 120, 'jitter': 20}, {'cp_refs': ['2', '4'], 'latency': 50, 'jitter': 10}, {'cp_refs': ['2', '3'], 'latency': 20, 'jitter': 10}],
                             'generator_data': {'file': __file__ ,'time': datetime.datetime.now()}
                            }
        
        mg = MznModelGenerator(logging.getLogger(__name__))
        test_mzn_model = mg.create_model(ns_placement_data)

        # run the model
        expected_result = [{}]

        mpc = MznPlacementConductor(logging.getLogger(__name__))
        placement = mpc._run_placement_model(mzn_model=test_mzn_model, ns_desc=[{'vnf_id': '1', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim00000000_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '2', 'vnf_price_per_vim': ['15,20,40,40,110,80,50,110,160,210']}, {'vnf_id': '3', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200'], 'vim_account': 'vim44444444_38f5_438d_b8ee_3f93b3531f87'}, {'vnf_id': '4', 'vnf_price_per_vim': ['5,10,30,30,100,70,40,100,150,200']}])
        # sort the result to ease assert with expected result
        if not placement[0]:
            sorted_placement = placement
        else:
            sorted_placement = sorted(placement, key=lambda k: k['member-vnf-index'])
        self.assertEqual(expected_result, sorted_placement, 'Faulty syntax or content')