#######################################################################################
# Copyright ETSI Contributors and Others.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#######################################################################################

"""
OSM Cluster API handling
"""

from osmclient.sol005.osm_api_object import GenericOSMAPIObject
from osmclient.common.exceptions import ClientException
import json


class Cluster(GenericOSMAPIObject):
    def __init__(self, http=None, client=None):
        super().__init__(http, client)
        self._apiName = "/k8scluster"
        self._apiVersion = "/v1"
        self._apiResource = "/clusters"
        self._logObjectName = "cluster"
        self._apiBase = "{}{}{}".format(
            self._apiName, self._apiVersion, self._apiResource
        )

    def update_profiles(self, cluster_id, profile_type, update_dict):
        """Updates the profiles in a cluster"""
        self._logger.debug("")
        self._client.get_token()
        profile_endpoint = {
            "infra-controller-profile": "infra_controller_profiles",
            "infra-config-profile": "infra_config_profiles",
            "app-profile": "app_profiles",
            "resource-profile": "resource_profiles",
        }
        http_code, resp = self._http.patch_cmd(
            endpoint="{}/{}/{}".format(
                self._apiBase, cluster_id, profile_endpoint[profile_type]
            ),
            postfields_dict=update_dict,
            skip_query_admin=True,
        )
        if http_code in (200, 201, 202):
            if resp:
                resp = json.loads(resp)
            if not resp or "id" not in resp:
                raise ClientException(f"unexpected response from server - {resp}")
            print(resp["id"])
        elif http_code == 204:
            print("Updated")

    # def get_credentials(self, cluster_id):
    #     # TODO:
