/*
 Copyright 2020 TATA ELXSI

 Licensed under the Apache License, Version 2.0 (the 'License');
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Author: KUMARAN M (kumaran.m@tataelxsi.co.in), RAJESH S (rajesh.s@tataelxsi.co.in), BARATH KUMAR R (barath.r@tataelxsi.co.in)
 */
var Tar =
/******/ (function (modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if (installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
				/******/
}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
				/******/
};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
			/******/
}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function (value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function (exports, name, getter) {
/******/ 		if (!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
	/******/
});
				/******/
}
			/******/
};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function (module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
			/******/
};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function (object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 2);
		/******/
})
/************************************************************************/
/******/([
/* 0 */
/***/ (function (module, exports) {

		/*
		 * tar-js
		 * MIT (c) 2011 T. Jameson Little
		 */

		(function () {
			"use strict";

			var lookup = [
				'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
				'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
				'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
				'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
				'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
				'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
				'w', 'x', 'y', 'z', '0', '1', '2', '3',
				'4', '5', '6', '7', '8', '9', '+', '/'
			];
			function clean(length) {
				var i, buffer = new Uint8Array(length);
				for (i = 0; i < length; i += 1) {
					buffer[i] = 0;
				}
				return buffer;
			}

			function extend(orig, length, addLength, multipleOf) {
				var newSize = length + addLength,
					buffer = clean((parseInt(newSize / multipleOf) + 1) * multipleOf);

				buffer.set(orig);

				return buffer;
			}

			function pad(num, bytes, base) {
				num = num.toString(base || 8);
				return "000000000000".substr(num.length + 12 - bytes) + num;
			}

			function stringToUint8(input, out, offset) {
				var i, length;

				out = out || clean(input.length);

				offset = offset || 0;
				for (i = 0, length = input.length; i < length; i += 1) {
					out[offset] = input.charCodeAt(i);
					offset += 1;
				}

				return out;
			}

			function uint8ToBase64(uint8) {
				var i,
					extraBytes = uint8.length % 3, // if we have 1 byte left, pad 2 bytes
					output = "",
					temp, length;

				function tripletToBase64(num) {
					return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F];
				};

				// go through the array every three bytes, we'll deal with trailing stuff later
				for (i = 0, length = uint8.length - extraBytes; i < length; i += 3) {
					temp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2]);
					output += tripletToBase64(temp);
				}

				// this prevents an ERR_INVALID_URL in Chrome (Firefox okay)
				switch (output.length % 4) {
					case 1:
						output += '=';
						break;
					case 2:
						output += '==';
						break;
					default:
						break;
				}

				return output;
			}

			module.exports.clean = clean;
			module.exports.pad = pad;
			module.exports.extend = extend;
			module.exports.stringToUint8 = stringToUint8;
			module.exports.uint8ToBase64 = uint8ToBase64;
		}());


		/***/
}),
/* 1 */
/***/ (function (module, exports, __webpack_require__) {

		/*
		 * tar-js
		 * MIT (c) 2011 T. Jameson Little
		 */

		(function () {
			"use strict";

			/*
			struct posix_header {             // byte offset
				char name[100];               //   0
				char mode[8];                 // 100
				char uid[8];                  // 108
				char gid[8];                  // 116
				char size[12];                // 124
				char mtime[12];               // 136
				char chksum[8];               // 148
				char typeflag;                // 156
				char linkname[100];           // 157
				char magic[6];                // 257
				char version[2];              // 263
				char uname[32];               // 265
				char gname[32];               // 297
				char devmajor[8];             // 329
				char devminor[8];             // 337
				char prefix[155];             // 345
											  // 500
			};
			*/

			var utils = __webpack_require__(0),
				headerFormat;

			headerFormat = [
				{
					'field': 'fileName',
					'length': 100
				},
				{
					'field': 'fileMode',
					'length': 8
				},
				{
					'field': 'uid',
					'length': 8
				},
				{
					'field': 'gid',
					'length': 8
				},
				{
					'field': 'fileSize',
					'length': 12
				},
				{
					'field': 'mtime',
					'length': 12
				},
				{
					'field': 'checksum',
					'length': 8
				},
				{
					'field': 'type',
					'length': 1
				},
				{
					'field': 'linkName',
					'length': 100
				},
				{
					'field': 'ustar',
					'length': 8
				},
				{
					'field': 'owner',
					'length': 32
				},
				{
					'field': 'group',
					'length': 32
				},
				{
					'field': 'majorNumber',
					'length': 8
				},
				{
					'field': 'minorNumber',
					'length': 8
				},
				{
					'field': 'filenamePrefix',
					'length': 155
				},
				{
					'field': 'padding',
					'length': 12
				}
			];

			function formatHeader(data, cb) {
				var buffer = utils.clean(512),
					offset = 0;

				headerFormat.forEach(function (value) {
					var str = data[value.field] || "",
						i, length;

					for (i = 0, length = str.length; i < length; i += 1) {
						buffer[offset] = str.charCodeAt(i);
						offset += 1;
					}

					offset += value.length - i; // space it out with nulls
				});

				if (typeof cb === 'function') {
					return cb(buffer, offset);
				}
				return buffer;
			}

			module.exports.structure = headerFormat;
			module.exports.format = formatHeader;
		}());


		/***/
}),
/* 2 */
/***/ (function (module, exports, __webpack_require__) {

		/*
		 * tar-js
		 * MIT (c) 2011 T. Jameson Little
		 */

		(function () {
			"use strict";

			var header = __webpack_require__(1),
				utils = __webpack_require__(0),
				recordSize = 512,
				blockSize;

			function Tar(recordsPerBlock) {
				this.written = 0;
				blockSize = (recordsPerBlock || 20) * recordSize;
				this.out = utils.clean(blockSize);
			}

			Tar.prototype.append = function (filepath, input, opts, callback) {
				var data,
					checksum,
					mode,
					mtime,
					uid,
					gid,
					headerArr;

				if (typeof input === 'string') {
					input = utils.stringToUint8(input);
				} else if (input.constructor !== Uint8Array.prototype.constructor) {
					throw 'Invalid input type. You gave me: ' + input.constructor.toString().match(/function\s*([$A-Za-z_][0-9A-Za-z_]*)\s*\(/)[1];
				}

				if (typeof opts === 'function') {
					callback = opts;
					opts = {};
				}

				opts = opts || {};

				mode = opts.mode || parseInt('777', 8) & 0xfff;
				mtime = opts.mtime || Math.floor(+new Date() / 1000);
				uid = opts.uid || 0;
				gid = opts.gid || 0;

				data = {
					fileName: filepath,
					fileMode: utils.pad(mode, 7),
					uid: utils.pad(uid, 7),
					gid: utils.pad(gid, 7),
					fileSize: utils.pad(input.length, 11),
					mtime: utils.pad(mtime, 11),
					checksum: '        ',
					type: opts.type || '0',
					ustar: 'ustar  ',
					owner: opts.owner || '',
					group: opts.group || '',
					linkName: opts.linkname || ''
				};

				// calculate the checksum
				checksum = 0;
				Object.keys(data).forEach(function (key) {
					var i, value = data[key], length;

					for (i = 0, length = value.length; i < length; i += 1) {
						checksum += value.charCodeAt(i);
					}
				});

				data.checksum = utils.pad(checksum, 6) + "\u0000 ";

				headerArr = header.format(data);

				var i, offset, length;

				this.out.set(headerArr, this.written);

				this.written += headerArr.length;

				// If there is not enough space in this.out, we need to expand it to
				// fit the new input.
				if (this.written + input.length > this.out.length) {
					this.out = utils.extend(this.out, this.written, input.length, blockSize);
				}

				this.out.set(input, this.written);

				// to the nearest multiple of recordSize
				this.written += input.length + (recordSize - (input.length % recordSize || recordSize));

				// make sure there's at least 2 empty records worth of extra space
				if (this.out.length - this.written < recordSize * 2) {
					this.out = utils.extend(this.out, this.written, recordSize * 2, blockSize);
				}

				if (typeof callback === 'function') {
					callback(this.out);
				}

				return this.out;
			};

			Tar.prototype.clear = function () {
				this.written = 0;
				this.out = utils.clean(blockSize);
			};

			module.exports = Tar;
		}());


		/***/
})
/******/]);