# N2VC Testing


# Preparation
## Environment variables

The test currently requires some environment variables set in order to run, but these will be deprecated as soon as possible.

## LXD

LXD should be installed via snap.

The connection to the LXD API server expects to use a self-signed SSL certificate, generated by lxc (`lxc list`, et al) is first one.

## Juju

Juju is expected to be installed via snap and bootstrapped.

Run `juju status -m controller` and capture the IP address of machine 0. This is the Juju controller, specified in VCA_HOST

export VCA_HOST=1.2.3.4
export VCA_USER=admin
export VCA_SECRET=admin


# Running tests

Tests are written with pytest, driven by tox. All tests are run from the root directory of the repository.

## Run one test

To run a single integration test, we tell tox which environment we need, and then the path to the test.

```bash
tox -e integration -- tests/integration/test_non-string_parameter.py
```

## Running all tests

`make test` will invoke tox to run all unit tests. Alternatively, you can limit this to a specific type of test by invoking tox manually:
```bash
tox -e integration -- tests/integration/
```

# TODO
- Update CI environment to have Juju and LXD available via snap
- Investigate running via Docker
- Remove the requirement for setting environment variables
- Integrate into Jenkins so that tests run against every commit
- Add global timeout to abort tests that are hung
- Only build a charm once per test run, i.e., if two or more tests use the same charm, we should only call `charm build` once.
