# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client._definitions import *
from juju.client.facade import ReturnMapping, Type


class ActionFacade(Type):
    name = 'Action'
    version = 2
    schema =     {'definitions': {'Action': {'additionalProperties': False,
                                'properties': {'name': {'type': 'string'},
                                               'parameters': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                               'receiver': {'type': 'string'},
                                               'tag': {'type': 'string'}},
                                'required': ['tag', 'receiver', 'name'],
                                'type': 'object'},
                     'ActionResult': {'additionalProperties': False,
                                      'properties': {'action': {'$ref': '#/definitions/Action'},
                                                     'completed': {'format': 'date-time',
                                                                   'type': 'string'},
                                                     'enqueued': {'format': 'date-time',
                                                                  'type': 'string'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'message': {'type': 'string'},
                                                     'output': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'started': {'format': 'date-time',
                                                                 'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'type': 'object'},
                     'ActionResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ActionSpec': {'additionalProperties': False,
                                    'properties': {'description': {'type': 'string'},
                                                   'params': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'}},
                                    'required': ['description', 'params'],
                                    'type': 'object'},
                     'Actions': {'additionalProperties': False,
                                 'properties': {'actions': {'items': {'$ref': '#/definitions/Action'},
                                                            'type': 'array'}},
                                 'type': 'object'},
                     'ActionsByName': {'additionalProperties': False,
                                       'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'},
                                                      'error': {'$ref': '#/definitions/Error'},
                                                      'name': {'type': 'string'}},
                                       'type': 'object'},
                     'ActionsByNames': {'additionalProperties': False,
                                        'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByName'},
                                                                   'type': 'array'}},
                                        'type': 'object'},
                     'ActionsByReceiver': {'additionalProperties': False,
                                           'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                      'type': 'array'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'receiver': {'type': 'string'}},
                                           'type': 'object'},
                     'ActionsByReceivers': {'additionalProperties': False,
                                            'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByReceiver'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'ApplicationCharmActionsResult': {'additionalProperties': False,
                                                       'properties': {'actions': {'patternProperties': {'.*': {'$ref': '#/definitions/ActionSpec'}},
                                                                                  'type': 'object'},
                                                                      'application-tag': {'type': 'string'},
                                                                      'error': {'$ref': '#/definitions/Error'}},
                                                       'type': 'object'},
                     'ApplicationsCharmActionsResults': {'additionalProperties': False,
                                                         'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationCharmActionsResult'},
                                                                                    'type': 'array'}},
                                                         'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'FindActionsByNames': {'additionalProperties': False,
                                            'properties': {'names': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                            'type': 'object'},
                     'FindTags': {'additionalProperties': False,
                                  'properties': {'prefixes': {'items': {'type': 'string'},
                                                              'type': 'array'}},
                                  'required': ['prefixes'],
                                  'type': 'object'},
                     'FindTagsResults': {'additionalProperties': False,
                                         'properties': {'matches': {'patternProperties': {'.*': {'items': {'$ref': '#/definitions/Entity'},
                                                                                                 'type': 'array'}},
                                                                    'type': 'object'}},
                                         'required': ['matches'],
                                         'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RunParams': {'additionalProperties': False,
                                   'properties': {'applications': {'items': {'type': 'string'},
                                                                   'type': 'array'},
                                                  'commands': {'type': 'string'},
                                                  'machines': {'items': {'type': 'string'},
                                                               'type': 'array'},
                                                  'timeout': {'type': 'integer'},
                                                  'units': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                   'required': ['commands', 'timeout'],
                                   'type': 'object'}},
     'properties': {'Actions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'ApplicationsCharmsActions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/ApplicationsCharmActionsResults'}},
                                                  'type': 'object'},
                    'Cancel': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ActionResults'}},
                               'type': 'object'},
                    'Enqueue': {'properties': {'Params': {'$ref': '#/definitions/Actions'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'FindActionTagsByPrefix': {'properties': {'Params': {'$ref': '#/definitions/FindTags'},
                                                              'Result': {'$ref': '#/definitions/FindTagsResults'}},
                                               'type': 'object'},
                    'FindActionsByNames': {'properties': {'Params': {'$ref': '#/definitions/FindActionsByNames'},
                                                          'Result': {'$ref': '#/definitions/ActionsByNames'}},
                                           'type': 'object'},
                    'ListAll': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                'type': 'object'},
                    'ListCompleted': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                      'type': 'object'},
                    'ListPending': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                    'type': 'object'},
                    'ListRunning': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                    'type': 'object'},
                    'Run': {'properties': {'Params': {'$ref': '#/definitions/RunParams'},
                                           'Result': {'$ref': '#/definitions/ActionResults'}},
                            'type': 'object'},
                    'RunOnAllMachines': {'properties': {'Params': {'$ref': '#/definitions/RunParams'},
                                                        'Result': {'$ref': '#/definitions/ActionResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ActionResults)
    async def Actions(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ActionResult]<~ActionResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='Actions', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationsCharmActionsResults)
    async def ApplicationsCharmsActions(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ApplicationCharmActionsResult]<~ApplicationCharmActionsResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='ApplicationsCharmsActions', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Cancel(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ActionResult]<~ActionResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='Cancel', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Enqueue(self, actions):
        '''
        actions : typing.Sequence<+T_co>[~Action]<~Action>
        Returns -> typing.Sequence<+T_co>[~ActionResult]<~ActionResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='Enqueue', version=2, params=_params)
        _params['actions'] = actions
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindTagsResults)
    async def FindActionTagsByPrefix(self, prefixes):
        '''
        prefixes : typing.Sequence<+T_co>[str]
        Returns -> typing.Sequence<+T_co>[~Entity]<~Entity>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='FindActionTagsByPrefix', version=2, params=_params)
        _params['prefixes'] = prefixes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByNames)
    async def FindActionsByNames(self, names):
        '''
        names : typing.Sequence<+T_co>[str]
        Returns -> typing.Sequence<+T_co>[~ActionsByName]<~ActionsByName>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='FindActionsByNames', version=2, params=_params)
        _params['names'] = names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListAll(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ActionsByReceiver]<~ActionsByReceiver>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='ListAll', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListCompleted(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ActionsByReceiver]<~ActionsByReceiver>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='ListCompleted', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListPending(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ActionsByReceiver]<~ActionsByReceiver>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='ListPending', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListRunning(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ActionsByReceiver]<~ActionsByReceiver>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='ListRunning', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Run(self, applications, commands, machines, timeout, units):
        '''
        applications : typing.Sequence<+T_co>[str]
        commands : str
        machines : typing.Sequence<+T_co>[str]
        timeout : int
        units : typing.Sequence<+T_co>[str]
        Returns -> typing.Sequence<+T_co>[~ActionResult]<~ActionResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='Run', version=2, params=_params)
        _params['applications'] = applications
        _params['commands'] = commands
        _params['machines'] = machines
        _params['timeout'] = timeout
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def RunOnAllMachines(self, applications, commands, machines, timeout, units):
        '''
        applications : typing.Sequence<+T_co>[str]
        commands : str
        machines : typing.Sequence<+T_co>[str]
        timeout : int
        units : typing.Sequence<+T_co>[str]
        Returns -> typing.Sequence<+T_co>[~ActionResult]<~ActionResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action', request='RunOnAllMachines', version=2, params=_params)
        _params['applications'] = applications
        _params['commands'] = commands
        _params['machines'] = machines
        _params['timeout'] = timeout
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



class AgentFacade(Type):
    name = 'Agent'
    version = 2
    schema =     {'definitions': {'AgentGetEntitiesResult': {'additionalProperties': False,
                                                'properties': {'container-type': {'type': 'string'},
                                                               'error': {'$ref': '#/definitions/Error'},
                                                               'jobs': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                               'life': {'type': 'string'}},
                                                'required': ['life',
                                                             'jobs',
                                                             'container-type'],
                                                'type': 'object'},
                     'AgentGetEntitiesResults': {'additionalProperties': False,
                                                 'properties': {'entities': {'items': {'$ref': '#/definitions/AgentGetEntitiesResult'},
                                                                             'type': 'array'}},
                                                 'required': ['entities'],
                                                 'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudSpec': {'additionalProperties': False,
                                   'properties': {'credential': {'$ref': '#/definitions/CloudCredential'},
                                                  'endpoint': {'type': 'string'},
                                                  'identity-endpoint': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'region': {'type': 'string'},
                                                  'storage-endpoint': {'type': 'string'},
                                                  'type': {'type': 'string'}},
                                   'required': ['type', 'name'],
                                   'type': 'object'},
                     'CloudSpecResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudSpec'}},
                                         'type': 'object'},
                     'CloudSpecResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudSpecResult'},
                                                                     'type': 'array'}},
                                          'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'IsMasterResult': {'additionalProperties': False,
                                        'properties': {'master': {'type': 'boolean'}},
                                        'required': ['master'],
                                        'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ModelTag': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'StateServingInfo': {'additionalProperties': False,
                                          'properties': {'api-port': {'type': 'integer'},
                                                         'ca-private-key': {'type': 'string'},
                                                         'cert': {'type': 'string'},
                                                         'private-key': {'type': 'string'},
                                                         'shared-secret': {'type': 'string'},
                                                         'state-port': {'type': 'integer'},
                                                         'system-identity': {'type': 'string'}},
                                          'required': ['api-port',
                                                       'state-port',
                                                       'cert',
                                                       'private-key',
                                                       'ca-private-key',
                                                       'shared-secret',
                                                       'system-identity'],
                                          'type': 'object'}},
     'properties': {'ClearReboot': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'CloudSpec': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudSpecResults'}},
                                  'type': 'object'},
                    'ControllerConfig': {'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'GetCloudSpec': {'properties': {'Params': {'$ref': '#/definitions/ModelTag'},
                                                    'Result': {'$ref': '#/definitions/CloudSpecResult'}},
                                     'type': 'object'},
                    'GetEntities': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/AgentGetEntitiesResults'}},
                                    'type': 'object'},
                    'IsMaster': {'properties': {'Result': {'$ref': '#/definitions/IsMasterResult'}},
                                 'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'SetPasswords': {'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'StateServingInfo': {'properties': {'Result': {'$ref': '#/definitions/StateServingInfo'}},
                                         'type': 'object'},
                    'WatchCredentials': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                         'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ClearReboot(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='ClearReboot', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResults)
    async def CloudSpec(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~CloudSpecResult]<~CloudSpecResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='CloudSpec', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''

        Returns -> typing.Mapping<~KT, +VT_co>[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='ControllerConfig', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResult)
    async def GetCloudSpec(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), _ForwardRef('CloudSpec')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='GetCloudSpec', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AgentGetEntitiesResults)
    async def GetEntities(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~AgentGetEntitiesResult]<~AgentGetEntitiesResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='GetEntities', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IsMasterResult)
    async def IsMaster(self):
        '''

        Returns -> bool
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='IsMaster', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping<~KT, +VT_co>[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='ModelConfig', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes):
        '''
        changes : typing.Sequence<+T_co>[~EntityPassword]<~EntityPassword>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='SetPasswords', version=2, params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StateServingInfo)
    async def StateServingInfo(self):
        '''

        Returns -> typing.Union[int, str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='StateServingInfo', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchCredentials(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='WatchCredentials', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent', request='WatchForModelConfigChanges', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class AllModelWatcherFacade(Type):
    name = 'AllModelWatcher'
    version = 2
    schema =     {'definitions': {'AllWatcherNextResults': {'additionalProperties': False,
                                               'properties': {'deltas': {'items': {'$ref': '#/definitions/Delta'},
                                                                         'type': 'array'}},
                                               'required': ['deltas'],
                                               'type': 'object'},
                     'Delta': {'additionalProperties': False,
                               'properties': {'entity': {'additionalProperties': True,
                                                         'type': 'object'},
                                              'removed': {'type': 'boolean'}},
                               'required': ['removed', 'entity'],
                               'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/AllWatcherNextResults'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AllWatcherNextResults)
    async def Next(self):
        '''

        Returns -> typing.Sequence<+T_co>[~Delta]<~Delta>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AllModelWatcher', request='Next', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AllModelWatcher', request='Stop', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class AnnotationsFacade(Type):
    name = 'Annotations'
    version = 2
    schema =     {'definitions': {'AnnotationsGetResult': {'additionalProperties': False,
                                              'properties': {'annotations': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                             'entity': {'type': 'string'},
                                                             'error': {'$ref': '#/definitions/ErrorResult'}},
                                              'required': ['entity', 'annotations'],
                                              'type': 'object'},
                     'AnnotationsGetResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/AnnotationsGetResult'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'AnnotationsSet': {'additionalProperties': False,
                                        'properties': {'annotations': {'items': {'$ref': '#/definitions/EntityAnnotations'},
                                                                       'type': 'array'}},
                                        'required': ['annotations'],
                                        'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityAnnotations': {'additionalProperties': False,
                                           'properties': {'annotations': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'},
                                                          'entity': {'type': 'string'}},
                                           'required': ['entity', 'annotations'],
                                           'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'Get': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                           'Result': {'$ref': '#/definitions/AnnotationsGetResults'}},
                            'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/AnnotationsSet'},
                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AnnotationsGetResults)
    async def Get(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~AnnotationsGetResult]<~AnnotationsGetResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Annotations', request='Get', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Set(self, annotations):
        '''
        annotations : typing.Sequence<+T_co>[~EntityAnnotations]<~EntityAnnotations>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Annotations', request='Set', version=2, params=_params)
        _params['annotations'] = annotations
        reply = await self.rpc(msg)
        return reply



class ApplicationFacade(Type):
    name = 'Application'
    version = 2
    schema =     {'definitions': {'AddApplicationUnits': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'num-units': {'type': 'integer'},
                                                            'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                          'type': 'array'}},
                                             'required': ['application',
                                                          'num-units',
                                                          'placement'],
                                             'type': 'object'},
                     'AddApplicationUnitsResults': {'additionalProperties': False,
                                                    'properties': {'units': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                                    'required': ['units'],
                                                    'type': 'object'},
                     'AddRelation': {'additionalProperties': False,
                                     'properties': {'endpoints': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                     'required': ['endpoints'],
                                     'type': 'object'},
                     'AddRelationResults': {'additionalProperties': False,
                                            'properties': {'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                                         'type': 'object'}},
                                            'required': ['endpoints'],
                                            'type': 'object'},
                     'ApplicationCharmRelations': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'ApplicationCharmRelationsResults': {'additionalProperties': False,
                                                          'properties': {'charm-relations': {'items': {'type': 'string'},
                                                                                             'type': 'array'}},
                                                          'required': ['charm-relations'],
                                                          'type': 'object'},
                     'ApplicationDeploy': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'channel': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                          'config-yaml': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'num-units': {'type': 'integer'},
                                                          'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                        'type': 'array'},
                                                          'resources': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'}},
                                           'required': ['application',
                                                        'series',
                                                        'charm-url',
                                                        'channel',
                                                        'num-units',
                                                        'config-yaml',
                                                        'constraints'],
                                           'type': 'object'},
                     'ApplicationDestroy': {'additionalProperties': False,
                                            'properties': {'application': {'type': 'string'}},
                                            'required': ['application'],
                                            'type': 'object'},
                     'ApplicationExpose': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'}},
                                           'required': ['application'],
                                           'type': 'object'},
                     'ApplicationGet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'}},
                                        'required': ['application'],
                                        'type': 'object'},
                     'ApplicationGetResults': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'charm': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'constraints': {'$ref': '#/definitions/Value'},
                                                              'series': {'type': 'string'}},
                                               'required': ['application',
                                                            'charm',
                                                            'config',
                                                            'constraints',
                                                            'series'],
                                               'type': 'object'},
                     'ApplicationMetricCredential': {'additionalProperties': False,
                                                     'properties': {'application': {'type': 'string'},
                                                                    'metrics-credentials': {'items': {'type': 'integer'},
                                                                                            'type': 'array'}},
                                                     'required': ['application',
                                                                  'metrics-credentials'],
                                                     'type': 'object'},
                     'ApplicationMetricCredentials': {'additionalProperties': False,
                                                      'properties': {'creds': {'items': {'$ref': '#/definitions/ApplicationMetricCredential'},
                                                                               'type': 'array'}},
                                                      'required': ['creds'],
                                                      'type': 'object'},
                     'ApplicationSet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'options': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'}},
                                        'required': ['application', 'options'],
                                        'type': 'object'},
                     'ApplicationSetCharm': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'channel': {'type': 'string'},
                                                            'charm-url': {'type': 'string'},
                                                            'config-settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                            'config-settings-yaml': {'type': 'string'},
                                                            'force-series': {'type': 'boolean'},
                                                            'force-units': {'type': 'boolean'},
                                                            'resource-ids': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                            'storage-constraints': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageConstraints'}},
                                                                                    'type': 'object'}},
                                             'required': ['application',
                                                          'charm-url',
                                                          'channel',
                                                          'force-units',
                                                          'force-series'],
                                             'type': 'object'},
                     'ApplicationUnexpose': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'}},
                                             'required': ['application'],
                                             'type': 'object'},
                     'ApplicationUnset': {'additionalProperties': False,
                                          'properties': {'application': {'type': 'string'},
                                                         'options': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                          'required': ['application', 'options'],
                                          'type': 'object'},
                     'ApplicationUpdate': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'force-charm-url': {'type': 'boolean'},
                                                          'force-series': {'type': 'boolean'},
                                                          'min-units': {'type': 'integer'},
                                                          'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                       'type': 'object'},
                                                          'settings-yaml': {'type': 'string'}},
                                           'required': ['application',
                                                        'charm-url',
                                                        'force-charm-url',
                                                        'force-series',
                                                        'settings-yaml'],
                                           'type': 'object'},
                     'ApplicationsDeploy': {'additionalProperties': False,
                                            'properties': {'applications': {'items': {'$ref': '#/definitions/ApplicationDeploy'},
                                                                            'type': 'array'}},
                                            'required': ['applications'],
                                            'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'DestroyApplicationUnits': {'additionalProperties': False,
                                                 'properties': {'unit-names': {'items': {'type': 'string'},
                                                                               'type': 'array'}},
                                                 'required': ['unit-names'],
                                                 'type': 'object'},
                     'DestroyRelation': {'additionalProperties': False,
                                         'properties': {'endpoints': {'items': {'type': 'string'},
                                                                      'type': 'array'}},
                                         'required': ['endpoints'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'GetApplicationConstraints': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'GetConstraintsResults': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'AddRelation': {'properties': {'Params': {'$ref': '#/definitions/AddRelation'},
                                                   'Result': {'$ref': '#/definitions/AddRelationResults'}},
                                    'type': 'object'},
                    'AddUnits': {'properties': {'Params': {'$ref': '#/definitions/AddApplicationUnits'},
                                                'Result': {'$ref': '#/definitions/AddApplicationUnitsResults'}},
                                 'type': 'object'},
                    'CharmRelations': {'properties': {'Params': {'$ref': '#/definitions/ApplicationCharmRelations'},
                                                      'Result': {'$ref': '#/definitions/ApplicationCharmRelationsResults'}},
                                       'type': 'object'},
                    'Deploy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationsDeploy'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationDestroy'}},
                                'type': 'object'},
                    'DestroyRelation': {'properties': {'Params': {'$ref': '#/definitions/DestroyRelation'}},
                                        'type': 'object'},
                    'DestroyUnits': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationUnits'}},
                                     'type': 'object'},
                    'Expose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationExpose'}},
                               'type': 'object'},
                    'Get': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                           'Result': {'$ref': '#/definitions/ApplicationGetResults'}},
                            'type': 'object'},
                    'GetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                                   'Result': {'$ref': '#/definitions/StringResult'}},
                                    'type': 'object'},
                    'GetConstraints': {'properties': {'Params': {'$ref': '#/definitions/GetApplicationConstraints'},
                                                      'Result': {'$ref': '#/definitions/GetConstraintsResults'}},
                                       'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSet'}},
                            'type': 'object'},
                    'SetCharm': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSetCharm'}},
                                 'type': 'object'},
                    'SetConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                       'type': 'object'},
                    'SetMetricCredentials': {'properties': {'Params': {'$ref': '#/definitions/ApplicationMetricCredentials'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'Unexpose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnexpose'}},
                                 'type': 'object'},
                    'Unset': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnset'}},
                              'type': 'object'},
                    'Update': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUpdate'}},
                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddRelationResults)
    async def AddRelation(self, endpoints):
        '''
        endpoints : typing.Sequence<+T_co>[str]
        Returns -> typing.Mapping<~KT, +VT_co>[str, ~CharmRelation]<~CharmRelation>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='AddRelation', version=2, params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddApplicationUnitsResults)
    async def AddUnits(self, application, num_units, placement):
        '''
        application : str
        num_units : int
        placement : typing.Sequence<+T_co>[~Placement]<~Placement>
        Returns -> typing.Sequence<+T_co>[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='AddUnits', version=2, params=_params)
        _params['application'] = application
        _params['num-units'] = num_units
        _params['placement'] = placement
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationCharmRelationsResults)
    async def CharmRelations(self, application):
        '''
        application : str
        Returns -> typing.Sequence<+T_co>[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='CharmRelations', version=2, params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Deploy(self, applications):
        '''
        applications : typing.Sequence<+T_co>[~ApplicationDeploy]<~ApplicationDeploy>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='Deploy', version=2, params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Destroy(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='Destroy', version=2, params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyRelation(self, endpoints):
        '''
        endpoints : typing.Sequence<+T_co>[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='DestroyRelation', version=2, params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyUnits(self, unit_names):
        '''
        unit_names : typing.Sequence<+T_co>[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='DestroyUnits', version=2, params=_params)
        _params['unit-names'] = unit_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Expose(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='Expose', version=2, params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetResults)
    async def Get(self, application):
        '''
        application : str
        Returns -> typing.Union[str, typing.Mapping<~KT, +VT_co>[str, typing.Any], _ForwardRef('Value')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='Get', version=2, params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def GetCharmURL(self, application):
        '''
        application : str
        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='GetCharmURL', version=2, params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetConstraintsResults)
    async def GetConstraints(self, application):
        '''
        application : str
        Returns -> Value
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='GetConstraints', version=2, params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Set(self, application, options):
        '''
        application : str
        options : typing.Mapping<~KT, +VT_co>[str, str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='Set', version=2, params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetCharm(self, application, channel, charm_url, config_settings, config_settings_yaml, force_series, force_units, resource_ids, storage_constraints):
        '''
        application : str
        channel : str
        charm_url : str
        config_settings : typing.Mapping<~KT, +VT_co>[str, str]
        config_settings_yaml : str
        force_series : bool
        force_units : bool
        resource_ids : typing.Mapping<~KT, +VT_co>[str, str]
        storage_constraints : typing.Mapping<~KT, +VT_co>[str, ~StorageConstraints]<~StorageConstraints>
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='SetCharm', version=2, params=_params)
        _params['application'] = application
        _params['channel'] = channel
        _params['charm-url'] = charm_url
        _params['config-settings'] = config_settings
        _params['config-settings-yaml'] = config_settings_yaml
        _params['force-series'] = force_series
        _params['force-units'] = force_units
        _params['resource-ids'] = resource_ids
        _params['storage-constraints'] = storage_constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetConstraints(self, application, constraints):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='SetConstraints', version=2, params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMetricCredentials(self, creds):
        '''
        creds : typing.Sequence<+T_co>[~ApplicationMetricCredential]<~ApplicationMetricCredential>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='SetMetricCredentials', version=2, params=_params)
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unexpose(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='Unexpose', version=2, params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unset(self, application, options):
        '''
        application : str
        options : typing.Sequence<+T_co>[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='Unset', version=2, params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Update(self, application, charm_url, constraints, force_charm_url, force_series, min_units, settings, settings_yaml):
        '''
        application : str
        charm_url : str
        constraints : Value
        force_charm_url : bool
        force_series : bool
        min_units : int
        settings : typing.Mapping<~KT, +VT_co>[str, str]
        settings_yaml : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application', request='Update', version=2, params=_params)
        _params['application'] = application
        _params['charm-url'] = charm_url
        _params['constraints'] = constraints
        _params['force-charm-url'] = force_charm_url
        _params['force-series'] = force_series
        _params['min-units'] = min_units
        _params['settings'] = settings
        _params['settings-yaml'] = settings_yaml
        reply = await self.rpc(msg)
        return reply



class BlockFacade(Type):
    name = 'Block'
    version = 2
    schema =     {'definitions': {'Block': {'additionalProperties': False,
                               'properties': {'id': {'type': 'string'},
                                              'message': {'type': 'string'},
                                              'tag': {'type': 'string'},
                                              'type': {'type': 'string'}},
                               'required': ['id', 'tag', 'type'],
                               'type': 'object'},
                     'BlockResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'result': {'$ref': '#/definitions/Block'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'BlockResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/BlockResult'},
                                                                 'type': 'array'}},
                                      'type': 'object'},
                     'BlockSwitchParams': {'additionalProperties': False,
                                           'properties': {'message': {'type': 'string'},
                                                          'type': {'type': 'string'}},
                                           'required': ['type'],
                                           'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'List': {'properties': {'Result': {'$ref': '#/definitions/BlockResults'}},
                             'type': 'object'},
                    'SwitchBlockOff': {'properties': {'Params': {'$ref': '#/definitions/BlockSwitchParams'},
                                                      'Result': {'$ref': '#/definitions/ErrorResult'}},
                                       'type': 'object'},
                    'SwitchBlockOn': {'properties': {'Params': {'$ref': '#/definitions/BlockSwitchParams'},
                                                     'Result': {'$ref': '#/definitions/ErrorResult'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BlockResults)
    async def List(self):
        '''

        Returns -> typing.Sequence<+T_co>[~BlockResult]<~BlockResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Block', request='List', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResult)
    async def SwitchBlockOff(self, message, type_):
        '''
        message : str
        type_ : str
        Returns -> Error
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Block', request='SwitchBlockOff', version=2, params=_params)
        _params['message'] = message
        _params['type'] = type_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResult)
    async def SwitchBlockOn(self, message, type_):
        '''
        message : str
        type_ : str
        Returns -> Error
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Block', request='SwitchBlockOn', version=2, params=_params)
        _params['message'] = message
        _params['type'] = type_
        reply = await self.rpc(msg)
        return reply



class CharmRevisionUpdaterFacade(Type):
    name = 'CharmRevisionUpdater'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'UpdateLatestRevisions': {'properties': {'Result': {'$ref': '#/definitions/ErrorResult'}},
                                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def UpdateLatestRevisions(self):
        '''

        Returns -> Error
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CharmRevisionUpdater', request='UpdateLatestRevisions', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class CharmsFacade(Type):
    name = 'Charms'
    version = 2
    schema =     {'definitions': {'CharmActionSpec': {'additionalProperties': False,
                                         'properties': {'description': {'type': 'string'},
                                                        'params': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                'type': 'object'}},
                                                                   'type': 'object'}},
                                         'required': ['description', 'params'],
                                         'type': 'object'},
                     'CharmActions': {'additionalProperties': False,
                                      'properties': {'specs': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmActionSpec'}},
                                                               'type': 'object'}},
                                      'type': 'object'},
                     'CharmInfo': {'additionalProperties': False,
                                   'properties': {'actions': {'$ref': '#/definitions/CharmActions'},
                                                  'config': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmOption'}},
                                                             'type': 'object'},
                                                  'meta': {'$ref': '#/definitions/CharmMeta'},
                                                  'metrics': {'$ref': '#/definitions/CharmMetrics'},
                                                  'revision': {'type': 'integer'},
                                                  'url': {'type': 'string'}},
                                   'required': ['revision', 'url', 'config'],
                                   'type': 'object'},
                     'CharmMeta': {'additionalProperties': False,
                                   'properties': {'categories': {'items': {'type': 'string'},
                                                                 'type': 'array'},
                                                  'description': {'type': 'string'},
                                                  'extra-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                  'min-juju-version': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'payload-classes': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmPayloadClass'}},
                                                                      'type': 'object'},
                                                  'peers': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                            'type': 'object'},
                                                  'provides': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                               'type': 'object'},
                                                  'requires': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                               'type': 'object'},
                                                  'resources': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmResourceMeta'}},
                                                                'type': 'object'},
                                                  'series': {'items': {'type': 'string'},
                                                             'type': 'array'},
                                                  'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmStorage'}},
                                                              'type': 'object'},
                                                  'subordinate': {'type': 'boolean'},
                                                  'summary': {'type': 'string'},
                                                  'tags': {'items': {'type': 'string'},
                                                           'type': 'array'},
                                                  'terms': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                   'required': ['name',
                                                'summary',
                                                'description',
                                                'subordinate'],
                                   'type': 'object'},
                     'CharmMetric': {'additionalProperties': False,
                                     'properties': {'description': {'type': 'string'},
                                                    'type': {'type': 'string'}},
                                     'required': ['type', 'description'],
                                     'type': 'object'},
                     'CharmMetrics': {'additionalProperties': False,
                                      'properties': {'metrics': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmMetric'}},
                                                                 'type': 'object'},
                                                     'plan': {'$ref': '#/definitions/CharmPlan'}},
                                      'required': ['metrics', 'plan'],
                                      'type': 'object'},
                     'CharmOption': {'additionalProperties': False,
                                     'properties': {'default': {'additionalProperties': True,
                                                                'type': 'object'},
                                                    'description': {'type': 'string'},
                                                    'type': {'type': 'string'}},
                                     'required': ['type'],
                                     'type': 'object'},
                     'CharmPayloadClass': {'additionalProperties': False,
                                           'properties': {'name': {'type': 'string'},
                                                          'type': {'type': 'string'}},
                                           'required': ['name', 'type'],
                                           'type': 'object'},
                     'CharmPlan': {'additionalProperties': False,
                                   'properties': {'required': {'type': 'boolean'}},
                                   'required': ['required'],
                                   'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'CharmResourceMeta': {'additionalProperties': False,
                                           'properties': {'description': {'type': 'string'},
                                                          'name': {'type': 'string'},
                                                          'path': {'type': 'string'},
                                                          'type': {'type': 'string'}},
                                           'required': ['name',
                                                        'type',
                                                        'path',
                                                        'description'],
                                           'type': 'object'},
                     'CharmStorage': {'additionalProperties': False,
                                      'properties': {'count-max': {'type': 'integer'},
                                                     'count-min': {'type': 'integer'},
                                                     'description': {'type': 'string'},
                                                     'location': {'type': 'string'},
                                                     'minimum-size': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'properties': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                     'read-only': {'type': 'boolean'},
                                                     'shared': {'type': 'boolean'},
                                                     'type': {'type': 'string'}},
                                      'required': ['name',
                                                   'description',
                                                   'type',
                                                   'shared',
                                                   'read-only',
                                                   'count-min',
                                                   'count-max',
                                                   'minimum-size'],
                                      'type': 'object'},
                     'CharmURL': {'additionalProperties': False,
                                  'properties': {'url': {'type': 'string'}},
                                  'required': ['url'],
                                  'type': 'object'},
                     'CharmsList': {'additionalProperties': False,
                                    'properties': {'names': {'items': {'type': 'string'},
                                                             'type': 'array'}},
                                    'required': ['names'],
                                    'type': 'object'},
                     'CharmsListResult': {'additionalProperties': False,
                                          'properties': {'charm-urls': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                          'required': ['charm-urls'],
                                          'type': 'object'},
                     'IsMeteredResult': {'additionalProperties': False,
                                         'properties': {'metered': {'type': 'boolean'}},
                                         'required': ['metered'],
                                         'type': 'object'}},
     'properties': {'CharmInfo': {'properties': {'Params': {'$ref': '#/definitions/CharmURL'},
                                                 'Result': {'$ref': '#/definitions/CharmInfo'}},
                                  'type': 'object'},
                    'IsMetered': {'properties': {'Params': {'$ref': '#/definitions/CharmURL'},
                                                 'Result': {'$ref': '#/definitions/IsMeteredResult'}},
                                  'type': 'object'},
                    'List': {'properties': {'Params': {'$ref': '#/definitions/CharmsList'},
                                            'Result': {'$ref': '#/definitions/CharmsListResult'}},
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(CharmInfo)
    async def CharmInfo(self, url):
        '''
        url : str
        Returns -> typing.Union[_ForwardRef('CharmActions'), typing.Mapping<~KT, +VT_co>[str, ~CharmOption]<~CharmOption>, _ForwardRef('CharmMeta'), _ForwardRef('CharmMetrics'), int, str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Charms', request='CharmInfo', version=2, params=_params)
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IsMeteredResult)
    async def IsMetered(self, url):
        '''
        url : str
        Returns -> bool
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Charms', request='IsMetered', version=2, params=_params)
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CharmsListResult)
    async def List(self, names):
        '''
        names : typing.Sequence<+T_co>[str]
        Returns -> typing.Sequence<+T_co>[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Charms', request='List', version=2, params=_params)
        _params['names'] = names
        reply = await self.rpc(msg)
        return reply



class CleanerFacade(Type):
    name = 'Cleaner'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'}},
     'properties': {'Cleanup': {'type': 'object'},
                    'WatchCleanups': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Cleanup(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cleaner', request='Cleanup', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchCleanups(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cleaner', request='WatchCleanups', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class DiscoverSpacesFacade(Type):
    name = 'DiscoverSpaces'
    version = 2
    schema =     {'definitions': {'AddSubnetParams': {'additionalProperties': False,
                                         'properties': {'provider-network-id': {'type': 'string'},
                                                        'space-tag': {'type': 'string'},
                                                        'subnet-provider-id': {'type': 'string'},
                                                        'subnet-tag': {'type': 'string'},
                                                        'vlan-tag': {'type': 'integer'},
                                                        'zones': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                         'required': ['space-tag'],
                                         'type': 'object'},
                     'AddSubnetsParams': {'additionalProperties': False,
                                          'properties': {'subnets': {'items': {'$ref': '#/definitions/AddSubnetParams'},
                                                                     'type': 'array'}},
                                          'required': ['subnets'],
                                          'type': 'object'},
                     'CreateSpaceParams': {'additionalProperties': False,
                                           'properties': {'provider-id': {'type': 'string'},
                                                          'public': {'type': 'boolean'},
                                                          'space-tag': {'type': 'string'},
                                                          'subnet-tags': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                           'required': ['subnet-tags',
                                                        'space-tag',
                                                        'public'],
                                           'type': 'object'},
                     'CreateSpacesParams': {'additionalProperties': False,
                                            'properties': {'spaces': {'items': {'$ref': '#/definitions/CreateSpaceParams'},
                                                                      'type': 'array'}},
                                            'required': ['spaces'],
                                            'type': 'object'},
                     'DiscoverSpacesResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/ProviderSpace'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSubnetsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/Subnet'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ProviderSpace': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'name': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                                  'type': 'array'}},
                                       'required': ['name',
                                                    'provider-id',
                                                    'subnets'],
                                       'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'SubnetsFilters': {'additionalProperties': False,
                                        'properties': {'space-tag': {'type': 'string'},
                                                       'zone': {'type': 'string'}},
                                        'type': 'object'}},
     'properties': {'AddSubnets': {'properties': {'Params': {'$ref': '#/definitions/AddSubnetsParams'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'CreateSpaces': {'properties': {'Params': {'$ref': '#/definitions/CreateSpacesParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListSpaces': {'properties': {'Result': {'$ref': '#/definitions/DiscoverSpacesResults'}},
                                   'type': 'object'},
                    'ListSubnets': {'properties': {'Params': {'$ref': '#/definitions/SubnetsFilters'},
                                                   'Result': {'$ref': '#/definitions/ListSubnetsResults'}},
                                    'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddSubnets(self, subnets):
        '''
        subnets : typing.Sequence<+T_co>[~AddSubnetParams]<~AddSubnetParams>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces', request='AddSubnets', version=2, params=_params)
        _params['subnets'] = subnets
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def CreateSpaces(self, spaces):
        '''
        spaces : typing.Sequence<+T_co>[~CreateSpaceParams]<~CreateSpaceParams>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces', request='CreateSpaces', version=2, params=_params)
        _params['spaces'] = spaces
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DiscoverSpacesResults)
    async def ListSpaces(self):
        '''

        Returns -> typing.Sequence<+T_co>[~ProviderSpace]<~ProviderSpace>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces', request='ListSpaces', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSubnetsResults)
    async def ListSubnets(self, space_tag, zone):
        '''
        space_tag : str
        zone : str
        Returns -> typing.Sequence<+T_co>[~Subnet]<~Subnet>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces', request='ListSubnets', version=2, params=_params)
        _params['space-tag'] = space_tag
        _params['zone'] = zone
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping<~KT, +VT_co>[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces', request='ModelConfig', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class DiskManagerFacade(Type):
    name = 'DiskManager'
    version = 2
    schema =     {'definitions': {'BlockDevice': {'additionalProperties': False,
                                     'properties': {'BusAddress': {'type': 'string'},
                                                    'DeviceLinks': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                    'DeviceName': {'type': 'string'},
                                                    'FilesystemType': {'type': 'string'},
                                                    'HardwareId': {'type': 'string'},
                                                    'InUse': {'type': 'boolean'},
                                                    'Label': {'type': 'string'},
                                                    'MountPoint': {'type': 'string'},
                                                    'Size': {'type': 'integer'},
                                                    'UUID': {'type': 'string'},
                                                    'WWN': {'type': 'string'}},
                                     'required': ['DeviceName',
                                                  'DeviceLinks',
                                                  'Label',
                                                  'UUID',
                                                  'HardwareId',
                                                  'WWN',
                                                  'BusAddress',
                                                  'Size',
                                                  'FilesystemType',
                                                  'InUse',
                                                  'MountPoint'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineBlockDevices': {'additionalProperties': False,
                                             'properties': {'block-devices': {'items': {'$ref': '#/definitions/BlockDevice'},
                                                                              'type': 'array'},
                                                            'machine': {'type': 'string'}},
                                             'required': ['machine'],
                                             'type': 'object'},
                     'SetMachineBlockDevices': {'additionalProperties': False,
                                                'properties': {'machine-block-devices': {'items': {'$ref': '#/definitions/MachineBlockDevices'},
                                                                                         'type': 'array'}},
                                                'required': ['machine-block-devices'],
                                                'type': 'object'}},
     'properties': {'SetMachineBlockDevices': {'properties': {'Params': {'$ref': '#/definitions/SetMachineBlockDevices'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def SetMachineBlockDevices(self, machine_block_devices):
        '''
        machine_block_devices : typing.Sequence<+T_co>[~MachineBlockDevices]<~MachineBlockDevices>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiskManager', request='SetMachineBlockDevices', version=2, params=_params)
        _params['machine-block-devices'] = machine_block_devices
        reply = await self.rpc(msg)
        return reply



class EntityWatcherFacade(Type):
    name = 'EntityWatcher'
    version = 2
    schema =     {'definitions': {'EntitiesWatchResult': {'additionalProperties': False,
                                             'properties': {'changes': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'watcher-id': {'type': 'string'}},
                                             'required': ['watcher-id'],
                                             'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/EntitiesWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(EntitiesWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[typing.Sequence<+T_co>[str], _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='EntityWatcher', request='Next', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='EntityWatcher', request='Stop', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class FilesystemAttachmentsWatcherFacade(Type):
    name = 'FilesystemAttachmentsWatcher'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineStorageId': {'additionalProperties': False,
                                          'properties': {'attachment-tag': {'type': 'string'},
                                                         'machine-tag': {'type': 'string'}},
                                          'required': ['machine-tag',
                                                       'attachment-tag'],
                                          'type': 'object'},
                     'MachineStorageIdsWatchResult': {'additionalProperties': False,
                                                      'properties': {'changes': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                                 'type': 'array'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'watcher-id': {'type': 'string'}},
                                                      'required': ['watcher-id',
                                                                   'changes'],
                                                      'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MachineStorageIdsWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[typing.Sequence<+T_co>[~MachineStorageId]<~MachineStorageId>, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='FilesystemAttachmentsWatcher', request='Next', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='FilesystemAttachmentsWatcher', request='Stop', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class HighAvailabilityFacade(Type):
    name = 'HighAvailability'
    version = 2
    schema =     {'definitions': {'Address': {'additionalProperties': False,
                                 'properties': {'Scope': {'type': 'string'},
                                                'SpaceName': {'type': 'string'},
                                                'SpaceProviderId': {'type': 'string'},
                                                'Type': {'type': 'string'},
                                                'Value': {'type': 'string'}},
                                 'required': ['Value',
                                              'Type',
                                              'Scope',
                                              'SpaceName',
                                              'SpaceProviderId'],
                                 'type': 'object'},
                     'ControllersChangeResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/ControllersChanges'}},
                                                 'required': ['result'],
                                                 'type': 'object'},
                     'ControllersChangeResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllersChangeResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllersChanges': {'additionalProperties': False,
                                            'properties': {'added': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                           'converted': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                           'demoted': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'maintained': {'items': {'type': 'string'},
                                                                          'type': 'array'},
                                                           'promoted': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                           'removed': {'items': {'type': 'string'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'ControllersSpec': {'additionalProperties': False,
                                         'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                        'num-controllers': {'type': 'integer'},
                                                        'placement': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                        'series': {'type': 'string'}},
                                         'required': ['num-controllers'],
                                         'type': 'object'},
                     'ControllersSpecs': {'additionalProperties': False,
                                          'properties': {'specs': {'items': {'$ref': '#/definitions/ControllersSpec'},
                                                                   'type': 'array'}},
                                          'required': ['specs'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'HAMember': {'additionalProperties': False,
                                  'properties': {'public-address': {'$ref': '#/definitions/Address'},
                                                 'series': {'type': 'string'},
                                                 'tag': {'type': 'string'}},
                                  'required': ['tag', 'public-address', 'series'],
                                  'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Member': {'additionalProperties': False,
                                'properties': {'Address': {'type': 'string'},
                                               'Arbiter': {'type': 'boolean'},
                                               'BuildIndexes': {'type': 'boolean'},
                                               'Hidden': {'type': 'boolean'},
                                               'Id': {'type': 'integer'},
                                               'Priority': {'type': 'number'},
                                               'SlaveDelay': {'type': 'integer'},
                                               'Tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                        'type': 'object'},
                                               'Votes': {'type': 'integer'}},
                                'required': ['Id',
                                             'Address',
                                             'Arbiter',
                                             'BuildIndexes',
                                             'Hidden',
                                             'Priority',
                                             'Tags',
                                             'SlaveDelay',
                                             'Votes'],
                                'type': 'object'},
                     'MongoUpgradeResults': {'additionalProperties': False,
                                             'properties': {'ha-members': {'items': {'$ref': '#/definitions/HAMember'},
                                                                           'type': 'array'},
                                                            'master': {'$ref': '#/definitions/HAMember'},
                                                            'rs-members': {'items': {'$ref': '#/definitions/Member'},
                                                                           'type': 'array'}},
                                             'required': ['rs-members',
                                                          'master',
                                                          'ha-members'],
                                             'type': 'object'},
                     'MongoVersion': {'additionalProperties': False,
                                      'properties': {'engine': {'type': 'string'},
                                                     'major': {'type': 'integer'},
                                                     'minor': {'type': 'integer'},
                                                     'patch': {'type': 'string'}},
                                      'required': ['major',
                                                   'minor',
                                                   'patch',
                                                   'engine'],
                                      'type': 'object'},
                     'ResumeReplicationParams': {'additionalProperties': False,
                                                 'properties': {'members': {'items': {'$ref': '#/definitions/Member'},
                                                                            'type': 'array'}},
                                                 'required': ['members'],
                                                 'type': 'object'},
                     'UpgradeMongoParams': {'additionalProperties': False,
                                            'properties': {'target': {'$ref': '#/definitions/MongoVersion'}},
                                            'required': ['target'],
                                            'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'EnableHA': {'properties': {'Params': {'$ref': '#/definitions/ControllersSpecs'},
                                                'Result': {'$ref': '#/definitions/ControllersChangeResults'}},
                                 'type': 'object'},
                    'ResumeHAReplicationAfterUpgrade': {'properties': {'Params': {'$ref': '#/definitions/ResumeReplicationParams'}},
                                                        'type': 'object'},
                    'StopHAReplicationForUpgrade': {'properties': {'Params': {'$ref': '#/definitions/UpgradeMongoParams'},
                                                                   'Result': {'$ref': '#/definitions/MongoUpgradeResults'}},
                                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ControllersChangeResults)
    async def EnableHA(self, specs):
        '''
        specs : typing.Sequence<+T_co>[~ControllersSpec]<~ControllersSpec>
        Returns -> typing.Sequence<+T_co>[~ControllersChangeResult]<~ControllersChangeResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='HighAvailability', request='EnableHA', version=2, params=_params)
        _params['specs'] = specs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ResumeHAReplicationAfterUpgrade(self, members):
        '''
        members : typing.Sequence<+T_co>[~Member]<~Member>
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='HighAvailability', request='ResumeHAReplicationAfterUpgrade', version=2, params=_params)
        _params['members'] = members
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MongoUpgradeResults)
    async def StopHAReplicationForUpgrade(self, target):
        '''
        target : MongoVersion
        Returns -> typing.Union[_ForwardRef('HAMember'), typing.Sequence<+T_co>[~Member]<~Member>]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='HighAvailability', request='StopHAReplicationForUpgrade', version=2, params=_params)
        _params['target'] = target
        reply = await self.rpc(msg)
        return reply



class ImageManagerFacade(Type):
    name = 'ImageManager'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ImageFilterParams': {'additionalProperties': False,
                                           'properties': {'images': {'items': {'$ref': '#/definitions/ImageSpec'},
                                                                     'type': 'array'}},
                                           'required': ['images'],
                                           'type': 'object'},
                     'ImageMetadata': {'additionalProperties': False,
                                       'properties': {'arch': {'type': 'string'},
                                                      'created': {'format': 'date-time',
                                                                  'type': 'string'},
                                                      'kind': {'type': 'string'},
                                                      'series': {'type': 'string'},
                                                      'url': {'type': 'string'}},
                                       'required': ['kind',
                                                    'arch',
                                                    'series',
                                                    'url',
                                                    'created'],
                                       'type': 'object'},
                     'ImageSpec': {'additionalProperties': False,
                                   'properties': {'arch': {'type': 'string'},
                                                  'kind': {'type': 'string'},
                                                  'series': {'type': 'string'}},
                                   'required': ['kind', 'arch', 'series'],
                                   'type': 'object'},
                     'ListImageResult': {'additionalProperties': False,
                                         'properties': {'result': {'items': {'$ref': '#/definitions/ImageMetadata'},
                                                                   'type': 'array'}},
                                         'required': ['result'],
                                         'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'DeleteImages': {'properties': {'Params': {'$ref': '#/definitions/ImageFilterParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListImages': {'properties': {'Params': {'$ref': '#/definitions/ImageFilterParams'},
                                                  'Result': {'$ref': '#/definitions/ListImageResult'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def DeleteImages(self, images):
        '''
        images : typing.Sequence<+T_co>[~ImageSpec]<~ImageSpec>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageManager', request='DeleteImages', version=2, params=_params)
        _params['images'] = images
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListImageResult)
    async def ListImages(self, images):
        '''
        images : typing.Sequence<+T_co>[~ImageSpec]<~ImageSpec>
        Returns -> typing.Sequence<+T_co>[~ImageMetadata]<~ImageMetadata>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageManager', request='ListImages', version=2, params=_params)
        _params['images'] = images
        reply = await self.rpc(msg)
        return reply



class ImageMetadataFacade(Type):
    name = 'ImageMetadata'
    version = 2
    schema =     {'definitions': {'CloudImageMetadata': {'additionalProperties': False,
                                            'properties': {'arch': {'type': 'string'},
                                                           'image-id': {'type': 'string'},
                                                           'priority': {'type': 'integer'},
                                                           'region': {'type': 'string'},
                                                           'root-storage-size': {'type': 'integer'},
                                                           'root-storage-type': {'type': 'string'},
                                                           'series': {'type': 'string'},
                                                           'source': {'type': 'string'},
                                                           'stream': {'type': 'string'},
                                                           'version': {'type': 'string'},
                                                           'virt-type': {'type': 'string'}},
                                            'required': ['image-id',
                                                         'region',
                                                         'version',
                                                         'series',
                                                         'arch',
                                                         'source',
                                                         'priority'],
                                            'type': 'object'},
                     'CloudImageMetadataList': {'additionalProperties': False,
                                                'properties': {'metadata': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                            'type': 'array'}},
                                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ImageMetadataFilter': {'additionalProperties': False,
                                             'properties': {'arches': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                            'region': {'type': 'string'},
                                                            'root-storage-type': {'type': 'string'},
                                                            'series': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                            'stream': {'type': 'string'},
                                                            'virt-type': {'type': 'string'}},
                                             'type': 'object'},
                     'ListCloudImageMetadataResult': {'additionalProperties': False,
                                                      'properties': {'result': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                                'type': 'array'}},
                                                      'required': ['result'],
                                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MetadataImageIds': {'additionalProperties': False,
                                          'properties': {'image-ids': {'items': {'type': 'string'},
                                                                       'type': 'array'}},
                                          'required': ['image-ids'],
                                          'type': 'object'},
                     'MetadataSaveParams': {'additionalProperties': False,
                                            'properties': {'metadata': {'items': {'$ref': '#/definitions/CloudImageMetadataList'},
                                                                        'type': 'array'}},
                                            'type': 'object'}},
     'properties': {'Delete': {'properties': {'Params': {'$ref': '#/definitions/MetadataImageIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'List': {'properties': {'Params': {'$ref': '#/definitions/ImageMetadataFilter'},
                                            'Result': {'$ref': '#/definitions/ListCloudImageMetadataResult'}},
                             'type': 'object'},
                    'Save': {'properties': {'Params': {'$ref': '#/definitions/MetadataSaveParams'},
                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                             'type': 'object'},
                    'UpdateFromPublishedImages': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def Delete(self, image_ids):
        '''
        image_ids : typing.Sequence<+T_co>[str]
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata', request='Delete', version=2, params=_params)
        _params['image-ids'] = image_ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListCloudImageMetadataResult)
    async def List(self, arches, region, root_storage_type, series, stream, virt_type):
        '''
        arches : typing.Sequence<+T_co>[str]
        region : str
        root_storage_type : str
        series : typing.Sequence<+T_co>[str]
        stream : str
        virt_type : str
        Returns -> typing.Sequence<+T_co>[~CloudImageMetadata]<~CloudImageMetadata>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata', request='List', version=2, params=_params)
        _params['arches'] = arches
        _params['region'] = region
        _params['root-storage-type'] = root_storage_type
        _params['series'] = series
        _params['stream'] = stream
        _params['virt-type'] = virt_type
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Save(self, metadata):
        '''
        metadata : typing.Sequence<+T_co>[~CloudImageMetadataList]<~CloudImageMetadataList>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata', request='Save', version=2, params=_params)
        _params['metadata'] = metadata
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def UpdateFromPublishedImages(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata', request='UpdateFromPublishedImages', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class LeadershipServiceFacade(Type):
    name = 'LeadershipService'
    version = 2
    schema =     {'definitions': {'ApplicationTag': {'additionalProperties': False,
                                        'properties': {'Name': {'type': 'string'}},
                                        'required': ['Name'],
                                        'type': 'object'},
                     'ClaimLeadershipBulkParams': {'additionalProperties': False,
                                                   'properties': {'params': {'items': {'$ref': '#/definitions/ClaimLeadershipParams'},
                                                                             'type': 'array'}},
                                                   'required': ['params'],
                                                   'type': 'object'},
                     'ClaimLeadershipBulkResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                               'type': 'array'}},
                                                    'required': ['results'],
                                                    'type': 'object'},
                     'ClaimLeadershipParams': {'additionalProperties': False,
                                               'properties': {'application-tag': {'type': 'string'},
                                                              'duration': {'type': 'number'},
                                                              'unit-tag': {'type': 'string'}},
                                               'required': ['application-tag',
                                                            'unit-tag',
                                                            'duration'],
                                               'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'BlockUntilLeadershipReleased': {'properties': {'Params': {'$ref': '#/definitions/ApplicationTag'},
                                                                    'Result': {'$ref': '#/definitions/ErrorResult'}},
                                                     'type': 'object'},
                    'ClaimLeadership': {'properties': {'Params': {'$ref': '#/definitions/ClaimLeadershipBulkParams'},
                                                       'Result': {'$ref': '#/definitions/ClaimLeadershipBulkResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def BlockUntilLeadershipReleased(self, name):
        '''
        name : str
        Returns -> Error
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LeadershipService', request='BlockUntilLeadershipReleased', version=2, params=_params)
        _params['Name'] = name
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ClaimLeadershipBulkResults)
    async def ClaimLeadership(self, params):
        '''
        params : typing.Sequence<+T_co>[~ClaimLeadershipParams]<~ClaimLeadershipParams>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LeadershipService', request='ClaimLeadership', version=2, params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



class MachineManagerFacade(Type):
    name = 'MachineManager'
    version = 2
    schema =     {'definitions': {'AddMachineParams': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'container-type': {'type': 'string'},
                                                         'disks': {'items': {'$ref': '#/definitions/Constraints'},
                                                                   'type': 'array'},
                                                         'hardware-characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                         'instance-id': {'type': 'string'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'nonce': {'type': 'string'},
                                                         'parent-id': {'type': 'string'},
                                                         'placement': {'$ref': '#/definitions/Placement'},
                                                         'series': {'type': 'string'}},
                                          'required': ['series',
                                                       'constraints',
                                                       'jobs',
                                                       'parent-id',
                                                       'container-type',
                                                       'instance-id',
                                                       'nonce',
                                                       'hardware-characteristics',
                                                       'addresses'],
                                          'type': 'object'},
                     'AddMachines': {'additionalProperties': False,
                                     'properties': {'params': {'items': {'$ref': '#/definitions/AddMachineParams'},
                                                               'type': 'array'}},
                                     'required': ['params'],
                                     'type': 'object'},
                     'AddMachinesResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'machine': {'type': 'string'}},
                                           'required': ['machine'],
                                           'type': 'object'},
                     'AddMachinesResults': {'additionalProperties': False,
                                            'properties': {'machines': {'items': {'$ref': '#/definitions/AddMachinesResult'},
                                                                        'type': 'array'}},
                                            'required': ['machines'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'InstanceType': {'additionalProperties': False,
                                      'properties': {'arches': {'items': {'type': 'string'},
                                                                'type': 'array'},
                                                     'cost': {'type': 'integer'},
                                                     'cpu-cores': {'type': 'integer'},
                                                     'deprecated': {'type': 'boolean'},
                                                     'memory': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'root-disk': {'type': 'integer'},
                                                     'virt-type': {'type': 'string'}},
                                      'required': ['arches', 'cpu-cores', 'memory'],
                                      'type': 'object'},
                     'InstanceTypesResult': {'additionalProperties': False,
                                             'properties': {'cost-currency': {'type': 'string'},
                                                            'cost-divisor': {'type': 'integer'},
                                                            'cost-unit': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'instance-types': {'items': {'$ref': '#/definitions/InstanceType'},
                                                                               'type': 'array'}},
                                             'type': 'object'},
                     'InstanceTypesResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/InstanceTypesResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelInstanceTypesConstraint': {'additionalProperties': False,
                                                      'properties': {'value': {'$ref': '#/definitions/Value'}},
                                                      'type': 'object'},
                     'ModelInstanceTypesConstraints': {'additionalProperties': False,
                                                       'properties': {'constraints': {'items': {'$ref': '#/definitions/ModelInstanceTypesConstraint'},
                                                                                      'type': 'array'}},
                                                       'required': ['constraints'],
                                                       'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'AddMachines': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                   'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                    'type': 'object'},
                    'InstanceTypes': {'properties': {'Params': {'$ref': '#/definitions/ModelInstanceTypesConstraints'},
                                                     'Result': {'$ref': '#/definitions/InstanceTypesResults'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddMachinesResults)
    async def AddMachines(self, params):
        '''
        params : typing.Sequence<+T_co>[~AddMachineParams]<~AddMachineParams>
        Returns -> typing.Sequence<+T_co>[~AddMachinesResult]<~AddMachinesResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager', request='AddMachines', version=2, params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InstanceTypesResults)
    async def InstanceTypes(self, constraints):
        '''
        constraints : typing.Sequence<+T_co>[~ModelInstanceTypesConstraint]<~ModelInstanceTypesConstraint>
        Returns -> typing.Sequence<+T_co>[~InstanceTypesResult]<~InstanceTypesResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager', request='InstanceTypes', version=2, params=_params)
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



class MetricsAdderFacade(Type):
    name = 'MetricsAdder'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Metric': {'additionalProperties': False,
                                'properties': {'key': {'type': 'string'},
                                               'time': {'format': 'date-time',
                                                        'type': 'string'},
                                               'value': {'type': 'string'}},
                                'required': ['key', 'value', 'time'],
                                'type': 'object'},
                     'MetricBatch': {'additionalProperties': False,
                                     'properties': {'charm-url': {'type': 'string'},
                                                    'created': {'format': 'date-time',
                                                                'type': 'string'},
                                                    'metrics': {'items': {'$ref': '#/definitions/Metric'},
                                                                'type': 'array'},
                                                    'uuid': {'type': 'string'}},
                                     'required': ['uuid',
                                                  'charm-url',
                                                  'created',
                                                  'metrics'],
                                     'type': 'object'},
                     'MetricBatchParam': {'additionalProperties': False,
                                          'properties': {'batch': {'$ref': '#/definitions/MetricBatch'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'batch'],
                                          'type': 'object'},
                     'MetricBatchParams': {'additionalProperties': False,
                                           'properties': {'batches': {'items': {'$ref': '#/definitions/MetricBatchParam'},
                                                                      'type': 'array'}},
                                           'required': ['batches'],
                                           'type': 'object'}},
     'properties': {'AddMetricBatches': {'properties': {'Params': {'$ref': '#/definitions/MetricBatchParams'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddMetricBatches(self, batches):
        '''
        batches : typing.Sequence<+T_co>[~MetricBatchParam]<~MetricBatchParam>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsAdder', request='AddMetricBatches', version=2, params=_params)
        _params['batches'] = batches
        reply = await self.rpc(msg)
        return reply



class MetricsDebugFacade(Type):
    name = 'MetricsDebug'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityMetrics': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'metrics': {'items': {'$ref': '#/definitions/MetricResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MeterStatusParam': {'additionalProperties': False,
                                          'properties': {'code': {'type': 'string'},
                                                         'info': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'code', 'info'],
                                          'type': 'object'},
                     'MeterStatusParams': {'additionalProperties': False,
                                           'properties': {'statues': {'items': {'$ref': '#/definitions/MeterStatusParam'},
                                                                      'type': 'array'}},
                                           'required': ['statues'],
                                           'type': 'object'},
                     'MetricResult': {'additionalProperties': False,
                                      'properties': {'key': {'type': 'string'},
                                                     'time': {'format': 'date-time',
                                                              'type': 'string'},
                                                     'unit': {'type': 'string'},
                                                     'value': {'type': 'string'}},
                                      'required': ['time', 'key', 'value', 'unit'],
                                      'type': 'object'},
                     'MetricResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/EntityMetrics'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'}},
     'properties': {'GetMetrics': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/MetricResults'}},
                                   'type': 'object'},
                    'SetMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/MeterStatusParams'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MetricResults)
    async def GetMetrics(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~EntityMetrics]<~EntityMetrics>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsDebug', request='GetMetrics', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMeterStatus(self, statues):
        '''
        statues : typing.Sequence<+T_co>[~MeterStatusParam]<~MeterStatusParam>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsDebug', request='SetMeterStatus', version=2, params=_params)
        _params['statues'] = statues
        reply = await self.rpc(msg)
        return reply



class ModelManagerFacade(Type):
    name = 'ModelManager'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MapResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                          'type': 'object'}},
                                                             'type': 'object'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'MapResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/MapResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'Model': {'additionalProperties': False,
                               'properties': {'name': {'type': 'string'},
                                              'owner-tag': {'type': 'string'},
                                              'uuid': {'type': 'string'}},
                               'required': ['name', 'uuid', 'owner-tag'],
                               'type': 'object'},
                     'ModelCreateArgs': {'additionalProperties': False,
                                         'properties': {'cloud-tag': {'type': 'string'},
                                                        'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                'type': 'object'}},
                                                                   'type': 'object'},
                                                        'credential': {'type': 'string'},
                                                        'name': {'type': 'string'},
                                                        'owner-tag': {'type': 'string'},
                                                        'region': {'type': 'string'}},
                                         'required': ['name', 'owner-tag'],
                                         'type': 'object'},
                     'ModelDefaultValues': {'additionalProperties': False,
                                            'properties': {'cloud-region': {'type': 'string'},
                                                           'cloud-tag': {'type': 'string'},
                                                           'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                   'type': 'object'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelDefaults': {'additionalProperties': False,
                                       'properties': {'controller': {'additionalProperties': True,
                                                                     'type': 'object'},
                                                      'default': {'additionalProperties': True,
                                                                  'type': 'object'},
                                                      'regions': {'items': {'$ref': '#/definitions/RegionDefaults'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ModelDefaultsResult': {'additionalProperties': False,
                                             'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ModelDefaults'}},
                                                                       'type': 'object'}},
                                             'required': ['config'],
                                             'type': 'object'},
                     'ModelInfo': {'additionalProperties': False,
                                   'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                  'cloud-credential-tag': {'type': 'string'},
                                                  'cloud-region': {'type': 'string'},
                                                  'cloud-tag': {'type': 'string'},
                                                  'controller-uuid': {'type': 'string'},
                                                  'default-series': {'type': 'string'},
                                                  'life': {'type': 'string'},
                                                  'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                               'type': 'array'},
                                                  'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                  'name': {'type': 'string'},
                                                  'owner-tag': {'type': 'string'},
                                                  'provider-type': {'type': 'string'},
                                                  'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                  'status': {'$ref': '#/definitions/EntityStatus'},
                                                  'users': {'items': {'$ref': '#/definitions/ModelUserInfo'},
                                                            'type': 'array'},
                                                  'uuid': {'type': 'string'}},
                                   'required': ['name',
                                                'uuid',
                                                'controller-uuid',
                                                'cloud-tag',
                                                'owner-tag',
                                                'life',
                                                'users',
                                                'machines',
                                                'sla',
                                                'agent-version'],
                                   'type': 'object'},
                     'ModelInfoResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/ModelInfo'}},
                                         'type': 'object'},
                     'ModelInfoResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/ModelInfoResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelMigrationStatus': {'additionalProperties': False,
                                              'properties': {'end': {'format': 'date-time',
                                                                     'type': 'string'},
                                                             'start': {'format': 'date-time',
                                                                       'type': 'string'},
                                                             'status': {'type': 'string'}},
                                              'required': ['status', 'start'],
                                              'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelStatus': {'additionalProperties': False,
                                     'properties': {'application-count': {'type': 'integer'},
                                                    'hosted-machine-count': {'type': 'integer'},
                                                    'life': {'type': 'string'},
                                                    'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                                 'type': 'array'},
                                                    'model-tag': {'type': 'string'},
                                                    'owner-tag': {'type': 'string'}},
                                     'required': ['model-tag',
                                                  'life',
                                                  'hosted-machine-count',
                                                  'application-count',
                                                  'owner-tag'],
                                     'type': 'object'},
                     'ModelStatusResults': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelStatus'},
                                                                      'type': 'array'}},
                                            'required': ['models'],
                                            'type': 'object'},
                     'ModelUnsetKeys': {'additionalProperties': False,
                                        'properties': {'cloud-region': {'type': 'string'},
                                                       'cloud-tag': {'type': 'string'},
                                                       'keys': {'items': {'type': 'string'},
                                                                'type': 'array'}},
                                        'required': ['keys'],
                                        'type': 'object'},
                     'ModelUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'last-connection': {'format': 'date-time',
                                                                          'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'last-connection',
                                                    'access'],
                                       'type': 'object'},
                     'ModifyModelAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'model-tag': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'action',
                                                        'access',
                                                        'model-tag'],
                                           'type': 'object'},
                     'ModifyModelAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyModelAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'RegionDefaults': {'additionalProperties': False,
                                        'properties': {'region-name': {'type': 'string'},
                                                       'value': {'additionalProperties': True,
                                                                 'type': 'object'}},
                                        'required': ['region-name', 'value'],
                                        'type': 'object'},
                     'SetModelDefaults': {'additionalProperties': False,
                                          'properties': {'config': {'items': {'$ref': '#/definitions/ModelDefaultValues'},
                                                                    'type': 'array'}},
                                          'required': ['config'],
                                          'type': 'object'},
                     'UnsetModelDefaults': {'additionalProperties': False,
                                            'properties': {'keys': {'items': {'$ref': '#/definitions/ModelUnsetKeys'},
                                                                    'type': 'array'}},
                                            'required': ['keys'],
                                            'type': 'object'},
                     'UserModel': {'additionalProperties': False,
                                   'properties': {'last-connection': {'format': 'date-time',
                                                                      'type': 'string'},
                                                  'model': {'$ref': '#/definitions/Model'}},
                                   'required': ['model', 'last-connection'],
                                   'type': 'object'},
                     'UserModelList': {'additionalProperties': False,
                                       'properties': {'user-models': {'items': {'$ref': '#/definitions/UserModel'},
                                                                      'type': 'array'}},
                                       'required': ['user-models'],
                                       'type': 'object'}},
     'properties': {'CreateModel': {'properties': {'Params': {'$ref': '#/definitions/ModelCreateArgs'},
                                                   'Result': {'$ref': '#/definitions/ModelInfo'}},
                                    'type': 'object'},
                    'DestroyModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'DumpModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/MapResults'}},
                                   'type': 'object'},
                    'DumpModelsDB': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/MapResults'}},
                                     'type': 'object'},
                    'ListModels': {'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                  'Result': {'$ref': '#/definitions/UserModelList'}},
                                   'type': 'object'},
                    'ModelDefaults': {'properties': {'Result': {'$ref': '#/definitions/ModelDefaultsResult'}},
                                      'type': 'object'},
                    'ModelInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/ModelInfoResults'}},
                                  'type': 'object'},
                    'ModelStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ModelStatusResults'}},
                                    'type': 'object'},
                    'ModifyModelAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyModelAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetModelDefaults': {'properties': {'Params': {'$ref': '#/definitions/SetModelDefaults'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'UnsetModelDefaults': {'properties': {'Params': {'$ref': '#/definitions/UnsetModelDefaults'},
                                                          'Result': {'$ref': '#/definitions/ErrorResults'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelInfo)
    async def CreateModel(self, cloud_tag, config, credential, name, owner_tag, region):
        '''
        cloud_tag : str
        config : typing.Mapping<~KT, +VT_co>[str, typing.Any]
        credential : str
        name : str
        owner_tag : str
        region : str
        Returns -> typing.Union[_ForwardRef('Number'), _ForwardRef('ModelMigrationStatus'), _ForwardRef('ModelSLAInfo'), _ForwardRef('EntityStatus'), typing.Sequence<+T_co>[~ModelUserInfo]<~ModelUserInfo>]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='CreateModel', version=2, params=_params)
        _params['cloud-tag'] = cloud_tag
        _params['config'] = config
        _params['credential'] = credential
        _params['name'] = name
        _params['owner-tag'] = owner_tag
        _params['region'] = region
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyModels(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='DestroyModels', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MapResults)
    async def DumpModels(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~MapResult]<~MapResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='DumpModels', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MapResults)
    async def DumpModelsDB(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~MapResult]<~MapResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='DumpModelsDB', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserModelList)
    async def ListModels(self, tag):
        '''
        tag : str
        Returns -> typing.Sequence<+T_co>[~UserModel]<~UserModel>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='ListModels', version=2, params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelDefaultsResult)
    async def ModelDefaults(self):
        '''

        Returns -> typing.Mapping<~KT, +VT_co>[str, ~ModelDefaults]<~ModelDefaults>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='ModelDefaults', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfoResults)
    async def ModelInfo(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ModelInfoResult]<~ModelInfoResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='ModelInfo', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelStatusResults)
    async def ModelStatus(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ModelStatus]<~ModelStatus>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='ModelStatus', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyModelAccess(self, changes):
        '''
        changes : typing.Sequence<+T_co>[~ModifyModelAccess]<~ModifyModelAccess>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='ModifyModelAccess', version=2, params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModelDefaults(self, config):
        '''
        config : typing.Sequence<+T_co>[~ModelDefaultValues]<~ModelDefaultValues>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='SetModelDefaults', version=2, params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UnsetModelDefaults(self, keys):
        '''
        keys : typing.Sequence<+T_co>[~ModelUnsetKeys]<~ModelUnsetKeys>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager', request='UnsetModelDefaults', version=2, params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



class RebootFacade(Type):
    name = 'Reboot'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'RebootActionResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'result': {'type': 'string'}},
                                            'type': 'object'},
                     'RebootActionResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/RebootActionResult'},
                                                                        'type': 'array'}},
                                             'type': 'object'}},
     'properties': {'ClearReboot': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'GetRebootAction': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/RebootActionResults'}},
                                        'type': 'object'},
                    'RequestReboot': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'WatchForRebootEvent': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ClearReboot(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot', request='ClearReboot', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RebootActionResults)
    async def GetRebootAction(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~RebootActionResult]<~RebootActionResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot', request='GetRebootAction', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RequestReboot(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot', request='RequestReboot', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForRebootEvent(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot', request='WatchForRebootEvent', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class ResumerFacade(Type):
    name = 'Resumer'
    version = 2
    schema =     {'properties': {'ResumeTransactions': {'type': 'object'}}, 'type': 'object'}
    

    @ReturnMapping(None)
    async def ResumeTransactions(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Resumer', request='ResumeTransactions', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class SSHClientFacade(Type):
    name = 'SSHClient'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SSHAddressResult': {'additionalProperties': False,
                                          'properties': {'address': {'type': 'string'},
                                                         'error': {'$ref': '#/definitions/Error'}},
                                          'type': 'object'},
                     'SSHAddressResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/SSHAddressResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'SSHAddressesResult': {'additionalProperties': False,
                                            'properties': {'addresses': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'}},
                                            'required': ['addresses'],
                                            'type': 'object'},
                     'SSHAddressesResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/SSHAddressesResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'SSHProxyResult': {'additionalProperties': False,
                                        'properties': {'use-proxy': {'type': 'boolean'}},
                                        'required': ['use-proxy'],
                                        'type': 'object'},
                     'SSHPublicKeysResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'public-keys': {'items': {'type': 'string'},
                                                                            'type': 'array'}},
                                             'type': 'object'},
                     'SSHPublicKeysResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/SSHPublicKeysResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'}},
     'properties': {'AllAddresses': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/SSHAddressesResults'}},
                                     'type': 'object'},
                    'PrivateAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/SSHAddressResults'}},
                                       'type': 'object'},
                    'Proxy': {'properties': {'Result': {'$ref': '#/definitions/SSHProxyResult'}},
                              'type': 'object'},
                    'PublicAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/SSHAddressResults'}},
                                      'type': 'object'},
                    'PublicKeys': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/SSHPublicKeysResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(SSHAddressesResults)
    async def AllAddresses(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~SSHAddressesResult]<~SSHAddressesResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient', request='AllAddresses', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHAddressResults)
    async def PrivateAddress(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~SSHAddressResult]<~SSHAddressResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient', request='PrivateAddress', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHProxyResult)
    async def Proxy(self):
        '''

        Returns -> bool
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient', request='Proxy', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHAddressResults)
    async def PublicAddress(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~SSHAddressResult]<~SSHAddressResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient', request='PublicAddress', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHPublicKeysResults)
    async def PublicKeys(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~SSHPublicKeysResult]<~SSHPublicKeysResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient', request='PublicKeys', version=2, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SpacesFacade(Type):
    name = 'Spaces'
    version = 2
    schema =     {'definitions': {'CreateSpaceParams': {'additionalProperties': False,
                                           'properties': {'provider-id': {'type': 'string'},
                                                          'public': {'type': 'boolean'},
                                                          'space-tag': {'type': 'string'},
                                                          'subnet-tags': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                           'required': ['subnet-tags',
                                                        'space-tag',
                                                        'public'],
                                           'type': 'object'},
                     'CreateSpacesParams': {'additionalProperties': False,
                                            'properties': {'spaces': {'items': {'$ref': '#/definitions/CreateSpaceParams'},
                                                                      'type': 'array'}},
                                            'required': ['spaces'],
                                            'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSpacesResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/Space'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Space': {'additionalProperties': False,
                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                              'name': {'type': 'string'},
                                              'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                          'type': 'array'}},
                               'required': ['name', 'subnets'],
                               'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'}},
     'properties': {'CreateSpaces': {'properties': {'Params': {'$ref': '#/definitions/CreateSpacesParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListSpaces': {'properties': {'Result': {'$ref': '#/definitions/ListSpacesResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def CreateSpaces(self, spaces):
        '''
        spaces : typing.Sequence<+T_co>[~CreateSpaceParams]<~CreateSpaceParams>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces', request='CreateSpaces', version=2, params=_params)
        _params['spaces'] = spaces
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSpacesResults)
    async def ListSpaces(self):
        '''

        Returns -> typing.Sequence<+T_co>[~Space]<~Space>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces', request='ListSpaces', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class StatusHistoryFacade(Type):
    name = 'StatusHistory'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'StatusHistoryPruneArgs': {'additionalProperties': False,
                                                'properties': {'max-history-mb': {'type': 'integer'},
                                                               'max-history-time': {'type': 'integer'}},
                                                'required': ['max-history-time',
                                                             'max-history-mb'],
                                                'type': 'object'}},
     'properties': {'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'Prune': {'properties': {'Params': {'$ref': '#/definitions/StatusHistoryPruneArgs'}},
                              'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping<~KT, +VT_co>[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StatusHistory', request='ModelConfig', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Prune(self, max_history_mb, max_history_time):
        '''
        max_history_mb : int
        max_history_time : int
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StatusHistory', request='Prune', version=2, params=_params)
        _params['max-history-mb'] = max_history_mb
        _params['max-history-time'] = max_history_time
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StatusHistory', request='WatchForModelConfigChanges', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



class SubnetsFacade(Type):
    name = 'Subnets'
    version = 2
    schema =     {'definitions': {'AddSubnetParams': {'additionalProperties': False,
                                         'properties': {'provider-network-id': {'type': 'string'},
                                                        'space-tag': {'type': 'string'},
                                                        'subnet-provider-id': {'type': 'string'},
                                                        'subnet-tag': {'type': 'string'},
                                                        'vlan-tag': {'type': 'integer'},
                                                        'zones': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                         'required': ['space-tag'],
                                         'type': 'object'},
                     'AddSubnetsParams': {'additionalProperties': False,
                                          'properties': {'subnets': {'items': {'$ref': '#/definitions/AddSubnetParams'},
                                                                     'type': 'array'}},
                                          'required': ['subnets'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSubnetsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/Subnet'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SpaceResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'tag': {'type': 'string'}},
                                     'required': ['tag'],
                                     'type': 'object'},
                     'SpaceResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/SpaceResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'SubnetsFilters': {'additionalProperties': False,
                                        'properties': {'space-tag': {'type': 'string'},
                                                       'zone': {'type': 'string'}},
                                        'type': 'object'},
                     'ZoneResult': {'additionalProperties': False,
                                    'properties': {'available': {'type': 'boolean'},
                                                   'error': {'$ref': '#/definitions/Error'},
                                                   'name': {'type': 'string'}},
                                    'required': ['name', 'available'],
                                    'type': 'object'},
                     'ZoneResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/ZoneResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'}},
     'properties': {'AddSubnets': {'properties': {'Params': {'$ref': '#/definitions/AddSubnetsParams'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'AllSpaces': {'properties': {'Result': {'$ref': '#/definitions/SpaceResults'}},
                                  'type': 'object'},
                    'AllZones': {'properties': {'Result': {'$ref': '#/definitions/ZoneResults'}},
                                 'type': 'object'},
                    'ListSubnets': {'properties': {'Params': {'$ref': '#/definitions/SubnetsFilters'},
                                                   'Result': {'$ref': '#/definitions/ListSubnetsResults'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddSubnets(self, subnets):
        '''
        subnets : typing.Sequence<+T_co>[~AddSubnetParams]<~AddSubnetParams>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets', request='AddSubnets', version=2, params=_params)
        _params['subnets'] = subnets
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SpaceResults)
    async def AllSpaces(self):
        '''

        Returns -> typing.Sequence<+T_co>[~SpaceResult]<~SpaceResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets', request='AllSpaces', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ZoneResults)
    async def AllZones(self):
        '''

        Returns -> typing.Sequence<+T_co>[~ZoneResult]<~ZoneResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets', request='AllZones', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSubnetsResults)
    async def ListSubnets(self, space_tag, zone):
        '''
        space_tag : str
        zone : str
        Returns -> typing.Sequence<+T_co>[~Subnet]<~Subnet>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets', request='ListSubnets', version=2, params=_params)
        _params['space-tag'] = space_tag
        _params['zone'] = zone
        reply = await self.rpc(msg)
        return reply



class VolumeAttachmentsWatcherFacade(Type):
    name = 'VolumeAttachmentsWatcher'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineStorageId': {'additionalProperties': False,
                                          'properties': {'attachment-tag': {'type': 'string'},
                                                         'machine-tag': {'type': 'string'}},
                                          'required': ['machine-tag',
                                                       'attachment-tag'],
                                          'type': 'object'},
                     'MachineStorageIdsWatchResult': {'additionalProperties': False,
                                                      'properties': {'changes': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                                 'type': 'array'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'watcher-id': {'type': 'string'}},
                                                      'required': ['watcher-id',
                                                                   'changes'],
                                                      'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MachineStorageIdsWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[typing.Sequence<+T_co>[~MachineStorageId]<~MachineStorageId>, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='VolumeAttachmentsWatcher', request='Next', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='VolumeAttachmentsWatcher', request='Stop', version=2, params=_params)

        reply = await self.rpc(msg)
        return reply
