# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client._definitions import *
from juju.client.facade import ReturnMapping, Type


class AgentToolsFacade(Type):
    name = 'AgentTools'
    version = 1
    schema =     {'properties': {'UpdateToolsAvailable': {'type': 'object'}}, 'type': 'object'}
    

    @ReturnMapping(None)
    async def UpdateToolsAvailable(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AgentTools', request='UpdateToolsAvailable', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class AllWatcherFacade(Type):
    name = 'AllWatcher'
    version = 1
    schema =     {'definitions': {'AllWatcherNextResults': {'additionalProperties': False,
                                               'properties': {'deltas': {'items': {'$ref': '#/definitions/Delta'},
                                                                         'type': 'array'}},
                                               'required': ['deltas'],
                                               'type': 'object'},
                     'Delta': {'additionalProperties': False,
                               'properties': {'entity': {'additionalProperties': True,
                                                         'type': 'object'},
                                              'removed': {'type': 'boolean'}},
                               'required': ['removed', 'entity'],
                               'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/AllWatcherNextResults'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AllWatcherNextResults)
    async def Next(self):
        '''

        Returns -> typing.Sequence<+T_co>[~Delta]<~Delta>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AllWatcher', request='Next', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AllWatcher', request='Stop', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class ApplicationRelationsWatcherFacade(Type):
    name = 'ApplicationRelationsWatcher'
    version = 1
    schema =     {'definitions': {'ApplicationRelationsChange': {'additionalProperties': False,
                                                    'properties': {'changed': {'items': {'$ref': '#/definitions/RelationChange'},
                                                                               'type': 'array'},
                                                                   'removed': {'items': {'type': 'integer'},
                                                                               'type': 'array'}},
                                                    'type': 'object'},
                     'ApplicationRelationsWatchResult': {'additionalProperties': False,
                                                         'properties': {'ApplicationRelationsWatcherId': {'type': 'string'},
                                                                        'changes': {'$ref': '#/definitions/ApplicationRelationsChange'},
                                                                        'error': {'$ref': '#/definitions/Error'}},
                                                         'required': ['ApplicationRelationsWatcherId'],
                                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RelationChange': {'additionalProperties': False,
                                        'properties': {'changedunits': {'patternProperties': {'.*': {'$ref': '#/definitions/RelationUnitChange'}},
                                                                        'type': 'object'},
                                                       'departedunits': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                       'id': {'type': 'integer'},
                                                       'life': {'type': 'string'}},
                                        'required': ['id', 'life'],
                                        'type': 'object'},
                     'RelationUnitChange': {'additionalProperties': False,
                                            'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                     'type': 'object'}},
                                                                        'type': 'object'}},
                                            'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/ApplicationRelationsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ApplicationRelationsWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('ApplicationRelationsChange'), _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationRelationsWatcher', request='Next', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationRelationsWatcher', request='Stop', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class ApplicationScalerFacade(Type):
    name = 'ApplicationScaler'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'Rescale': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'Watch': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def Rescale(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationScaler', request='Rescale', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def Watch(self):
        '''

        Returns -> typing.Union[typing.Sequence<+T_co>[str], _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationScaler', request='Watch', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class BackupsFacade(Type):
    name = 'Backups'
    version = 1
    schema =     {'definitions': {'BackupsCreateArgs': {'additionalProperties': False,
                                           'properties': {'notes': {'type': 'string'}},
                                           'required': ['notes'],
                                           'type': 'object'},
                     'BackupsInfoArgs': {'additionalProperties': False,
                                         'properties': {'id': {'type': 'string'}},
                                         'required': ['id'],
                                         'type': 'object'},
                     'BackupsListArgs': {'additionalProperties': False,
                                         'type': 'object'},
                     'BackupsListResult': {'additionalProperties': False,
                                           'properties': {'list': {'items': {'$ref': '#/definitions/BackupsMetadataResult'},
                                                                   'type': 'array'}},
                                           'required': ['list'],
                                           'type': 'object'},
                     'BackupsMetadataResult': {'additionalProperties': False,
                                               'properties': {'ca-cert': {'type': 'string'},
                                                              'ca-private-key': {'type': 'string'},
                                                              'checksum': {'type': 'string'},
                                                              'checksum-format': {'type': 'string'},
                                                              'finished': {'format': 'date-time',
                                                                           'type': 'string'},
                                                              'hostname': {'type': 'string'},
                                                              'id': {'type': 'string'},
                                                              'machine': {'type': 'string'},
                                                              'model': {'type': 'string'},
                                                              'notes': {'type': 'string'},
                                                              'series': {'type': 'string'},
                                                              'size': {'type': 'integer'},
                                                              'started': {'format': 'date-time',
                                                                          'type': 'string'},
                                                              'stored': {'format': 'date-time',
                                                                         'type': 'string'},
                                                              'version': {'$ref': '#/definitions/Number'}},
                                               'required': ['id',
                                                            'checksum',
                                                            'checksum-format',
                                                            'size',
                                                            'stored',
                                                            'started',
                                                            'finished',
                                                            'notes',
                                                            'model',
                                                            'machine',
                                                            'hostname',
                                                            'version',
                                                            'series',
                                                            'ca-cert',
                                                            'ca-private-key'],
                                               'type': 'object'},
                     'BackupsRemoveArgs': {'additionalProperties': False,
                                           'properties': {'id': {'type': 'string'}},
                                           'required': ['id'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'RestoreArgs': {'additionalProperties': False,
                                     'properties': {'backup-id': {'type': 'string'}},
                                     'required': ['backup-id'],
                                     'type': 'object'}},
     'properties': {'Create': {'properties': {'Params': {'$ref': '#/definitions/BackupsCreateArgs'},
                                              'Result': {'$ref': '#/definitions/BackupsMetadataResult'}},
                               'type': 'object'},
                    'FinishRestore': {'type': 'object'},
                    'Info': {'properties': {'Params': {'$ref': '#/definitions/BackupsInfoArgs'},
                                            'Result': {'$ref': '#/definitions/BackupsMetadataResult'}},
                             'type': 'object'},
                    'List': {'properties': {'Params': {'$ref': '#/definitions/BackupsListArgs'},
                                            'Result': {'$ref': '#/definitions/BackupsListResult'}},
                             'type': 'object'},
                    'PrepareRestore': {'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/BackupsRemoveArgs'}},
                               'type': 'object'},
                    'Restore': {'properties': {'Params': {'$ref': '#/definitions/RestoreArgs'}},
                                'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BackupsMetadataResult)
    async def Create(self, notes):
        '''
        notes : str
        Returns -> typing.Union[str, int, _ForwardRef('Number')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups', request='Create', version=1, params=_params)
        _params['notes'] = notes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def FinishRestore(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups', request='FinishRestore', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BackupsMetadataResult)
    async def Info(self, id_):
        '''
        id_ : str
        Returns -> typing.Union[str, int, _ForwardRef('Number')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups', request='Info', version=1, params=_params)
        _params['id'] = id_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BackupsListResult)
    async def List(self):
        '''

        Returns -> typing.Sequence<+T_co>[~BackupsMetadataResult]<~BackupsMetadataResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups', request='List', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def PrepareRestore(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups', request='PrepareRestore', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Remove(self, id_):
        '''
        id_ : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups', request='Remove', version=1, params=_params)
        _params['id'] = id_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Restore(self, backup_id):
        '''
        backup_id : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups', request='Restore', version=1, params=_params)
        _params['backup-id'] = backup_id
        reply = await self.rpc(msg)
        return reply



class BundleFacade(Type):
    name = 'Bundle'
    version = 1
    schema =     {'definitions': {'BundleChange': {'additionalProperties': False,
                                      'properties': {'args': {'items': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                              'type': 'array'},
                                                     'id': {'type': 'string'},
                                                     'method': {'type': 'string'},
                                                     'requires': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['id',
                                                   'method',
                                                   'args',
                                                   'requires'],
                                      'type': 'object'},
                     'BundleChangesParams': {'additionalProperties': False,
                                             'properties': {'yaml': {'type': 'string'}},
                                             'required': ['yaml'],
                                             'type': 'object'},
                     'BundleChangesResults': {'additionalProperties': False,
                                              'properties': {'changes': {'items': {'$ref': '#/definitions/BundleChange'},
                                                                         'type': 'array'},
                                                             'errors': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                              'type': 'object'}},
     'properties': {'GetChanges': {'properties': {'Params': {'$ref': '#/definitions/BundleChangesParams'},
                                                  'Result': {'$ref': '#/definitions/BundleChangesResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BundleChangesResults)
    async def GetChanges(self, yaml):
        '''
        yaml : str
        Returns -> typing.Sequence<+T_co>[~BundleChange]<~BundleChange>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Bundle', request='GetChanges', version=1, params=_params)
        _params['yaml'] = yaml
        reply = await self.rpc(msg)
        return reply



class ClientFacade(Type):
    name = 'Client'
    version = 1
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'AddCharm': {'additionalProperties': False,
                                  'properties': {'channel': {'type': 'string'},
                                                 'url': {'type': 'string'}},
                                  'required': ['url', 'channel'],
                                  'type': 'object'},
                     'AddCharmWithAuthorization': {'additionalProperties': False,
                                                   'properties': {'channel': {'type': 'string'},
                                                                  'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                                  'url': {'type': 'string'}},
                                                   'required': ['url',
                                                                'channel',
                                                                'macaroon'],
                                                   'type': 'object'},
                     'AddMachineParams': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'container-type': {'type': 'string'},
                                                         'disks': {'items': {'$ref': '#/definitions/Constraints'},
                                                                   'type': 'array'},
                                                         'hardware-characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                         'instance-id': {'type': 'string'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'nonce': {'type': 'string'},
                                                         'parent-id': {'type': 'string'},
                                                         'placement': {'$ref': '#/definitions/Placement'},
                                                         'series': {'type': 'string'}},
                                          'required': ['series',
                                                       'constraints',
                                                       'jobs',
                                                       'parent-id',
                                                       'container-type',
                                                       'instance-id',
                                                       'nonce',
                                                       'hardware-characteristics',
                                                       'addresses'],
                                          'type': 'object'},
                     'AddMachines': {'additionalProperties': False,
                                     'properties': {'params': {'items': {'$ref': '#/definitions/AddMachineParams'},
                                                               'type': 'array'}},
                                     'required': ['params'],
                                     'type': 'object'},
                     'AddMachinesResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'machine': {'type': 'string'}},
                                           'required': ['machine'],
                                           'type': 'object'},
                     'AddMachinesResults': {'additionalProperties': False,
                                            'properties': {'machines': {'items': {'$ref': '#/definitions/AddMachinesResult'},
                                                                        'type': 'array'}},
                                            'required': ['machines'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'AgentVersionResult': {'additionalProperties': False,
                                            'properties': {'version': {'$ref': '#/definitions/Number'}},
                                            'required': ['version'],
                                            'type': 'object'},
                     'AllWatcherId': {'additionalProperties': False,
                                      'properties': {'watcher-id': {'type': 'string'}},
                                      'required': ['watcher-id'],
                                      'type': 'object'},
                     'ApplicationStatus': {'additionalProperties': False,
                                           'properties': {'can-upgrade-to': {'type': 'string'},
                                                          'charm': {'type': 'string'},
                                                          'err': {'additionalProperties': True,
                                                                  'type': 'object'},
                                                          'exposed': {'type': 'boolean'},
                                                          'life': {'type': 'string'},
                                                          'meter-statuses': {'patternProperties': {'.*': {'$ref': '#/definitions/MeterStatus'}},
                                                                             'type': 'object'},
                                                          'relations': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                     'type': 'array'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'status': {'$ref': '#/definitions/DetailedStatus'},
                                                          'subordinate-to': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                          'units': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitStatus'}},
                                                                    'type': 'object'},
                                                          'workload-version': {'type': 'string'}},
                                           'required': ['charm',
                                                        'series',
                                                        'exposed',
                                                        'life',
                                                        'relations',
                                                        'can-upgrade-to',
                                                        'subordinate-to',
                                                        'units',
                                                        'meter-statuses',
                                                        'status',
                                                        'workload-version'],
                                           'type': 'object'},
                     'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Series': {'type': 'string'}},
                                'required': ['Number', 'Series', 'Arch'],
                                'type': 'object'},
                     'BundleChange': {'additionalProperties': False,
                                      'properties': {'args': {'items': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                              'type': 'array'},
                                                     'id': {'type': 'string'},
                                                     'method': {'type': 'string'},
                                                     'requires': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['id',
                                                   'method',
                                                   'args',
                                                   'requires'],
                                      'type': 'object'},
                     'BundleChangesParams': {'additionalProperties': False,
                                             'properties': {'yaml': {'type': 'string'}},
                                             'required': ['yaml'],
                                             'type': 'object'},
                     'BundleChangesResults': {'additionalProperties': False,
                                              'properties': {'changes': {'items': {'$ref': '#/definitions/BundleChange'},
                                                                         'type': 'array'},
                                                             'errors': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                              'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'DestroyMachines': {'additionalProperties': False,
                                         'properties': {'force': {'type': 'boolean'},
                                                        'machine-names': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                         'required': ['machine-names', 'force'],
                                         'type': 'object'},
                     'DetailedStatus': {'additionalProperties': False,
                                        'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                       'err': {'additionalProperties': True,
                                                               'type': 'object'},
                                                       'info': {'type': 'string'},
                                                       'kind': {'type': 'string'},
                                                       'life': {'type': 'string'},
                                                       'since': {'format': 'date-time',
                                                                 'type': 'string'},
                                                       'status': {'type': 'string'},
                                                       'version': {'type': 'string'}},
                                        'required': ['status',
                                                     'info',
                                                     'data',
                                                     'since',
                                                     'kind',
                                                     'version',
                                                     'life'],
                                        'type': 'object'},
                     'EndpointStatus': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'},
                                                       'subordinate': {'type': 'boolean'}},
                                        'required': ['application',
                                                     'name',
                                                     'role',
                                                     'subordinate'],
                                        'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FindToolsParams': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'major': {'type': 'integer'},
                                                        'minor': {'type': 'integer'},
                                                        'number': {'$ref': '#/definitions/Number'},
                                                        'series': {'type': 'string'}},
                                         'required': ['number',
                                                      'major',
                                                      'minor',
                                                      'arch',
                                                      'series'],
                                         'type': 'object'},
                     'FindToolsResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'list': {'items': {'$ref': '#/definitions/Tools'},
                                                                 'type': 'array'}},
                                         'required': ['list'],
                                         'type': 'object'},
                     'FullStatus': {'additionalProperties': False,
                                    'properties': {'applications': {'patternProperties': {'.*': {'$ref': '#/definitions/ApplicationStatus'}},
                                                                    'type': 'object'},
                                                   'machines': {'patternProperties': {'.*': {'$ref': '#/definitions/MachineStatus'}},
                                                                'type': 'object'},
                                                   'model': {'$ref': '#/definitions/ModelStatusInfo'},
                                                   'relations': {'items': {'$ref': '#/definitions/RelationStatus'},
                                                                 'type': 'array'},
                                                   'remote-applications': {'patternProperties': {'.*': {'$ref': '#/definitions/RemoteApplicationStatus'}},
                                                                           'type': 'object'}},
                                    'required': ['model',
                                                 'machines',
                                                 'applications',
                                                 'remote-applications',
                                                 'relations'],
                                    'type': 'object'},
                     'GetConstraintsResults': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'History': {'additionalProperties': False,
                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                'statuses': {'items': {'$ref': '#/definitions/DetailedStatus'},
                                                             'type': 'array'}},
                                 'required': ['statuses'],
                                 'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'}},
                                  'required': ['Address', 'port'],
                                  'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MachineStatus': {'additionalProperties': False,
                                       'properties': {'agent-status': {'$ref': '#/definitions/DetailedStatus'},
                                                      'constraints': {'type': 'string'},
                                                      'containers': {'patternProperties': {'.*': {'$ref': '#/definitions/MachineStatus'}},
                                                                     'type': 'object'},
                                                      'dns-name': {'type': 'string'},
                                                      'hardware': {'type': 'string'},
                                                      'has-vote': {'type': 'boolean'},
                                                      'id': {'type': 'string'},
                                                      'instance-id': {'type': 'string'},
                                                      'instance-status': {'$ref': '#/definitions/DetailedStatus'},
                                                      'ip-addresses': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                      'jobs': {'items': {'type': 'string'},
                                                               'type': 'array'},
                                                      'network-interfaces': {'patternProperties': {'.*': {'$ref': '#/definitions/NetworkInterface'}},
                                                                             'type': 'object'},
                                                      'series': {'type': 'string'},
                                                      'wants-vote': {'type': 'boolean'}},
                                       'required': ['agent-status',
                                                    'instance-status',
                                                    'dns-name',
                                                    'instance-id',
                                                    'series',
                                                    'id',
                                                    'containers',
                                                    'constraints',
                                                    'hardware',
                                                    'jobs',
                                                    'has-vote',
                                                    'wants-vote'],
                                       'type': 'object'},
                     'MeterStatus': {'additionalProperties': False,
                                     'properties': {'color': {'type': 'string'},
                                                    'message': {'type': 'string'}},
                                     'required': ['color', 'message'],
                                     'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelInfo': {'additionalProperties': False,
                                   'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                  'cloud-credential-tag': {'type': 'string'},
                                                  'cloud-region': {'type': 'string'},
                                                  'cloud-tag': {'type': 'string'},
                                                  'controller-uuid': {'type': 'string'},
                                                  'default-series': {'type': 'string'},
                                                  'life': {'type': 'string'},
                                                  'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                               'type': 'array'},
                                                  'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                  'name': {'type': 'string'},
                                                  'owner-tag': {'type': 'string'},
                                                  'provider-type': {'type': 'string'},
                                                  'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                  'status': {'$ref': '#/definitions/EntityStatus'},
                                                  'users': {'items': {'$ref': '#/definitions/ModelUserInfo'},
                                                            'type': 'array'},
                                                  'uuid': {'type': 'string'}},
                                   'required': ['name',
                                                'uuid',
                                                'controller-uuid',
                                                'cloud-tag',
                                                'owner-tag',
                                                'life',
                                                'users',
                                                'machines',
                                                'sla',
                                                'agent-version'],
                                   'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelMigrationStatus': {'additionalProperties': False,
                                              'properties': {'end': {'format': 'date-time',
                                                                     'type': 'string'},
                                                             'start': {'format': 'date-time',
                                                                       'type': 'string'},
                                                             'status': {'type': 'string'}},
                                              'required': ['status', 'start'],
                                              'type': 'object'},
                     'ModelSLA': {'additionalProperties': False,
                                  'properties': {'ModelSLAInfo': {'$ref': '#/definitions/ModelSLAInfo'},
                                                 'creds': {'items': {'type': 'integer'},
                                                           'type': 'array'}},
                                  'required': ['ModelSLAInfo', 'creds'],
                                  'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelSet': {'additionalProperties': False,
                                  'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                         'type': 'object'}},
                                                            'type': 'object'}},
                                  'required': ['config'],
                                  'type': 'object'},
                     'ModelStatusInfo': {'additionalProperties': False,
                                         'properties': {'available-version': {'type': 'string'},
                                                        'cloud-tag': {'type': 'string'},
                                                        'meter-status': {'$ref': '#/definitions/MeterStatus'},
                                                        'model-status': {'$ref': '#/definitions/DetailedStatus'},
                                                        'name': {'type': 'string'},
                                                        'region': {'type': 'string'},
                                                        'sla': {'type': 'string'},
                                                        'version': {'type': 'string'}},
                                         'required': ['name',
                                                      'cloud-tag',
                                                      'version',
                                                      'available-version',
                                                      'model-status',
                                                      'meter-status',
                                                      'sla'],
                                         'type': 'object'},
                     'ModelUnset': {'additionalProperties': False,
                                    'properties': {'keys': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['keys'],
                                    'type': 'object'},
                     'ModelUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'last-connection': {'format': 'date-time',
                                                                          'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'last-connection',
                                                    'access'],
                                       'type': 'object'},
                     'ModelUserInfoResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/ModelUserInfo'}},
                                             'type': 'object'},
                     'ModelUserInfoResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ModelUserInfoResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'NetworkInterface': {'additionalProperties': False,
                                          'properties': {'dns-nameservers': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                         'gateway': {'type': 'string'},
                                                         'ip-addresses': {'items': {'type': 'string'},
                                                                          'type': 'array'},
                                                         'is-up': {'type': 'boolean'},
                                                         'mac-address': {'type': 'string'},
                                                         'space': {'type': 'string'}},
                                          'required': ['ip-addresses',
                                                       'mac-address',
                                                       'is-up'],
                                          'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'PrivateAddress': {'additionalProperties': False,
                                        'properties': {'target': {'type': 'string'}},
                                        'required': ['target'],
                                        'type': 'object'},
                     'PrivateAddressResults': {'additionalProperties': False,
                                               'properties': {'private-address': {'type': 'string'}},
                                               'required': ['private-address'],
                                               'type': 'object'},
                     'ProvisioningScriptParams': {'additionalProperties': False,
                                                  'properties': {'data-dir': {'type': 'string'},
                                                                 'disable-package-commands': {'type': 'boolean'},
                                                                 'machine-id': {'type': 'string'},
                                                                 'nonce': {'type': 'string'}},
                                                  'required': ['machine-id',
                                                               'nonce',
                                                               'data-dir',
                                                               'disable-package-commands'],
                                                  'type': 'object'},
                     'ProvisioningScriptResult': {'additionalProperties': False,
                                                  'properties': {'script': {'type': 'string'}},
                                                  'required': ['script'],
                                                  'type': 'object'},
                     'PublicAddress': {'additionalProperties': False,
                                       'properties': {'target': {'type': 'string'}},
                                       'required': ['target'],
                                       'type': 'object'},
                     'PublicAddressResults': {'additionalProperties': False,
                                              'properties': {'public-address': {'type': 'string'}},
                                              'required': ['public-address'],
                                              'type': 'object'},
                     'RelationStatus': {'additionalProperties': False,
                                        'properties': {'endpoints': {'items': {'$ref': '#/definitions/EndpointStatus'},
                                                                     'type': 'array'},
                                                       'id': {'type': 'integer'},
                                                       'interface': {'type': 'string'},
                                                       'key': {'type': 'string'},
                                                       'scope': {'type': 'string'}},
                                        'required': ['id',
                                                     'key',
                                                     'interface',
                                                     'scope',
                                                     'endpoints'],
                                        'type': 'object'},
                     'RemoteApplicationStatus': {'additionalProperties': False,
                                                 'properties': {'application-name': {'type': 'string'},
                                                                'application-url': {'type': 'string'},
                                                                'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                              'type': 'array'},
                                                                'err': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                                'life': {'type': 'string'},
                                                                'relations': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                           'type': 'array'}},
                                                                              'type': 'object'},
                                                                'status': {'$ref': '#/definitions/DetailedStatus'}},
                                                 'required': ['application-url',
                                                              'application-name',
                                                              'endpoints',
                                                              'life',
                                                              'relations',
                                                              'status'],
                                                 'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'},
                                                       'scope': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit',
                                                     'scope'],
                                        'type': 'object'},
                     'ResolveCharmResult': {'additionalProperties': False,
                                            'properties': {'error': {'type': 'string'},
                                                           'url': {'type': 'string'}},
                                            'type': 'object'},
                     'ResolveCharmResults': {'additionalProperties': False,
                                             'properties': {'urls': {'items': {'$ref': '#/definitions/ResolveCharmResult'},
                                                                     'type': 'array'}},
                                             'required': ['urls'],
                                             'type': 'object'},
                     'ResolveCharms': {'additionalProperties': False,
                                       'properties': {'references': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                       'required': ['references'],
                                       'type': 'object'},
                     'Resolved': {'additionalProperties': False,
                                  'properties': {'retry': {'type': 'boolean'},
                                                 'unit-name': {'type': 'string'}},
                                  'required': ['unit-name', 'retry'],
                                  'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'SetModelAgentVersion': {'additionalProperties': False,
                                              'properties': {'version': {'$ref': '#/definitions/Number'}},
                                              'required': ['version'],
                                              'type': 'object'},
                     'StatusHistoryFilter': {'additionalProperties': False,
                                             'properties': {'date': {'format': 'date-time',
                                                                     'type': 'string'},
                                                            'delta': {'type': 'integer'},
                                                            'exclude': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                            'size': {'type': 'integer'}},
                                             'required': ['size',
                                                          'date',
                                                          'delta',
                                                          'exclude'],
                                             'type': 'object'},
                     'StatusHistoryRequest': {'additionalProperties': False,
                                              'properties': {'filter': {'$ref': '#/definitions/StatusHistoryFilter'},
                                                             'historyKind': {'type': 'string'},
                                                             'size': {'type': 'integer'},
                                                             'tag': {'type': 'string'}},
                                              'required': ['historyKind',
                                                           'size',
                                                           'filter',
                                                           'tag'],
                                              'type': 'object'},
                     'StatusHistoryRequests': {'additionalProperties': False,
                                               'properties': {'requests': {'items': {'$ref': '#/definitions/StatusHistoryRequest'},
                                                                           'type': 'array'}},
                                               'required': ['requests'],
                                               'type': 'object'},
                     'StatusHistoryResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'history': {'$ref': '#/definitions/History'}},
                                             'required': ['history'],
                                             'type': 'object'},
                     'StatusHistoryResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/StatusHistoryResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'StatusParams': {'additionalProperties': False,
                                      'properties': {'patterns': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['patterns'],
                                      'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Tools': {'additionalProperties': False,
                               'properties': {'sha256': {'type': 'string'},
                                              'size': {'type': 'integer'},
                                              'url': {'type': 'string'},
                                              'version': {'$ref': '#/definitions/Binary'}},
                               'required': ['version', 'url', 'size'],
                               'type': 'object'},
                     'UnitStatus': {'additionalProperties': False,
                                    'properties': {'agent-status': {'$ref': '#/definitions/DetailedStatus'},
                                                   'charm': {'type': 'string'},
                                                   'leader': {'type': 'boolean'},
                                                   'machine': {'type': 'string'},
                                                   'opened-ports': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                   'public-address': {'type': 'string'},
                                                   'subordinates': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitStatus'}},
                                                                    'type': 'object'},
                                                   'workload-status': {'$ref': '#/definitions/DetailedStatus'},
                                                   'workload-version': {'type': 'string'}},
                                    'required': ['agent-status',
                                                 'workload-status',
                                                 'workload-version',
                                                 'machine',
                                                 'opened-ports',
                                                 'public-address',
                                                 'charm',
                                                 'subordinates'],
                                    'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'AbortCurrentUpgrade': {'type': 'object'},
                    'AddCharm': {'properties': {'Params': {'$ref': '#/definitions/AddCharm'}},
                                 'type': 'object'},
                    'AddCharmWithAuthorization': {'properties': {'Params': {'$ref': '#/definitions/AddCharmWithAuthorization'}},
                                                  'type': 'object'},
                    'AddMachines': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                   'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                    'type': 'object'},
                    'AddMachinesV2': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                     'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                      'type': 'object'},
                    'AgentVersion': {'properties': {'Result': {'$ref': '#/definitions/AgentVersionResult'}},
                                     'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'DestroyMachines': {'properties': {'Params': {'$ref': '#/definitions/DestroyMachines'}},
                                        'type': 'object'},
                    'FindTools': {'properties': {'Params': {'$ref': '#/definitions/FindToolsParams'},
                                                 'Result': {'$ref': '#/definitions/FindToolsResult'}},
                                  'type': 'object'},
                    'FullStatus': {'properties': {'Params': {'$ref': '#/definitions/StatusParams'},
                                                  'Result': {'$ref': '#/definitions/FullStatus'}},
                                   'type': 'object'},
                    'GetBundleChanges': {'properties': {'Params': {'$ref': '#/definitions/BundleChangesParams'},
                                                        'Result': {'$ref': '#/definitions/BundleChangesResults'}},
                                         'type': 'object'},
                    'GetModelConstraints': {'properties': {'Result': {'$ref': '#/definitions/GetConstraintsResults'}},
                                            'type': 'object'},
                    'InjectMachines': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                      'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                       'type': 'object'},
                    'ModelGet': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                 'type': 'object'},
                    'ModelInfo': {'properties': {'Result': {'$ref': '#/definitions/ModelInfo'}},
                                  'type': 'object'},
                    'ModelSet': {'properties': {'Params': {'$ref': '#/definitions/ModelSet'}},
                                 'type': 'object'},
                    'ModelUnset': {'properties': {'Params': {'$ref': '#/definitions/ModelUnset'}},
                                   'type': 'object'},
                    'ModelUserInfo': {'properties': {'Result': {'$ref': '#/definitions/ModelUserInfoResults'}},
                                      'type': 'object'},
                    'PrivateAddress': {'properties': {'Params': {'$ref': '#/definitions/PrivateAddress'},
                                                      'Result': {'$ref': '#/definitions/PrivateAddressResults'}},
                                       'type': 'object'},
                    'ProvisioningScript': {'properties': {'Params': {'$ref': '#/definitions/ProvisioningScriptParams'},
                                                          'Result': {'$ref': '#/definitions/ProvisioningScriptResult'}},
                                           'type': 'object'},
                    'PublicAddress': {'properties': {'Params': {'$ref': '#/definitions/PublicAddress'},
                                                     'Result': {'$ref': '#/definitions/PublicAddressResults'}},
                                      'type': 'object'},
                    'ResolveCharms': {'properties': {'Params': {'$ref': '#/definitions/ResolveCharms'},
                                                     'Result': {'$ref': '#/definitions/ResolveCharmResults'}},
                                      'type': 'object'},
                    'Resolved': {'properties': {'Params': {'$ref': '#/definitions/Resolved'}},
                                 'type': 'object'},
                    'RetryProvisioning': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SLALevel': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                 'type': 'object'},
                    'SetModelAgentVersion': {'properties': {'Params': {'$ref': '#/definitions/SetModelAgentVersion'}},
                                             'type': 'object'},
                    'SetModelConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                            'type': 'object'},
                    'SetSLALevel': {'properties': {'Params': {'$ref': '#/definitions/ModelSLA'}},
                                    'type': 'object'},
                    'StatusHistory': {'properties': {'Params': {'$ref': '#/definitions/StatusHistoryRequests'},
                                                     'Result': {'$ref': '#/definitions/StatusHistoryResults'}},
                                      'type': 'object'},
                    'WatchAll': {'properties': {'Result': {'$ref': '#/definitions/AllWatcherId'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> typing.Sequence<+T_co>[~HostPort]<~HostPort>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='APIHostPorts', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AbortCurrentUpgrade(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='AbortCurrentUpgrade', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AddCharm(self, channel, url):
        '''
        channel : str
        url : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='AddCharm', version=1, params=_params)
        _params['channel'] = channel
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AddCharmWithAuthorization(self, channel, macaroon, url):
        '''
        channel : str
        macaroon : Macaroon
        url : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='AddCharmWithAuthorization', version=1, params=_params)
        _params['channel'] = channel
        _params['macaroon'] = macaroon
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def AddMachines(self, params):
        '''
        params : typing.Sequence<+T_co>[~AddMachineParams]<~AddMachineParams>
        Returns -> typing.Sequence<+T_co>[~AddMachinesResult]<~AddMachinesResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='AddMachines', version=1, params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def AddMachinesV2(self, params):
        '''
        params : typing.Sequence<+T_co>[~AddMachineParams]<~AddMachineParams>
        Returns -> typing.Sequence<+T_co>[~AddMachinesResult]<~AddMachinesResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='AddMachinesV2', version=1, params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AgentVersionResult)
    async def AgentVersion(self):
        '''

        Returns -> Number
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='AgentVersion', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> typing.Sequence<+T_co>[int]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='CACert', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyMachines(self, force, machine_names):
        '''
        force : bool
        machine_names : typing.Sequence<+T_co>[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='DestroyMachines', version=1, params=_params)
        _params['force'] = force
        _params['machine-names'] = machine_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindToolsResult)
    async def FindTools(self, arch, major, minor, number, series):
        '''
        arch : str
        major : int
        minor : int
        number : Number
        series : str
        Returns -> typing.Union[_ForwardRef('Error'), typing.Sequence<+T_co>[~Tools]<~Tools>]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='FindTools', version=1, params=_params)
        _params['arch'] = arch
        _params['major'] = major
        _params['minor'] = minor
        _params['number'] = number
        _params['series'] = series
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FullStatus)
    async def FullStatus(self, patterns):
        '''
        patterns : typing.Sequence<+T_co>[str]
        Returns -> typing.Union[_ForwardRef('ModelStatusInfo'), typing.Sequence<+T_co>[~RelationStatus]<~RelationStatus>, typing.Mapping<~KT, +VT_co>[str, ~RemoteApplicationStatus]<~RemoteApplicationStatus>]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='FullStatus', version=1, params=_params)
        _params['patterns'] = patterns
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BundleChangesResults)
    async def GetBundleChanges(self, yaml):
        '''
        yaml : str
        Returns -> typing.Sequence<+T_co>[~BundleChange]<~BundleChange>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='GetBundleChanges', version=1, params=_params)
        _params['yaml'] = yaml
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetConstraintsResults)
    async def GetModelConstraints(self):
        '''

        Returns -> Value
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='GetModelConstraints', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def InjectMachines(self, params):
        '''
        params : typing.Sequence<+T_co>[~AddMachineParams]<~AddMachineParams>
        Returns -> typing.Sequence<+T_co>[~AddMachinesResult]<~AddMachinesResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='InjectMachines', version=1, params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResults)
    async def ModelGet(self):
        '''

        Returns -> typing.Mapping<~KT, +VT_co>[str, ~ConfigValue]<~ConfigValue>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='ModelGet', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfo)
    async def ModelInfo(self):
        '''

        Returns -> typing.Union[_ForwardRef('Number'), _ForwardRef('ModelMigrationStatus'), _ForwardRef('ModelSLAInfo'), _ForwardRef('EntityStatus'), typing.Sequence<+T_co>[~ModelUserInfo]<~ModelUserInfo>]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='ModelInfo', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelSet(self, config):
        '''
        config : typing.Mapping<~KT, +VT_co>[str, typing.Any]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='ModelSet', version=1, params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelUnset(self, keys):
        '''
        keys : typing.Sequence<+T_co>[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='ModelUnset', version=1, params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelUserInfoResults)
    async def ModelUserInfo(self):
        '''

        Returns -> typing.Sequence<+T_co>[~ModelUserInfoResult]<~ModelUserInfoResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='ModelUserInfo', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PrivateAddressResults)
    async def PrivateAddress(self, target):
        '''
        target : str
        Returns -> str
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='PrivateAddress', version=1, params=_params)
        _params['target'] = target
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProvisioningScriptResult)
    async def ProvisioningScript(self, data_dir, disable_package_commands, machine_id, nonce):
        '''
        data_dir : str
        disable_package_commands : bool
        machine_id : str
        nonce : str
        Returns -> str
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='ProvisioningScript', version=1, params=_params)
        _params['data-dir'] = data_dir
        _params['disable-package-commands'] = disable_package_commands
        _params['machine-id'] = machine_id
        _params['nonce'] = nonce
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PublicAddressResults)
    async def PublicAddress(self, target):
        '''
        target : str
        Returns -> str
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='PublicAddress', version=1, params=_params)
        _params['target'] = target
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ResolveCharmResults)
    async def ResolveCharms(self, references):
        '''
        references : typing.Sequence<+T_co>[str]
        Returns -> typing.Sequence<+T_co>[~ResolveCharmResult]<~ResolveCharmResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='ResolveCharms', version=1, params=_params)
        _params['references'] = references
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Resolved(self, retry, unit_name):
        '''
        retry : bool
        unit_name : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='Resolved', version=1, params=_params)
        _params['retry'] = retry
        _params['unit-name'] = unit_name
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RetryProvisioning(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='RetryProvisioning', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def SLALevel(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='SLALevel', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetModelAgentVersion(self, version):
        '''
        version : Number
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='SetModelAgentVersion', version=1, params=_params)
        _params['version'] = version
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetModelConstraints(self, application, constraints):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='SetModelConstraints', version=1, params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetSLALevel(self, creds, level):
        '''
        creds : typing.Sequence<+T_co>[int]
        level : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='SetSLALevel', version=1, params=_params)
        _params['creds'] = creds
        _params['level'] = level
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusHistoryResults)
    async def StatusHistory(self, requests):
        '''
        requests : typing.Sequence<+T_co>[~StatusHistoryRequest]<~StatusHistoryRequest>
        Returns -> typing.Sequence<+T_co>[~StatusHistoryResult]<~StatusHistoryResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='StatusHistory', version=1, params=_params)
        _params['requests'] = requests
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AllWatcherId)
    async def WatchAll(self):
        '''

        Returns -> str
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client', request='WatchAll', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class CloudFacade(Type):
    name = 'Cloud'
    version = 1
    schema =     {'definitions': {'Cloud': {'additionalProperties': False,
                               'properties': {'auth-types': {'items': {'type': 'string'},
                                                             'type': 'array'},
                                              'endpoint': {'type': 'string'},
                                              'identity-endpoint': {'type': 'string'},
                                              'regions': {'items': {'$ref': '#/definitions/CloudRegion'},
                                                          'type': 'array'},
                                              'storage-endpoint': {'type': 'string'},
                                              'type': {'type': 'string'}},
                               'required': ['type'],
                               'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudCredentialResult': {'additionalProperties': False,
                                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                                              'result': {'$ref': '#/definitions/CloudCredential'}},
                                               'type': 'object'},
                     'CloudCredentialResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/CloudCredentialResult'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'CloudInstanceTypesConstraint': {'additionalProperties': False,
                                                      'properties': {'cloud-tag': {'type': 'string'},
                                                                     'constraints': {'$ref': '#/definitions/Value'},
                                                                     'region': {'type': 'string'}},
                                                      'required': ['cloud-tag',
                                                                   'region'],
                                                      'type': 'object'},
                     'CloudInstanceTypesConstraints': {'additionalProperties': False,
                                                       'properties': {'constraints': {'items': {'$ref': '#/definitions/CloudInstanceTypesConstraint'},
                                                                                      'type': 'array'}},
                                                       'required': ['constraints'],
                                                       'type': 'object'},
                     'CloudRegion': {'additionalProperties': False,
                                     'properties': {'endpoint': {'type': 'string'},
                                                    'identity-endpoint': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'storage-endpoint': {'type': 'string'}},
                                     'required': ['name'],
                                     'type': 'object'},
                     'CloudResult': {'additionalProperties': False,
                                     'properties': {'cloud': {'$ref': '#/definitions/Cloud'},
                                                    'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'CloudResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/CloudResult'},
                                                                 'type': 'array'}},
                                      'type': 'object'},
                     'CloudsResult': {'additionalProperties': False,
                                      'properties': {'clouds': {'patternProperties': {'.*': {'$ref': '#/definitions/Cloud'}},
                                                                'type': 'object'}},
                                      'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'InstanceType': {'additionalProperties': False,
                                      'properties': {'arches': {'items': {'type': 'string'},
                                                                'type': 'array'},
                                                     'cost': {'type': 'integer'},
                                                     'cpu-cores': {'type': 'integer'},
                                                     'deprecated': {'type': 'boolean'},
                                                     'memory': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'root-disk': {'type': 'integer'},
                                                     'virt-type': {'type': 'string'}},
                                      'required': ['arches', 'cpu-cores', 'memory'],
                                      'type': 'object'},
                     'InstanceTypesResult': {'additionalProperties': False,
                                             'properties': {'cost-currency': {'type': 'string'},
                                                            'cost-divisor': {'type': 'integer'},
                                                            'cost-unit': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'instance-types': {'items': {'$ref': '#/definitions/InstanceType'},
                                                                               'type': 'array'}},
                                             'type': 'object'},
                     'InstanceTypesResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/InstanceTypesResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'UpdateCloudCredential': {'additionalProperties': False,
                                               'properties': {'credential': {'$ref': '#/definitions/CloudCredential'},
                                                              'tag': {'type': 'string'}},
                                               'required': ['tag', 'credential'],
                                               'type': 'object'},
                     'UpdateCloudCredentials': {'additionalProperties': False,
                                                'properties': {'credentials': {'items': {'$ref': '#/definitions/UpdateCloudCredential'},
                                                                               'type': 'array'}},
                                                'type': 'object'},
                     'UserCloud': {'additionalProperties': False,
                                   'properties': {'cloud-tag': {'type': 'string'},
                                                  'user-tag': {'type': 'string'}},
                                   'required': ['user-tag', 'cloud-tag'],
                                   'type': 'object'},
                     'UserClouds': {'additionalProperties': False,
                                    'properties': {'user-clouds': {'items': {'$ref': '#/definitions/UserCloud'},
                                                                   'type': 'array'}},
                                    'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'Cloud': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/CloudResults'}},
                              'type': 'object'},
                    'Clouds': {'properties': {'Result': {'$ref': '#/definitions/CloudsResult'}},
                               'type': 'object'},
                    'Credential': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/CloudCredentialResults'}},
                                   'type': 'object'},
                    'DefaultCloud': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'InstanceTypes': {'properties': {'Params': {'$ref': '#/definitions/CloudInstanceTypesConstraints'},
                                                     'Result': {'$ref': '#/definitions/InstanceTypesResults'}},
                                      'type': 'object'},
                    'RevokeCredentials': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'UpdateCredentials': {'properties': {'Params': {'$ref': '#/definitions/UpdateCloudCredentials'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'UserCredentials': {'properties': {'Params': {'$ref': '#/definitions/UserClouds'},
                                                       'Result': {'$ref': '#/definitions/StringsResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(CloudResults)
    async def Cloud(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~CloudResult]<~CloudResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud', request='Cloud', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudsResult)
    async def Clouds(self):
        '''

        Returns -> typing.Mapping<~KT, +VT_co>[str, ~Cloud]<~Cloud>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud', request='Clouds', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudCredentialResults)
    async def Credential(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~CloudCredentialResult]<~CloudCredentialResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud', request='Credential', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def DefaultCloud(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud', request='DefaultCloud', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InstanceTypesResults)
    async def InstanceTypes(self, constraints):
        '''
        constraints : typing.Sequence<+T_co>[~CloudInstanceTypesConstraint]<~CloudInstanceTypesConstraint>
        Returns -> typing.Sequence<+T_co>[~InstanceTypesResult]<~InstanceTypesResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud', request='InstanceTypes', version=1, params=_params)
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RevokeCredentials(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud', request='RevokeCredentials', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateCredentials(self, credentials):
        '''
        credentials : typing.Sequence<+T_co>[~UpdateCloudCredential]<~UpdateCloudCredential>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud', request='UpdateCredentials', version=1, params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def UserCredentials(self, user_clouds):
        '''
        user_clouds : typing.Sequence<+T_co>[~UserCloud]<~UserCloud>
        Returns -> typing.Sequence<+T_co>[~StringsResult]<~StringsResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud', request='UserCredentials', version=1, params=_params)
        _params['user-clouds'] = user_clouds
        reply = await self.rpc(msg)
        return reply



class DeployerFacade(Type):
    name = 'Deployer'
    version = 1
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'DeployerConnectionValues': {'additionalProperties': False,
                                                  'properties': {'api-addresses': {'items': {'type': 'string'},
                                                                                   'type': 'array'},
                                                                 'state-addresses': {'items': {'type': 'string'},
                                                                                     'type': 'array'}},
                                                  'required': ['state-addresses',
                                                               'api-addresses'],
                                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'}},
                                  'required': ['Address', 'port'],
                                  'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'ConnectionInfo': {'properties': {'Result': {'$ref': '#/definitions/DeployerConnectionValues'}},
                                       'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'SetPasswords': {'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'StateAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                       'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchUnits': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), typing.Sequence<+T_co>[str]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='APIAddresses', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> typing.Sequence<+T_co>[~HostPort]<~HostPort>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='APIHostPorts', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> typing.Sequence<+T_co>[int]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='CACert', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DeployerConnectionValues)
    async def ConnectionInfo(self):
        '''

        Returns -> typing.Sequence<+T_co>[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='ConnectionInfo', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~LifeResult]<~LifeResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='Life', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='ModelUUID', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='Remove', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes):
        '''
        changes : typing.Sequence<+T_co>[~EntityPassword]<~EntityPassword>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='SetPasswords', version=1, params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~EntityStatusArgs]<~EntityStatusArgs>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='SetStatus', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResult)
    async def StateAddresses(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), typing.Sequence<+T_co>[str]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='StateAddresses', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~EntityStatusArgs]<~EntityStatusArgs>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='UpdateStatus', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='WatchAPIHostPorts', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchUnits(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~StringsWatchResult]<~StringsWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer', request='WatchUnits', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class HostKeyReporterFacade(Type):
    name = 'HostKeyReporter'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SSHHostKeySet': {'additionalProperties': False,
                                       'properties': {'entity-keys': {'items': {'$ref': '#/definitions/SSHHostKeys'},
                                                                      'type': 'array'}},
                                       'required': ['entity-keys'],
                                       'type': 'object'},
                     'SSHHostKeys': {'additionalProperties': False,
                                     'properties': {'public-keys': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                    'tag': {'type': 'string'}},
                                     'required': ['tag', 'public-keys'],
                                     'type': 'object'}},
     'properties': {'ReportKeys': {'properties': {'Params': {'$ref': '#/definitions/SSHHostKeySet'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ReportKeys(self, entity_keys):
        '''
        entity_keys : typing.Sequence<+T_co>[~SSHHostKeys]<~SSHHostKeys>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='HostKeyReporter', request='ReportKeys', version=1, params=_params)
        _params['entity-keys'] = entity_keys
        reply = await self.rpc(msg)
        return reply



class KeyManagerFacade(Type):
    name = 'KeyManager'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSSHKeys': {'additionalProperties': False,
                                     'properties': {'entities': {'$ref': '#/definitions/Entities'},
                                                    'mode': {'type': 'boolean'}},
                                     'required': ['entities', 'mode'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModifyUserSSHKeys': {'additionalProperties': False,
                                           'properties': {'ssh-keys': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                          'user': {'type': 'string'}},
                                           'required': ['user', 'ssh-keys'],
                                           'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'}},
     'properties': {'AddKeys': {'properties': {'Params': {'$ref': '#/definitions/ModifyUserSSHKeys'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'DeleteKeys': {'properties': {'Params': {'$ref': '#/definitions/ModifyUserSSHKeys'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'ImportKeys': {'properties': {'Params': {'$ref': '#/definitions/ModifyUserSSHKeys'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'ListKeys': {'properties': {'Params': {'$ref': '#/definitions/ListSSHKeys'},
                                                'Result': {'$ref': '#/definitions/StringsResults'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddKeys(self, ssh_keys, user):
        '''
        ssh_keys : typing.Sequence<+T_co>[str]
        user : str
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyManager', request='AddKeys', version=1, params=_params)
        _params['ssh-keys'] = ssh_keys
        _params['user'] = user
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DeleteKeys(self, ssh_keys, user):
        '''
        ssh_keys : typing.Sequence<+T_co>[str]
        user : str
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyManager', request='DeleteKeys', version=1, params=_params)
        _params['ssh-keys'] = ssh_keys
        _params['user'] = user
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ImportKeys(self, ssh_keys, user):
        '''
        ssh_keys : typing.Sequence<+T_co>[str]
        user : str
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyManager', request='ImportKeys', version=1, params=_params)
        _params['ssh-keys'] = ssh_keys
        _params['user'] = user
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def ListKeys(self, entities, mode):
        '''
        entities : Entities
        mode : bool
        Returns -> typing.Sequence<+T_co>[~StringsResult]<~StringsResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyManager', request='ListKeys', version=1, params=_params)
        _params['entities'] = entities
        _params['mode'] = mode
        reply = await self.rpc(msg)
        return reply



class KeyUpdaterFacade(Type):
    name = 'KeyUpdater'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'}},
     'properties': {'AuthorisedKeys': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StringsResults'}},
                                       'type': 'object'},
                    'WatchAuthorisedKeys': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResults)
    async def AuthorisedKeys(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~StringsResult]<~StringsResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyUpdater', request='AuthorisedKeys', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchAuthorisedKeys(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyUpdater', request='WatchAuthorisedKeys', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class LifeFlagFacade(Type):
    name = 'LifeFlag'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'Watch': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(LifeResults)
    async def Life(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~LifeResult]<~LifeResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LifeFlag', request='Life', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LifeFlag', request='Watch', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class LogForwardingFacade(Type):
    name = 'LogForwarding'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'LogForwardingGetLastSentParams': {'additionalProperties': False,
                                                        'properties': {'ids': {'items': {'$ref': '#/definitions/LogForwardingID'},
                                                                               'type': 'array'}},
                                                        'required': ['ids'],
                                                        'type': 'object'},
                     'LogForwardingGetLastSentResult': {'additionalProperties': False,
                                                        'properties': {'err': {'$ref': '#/definitions/Error'},
                                                                       'record-id': {'type': 'integer'},
                                                                       'record-timestamp': {'type': 'integer'}},
                                                        'required': ['record-id',
                                                                     'record-timestamp',
                                                                     'err'],
                                                        'type': 'object'},
                     'LogForwardingGetLastSentResults': {'additionalProperties': False,
                                                         'properties': {'results': {'items': {'$ref': '#/definitions/LogForwardingGetLastSentResult'},
                                                                                    'type': 'array'}},
                                                         'required': ['results'],
                                                         'type': 'object'},
                     'LogForwardingID': {'additionalProperties': False,
                                         'properties': {'model': {'type': 'string'},
                                                        'sink': {'type': 'string'}},
                                         'required': ['model', 'sink'],
                                         'type': 'object'},
                     'LogForwardingSetLastSentParam': {'additionalProperties': False,
                                                       'properties': {'LogForwardingID': {'$ref': '#/definitions/LogForwardingID'},
                                                                      'record-id': {'type': 'integer'},
                                                                      'record-timestamp': {'type': 'integer'}},
                                                       'required': ['LogForwardingID',
                                                                    'record-id',
                                                                    'record-timestamp'],
                                                       'type': 'object'},
                     'LogForwardingSetLastSentParams': {'additionalProperties': False,
                                                        'properties': {'params': {'items': {'$ref': '#/definitions/LogForwardingSetLastSentParam'},
                                                                                  'type': 'array'}},
                                                        'required': ['params'],
                                                        'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'GetLastSent': {'properties': {'Params': {'$ref': '#/definitions/LogForwardingGetLastSentParams'},
                                                   'Result': {'$ref': '#/definitions/LogForwardingGetLastSentResults'}},
                                    'type': 'object'},
                    'SetLastSent': {'properties': {'Params': {'$ref': '#/definitions/LogForwardingSetLastSentParams'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(LogForwardingGetLastSentResults)
    async def GetLastSent(self, ids):
        '''
        ids : typing.Sequence<+T_co>[~LogForwardingID]<~LogForwardingID>
        Returns -> typing.Sequence<+T_co>[~LogForwardingGetLastSentResult]<~LogForwardingGetLastSentResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LogForwarding', request='GetLastSent', version=1, params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetLastSent(self, params):
        '''
        params : typing.Sequence<+T_co>[~LogForwardingSetLastSentParam]<~LogForwardingSetLastSentParam>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LogForwarding', request='SetLastSent', version=1, params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



class LoggerFacade(Type):
    name = 'Logger'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'}},
     'properties': {'LoggingConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/StringResults'}},
                                      'type': 'object'},
                    'WatchLoggingConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringResults)
    async def LoggingConfig(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~StringResult]<~StringResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Logger', request='LoggingConfig', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchLoggingConfig(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Logger', request='WatchLoggingConfig', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MachineActionsFacade(Type):
    name = 'MachineActions'
    version = 1
    schema =     {'definitions': {'Action': {'additionalProperties': False,
                                'properties': {'name': {'type': 'string'},
                                               'parameters': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                               'receiver': {'type': 'string'},
                                               'tag': {'type': 'string'}},
                                'required': ['tag', 'receiver', 'name'],
                                'type': 'object'},
                     'ActionExecutionResult': {'additionalProperties': False,
                                               'properties': {'action-tag': {'type': 'string'},
                                                              'message': {'type': 'string'},
                                                              'results': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'},
                                                              'status': {'type': 'string'}},
                                               'required': ['action-tag', 'status'],
                                               'type': 'object'},
                     'ActionExecutionResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/ActionExecutionResult'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'ActionResult': {'additionalProperties': False,
                                      'properties': {'action': {'$ref': '#/definitions/Action'},
                                                     'completed': {'format': 'date-time',
                                                                   'type': 'string'},
                                                     'enqueued': {'format': 'date-time',
                                                                  'type': 'string'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'message': {'type': 'string'},
                                                     'output': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'started': {'format': 'date-time',
                                                                 'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'type': 'object'},
                     'ActionResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ActionsByReceiver': {'additionalProperties': False,
                                           'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                      'type': 'array'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'receiver': {'type': 'string'}},
                                           'type': 'object'},
                     'ActionsByReceivers': {'additionalProperties': False,
                                            'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByReceiver'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'}},
     'properties': {'Actions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'BeginActions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'FinishActions': {'properties': {'Params': {'$ref': '#/definitions/ActionExecutionResults'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'RunningActions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                       'type': 'object'},
                    'WatchActionNotifications': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ActionResults)
    async def Actions(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ActionResult]<~ActionResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineActions', request='Actions', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def BeginActions(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineActions', request='BeginActions', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def FinishActions(self, results):
        '''
        results : typing.Sequence<+T_co>[~ActionExecutionResult]<~ActionExecutionResult>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineActions', request='FinishActions', version=1, params=_params)
        _params['results'] = results
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def RunningActions(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ActionsByReceiver]<~ActionsByReceiver>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineActions', request='RunningActions', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchActionNotifications(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~StringsWatchResult]<~StringsWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineActions', request='WatchActionNotifications', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MachineUndertakerFacade(Type):
    name = 'MachineUndertaker'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'EntitiesResult': {'additionalProperties': False,
                                        'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                    'type': 'array'},
                                                       'error': {'$ref': '#/definitions/Error'}},
                                        'required': ['entities'],
                                        'type': 'object'},
                     'EntitiesResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/EntitiesResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ProviderInterfaceInfo': {'additionalProperties': False,
                                               'properties': {'interface-name': {'type': 'string'},
                                                              'mac-address': {'type': 'string'},
                                                              'provider-id': {'type': 'string'}},
                                               'required': ['interface-name',
                                                            'mac-address',
                                                            'provider-id'],
                                               'type': 'object'},
                     'ProviderInterfaceInfoResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'interfaces': {'items': {'$ref': '#/definitions/ProviderInterfaceInfo'},
                                                                                   'type': 'array'},
                                                                    'machine-tag': {'type': 'string'}},
                                                     'required': ['machine-tag',
                                                                  'interfaces'],
                                                     'type': 'object'},
                     'ProviderInterfaceInfoResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/ProviderInterfaceInfoResult'},
                                                                                 'type': 'array'}},
                                                      'required': ['results'],
                                                      'type': 'object'}},
     'properties': {'AllMachineRemovals': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/EntitiesResults'}},
                                           'type': 'object'},
                    'CompleteMachineRemovals': {'properties': {'Params': {'$ref': '#/definitions/Entities'}},
                                                'type': 'object'},
                    'GetMachineProviderInterfaceInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                       'Result': {'$ref': '#/definitions/ProviderInterfaceInfoResults'}},
                                                        'type': 'object'},
                    'WatchMachineRemovals': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                            'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(EntitiesResults)
    async def AllMachineRemovals(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~EntitiesResult]<~EntitiesResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineUndertaker', request='AllMachineRemovals', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def CompleteMachineRemovals(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineUndertaker', request='CompleteMachineRemovals', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProviderInterfaceInfoResults)
    async def GetMachineProviderInterfaceInfo(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ProviderInterfaceInfoResult]<~ProviderInterfaceInfoResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineUndertaker', request='GetMachineProviderInterfaceInfo', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMachineRemovals(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineUndertaker', request='WatchMachineRemovals', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MachinerFacade(Type):
    name = 'Machiner'
    version = 1
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'}},
                                  'required': ['Address', 'port'],
                                  'type': 'object'},
                     'JobsResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'jobs': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['jobs'],
                                    'type': 'object'},
                     'JobsResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/JobsResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineAddresses': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'addresses'],
                                          'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SetMachineNetworkConfig': {'additionalProperties': False,
                                                 'properties': {'config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                           'type': 'array'},
                                                                'tag': {'type': 'string'}},
                                                 'required': ['tag', 'config'],
                                                 'type': 'object'},
                     'SetMachinesAddresses': {'additionalProperties': False,
                                              'properties': {'machine-addresses': {'items': {'$ref': '#/definitions/MachineAddresses'},
                                                                                   'type': 'array'}},
                                              'required': ['machine-addresses'],
                                              'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'Jobs': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/JobsResults'}},
                             'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'SetMachineAddresses': {'properties': {'Params': {'$ref': '#/definitions/SetMachinesAddresses'},
                                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                                            'type': 'object'},
                    'SetObservedNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                 'type': 'object'},
                    'SetProviderNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                 'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'Watch': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), typing.Sequence<+T_co>[str]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='APIAddresses', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> typing.Sequence<+T_co>[~HostPort]<~HostPort>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='APIHostPorts', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> typing.Sequence<+T_co>[int]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='CACert', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='EnsureDead', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(JobsResults)
    async def Jobs(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~JobsResult]<~JobsResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='Jobs', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~LifeResult]<~LifeResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='Life', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='ModelUUID', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMachineAddresses(self, machine_addresses):
        '''
        machine_addresses : typing.Sequence<+T_co>[~MachineAddresses]<~MachineAddresses>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='SetMachineAddresses', version=1, params=_params)
        _params['machine-addresses'] = machine_addresses
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetObservedNetworkConfig(self, config, tag):
        '''
        config : typing.Sequence<+T_co>[~NetworkConfig]<~NetworkConfig>
        tag : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='SetObservedNetworkConfig', version=1, params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetProviderNetworkConfig(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='SetProviderNetworkConfig', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~EntityStatusArgs]<~EntityStatusArgs>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='SetStatus', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~EntityStatusArgs]<~EntityStatusArgs>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='UpdateStatus', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='Watch', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner', request='WatchAPIHostPorts', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class MeterStatusFacade(Type):
    name = 'MeterStatus'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MeterStatusResult': {'additionalProperties': False,
                                           'properties': {'code': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'type': 'string'}},
                                           'required': ['code', 'info'],
                                           'type': 'object'},
                     'MeterStatusResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/MeterStatusResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'GetMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/MeterStatusResults'}},
                                       'type': 'object'},
                    'WatchMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MeterStatusResults)
    async def GetMeterStatus(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~MeterStatusResult]<~MeterStatusResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MeterStatus', request='GetMeterStatus', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMeterStatus(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MeterStatus', request='WatchMeterStatus', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MetricsManagerFacade(Type):
    name = 'MetricsManager'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'AddJujuMachineMetrics': {'type': 'object'},
                    'CleanupOldMetrics': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SendMetrics': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def AddJujuMachineMetrics(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsManager', request='AddJujuMachineMetrics', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def CleanupOldMetrics(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsManager', request='CleanupOldMetrics', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SendMetrics(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsManager', request='SendMetrics', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MigrationFlagFacade(Type):
    name = 'MigrationFlag'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'PhaseResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'phase': {'type': 'string'}},
                                     'type': 'object'},
                     'PhaseResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/PhaseResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'}},
     'properties': {'Phase': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/PhaseResults'}},
                              'type': 'object'},
                    'Watch': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(PhaseResults)
    async def Phase(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~PhaseResult]<~PhaseResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationFlag', request='Phase', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationFlag', request='Watch', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MigrationMasterFacade(Type):
    name = 'MigrationMaster'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MasterMigrationStatus': {'additionalProperties': False,
                                               'properties': {'migration-id': {'type': 'string'},
                                                              'phase': {'type': 'string'},
                                                              'phase-changed-time': {'format': 'date-time',
                                                                                     'type': 'string'},
                                                              'spec': {'$ref': '#/definitions/MigrationSpec'}},
                                               'required': ['spec',
                                                            'migration-id',
                                                            'phase',
                                                            'phase-changed-time'],
                                               'type': 'object'},
                     'MigrationModelInfo': {'additionalProperties': False,
                                            'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                           'controller-agent-version': {'$ref': '#/definitions/Number'},
                                                           'name': {'type': 'string'},
                                                           'owner-tag': {'type': 'string'},
                                                           'uuid': {'type': 'string'}},
                                            'required': ['uuid',
                                                         'name',
                                                         'owner-tag',
                                                         'agent-version',
                                                         'controller-agent-version'],
                                            'type': 'object'},
                     'MigrationSpec': {'additionalProperties': False,
                                       'properties': {'model-tag': {'type': 'string'},
                                                      'target-info': {'$ref': '#/definitions/MigrationTargetInfo'}},
                                       'required': ['model-tag', 'target-info'],
                                       'type': 'object'},
                     'MigrationTargetInfo': {'additionalProperties': False,
                                             'properties': {'addrs': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                            'auth-tag': {'type': 'string'},
                                                            'ca-cert': {'type': 'string'},
                                                            'controller-tag': {'type': 'string'},
                                                            'macaroons': {'type': 'string'},
                                                            'password': {'type': 'string'}},
                                             'required': ['controller-tag',
                                                          'addrs',
                                                          'ca-cert',
                                                          'auth-tag'],
                                             'type': 'object'},
                     'MinionReports': {'additionalProperties': False,
                                       'properties': {'failed': {'items': {'type': 'string'},
                                                                 'type': 'array'},
                                                      'migration-id': {'type': 'string'},
                                                      'phase': {'type': 'string'},
                                                      'success-count': {'type': 'integer'},
                                                      'unknown-count': {'type': 'integer'},
                                                      'unknown-sample': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                       'required': ['migration-id',
                                                    'phase',
                                                    'success-count',
                                                    'unknown-count',
                                                    'unknown-sample',
                                                    'failed'],
                                       'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'SerializedModel': {'additionalProperties': False,
                                         'properties': {'bytes': {'items': {'type': 'integer'},
                                                                  'type': 'array'},
                                                        'charms': {'items': {'type': 'string'},
                                                                   'type': 'array'},
                                                        'resources': {'items': {'$ref': '#/definitions/SerializedModelResource'},
                                                                      'type': 'array'},
                                                        'tools': {'items': {'$ref': '#/definitions/SerializedModelTools'},
                                                                  'type': 'array'}},
                                         'required': ['bytes',
                                                      'charms',
                                                      'tools',
                                                      'resources'],
                                         'type': 'object'},
                     'SerializedModelResource': {'additionalProperties': False,
                                                 'properties': {'application': {'type': 'string'},
                                                                'application-revision': {'$ref': '#/definitions/SerializedModelResourceRevision'},
                                                                'charmstore-revision': {'$ref': '#/definitions/SerializedModelResourceRevision'},
                                                                'name': {'type': 'string'},
                                                                'unit-revisions': {'patternProperties': {'.*': {'$ref': '#/definitions/SerializedModelResourceRevision'}},
                                                                                   'type': 'object'}},
                                                 'required': ['application',
                                                              'name',
                                                              'application-revision',
                                                              'charmstore-revision',
                                                              'unit-revisions'],
                                                 'type': 'object'},
                     'SerializedModelResourceRevision': {'additionalProperties': False,
                                                         'properties': {'description': {'type': 'string'},
                                                                        'fingerprint': {'type': 'string'},
                                                                        'origin': {'type': 'string'},
                                                                        'path': {'type': 'string'},
                                                                        'revision': {'type': 'integer'},
                                                                        'size': {'type': 'integer'},
                                                                        'timestamp': {'format': 'date-time',
                                                                                      'type': 'string'},
                                                                        'type': {'type': 'string'},
                                                                        'username': {'type': 'string'}},
                                                         'required': ['revision',
                                                                      'type',
                                                                      'path',
                                                                      'description',
                                                                      'origin',
                                                                      'fingerprint',
                                                                      'size',
                                                                      'timestamp'],
                                                         'type': 'object'},
                     'SerializedModelTools': {'additionalProperties': False,
                                              'properties': {'uri': {'type': 'string'},
                                                             'version': {'type': 'string'}},
                                              'required': ['version', 'uri'],
                                              'type': 'object'},
                     'SetMigrationPhaseArgs': {'additionalProperties': False,
                                               'properties': {'phase': {'type': 'string'}},
                                               'required': ['phase'],
                                               'type': 'object'},
                     'SetMigrationStatusMessageArgs': {'additionalProperties': False,
                                                       'properties': {'message': {'type': 'string'}},
                                                       'required': ['message'],
                                                       'type': 'object'}},
     'properties': {'Export': {'properties': {'Result': {'$ref': '#/definitions/SerializedModel'}},
                               'type': 'object'},
                    'MigrationStatus': {'properties': {'Result': {'$ref': '#/definitions/MasterMigrationStatus'}},
                                        'type': 'object'},
                    'MinionReports': {'properties': {'Result': {'$ref': '#/definitions/MinionReports'}},
                                      'type': 'object'},
                    'ModelInfo': {'properties': {'Result': {'$ref': '#/definitions/MigrationModelInfo'}},
                                  'type': 'object'},
                    'Prechecks': {'type': 'object'},
                    'Reap': {'type': 'object'},
                    'SetPhase': {'properties': {'Params': {'$ref': '#/definitions/SetMigrationPhaseArgs'}},
                                 'type': 'object'},
                    'SetStatusMessage': {'properties': {'Params': {'$ref': '#/definitions/SetMigrationStatusMessageArgs'}},
                                         'type': 'object'},
                    'Watch': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                              'type': 'object'},
                    'WatchMinionReports': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(SerializedModel)
    async def Export(self):
        '''

        Returns -> typing.Sequence<+T_co>[~SerializedModelTools]<~SerializedModelTools>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster', request='Export', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MasterMigrationStatus)
    async def MigrationStatus(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('MigrationSpec')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster', request='MigrationStatus', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MinionReports)
    async def MinionReports(self):
        '''

        Returns -> typing.Union[typing.Sequence<+T_co>[str], int]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster', request='MinionReports', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MigrationModelInfo)
    async def ModelInfo(self):
        '''

        Returns -> typing.Union[_ForwardRef('Number'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster', request='ModelInfo', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Prechecks(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster', request='Prechecks', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Reap(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster', request='Reap', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetPhase(self, phase):
        '''
        phase : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster', request='SetPhase', version=1, params=_params)
        _params['phase'] = phase
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetStatusMessage(self, message):
        '''
        message : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster', request='SetStatusMessage', version=1, params=_params)
        _params['message'] = message
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def Watch(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster', request='Watch', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchMinionReports(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster', request='WatchMinionReports', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class MigrationMinionFacade(Type):
    name = 'MigrationMinion'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MinionReport': {'additionalProperties': False,
                                      'properties': {'migration-id': {'type': 'string'},
                                                     'phase': {'type': 'string'},
                                                     'success': {'type': 'boolean'}},
                                      'required': ['migration-id',
                                                   'phase',
                                                   'success'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'}},
     'properties': {'Report': {'properties': {'Params': {'$ref': '#/definitions/MinionReport'}},
                               'type': 'object'},
                    'Watch': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Report(self, migration_id, phase, success):
        '''
        migration_id : str
        phase : str
        success : bool
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMinion', request='Report', version=1, params=_params)
        _params['migration-id'] = migration_id
        _params['phase'] = phase
        _params['success'] = success
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def Watch(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMinion', request='Watch', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class MigrationStatusWatcherFacade(Type):
    name = 'MigrationStatusWatcher'
    version = 1
    schema =     {'definitions': {'MigrationStatus': {'additionalProperties': False,
                                         'properties': {'attempt': {'type': 'integer'},
                                                        'migration-id': {'type': 'string'},
                                                        'phase': {'type': 'string'},
                                                        'source-api-addrs': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                        'source-ca-cert': {'type': 'string'},
                                                        'target-api-addrs': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                        'target-ca-cert': {'type': 'string'}},
                                         'required': ['migration-id',
                                                      'attempt',
                                                      'phase',
                                                      'source-api-addrs',
                                                      'source-ca-cert',
                                                      'target-api-addrs',
                                                      'target-ca-cert'],
                                         'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/MigrationStatus'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MigrationStatus)
    async def Next(self):
        '''

        Returns -> typing.Union[int, typing.Sequence<+T_co>[str]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationStatusWatcher', request='Next', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationStatusWatcher', request='Stop', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class MigrationTargetFacade(Type):
    name = 'MigrationTarget'
    version = 1
    schema =     {'definitions': {'AdoptResourcesArgs': {'additionalProperties': False,
                                            'properties': {'model-tag': {'type': 'string'},
                                                           'source-controller-version': {'$ref': '#/definitions/Number'}},
                                            'required': ['model-tag',
                                                         'source-controller-version'],
                                            'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'MigrationModelInfo': {'additionalProperties': False,
                                            'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                           'controller-agent-version': {'$ref': '#/definitions/Number'},
                                                           'name': {'type': 'string'},
                                                           'owner-tag': {'type': 'string'},
                                                           'uuid': {'type': 'string'}},
                                            'required': ['uuid',
                                                         'name',
                                                         'owner-tag',
                                                         'agent-version',
                                                         'controller-agent-version'],
                                            'type': 'object'},
                     'ModelArgs': {'additionalProperties': False,
                                   'properties': {'model-tag': {'type': 'string'}},
                                   'required': ['model-tag'],
                                   'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'SerializedModel': {'additionalProperties': False,
                                         'properties': {'bytes': {'items': {'type': 'integer'},
                                                                  'type': 'array'},
                                                        'charms': {'items': {'type': 'string'},
                                                                   'type': 'array'},
                                                        'resources': {'items': {'$ref': '#/definitions/SerializedModelResource'},
                                                                      'type': 'array'},
                                                        'tools': {'items': {'$ref': '#/definitions/SerializedModelTools'},
                                                                  'type': 'array'}},
                                         'required': ['bytes',
                                                      'charms',
                                                      'tools',
                                                      'resources'],
                                         'type': 'object'},
                     'SerializedModelResource': {'additionalProperties': False,
                                                 'properties': {'application': {'type': 'string'},
                                                                'application-revision': {'$ref': '#/definitions/SerializedModelResourceRevision'},
                                                                'charmstore-revision': {'$ref': '#/definitions/SerializedModelResourceRevision'},
                                                                'name': {'type': 'string'},
                                                                'unit-revisions': {'patternProperties': {'.*': {'$ref': '#/definitions/SerializedModelResourceRevision'}},
                                                                                   'type': 'object'}},
                                                 'required': ['application',
                                                              'name',
                                                              'application-revision',
                                                              'charmstore-revision',
                                                              'unit-revisions'],
                                                 'type': 'object'},
                     'SerializedModelResourceRevision': {'additionalProperties': False,
                                                         'properties': {'description': {'type': 'string'},
                                                                        'fingerprint': {'type': 'string'},
                                                                        'origin': {'type': 'string'},
                                                                        'path': {'type': 'string'},
                                                                        'revision': {'type': 'integer'},
                                                                        'size': {'type': 'integer'},
                                                                        'timestamp': {'format': 'date-time',
                                                                                      'type': 'string'},
                                                                        'type': {'type': 'string'},
                                                                        'username': {'type': 'string'}},
                                                         'required': ['revision',
                                                                      'type',
                                                                      'path',
                                                                      'description',
                                                                      'origin',
                                                                      'fingerprint',
                                                                      'size',
                                                                      'timestamp'],
                                                         'type': 'object'},
                     'SerializedModelTools': {'additionalProperties': False,
                                              'properties': {'uri': {'type': 'string'},
                                                             'version': {'type': 'string'}},
                                              'required': ['version', 'uri'],
                                              'type': 'object'}},
     'properties': {'Abort': {'properties': {'Params': {'$ref': '#/definitions/ModelArgs'}},
                              'type': 'object'},
                    'Activate': {'properties': {'Params': {'$ref': '#/definitions/ModelArgs'}},
                                 'type': 'object'},
                    'AdoptResources': {'properties': {'Params': {'$ref': '#/definitions/AdoptResourcesArgs'}},
                                       'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'Import': {'properties': {'Params': {'$ref': '#/definitions/SerializedModel'}},
                               'type': 'object'},
                    'LatestLogTime': {'properties': {'Params': {'$ref': '#/definitions/ModelArgs'},
                                                     'Result': {'format': 'date-time',
                                                                'type': 'string'}},
                                      'type': 'object'},
                    'Prechecks': {'properties': {'Params': {'$ref': '#/definitions/MigrationModelInfo'}},
                                  'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Abort(self, model_tag):
        '''
        model_tag : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget', request='Abort', version=1, params=_params)
        _params['model-tag'] = model_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Activate(self, model_tag):
        '''
        model_tag : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget', request='Activate', version=1, params=_params)
        _params['model-tag'] = model_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AdoptResources(self, model_tag, source_controller_version):
        '''
        model_tag : str
        source_controller_version : Number
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget', request='AdoptResources', version=1, params=_params)
        _params['model-tag'] = model_tag
        _params['source-controller-version'] = source_controller_version
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> typing.Sequence<+T_co>[int]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget', request='CACert', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Import(self, bytes_, charms, tools):
        '''
        bytes_ : typing.Sequence<+T_co>[int]
        charms : typing.Sequence<+T_co>[str]
        tools : typing.Sequence<+T_co>[~SerializedModelTools]<~SerializedModelTools>
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget', request='Import', version=1, params=_params)
        _params['bytes'] = bytes_
        _params['charms'] = charms
        _params['tools'] = tools
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(str)
    async def LatestLogTime(self, model_tag):
        '''
        model_tag : str
        Returns -> str
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget', request='LatestLogTime', version=1, params=_params)
        _params['model-tag'] = model_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Prechecks(self, agent_version, name, owner_tag, uuid):
        '''
        agent_version : Number
        name : str
        owner_tag : str
        uuid : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget', request='Prechecks', version=1, params=_params)
        _params['agent-version'] = agent_version
        _params['name'] = name
        _params['owner-tag'] = owner_tag
        _params['uuid'] = uuid
        reply = await self.rpc(msg)
        return reply



class ModelConfigFacade(Type):
    name = 'ModelConfig'
    version = 1
    schema =     {'definitions': {'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelSLA': {'additionalProperties': False,
                                  'properties': {'ModelSLAInfo': {'$ref': '#/definitions/ModelSLAInfo'},
                                                 'creds': {'items': {'type': 'integer'},
                                                           'type': 'array'}},
                                  'required': ['ModelSLAInfo', 'creds'],
                                  'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelSet': {'additionalProperties': False,
                                  'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                         'type': 'object'}},
                                                            'type': 'object'}},
                                  'required': ['config'],
                                  'type': 'object'},
                     'ModelUnset': {'additionalProperties': False,
                                    'properties': {'keys': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['keys'],
                                    'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'}},
     'properties': {'ModelGet': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                 'type': 'object'},
                    'ModelSet': {'properties': {'Params': {'$ref': '#/definitions/ModelSet'}},
                                 'type': 'object'},
                    'ModelUnset': {'properties': {'Params': {'$ref': '#/definitions/ModelUnset'}},
                                   'type': 'object'},
                    'SLALevel': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                 'type': 'object'},
                    'SetSLALevel': {'properties': {'Params': {'$ref': '#/definitions/ModelSLA'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelConfigResults)
    async def ModelGet(self):
        '''

        Returns -> typing.Mapping<~KT, +VT_co>[str, ~ConfigValue]<~ConfigValue>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig', request='ModelGet', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelSet(self, config):
        '''
        config : typing.Mapping<~KT, +VT_co>[str, typing.Any]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig', request='ModelSet', version=1, params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelUnset(self, keys):
        '''
        keys : typing.Sequence<+T_co>[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig', request='ModelUnset', version=1, params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def SLALevel(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig', request='SLALevel', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetSLALevel(self, creds, level):
        '''
        creds : typing.Sequence<+T_co>[int]
        level : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig', request='SetSLALevel', version=1, params=_params)
        _params['creds'] = creds
        _params['level'] = level
        reply = await self.rpc(msg)
        return reply



class NotifyWatcherFacade(Type):
    name = 'NotifyWatcher'
    version = 1
    schema =     {'properties': {'Next': {'type': 'object'}, 'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Next(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='NotifyWatcher', request='Next', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='NotifyWatcher', request='Stop', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class PayloadsFacade(Type):
    name = 'Payloads'
    version = 1
    schema =     {'definitions': {'Payload': {'additionalProperties': False,
                                 'properties': {'class': {'type': 'string'},
                                                'id': {'type': 'string'},
                                                'labels': {'items': {'type': 'string'},
                                                           'type': 'array'},
                                                'machine': {'type': 'string'},
                                                'status': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'unit': {'type': 'string'}},
                                 'required': ['class',
                                              'type',
                                              'id',
                                              'status',
                                              'labels',
                                              'unit',
                                              'machine'],
                                 'type': 'object'},
                     'PayloadListArgs': {'additionalProperties': False,
                                         'properties': {'patterns': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['patterns'],
                                         'type': 'object'},
                     'PayloadListResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/Payload'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'List': {'properties': {'Params': {'$ref': '#/definitions/PayloadListArgs'},
                                            'Result': {'$ref': '#/definitions/PayloadListResults'}},
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(PayloadListResults)
    async def List(self, patterns):
        '''
        patterns : typing.Sequence<+T_co>[str]
        Returns -> typing.Sequence<+T_co>[~Payload]<~Payload>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Payloads', request='List', version=1, params=_params)
        _params['patterns'] = patterns
        reply = await self.rpc(msg)
        return reply



class PayloadsHookContextFacade(Type):
    name = 'PayloadsHookContext'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'LookUpPayloadArg': {'additionalProperties': False,
                                          'properties': {'id': {'type': 'string'},
                                                         'name': {'type': 'string'}},
                                          'required': ['name', 'id'],
                                          'type': 'object'},
                     'LookUpPayloadArgs': {'additionalProperties': False,
                                           'properties': {'args': {'items': {'$ref': '#/definitions/LookUpPayloadArg'},
                                                                   'type': 'array'}},
                                           'required': ['args'],
                                           'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Payload': {'additionalProperties': False,
                                 'properties': {'class': {'type': 'string'},
                                                'id': {'type': 'string'},
                                                'labels': {'items': {'type': 'string'},
                                                           'type': 'array'},
                                                'machine': {'type': 'string'},
                                                'status': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'unit': {'type': 'string'}},
                                 'required': ['class',
                                              'type',
                                              'id',
                                              'status',
                                              'labels',
                                              'unit',
                                              'machine'],
                                 'type': 'object'},
                     'PayloadResult': {'additionalProperties': False,
                                       'properties': {'Entity': {'$ref': '#/definitions/Entity'},
                                                      'error': {'$ref': '#/definitions/Error'},
                                                      'not-found': {'type': 'boolean'},
                                                      'payload': {'$ref': '#/definitions/Payload'}},
                                       'required': ['Entity',
                                                    'payload',
                                                    'not-found'],
                                       'type': 'object'},
                     'PayloadResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/PayloadResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'SetPayloadStatusArg': {'additionalProperties': False,
                                             'properties': {'Entity': {'$ref': '#/definitions/Entity'},
                                                            'status': {'type': 'string'}},
                                             'required': ['Entity', 'status'],
                                             'type': 'object'},
                     'SetPayloadStatusArgs': {'additionalProperties': False,
                                              'properties': {'args': {'items': {'$ref': '#/definitions/SetPayloadStatusArg'},
                                                                      'type': 'array'}},
                                              'required': ['args'],
                                              'type': 'object'},
                     'TrackPayloadArgs': {'additionalProperties': False,
                                          'properties': {'payloads': {'items': {'$ref': '#/definitions/Payload'},
                                                                      'type': 'array'}},
                                          'required': ['payloads'],
                                          'type': 'object'}},
     'properties': {'List': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/PayloadResults'}},
                             'type': 'object'},
                    'LookUp': {'properties': {'Params': {'$ref': '#/definitions/LookUpPayloadArgs'},
                                              'Result': {'$ref': '#/definitions/PayloadResults'}},
                               'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetPayloadStatusArgs'},
                                                 'Result': {'$ref': '#/definitions/PayloadResults'}},
                                  'type': 'object'},
                    'Track': {'properties': {'Params': {'$ref': '#/definitions/TrackPayloadArgs'},
                                             'Result': {'$ref': '#/definitions/PayloadResults'}},
                              'type': 'object'},
                    'Untrack': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/PayloadResults'}},
                                'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(PayloadResults)
    async def List(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~PayloadResult]<~PayloadResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='PayloadsHookContext', request='List', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PayloadResults)
    async def LookUp(self, args):
        '''
        args : typing.Sequence<+T_co>[~LookUpPayloadArg]<~LookUpPayloadArg>
        Returns -> typing.Sequence<+T_co>[~PayloadResult]<~PayloadResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='PayloadsHookContext', request='LookUp', version=1, params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PayloadResults)
    async def SetStatus(self, args):
        '''
        args : typing.Sequence<+T_co>[~SetPayloadStatusArg]<~SetPayloadStatusArg>
        Returns -> typing.Sequence<+T_co>[~PayloadResult]<~PayloadResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='PayloadsHookContext', request='SetStatus', version=1, params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PayloadResults)
    async def Track(self, payloads):
        '''
        payloads : typing.Sequence<+T_co>[~Payload]<~Payload>
        Returns -> typing.Sequence<+T_co>[~PayloadResult]<~PayloadResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='PayloadsHookContext', request='Track', version=1, params=_params)
        _params['payloads'] = payloads
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PayloadResults)
    async def Untrack(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~PayloadResult]<~PayloadResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='PayloadsHookContext', request='Untrack', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class PingerFacade(Type):
    name = 'Pinger'
    version = 1
    schema =     {'properties': {'Ping': {'type': 'object'}, 'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Ping(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Pinger', request='Ping', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Pinger', request='Stop', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class ProxyUpdaterFacade(Type):
    name = 'ProxyUpdater'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ProxyConfig': {'additionalProperties': False,
                                     'properties': {'ftp': {'type': 'string'},
                                                    'http': {'type': 'string'},
                                                    'https': {'type': 'string'},
                                                    'no-proxy': {'type': 'string'}},
                                     'required': ['http',
                                                  'https',
                                                  'ftp',
                                                  'no-proxy'],
                                     'type': 'object'},
                     'ProxyConfigResult': {'additionalProperties': False,
                                           'properties': {'apt-proxy-settings': {'$ref': '#/definitions/ProxyConfig'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'proxy-settings': {'$ref': '#/definitions/ProxyConfig'}},
                                           'required': ['proxy-settings',
                                                        'apt-proxy-settings'],
                                           'type': 'object'},
                     'ProxyConfigResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/ProxyConfigResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'ProxyConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ProxyConfigResults'}},
                                    'type': 'object'},
                    'WatchForProxyConfigAndAPIHostPortChanges': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                                'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ProxyConfigResults)
    async def ProxyConfig(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ProxyConfigResult]<~ProxyConfigResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ProxyUpdater', request='ProxyConfig', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchForProxyConfigAndAPIHostPortChanges(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ProxyUpdater', request='WatchForProxyConfigAndAPIHostPortChanges', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class RelationUnitsWatcherFacade(Type):
    name = 'RelationUnitsWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RelationUnitsChange': {'additionalProperties': False,
                                             'properties': {'changed': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitSettings'}},
                                                                        'type': 'object'},
                                                            'departed': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                             'required': ['changed'],
                                             'type': 'object'},
                     'RelationUnitsWatchResult': {'additionalProperties': False,
                                                  'properties': {'changes': {'$ref': '#/definitions/RelationUnitsChange'},
                                                                 'error': {'$ref': '#/definitions/Error'},
                                                                 'watcher-id': {'type': 'string'}},
                                                  'required': ['watcher-id',
                                                               'changes'],
                                                  'type': 'object'},
                     'UnitSettings': {'additionalProperties': False,
                                      'properties': {'version': {'type': 'integer'}},
                                      'required': ['version'],
                                      'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/RelationUnitsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(RelationUnitsWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[_ForwardRef('RelationUnitsChange'), _ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RelationUnitsWatcher', request='Next', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RelationUnitsWatcher', request='Stop', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class RemoteApplicationWatcherFacade(Type):
    name = 'RemoteApplicationWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RemoteApplicationChange': {'additionalProperties': False,
                                                 'properties': {'application-tag': {'type': 'string'},
                                                                'life': {'type': 'string'},
                                                                'relations': {'$ref': '#/definitions/RemoteRelationsChange'}},
                                                 'required': ['application-tag',
                                                              'life',
                                                              'relations'],
                                                 'type': 'object'},
                     'RemoteApplicationWatchResult': {'additionalProperties': False,
                                                      'properties': {'change': {'$ref': '#/definitions/RemoteApplicationChange'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'id': {'type': 'string'}},
                                                      'required': ['id'],
                                                      'type': 'object'},
                     'RemoteEntityId': {'additionalProperties': False,
                                        'properties': {'model-uuid': {'type': 'string'},
                                                       'token': {'type': 'string'}},
                                        'required': ['model-uuid', 'token'],
                                        'type': 'object'},
                     'RemoteRelationChange': {'additionalProperties': False,
                                              'properties': {'changed-units': {'patternProperties': {'.*': {'$ref': '#/definitions/RemoteRelationUnitChange'}},
                                                                               'type': 'object'},
                                                             'departed-units': {'items': {'type': 'string'},
                                                                                'type': 'array'},
                                                             'id': {'type': 'integer'},
                                                             'life': {'type': 'string'}},
                                              'required': ['id', 'life'],
                                              'type': 'object'},
                     'RemoteRelationUnitChange': {'additionalProperties': False,
                                                  'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                           'type': 'object'}},
                                                                              'type': 'object'},
                                                                 'unit-id': {'$ref': '#/definitions/RemoteEntityId'}},
                                                  'required': ['unit-id'],
                                                  'type': 'object'},
                     'RemoteRelationsChange': {'additionalProperties': False,
                                               'properties': {'changed': {'items': {'$ref': '#/definitions/RemoteRelationChange'},
                                                                          'type': 'array'},
                                                              'initial': {'type': 'boolean'},
                                                              'removed': {'items': {'type': 'integer'},
                                                                          'type': 'array'}},
                                               'required': ['initial'],
                                               'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/RemoteApplicationWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(RemoteApplicationWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[_ForwardRef('RemoteApplicationChange'), _ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteApplicationWatcher', request='Next', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteApplicationWatcher', request='Stop', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class RemoteRelationsWatcherFacade(Type):
    name = 'RemoteRelationsWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RemoteEntityId': {'additionalProperties': False,
                                        'properties': {'model-uuid': {'type': 'string'},
                                                       'token': {'type': 'string'}},
                                        'required': ['model-uuid', 'token'],
                                        'type': 'object'},
                     'RemoteRelationChange': {'additionalProperties': False,
                                              'properties': {'changed-units': {'patternProperties': {'.*': {'$ref': '#/definitions/RemoteRelationUnitChange'}},
                                                                               'type': 'object'},
                                                             'departed-units': {'items': {'type': 'string'},
                                                                                'type': 'array'},
                                                             'id': {'type': 'integer'},
                                                             'life': {'type': 'string'}},
                                              'required': ['id', 'life'],
                                              'type': 'object'},
                     'RemoteRelationUnitChange': {'additionalProperties': False,
                                                  'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                           'type': 'object'}},
                                                                              'type': 'object'},
                                                                 'unit-id': {'$ref': '#/definitions/RemoteEntityId'}},
                                                  'required': ['unit-id'],
                                                  'type': 'object'},
                     'RemoteRelationsChange': {'additionalProperties': False,
                                               'properties': {'changed': {'items': {'$ref': '#/definitions/RemoteRelationChange'},
                                                                          'type': 'array'},
                                                              'initial': {'type': 'boolean'},
                                                              'removed': {'items': {'type': 'integer'},
                                                                          'type': 'array'}},
                                               'required': ['initial'],
                                               'type': 'object'},
                     'RemoteRelationsWatchResult': {'additionalProperties': False,
                                                    'properties': {'RemoteRelationsWatcherId': {'type': 'string'},
                                                                   'change': {'$ref': '#/definitions/RemoteRelationsChange'},
                                                                   'error': {'$ref': '#/definitions/Error'}},
                                                    'required': ['RemoteRelationsWatcherId'],
                                                    'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/RemoteRelationsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(RemoteRelationsWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('RemoteRelationsChange'), _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelationsWatcher', request='Next', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelationsWatcher', request='Stop', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class ResourcesFacade(Type):
    name = 'Resources'
    version = 1
    schema =     {'definitions': {'AddCharmWithAuthorization': {'additionalProperties': False,
                                                   'properties': {'channel': {'type': 'string'},
                                                                  'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                                  'url': {'type': 'string'}},
                                                   'required': ['url',
                                                                'channel',
                                                                'macaroon'],
                                                   'type': 'object'},
                     'AddPendingResourcesArgs': {'additionalProperties': False,
                                                 'properties': {'AddCharmWithAuthorization': {'$ref': '#/definitions/AddCharmWithAuthorization'},
                                                                'Entity': {'$ref': '#/definitions/Entity'},
                                                                'resources': {'items': {'$ref': '#/definitions/CharmResource'},
                                                                              'type': 'array'}},
                                                 'required': ['Entity',
                                                              'AddCharmWithAuthorization',
                                                              'resources'],
                                                 'type': 'object'},
                     'AddPendingResourcesResult': {'additionalProperties': False,
                                                   'properties': {'ErrorResult': {'$ref': '#/definitions/ErrorResult'},
                                                                  'pending-ids': {'items': {'type': 'string'},
                                                                                  'type': 'array'}},
                                                   'required': ['ErrorResult',
                                                                'pending-ids'],
                                                   'type': 'object'},
                     'CharmResource': {'additionalProperties': False,
                                       'properties': {'description': {'type': 'string'},
                                                      'fingerprint': {'items': {'type': 'integer'},
                                                                      'type': 'array'},
                                                      'name': {'type': 'string'},
                                                      'origin': {'type': 'string'},
                                                      'path': {'type': 'string'},
                                                      'revision': {'type': 'integer'},
                                                      'size': {'type': 'integer'},
                                                      'type': {'type': 'string'}},
                                       'required': ['name',
                                                    'type',
                                                    'path',
                                                    'origin',
                                                    'revision',
                                                    'fingerprint',
                                                    'size'],
                                       'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ListResourcesArgs': {'additionalProperties': False,
                                           'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                       'type': 'array'}},
                                           'required': ['entities'],
                                           'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Resource': {'additionalProperties': False,
                                  'properties': {'CharmResource': {'$ref': '#/definitions/CharmResource'},
                                                 'application': {'type': 'string'},
                                                 'id': {'type': 'string'},
                                                 'pending-id': {'type': 'string'},
                                                 'timestamp': {'format': 'date-time',
                                                               'type': 'string'},
                                                 'username': {'type': 'string'}},
                                  'required': ['CharmResource',
                                               'id',
                                               'pending-id',
                                               'application',
                                               'username',
                                               'timestamp'],
                                  'type': 'object'},
                     'ResourcesResult': {'additionalProperties': False,
                                         'properties': {'ErrorResult': {'$ref': '#/definitions/ErrorResult'},
                                                        'charm-store-resources': {'items': {'$ref': '#/definitions/CharmResource'},
                                                                                  'type': 'array'},
                                                        'resources': {'items': {'$ref': '#/definitions/Resource'},
                                                                      'type': 'array'},
                                                        'unit-resources': {'items': {'$ref': '#/definitions/UnitResources'},
                                                                           'type': 'array'}},
                                         'required': ['ErrorResult',
                                                      'resources',
                                                      'charm-store-resources',
                                                      'unit-resources'],
                                         'type': 'object'},
                     'ResourcesResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/ResourcesResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'UnitResources': {'additionalProperties': False,
                                       'properties': {'Entity': {'$ref': '#/definitions/Entity'},
                                                      'download-progress': {'patternProperties': {'.*': {'type': 'integer'}},
                                                                            'type': 'object'},
                                                      'resources': {'items': {'$ref': '#/definitions/Resource'},
                                                                    'type': 'array'}},
                                       'required': ['Entity',
                                                    'resources',
                                                    'download-progress'],
                                       'type': 'object'}},
     'properties': {'AddPendingResources': {'properties': {'Params': {'$ref': '#/definitions/AddPendingResourcesArgs'},
                                                           'Result': {'$ref': '#/definitions/AddPendingResourcesResult'}},
                                            'type': 'object'},
                    'ListResources': {'properties': {'Params': {'$ref': '#/definitions/ListResourcesArgs'},
                                                     'Result': {'$ref': '#/definitions/ResourcesResults'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddPendingResourcesResult)
    async def AddPendingResources(self, addcharmwithauthorization, entity, resources):
        '''
        addcharmwithauthorization : AddCharmWithAuthorization
        entity : Entity
        resources : typing.Sequence<+T_co>[~CharmResource]<~CharmResource>
        Returns -> typing.Union[_ForwardRef('ErrorResult'), typing.Sequence<+T_co>[str]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Resources', request='AddPendingResources', version=1, params=_params)
        _params['AddCharmWithAuthorization'] = addcharmwithauthorization
        _params['Entity'] = entity
        _params['Resources'] = resources
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ResourcesResults)
    async def ListResources(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ResourcesResult]<~ResourcesResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Resources', request='ListResources', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class ResourcesHookContextFacade(Type):
    name = 'ResourcesHookContext'
    version = 1
    schema =     {'definitions': {'CharmResource': {'additionalProperties': False,
                                       'properties': {'description': {'type': 'string'},
                                                      'fingerprint': {'items': {'type': 'integer'},
                                                                      'type': 'array'},
                                                      'name': {'type': 'string'},
                                                      'origin': {'type': 'string'},
                                                      'path': {'type': 'string'},
                                                      'revision': {'type': 'integer'},
                                                      'size': {'type': 'integer'},
                                                      'type': {'type': 'string'}},
                                       'required': ['name',
                                                    'type',
                                                    'path',
                                                    'origin',
                                                    'revision',
                                                    'fingerprint',
                                                    'size'],
                                       'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ListUnitResourcesArgs': {'additionalProperties': False,
                                               'properties': {'resource-names': {'items': {'type': 'string'},
                                                                                 'type': 'array'}},
                                               'required': ['resource-names'],
                                               'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Resource': {'additionalProperties': False,
                                  'properties': {'CharmResource': {'$ref': '#/definitions/CharmResource'},
                                                 'application': {'type': 'string'},
                                                 'id': {'type': 'string'},
                                                 'pending-id': {'type': 'string'},
                                                 'timestamp': {'format': 'date-time',
                                                               'type': 'string'},
                                                 'username': {'type': 'string'}},
                                  'required': ['CharmResource',
                                               'id',
                                               'pending-id',
                                               'application',
                                               'username',
                                               'timestamp'],
                                  'type': 'object'},
                     'UnitResourceResult': {'additionalProperties': False,
                                            'properties': {'ErrorResult': {'$ref': '#/definitions/ErrorResult'},
                                                           'resource': {'$ref': '#/definitions/Resource'}},
                                            'required': ['ErrorResult', 'resource'],
                                            'type': 'object'},
                     'UnitResourcesResult': {'additionalProperties': False,
                                             'properties': {'ErrorResult': {'$ref': '#/definitions/ErrorResult'},
                                                            'resources': {'items': {'$ref': '#/definitions/UnitResourceResult'},
                                                                          'type': 'array'}},
                                             'required': ['ErrorResult',
                                                          'resources'],
                                             'type': 'object'}},
     'properties': {'GetResourceInfo': {'properties': {'Params': {'$ref': '#/definitions/ListUnitResourcesArgs'},
                                                       'Result': {'$ref': '#/definitions/UnitResourcesResult'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(UnitResourcesResult)
    async def GetResourceInfo(self, resource_names):
        '''
        resource_names : typing.Sequence<+T_co>[str]
        Returns -> typing.Union[_ForwardRef('ErrorResult'), typing.Sequence<+T_co>[~UnitResourceResult]<~UnitResourceResult>]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ResourcesHookContext', request='GetResourceInfo', version=1, params=_params)
        _params['resource-names'] = resource_names
        reply = await self.rpc(msg)
        return reply



class RetryStrategyFacade(Type):
    name = 'RetryStrategy'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'RetryStrategy': {'additionalProperties': False,
                                       'properties': {'jitter-retry-time': {'type': 'boolean'},
                                                      'max-retry-time': {'type': 'integer'},
                                                      'min-retry-time': {'type': 'integer'},
                                                      'retry-time-factor': {'type': 'integer'},
                                                      'should-retry': {'type': 'boolean'}},
                                       'required': ['should-retry',
                                                    'min-retry-time',
                                                    'max-retry-time',
                                                    'jitter-retry-time',
                                                    'retry-time-factor'],
                                       'type': 'object'},
                     'RetryStrategyResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/RetryStrategy'}},
                                             'type': 'object'},
                     'RetryStrategyResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/RetryStrategyResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'}},
     'properties': {'RetryStrategy': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/RetryStrategyResults'}},
                                      'type': 'object'},
                    'WatchRetryStrategy': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(RetryStrategyResults)
    async def RetryStrategy(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~RetryStrategyResult]<~RetryStrategyResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RetryStrategy', request='RetryStrategy', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchRetryStrategy(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RetryStrategy', request='WatchRetryStrategy', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SSHClientFacade(Type):
    name = 'SSHClient'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SSHAddressResult': {'additionalProperties': False,
                                          'properties': {'address': {'type': 'string'},
                                                         'error': {'$ref': '#/definitions/Error'}},
                                          'type': 'object'},
                     'SSHAddressResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/SSHAddressResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'SSHProxyResult': {'additionalProperties': False,
                                        'properties': {'use-proxy': {'type': 'boolean'}},
                                        'required': ['use-proxy'],
                                        'type': 'object'},
                     'SSHPublicKeysResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'public-keys': {'items': {'type': 'string'},
                                                                            'type': 'array'}},
                                             'type': 'object'},
                     'SSHPublicKeysResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/SSHPublicKeysResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'}},
     'properties': {'PrivateAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/SSHAddressResults'}},
                                       'type': 'object'},
                    'Proxy': {'properties': {'Result': {'$ref': '#/definitions/SSHProxyResult'}},
                              'type': 'object'},
                    'PublicAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/SSHAddressResults'}},
                                      'type': 'object'},
                    'PublicKeys': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/SSHPublicKeysResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(SSHAddressResults)
    async def PrivateAddress(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~SSHAddressResult]<~SSHAddressResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient', request='PrivateAddress', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHProxyResult)
    async def Proxy(self):
        '''

        Returns -> bool
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient', request='Proxy', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHAddressResults)
    async def PublicAddress(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~SSHAddressResult]<~SSHAddressResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient', request='PublicAddress', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHPublicKeysResults)
    async def PublicKeys(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~SSHPublicKeysResult]<~SSHPublicKeysResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient', request='PublicKeys', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SingularFacade(Type):
    name = 'Singular'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SingularClaim': {'additionalProperties': False,
                                       'properties': {'controller-tag': {'type': 'string'},
                                                      'duration': {'type': 'integer'},
                                                      'model-tag': {'type': 'string'}},
                                       'required': ['model-tag',
                                                    'controller-tag',
                                                    'duration'],
                                       'type': 'object'},
                     'SingularClaims': {'additionalProperties': False,
                                        'properties': {'claims': {'items': {'$ref': '#/definitions/SingularClaim'},
                                                                  'type': 'array'}},
                                        'required': ['claims'],
                                        'type': 'object'}},
     'properties': {'Claim': {'properties': {'Params': {'$ref': '#/definitions/SingularClaims'},
                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                              'type': 'object'},
                    'Wait': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def Claim(self, claims):
        '''
        claims : typing.Sequence<+T_co>[~SingularClaim]<~SingularClaim>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Singular', request='Claim', version=1, params=_params)
        _params['claims'] = claims
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Wait(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Singular', request='Wait', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class StringsWatcherFacade(Type):
    name = 'StringsWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[typing.Sequence<+T_co>[str], _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StringsWatcher', request='Next', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StringsWatcher', request='Stop', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class UndertakerFacade(Type):
    name = 'Undertaker'
    version = 1
    schema =     {'definitions': {'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'UndertakerModelInfo': {'additionalProperties': False,
                                             'properties': {'global-name': {'type': 'string'},
                                                            'is-system': {'type': 'boolean'},
                                                            'life': {'type': 'string'},
                                                            'name': {'type': 'string'},
                                                            'uuid': {'type': 'string'}},
                                             'required': ['uuid',
                                                          'name',
                                                          'global-name',
                                                          'is-system',
                                                          'life'],
                                             'type': 'object'},
                     'UndertakerModelInfoResult': {'additionalProperties': False,
                                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                  'result': {'$ref': '#/definitions/UndertakerModelInfo'}},
                                                   'required': ['result'],
                                                   'type': 'object'}},
     'properties': {'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ModelInfo': {'properties': {'Result': {'$ref': '#/definitions/UndertakerModelInfoResult'}},
                                  'type': 'object'},
                    'ProcessDyingModel': {'type': 'object'},
                    'RemoveModel': {'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'WatchModelResources': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping<~KT, +VT_co>[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker', request='ModelConfig', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UndertakerModelInfoResult)
    async def ModelInfo(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), _ForwardRef('UndertakerModelInfo')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker', request='ModelInfo', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ProcessDyingModel(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker', request='ProcessDyingModel', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def RemoveModel(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker', request='RemoveModel', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~EntityStatusArgs]<~EntityStatusArgs>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker', request='SetStatus', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~EntityStatusArgs]<~EntityStatusArgs>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker', request='UpdateStatus', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchModelResources(self):
        '''

        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker', request='WatchModelResources', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class UnitAssignerFacade(Type):
    name = 'UnitAssigner'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'AssignUnits': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'SetAgentStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'WatchUnitAssignments': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AssignUnits(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UnitAssigner', request='AssignUnits', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetAgentStatus(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~EntityStatusArgs]<~EntityStatusArgs>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UnitAssigner', request='SetAgentStatus', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchUnitAssignments(self):
        '''

        Returns -> typing.Union[typing.Sequence<+T_co>[str], _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UnitAssigner', request='WatchUnitAssignments', version=1, params=_params)

        reply = await self.rpc(msg)
        return reply



class UpgraderFacade(Type):
    name = 'Upgrader'
    version = 1
    schema =     {'definitions': {'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Series': {'type': 'string'}},
                                'required': ['Number', 'Series', 'Arch'],
                                'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'EntitiesVersion': {'additionalProperties': False,
                                         'properties': {'agent-tools': {'items': {'$ref': '#/definitions/EntityVersion'},
                                                                        'type': 'array'}},
                                         'required': ['agent-tools'],
                                         'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityVersion': {'additionalProperties': False,
                                       'properties': {'tag': {'type': 'string'},
                                                      'tools': {'$ref': '#/definitions/Version'}},
                                       'required': ['tag', 'tools'],
                                       'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'Tools': {'additionalProperties': False,
                               'properties': {'sha256': {'type': 'string'},
                                              'size': {'type': 'integer'},
                                              'url': {'type': 'string'},
                                              'version': {'$ref': '#/definitions/Binary'}},
                               'required': ['version', 'url', 'size'],
                               'type': 'object'},
                     'ToolsResult': {'additionalProperties': False,
                                     'properties': {'disable-ssl-hostname-verification': {'type': 'boolean'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'tools': {'items': {'$ref': '#/definitions/Tools'},
                                                              'type': 'array'}},
                                     'required': ['tools',
                                                  'disable-ssl-hostname-verification'],
                                     'type': 'object'},
                     'ToolsResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ToolsResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Version': {'additionalProperties': False,
                                 'properties': {'version': {'$ref': '#/definitions/Binary'}},
                                 'required': ['version'],
                                 'type': 'object'},
                     'VersionResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'version': {'$ref': '#/definitions/Number'}},
                                       'type': 'object'},
                     'VersionResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/VersionResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'}},
     'properties': {'DesiredVersion': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/VersionResults'}},
                                       'type': 'object'},
                    'SetTools': {'properties': {'Params': {'$ref': '#/definitions/EntitiesVersion'},
                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                 'type': 'object'},
                    'Tools': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/ToolsResults'}},
                              'type': 'object'},
                    'WatchAPIVersion': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(VersionResults)
    async def DesiredVersion(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~VersionResult]<~VersionResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Upgrader', request='DesiredVersion', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetTools(self, agent_tools):
        '''
        agent_tools : typing.Sequence<+T_co>[~EntityVersion]<~EntityVersion>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Upgrader', request='SetTools', version=1, params=_params)
        _params['agent-tools'] = agent_tools
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ToolsResults)
    async def Tools(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ToolsResult]<~ToolsResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Upgrader', request='Tools', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchAPIVersion(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~NotifyWatchResult]<~NotifyWatchResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Upgrader', request='WatchAPIVersion', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class UserManagerFacade(Type):
    name = 'UserManager'
    version = 1
    schema =     {'definitions': {'AddUser': {'additionalProperties': False,
                                 'properties': {'display-name': {'type': 'string'},
                                                'password': {'type': 'string'},
                                                'username': {'type': 'string'}},
                                 'required': ['username', 'display-name'],
                                 'type': 'object'},
                     'AddUserResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'secret-key': {'items': {'type': 'integer'},
                                                                     'type': 'array'},
                                                      'tag': {'type': 'string'}},
                                       'type': 'object'},
                     'AddUserResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/AddUserResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'AddUsers': {'additionalProperties': False,
                                  'properties': {'users': {'items': {'$ref': '#/definitions/AddUser'},
                                                           'type': 'array'}},
                                  'required': ['users'],
                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'UserInfo': {'additionalProperties': False,
                                  'properties': {'access': {'type': 'string'},
                                                 'created-by': {'type': 'string'},
                                                 'date-created': {'format': 'date-time',
                                                                  'type': 'string'},
                                                 'disabled': {'type': 'boolean'},
                                                 'display-name': {'type': 'string'},
                                                 'last-connection': {'format': 'date-time',
                                                                     'type': 'string'},
                                                 'username': {'type': 'string'}},
                                  'required': ['username',
                                               'display-name',
                                               'access',
                                               'created-by',
                                               'date-created',
                                               'disabled'],
                                  'type': 'object'},
                     'UserInfoRequest': {'additionalProperties': False,
                                         'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                     'type': 'array'},
                                                        'include-disabled': {'type': 'boolean'}},
                                         'required': ['entities',
                                                      'include-disabled'],
                                         'type': 'object'},
                     'UserInfoResult': {'additionalProperties': False,
                                        'properties': {'error': {'$ref': '#/definitions/Error'},
                                                       'result': {'$ref': '#/definitions/UserInfo'}},
                                        'type': 'object'},
                     'UserInfoResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/UserInfoResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'}},
     'properties': {'AddUser': {'properties': {'Params': {'$ref': '#/definitions/AddUsers'},
                                               'Result': {'$ref': '#/definitions/AddUserResults'}},
                                'type': 'object'},
                    'DisableUser': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'EnableUser': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'RemoveUser': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'SetPassword': {'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'UserInfo': {'properties': {'Params': {'$ref': '#/definitions/UserInfoRequest'},
                                                'Result': {'$ref': '#/definitions/UserInfoResults'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddUserResults)
    async def AddUser(self, users):
        '''
        users : typing.Sequence<+T_co>[~AddUser]<~AddUser>
        Returns -> typing.Sequence<+T_co>[~AddUserResult]<~AddUserResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager', request='AddUser', version=1, params=_params)
        _params['users'] = users
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DisableUser(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager', request='DisableUser', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnableUser(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager', request='EnableUser', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveUser(self, entities):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager', request='RemoveUser', version=1, params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPassword(self, changes):
        '''
        changes : typing.Sequence<+T_co>[~EntityPassword]<~EntityPassword>
        Returns -> typing.Sequence<+T_co>[~ErrorResult]<~ErrorResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager', request='SetPassword', version=1, params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserInfoResults)
    async def UserInfo(self, entities, include_disabled):
        '''
        entities : typing.Sequence<+T_co>[~Entity]<~Entity>
        include_disabled : bool
        Returns -> typing.Sequence<+T_co>[~UserInfoResult]<~UserInfoResult>
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager', request='UserInfo', version=1, params=_params)
        _params['entities'] = entities
        _params['include-disabled'] = include_disabled
        reply = await self.rpc(msg)
        return reply
