# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client._definitions import *
from juju.client.facade import ReturnMapping, Type


class ApplicationFacade(Type):
    name = 'Application'
    version = 4
    schema =     {'definitions': {'AddApplicationUnits': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'num-units': {'type': 'integer'},
                                                            'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                          'type': 'array'}},
                                             'required': ['application',
                                                          'num-units',
                                                          'placement'],
                                             'type': 'object'},
                     'AddApplicationUnitsResults': {'additionalProperties': False,
                                                    'properties': {'units': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                                    'required': ['units'],
                                                    'type': 'object'},
                     'AddRelation': {'additionalProperties': False,
                                     'properties': {'endpoints': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                     'required': ['endpoints'],
                                     'type': 'object'},
                     'AddRelationResults': {'additionalProperties': False,
                                            'properties': {'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                                         'type': 'object'}},
                                            'required': ['endpoints'],
                                            'type': 'object'},
                     'ApplicationCharmRelations': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'ApplicationCharmRelationsResults': {'additionalProperties': False,
                                                          'properties': {'charm-relations': {'items': {'type': 'string'},
                                                                                             'type': 'array'}},
                                                          'required': ['charm-relations'],
                                                          'type': 'object'},
                     'ApplicationDeploy': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'channel': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                          'config-yaml': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'num-units': {'type': 'integer'},
                                                          'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                        'type': 'array'},
                                                          'resources': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'}},
                                           'required': ['application',
                                                        'series',
                                                        'charm-url',
                                                        'channel',
                                                        'num-units',
                                                        'config-yaml',
                                                        'constraints'],
                                           'type': 'object'},
                     'ApplicationDestroy': {'additionalProperties': False,
                                            'properties': {'application': {'type': 'string'}},
                                            'required': ['application'],
                                            'type': 'object'},
                     'ApplicationExpose': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'}},
                                           'required': ['application'],
                                           'type': 'object'},
                     'ApplicationGet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'}},
                                        'required': ['application'],
                                        'type': 'object'},
                     'ApplicationGetResults': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'charm': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'constraints': {'$ref': '#/definitions/Value'},
                                                              'series': {'type': 'string'}},
                                               'required': ['application',
                                                            'charm',
                                                            'config',
                                                            'constraints',
                                                            'series'],
                                               'type': 'object'},
                     'ApplicationMetricCredential': {'additionalProperties': False,
                                                     'properties': {'application': {'type': 'string'},
                                                                    'metrics-credentials': {'items': {'type': 'integer'},
                                                                                            'type': 'array'}},
                                                     'required': ['application',
                                                                  'metrics-credentials'],
                                                     'type': 'object'},
                     'ApplicationMetricCredentials': {'additionalProperties': False,
                                                      'properties': {'creds': {'items': {'$ref': '#/definitions/ApplicationMetricCredential'},
                                                                               'type': 'array'}},
                                                      'required': ['creds'],
                                                      'type': 'object'},
                     'ApplicationSet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'options': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'}},
                                        'required': ['application', 'options'],
                                        'type': 'object'},
                     'ApplicationSetCharm': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'channel': {'type': 'string'},
                                                            'charm-url': {'type': 'string'},
                                                            'config-settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                            'config-settings-yaml': {'type': 'string'},
                                                            'force-series': {'type': 'boolean'},
                                                            'force-units': {'type': 'boolean'},
                                                            'resource-ids': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                            'storage-constraints': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageConstraints'}},
                                                                                    'type': 'object'}},
                                             'required': ['application',
                                                          'charm-url',
                                                          'channel',
                                                          'force-units',
                                                          'force-series'],
                                             'type': 'object'},
                     'ApplicationURLs': {'additionalProperties': False,
                                         'properties': {'application-urls': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                         'type': 'object'},
                     'ApplicationUnexpose': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'}},
                                             'required': ['application'],
                                             'type': 'object'},
                     'ApplicationUnset': {'additionalProperties': False,
                                          'properties': {'application': {'type': 'string'},
                                                         'options': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                          'required': ['application', 'options'],
                                          'type': 'object'},
                     'ApplicationUpdate': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'force-charm-url': {'type': 'boolean'},
                                                          'force-series': {'type': 'boolean'},
                                                          'min-units': {'type': 'integer'},
                                                          'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                       'type': 'object'},
                                                          'settings-yaml': {'type': 'string'}},
                                           'required': ['application',
                                                        'charm-url',
                                                        'force-charm-url',
                                                        'force-series',
                                                        'settings-yaml'],
                                           'type': 'object'},
                     'ApplicationsDeploy': {'additionalProperties': False,
                                            'properties': {'applications': {'items': {'$ref': '#/definitions/ApplicationDeploy'},
                                                                            'type': 'array'}},
                                            'required': ['applications'],
                                            'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'ConsumeApplicationArg': {'additionalProperties': False,
                                               'properties': {'application-alias': {'type': 'string'},
                                                              'application-url': {'type': 'string'}},
                                               'required': ['application-url'],
                                               'type': 'object'},
                     'ConsumeApplicationArgs': {'additionalProperties': False,
                                                'properties': {'args': {'items': {'$ref': '#/definitions/ConsumeApplicationArg'},
                                                                        'type': 'array'}},
                                                'type': 'object'},
                     'ConsumeApplicationResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'local-name': {'type': 'string'}},
                                                  'type': 'object'},
                     'ConsumeApplicationResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/ConsumeApplicationResult'},
                                                                              'type': 'array'}},
                                                   'required': ['results'],
                                                   'type': 'object'},
                     'DestroyApplicationInfo': {'additionalProperties': False,
                                                'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                     'type': 'array'},
                                                               'destroyed-units': {'items': {'$ref': '#/definitions/Entity'},
                                                                                   'type': 'array'},
                                                               'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                    'type': 'array'}},
                                                'type': 'object'},
                     'DestroyApplicationResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'info': {'$ref': '#/definitions/DestroyApplicationInfo'}},
                                                  'type': 'object'},
                     'DestroyApplicationResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/DestroyApplicationResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'DestroyApplicationUnits': {'additionalProperties': False,
                                                 'properties': {'unit-names': {'items': {'type': 'string'},
                                                                               'type': 'array'}},
                                                 'required': ['unit-names'],
                                                 'type': 'object'},
                     'DestroyRelation': {'additionalProperties': False,
                                         'properties': {'endpoints': {'items': {'type': 'string'},
                                                                      'type': 'array'}},
                                         'required': ['endpoints'],
                                         'type': 'object'},
                     'DestroyUnitInfo': {'additionalProperties': False,
                                         'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                              'type': 'array'},
                                                        'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                             'type': 'array'}},
                                         'type': 'object'},
                     'DestroyUnitResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'$ref': '#/definitions/DestroyUnitInfo'}},
                                           'type': 'object'},
                     'DestroyUnitResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/DestroyUnitResult'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'GetApplicationConstraints': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'GetConstraintsResults': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'RemoteApplicationInfo': {'additionalProperties': False,
                                               'properties': {'application-url': {'type': 'string'},
                                                              'description': {'type': 'string'},
                                                              'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                            'type': 'array'},
                                                              'icon-url-path': {'type': 'string'},
                                                              'model-tag': {'type': 'string'},
                                                              'name': {'type': 'string'},
                                                              'source-model-label': {'type': 'string'}},
                                               'required': ['model-tag',
                                                            'name',
                                                            'description',
                                                            'application-url',
                                                            'endpoints',
                                                            'icon-url-path'],
                                               'type': 'object'},
                     'RemoteApplicationInfoResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'result': {'$ref': '#/definitions/RemoteApplicationInfo'}},
                                                     'type': 'object'},
                     'RemoteApplicationInfoResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/RemoteApplicationInfoResult'},
                                                                                 'type': 'array'}},
                                                      'required': ['results'],
                                                      'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'},
                                                       'scope': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit',
                                                     'scope'],
                                        'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'AddRelation': {'properties': {'Params': {'$ref': '#/definitions/AddRelation'},
                                                   'Result': {'$ref': '#/definitions/AddRelationResults'}},
                                    'type': 'object'},
                    'AddUnits': {'properties': {'Params': {'$ref': '#/definitions/AddApplicationUnits'},
                                                'Result': {'$ref': '#/definitions/AddApplicationUnitsResults'}},
                                 'type': 'object'},
                    'CharmRelations': {'properties': {'Params': {'$ref': '#/definitions/ApplicationCharmRelations'},
                                                      'Result': {'$ref': '#/definitions/ApplicationCharmRelationsResults'}},
                                       'type': 'object'},
                    'Consume': {'properties': {'Params': {'$ref': '#/definitions/ConsumeApplicationArgs'},
                                               'Result': {'$ref': '#/definitions/ConsumeApplicationResults'}},
                                'type': 'object'},
                    'Deploy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationsDeploy'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationDestroy'}},
                                'type': 'object'},
                    'DestroyApplication': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/DestroyApplicationResults'}},
                                           'type': 'object'},
                    'DestroyRelation': {'properties': {'Params': {'$ref': '#/definitions/DestroyRelation'}},
                                        'type': 'object'},
                    'DestroyUnit': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/DestroyUnitResults'}},
                                    'type': 'object'},
                    'DestroyUnits': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationUnits'}},
                                     'type': 'object'},
                    'Expose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationExpose'}},
                               'type': 'object'},
                    'Get': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                           'Result': {'$ref': '#/definitions/ApplicationGetResults'}},
                            'type': 'object'},
                    'GetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                                   'Result': {'$ref': '#/definitions/StringResult'}},
                                    'type': 'object'},
                    'GetConstraints': {'properties': {'Params': {'$ref': '#/definitions/GetApplicationConstraints'},
                                                      'Result': {'$ref': '#/definitions/GetConstraintsResults'}},
                                       'type': 'object'},
                    'RemoteApplicationInfo': {'properties': {'Params': {'$ref': '#/definitions/ApplicationURLs'},
                                                             'Result': {'$ref': '#/definitions/RemoteApplicationInfoResults'}},
                                              'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSet'}},
                            'type': 'object'},
                    'SetCharm': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSetCharm'}},
                                 'type': 'object'},
                    'SetConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                       'type': 'object'},
                    'SetMetricCredentials': {'properties': {'Params': {'$ref': '#/definitions/ApplicationMetricCredentials'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'Unexpose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnexpose'}},
                                 'type': 'object'},
                    'Unset': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnset'}},
                              'type': 'object'},
                    'Update': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUpdate'}},
                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddRelationResults)
    async def AddRelation(self, endpoints):
        '''
        endpoints : typing.Sequence[str]
        Returns -> typing.Mapping[str, ~CharmRelation]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddRelation',
                   version=4,
                   params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddApplicationUnitsResults)
    async def AddUnits(self, application, num_units, placement):
        '''
        application : str
        num_units : int
        placement : typing.Sequence[~Placement]
        Returns -> typing.Sequence[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddUnits',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['num-units'] = num_units
        _params['placement'] = placement
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationCharmRelationsResults)
    async def CharmRelations(self, application):
        '''
        application : str
        Returns -> typing.Sequence[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmRelations',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConsumeApplicationResults)
    async def Consume(self, args):
        '''
        args : typing.Sequence[~ConsumeApplicationArg]
        Returns -> typing.Sequence[~ConsumeApplicationResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Consume',
                   version=4,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Deploy(self, applications):
        '''
        applications : typing.Sequence[~ApplicationDeploy]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Deploy',
                   version=4,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Destroy(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Destroy',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyApplicationResults)
    async def DestroyApplication(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~DestroyApplicationResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyApplication',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyRelation(self, endpoints):
        '''
        endpoints : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyRelation',
                   version=4,
                   params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyUnitResults)
    async def DestroyUnit(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~DestroyUnitResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnit',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyUnits(self, unit_names):
        '''
        unit_names : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnits',
                   version=4,
                   params=_params)
        _params['unit-names'] = unit_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Expose(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Expose',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetResults)
    async def Get(self, application):
        '''
        application : str
        Returns -> typing.Union[str, typing.Mapping[str, typing.Any], _ForwardRef('Value')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Get',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def GetCharmURL(self, application):
        '''
        application : str
        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetCharmURL',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetConstraintsResults)
    async def GetConstraints(self, application):
        '''
        application : str
        Returns -> Value
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConstraints',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoteApplicationInfoResults)
    async def RemoteApplicationInfo(self, application_urls):
        '''
        application_urls : typing.Sequence[str]
        Returns -> typing.Sequence[~RemoteApplicationInfoResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='RemoteApplicationInfo',
                   version=4,
                   params=_params)
        _params['application-urls'] = application_urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Set(self, application, options):
        '''
        application : str
        options : typing.Mapping[str, str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Set',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetCharm(self, application, channel, charm_url, config_settings, config_settings_yaml, force_series, force_units, resource_ids, storage_constraints):
        '''
        application : str
        channel : str
        charm_url : str
        config_settings : typing.Mapping[str, str]
        config_settings_yaml : str
        force_series : bool
        force_units : bool
        resource_ids : typing.Mapping[str, str]
        storage_constraints : typing.Mapping[str, ~StorageConstraints]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetCharm',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['channel'] = channel
        _params['charm-url'] = charm_url
        _params['config-settings'] = config_settings
        _params['config-settings-yaml'] = config_settings_yaml
        _params['force-series'] = force_series
        _params['force-units'] = force_units
        _params['resource-ids'] = resource_ids
        _params['storage-constraints'] = storage_constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetConstraints(self, application, constraints):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetConstraints',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMetricCredentials(self, creds):
        '''
        creds : typing.Sequence[~ApplicationMetricCredential]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetMetricCredentials',
                   version=4,
                   params=_params)
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unexpose(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unexpose',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unset(self, application, options):
        '''
        application : str
        options : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unset',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Update(self, application, charm_url, constraints, force_charm_url, force_series, min_units, settings, settings_yaml):
        '''
        application : str
        charm_url : str
        constraints : Value
        force_charm_url : bool
        force_series : bool
        min_units : int
        settings : typing.Mapping[str, str]
        settings_yaml : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Update',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['charm-url'] = charm_url
        _params['constraints'] = constraints
        _params['force-charm-url'] = force_charm_url
        _params['force-series'] = force_series
        _params['min-units'] = min_units
        _params['settings'] = settings
        _params['settings-yaml'] = settings_yaml
        reply = await self.rpc(msg)
        return reply



class StorageFacade(Type):
    name = 'Storage'
    version = 4
    schema =     {'definitions': {'AddStorageDetails': {'additionalProperties': False,
                                           'properties': {'storage-tags': {'items': {'type': 'string'},
                                                                           'type': 'array'}},
                                           'required': ['storage-tags'],
                                           'type': 'object'},
                     'AddStorageResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'result': {'$ref': '#/definitions/AddStorageDetails'}},
                                          'type': 'object'},
                     'AddStorageResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/AddStorageResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'BulkImportStorageParams': {'additionalProperties': False,
                                                 'properties': {'storage': {'items': {'$ref': '#/definitions/ImportStorageParams'},
                                                                            'type': 'array'}},
                                                 'required': ['storage'],
                                                 'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FilesystemAttachmentDetails': {'additionalProperties': False,
                                                     'properties': {'FilesystemAttachmentInfo': {'$ref': '#/definitions/FilesystemAttachmentInfo'},
                                                                    'life': {'type': 'string'}},
                                                     'required': ['FilesystemAttachmentInfo'],
                                                     'type': 'object'},
                     'FilesystemAttachmentInfo': {'additionalProperties': False,
                                                  'properties': {'mount-point': {'type': 'string'},
                                                                 'read-only': {'type': 'boolean'}},
                                                  'type': 'object'},
                     'FilesystemDetails': {'additionalProperties': False,
                                           'properties': {'filesystem-tag': {'type': 'string'},
                                                          'info': {'$ref': '#/definitions/FilesystemInfo'},
                                                          'life': {'type': 'string'},
                                                          'machine-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/FilesystemAttachmentDetails'}},
                                                                                  'type': 'object'},
                                                          'status': {'$ref': '#/definitions/EntityStatus'},
                                                          'storage': {'$ref': '#/definitions/StorageDetails'},
                                                          'unit-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/FilesystemAttachmentDetails'}},
                                                                               'type': 'object'},
                                                          'volume-tag': {'type': 'string'}},
                                           'required': ['filesystem-tag',
                                                        'info',
                                                        'status'],
                                           'type': 'object'},
                     'FilesystemDetailsListResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'result': {'items': {'$ref': '#/definitions/FilesystemDetails'},
                                                                               'type': 'array'}},
                                                     'type': 'object'},
                     'FilesystemDetailsListResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemDetailsListResult'},
                                                                                 'type': 'array'}},
                                                      'type': 'object'},
                     'FilesystemFilter': {'additionalProperties': False,
                                          'properties': {'machines': {'items': {'type': 'string'},
                                                                      'type': 'array'}},
                                          'type': 'object'},
                     'FilesystemFilters': {'additionalProperties': False,
                                           'properties': {'filters': {'items': {'$ref': '#/definitions/FilesystemFilter'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'FilesystemInfo': {'additionalProperties': False,
                                        'properties': {'filesystem-id': {'type': 'string'},
                                                       'pool': {'type': 'string'},
                                                       'size': {'type': 'integer'}},
                                        'required': ['filesystem-id',
                                                     'pool',
                                                     'size'],
                                        'type': 'object'},
                     'ImportStorageDetails': {'additionalProperties': False,
                                              'properties': {'storage-tag': {'type': 'string'}},
                                              'required': ['storage-tag'],
                                              'type': 'object'},
                     'ImportStorageParams': {'additionalProperties': False,
                                             'properties': {'kind': {'type': 'integer'},
                                                            'pool': {'type': 'string'},
                                                            'provider-id': {'type': 'string'},
                                                            'storage-name': {'type': 'string'}},
                                             'required': ['kind',
                                                          'pool',
                                                          'provider-id',
                                                          'storage-name'],
                                             'type': 'object'},
                     'ImportStorageResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/ImportStorageDetails'}},
                                             'type': 'object'},
                     'ImportStorageResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ImportStorageResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RemoveStorage': {'additionalProperties': False,
                                       'properties': {'storage': {'items': {'$ref': '#/definitions/RemoveStorageInstance'},
                                                                  'type': 'array'}},
                                       'required': ['storage'],
                                       'type': 'object'},
                     'RemoveStorageInstance': {'additionalProperties': False,
                                               'properties': {'destroy-attachments': {'type': 'boolean'},
                                                              'destroy-storage': {'type': 'boolean'},
                                                              'tag': {'type': 'string'}},
                                               'required': ['tag'],
                                               'type': 'object'},
                     'StorageAddParams': {'additionalProperties': False,
                                          'properties': {'name': {'type': 'string'},
                                                         'storage': {'$ref': '#/definitions/StorageConstraints'},
                                                         'unit': {'type': 'string'}},
                                          'required': ['unit', 'name', 'storage'],
                                          'type': 'object'},
                     'StorageAttachmentDetails': {'additionalProperties': False,
                                                  'properties': {'life': {'type': 'string'},
                                                                 'location': {'type': 'string'},
                                                                 'machine-tag': {'type': 'string'},
                                                                 'storage-tag': {'type': 'string'},
                                                                 'unit-tag': {'type': 'string'}},
                                                  'required': ['storage-tag',
                                                               'unit-tag',
                                                               'machine-tag'],
                                                  'type': 'object'},
                     'StorageAttachmentId': {'additionalProperties': False,
                                             'properties': {'storage-tag': {'type': 'string'},
                                                            'unit-tag': {'type': 'string'}},
                                             'required': ['storage-tag',
                                                          'unit-tag'],
                                             'type': 'object'},
                     'StorageAttachmentIds': {'additionalProperties': False,
                                              'properties': {'ids': {'items': {'$ref': '#/definitions/StorageAttachmentId'},
                                                                     'type': 'array'}},
                                              'required': ['ids'],
                                              'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StorageDetails': {'additionalProperties': False,
                                        'properties': {'attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageAttachmentDetails'}},
                                                                       'type': 'object'},
                                                       'kind': {'type': 'integer'},
                                                       'life': {'type': 'string'},
                                                       'owner-tag': {'type': 'string'},
                                                       'persistent': {'type': 'boolean'},
                                                       'status': {'$ref': '#/definitions/EntityStatus'},
                                                       'storage-tag': {'type': 'string'}},
                                        'required': ['storage-tag',
                                                     'owner-tag',
                                                     'kind',
                                                     'status',
                                                     'persistent'],
                                        'type': 'object'},
                     'StorageDetailsListResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'result': {'items': {'$ref': '#/definitions/StorageDetails'},
                                                                            'type': 'array'}},
                                                  'type': 'object'},
                     'StorageDetailsListResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/StorageDetailsListResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'StorageDetailsResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'result': {'$ref': '#/definitions/StorageDetails'}},
                                              'type': 'object'},
                     'StorageDetailsResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/StorageDetailsResult'},
                                                                          'type': 'array'}},
                                               'type': 'object'},
                     'StorageFilter': {'additionalProperties': False,
                                       'type': 'object'},
                     'StorageFilters': {'additionalProperties': False,
                                        'properties': {'filters': {'items': {'$ref': '#/definitions/StorageFilter'},
                                                                   'type': 'array'}},
                                        'type': 'object'},
                     'StoragePool': {'additionalProperties': False,
                                     'properties': {'attrs': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                    'name': {'type': 'string'},
                                                    'provider': {'type': 'string'}},
                                     'required': ['name', 'provider', 'attrs'],
                                     'type': 'object'},
                     'StoragePoolFilter': {'additionalProperties': False,
                                           'properties': {'names': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                          'providers': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                           'type': 'object'},
                     'StoragePoolFilters': {'additionalProperties': False,
                                            'properties': {'filters': {'items': {'$ref': '#/definitions/StoragePoolFilter'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'StoragePoolsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'storage-pools': {'items': {'$ref': '#/definitions/StoragePool'},
                                                                             'type': 'array'}},
                                            'type': 'object'},
                     'StoragePoolsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StoragePoolsResult'},
                                                                        'type': 'array'}},
                                             'type': 'object'},
                     'StoragesAddParams': {'additionalProperties': False,
                                           'properties': {'storages': {'items': {'$ref': '#/definitions/StorageAddParams'},
                                                                       'type': 'array'}},
                                           'required': ['storages'],
                                           'type': 'object'},
                     'VolumeAttachmentDetails': {'additionalProperties': False,
                                                 'properties': {'VolumeAttachmentInfo': {'$ref': '#/definitions/VolumeAttachmentInfo'},
                                                                'life': {'type': 'string'}},
                                                 'required': ['VolumeAttachmentInfo'],
                                                 'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeAttachmentPlanInfo': {'additionalProperties': False,
                                                  'properties': {'device-attributes': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                       'type': 'object'},
                                                                 'device-type': {'type': 'string'}},
                                                  'type': 'object'},
                     'VolumeDetails': {'additionalProperties': False,
                                       'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                                      'life': {'type': 'string'},
                                                      'machine-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentDetails'}},
                                                                              'type': 'object'},
                                                      'status': {'$ref': '#/definitions/EntityStatus'},
                                                      'storage': {'$ref': '#/definitions/StorageDetails'},
                                                      'unit-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentDetails'}},
                                                                           'type': 'object'},
                                                      'volume-tag': {'type': 'string'}},
                                       'required': ['volume-tag', 'info', 'status'],
                                       'type': 'object'},
                     'VolumeDetailsListResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'items': {'$ref': '#/definitions/VolumeDetails'},
                                                                           'type': 'array'}},
                                                 'type': 'object'},
                     'VolumeDetailsListResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/VolumeDetailsListResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'VolumeFilter': {'additionalProperties': False,
                                      'properties': {'machines': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'type': 'object'},
                     'VolumeFilters': {'additionalProperties': False,
                                       'properties': {'filters': {'items': {'$ref': '#/definitions/VolumeFilter'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'}},
     'properties': {'AddToUnit': {'properties': {'Params': {'$ref': '#/definitions/StoragesAddParams'},
                                                 'Result': {'$ref': '#/definitions/AddStorageResults'}},
                                  'type': 'object'},
                    'Attach': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'CreatePool': {'properties': {'Params': {'$ref': '#/definitions/StoragePool'}},
                                   'type': 'object'},
                    'Detach': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Import': {'properties': {'Params': {'$ref': '#/definitions/BulkImportStorageParams'},
                                              'Result': {'$ref': '#/definitions/ImportStorageResults'}},
                               'type': 'object'},
                    'ListFilesystems': {'properties': {'Params': {'$ref': '#/definitions/FilesystemFilters'},
                                                       'Result': {'$ref': '#/definitions/FilesystemDetailsListResults'}},
                                        'type': 'object'},
                    'ListPools': {'properties': {'Params': {'$ref': '#/definitions/StoragePoolFilters'},
                                                 'Result': {'$ref': '#/definitions/StoragePoolsResults'}},
                                  'type': 'object'},
                    'ListStorageDetails': {'properties': {'Params': {'$ref': '#/definitions/StorageFilters'},
                                                          'Result': {'$ref': '#/definitions/StorageDetailsListResults'}},
                                           'type': 'object'},
                    'ListVolumes': {'properties': {'Params': {'$ref': '#/definitions/VolumeFilters'},
                                                   'Result': {'$ref': '#/definitions/VolumeDetailsListResults'}},
                                    'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/RemoveStorage'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'StorageDetails': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StorageDetailsResults'}},
                                       'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddStorageResults)
    async def AddToUnit(self, storages):
        '''
        storages : typing.Sequence[~StorageAddParams]
        Returns -> typing.Sequence[~AddStorageResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='AddToUnit',
                   version=4,
                   params=_params)
        _params['storages'] = storages
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Attach(self, ids):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Attach',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def CreatePool(self, attrs, name, provider):
        '''
        attrs : typing.Mapping[str, typing.Any]
        name : str
        provider : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='CreatePool',
                   version=4,
                   params=_params)
        _params['attrs'] = attrs
        _params['name'] = name
        _params['provider'] = provider
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Detach(self, ids):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Detach',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ImportStorageResults)
    async def Import(self, storage):
        '''
        storage : typing.Sequence[~ImportStorageParams]
        Returns -> typing.Sequence[~ImportStorageResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Import',
                   version=4,
                   params=_params)
        _params['storage'] = storage
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemDetailsListResults)
    async def ListFilesystems(self, filters):
        '''
        filters : typing.Sequence[~FilesystemFilter]
        Returns -> typing.Sequence[~FilesystemDetailsListResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListFilesystems',
                   version=4,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StoragePoolsResults)
    async def ListPools(self, filters):
        '''
        filters : typing.Sequence[~StoragePoolFilter]
        Returns -> typing.Sequence[~StoragePoolsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListPools',
                   version=4,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageDetailsListResults)
    async def ListStorageDetails(self, filters):
        '''
        filters : typing.Sequence[~StorageFilter]
        Returns -> typing.Sequence[~StorageDetailsListResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListStorageDetails',
                   version=4,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeDetailsListResults)
    async def ListVolumes(self, filters):
        '''
        filters : typing.Sequence[~VolumeFilter]
        Returns -> typing.Sequence[~VolumeDetailsListResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListVolumes',
                   version=4,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, storage):
        '''
        storage : typing.Sequence[~RemoveStorageInstance]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Remove',
                   version=4,
                   params=_params)
        _params['storage'] = storage
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageDetailsResults)
    async def StorageDetails(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StorageDetailsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='StorageDetails',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class StorageProvisionerFacade(Type):
    name = 'StorageProvisioner'
    version = 4
    schema =     {'definitions': {'BlockDevice': {'additionalProperties': False,
                                     'properties': {'BusAddress': {'type': 'string'},
                                                    'DeviceLinks': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                    'DeviceName': {'type': 'string'},
                                                    'FilesystemType': {'type': 'string'},
                                                    'HardwareId': {'type': 'string'},
                                                    'InUse': {'type': 'boolean'},
                                                    'Label': {'type': 'string'},
                                                    'MountPoint': {'type': 'string'},
                                                    'Size': {'type': 'integer'},
                                                    'UUID': {'type': 'string'},
                                                    'WWN': {'type': 'string'}},
                                     'required': ['DeviceName',
                                                  'DeviceLinks',
                                                  'Label',
                                                  'UUID',
                                                  'HardwareId',
                                                  'WWN',
                                                  'BusAddress',
                                                  'Size',
                                                  'FilesystemType',
                                                  'InUse',
                                                  'MountPoint'],
                                     'type': 'object'},
                     'BlockDeviceResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'result': {'$ref': '#/definitions/BlockDevice'}},
                                           'required': ['result'],
                                           'type': 'object'},
                     'BlockDeviceResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/BlockDeviceResult'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Filesystem': {'additionalProperties': False,
                                    'properties': {'filesystem-tag': {'type': 'string'},
                                                   'info': {'$ref': '#/definitions/FilesystemInfo'},
                                                   'volume-tag': {'type': 'string'}},
                                    'required': ['filesystem-tag', 'info'],
                                    'type': 'object'},
                     'FilesystemAttachment': {'additionalProperties': False,
                                              'properties': {'filesystem-tag': {'type': 'string'},
                                                             'info': {'$ref': '#/definitions/FilesystemAttachmentInfo'},
                                                             'machine-tag': {'type': 'string'}},
                                              'required': ['filesystem-tag',
                                                           'machine-tag',
                                                           'info'],
                                              'type': 'object'},
                     'FilesystemAttachmentInfo': {'additionalProperties': False,
                                                  'properties': {'mount-point': {'type': 'string'},
                                                                 'read-only': {'type': 'boolean'}},
                                                  'type': 'object'},
                     'FilesystemAttachmentParams': {'additionalProperties': False,
                                                    'properties': {'filesystem-id': {'type': 'string'},
                                                                   'filesystem-tag': {'type': 'string'},
                                                                   'instance-id': {'type': 'string'},
                                                                   'machine-tag': {'type': 'string'},
                                                                   'mount-point': {'type': 'string'},
                                                                   'provider': {'type': 'string'},
                                                                   'read-only': {'type': 'boolean'}},
                                                    'required': ['filesystem-tag',
                                                                 'machine-tag',
                                                                 'provider'],
                                                    'type': 'object'},
                     'FilesystemAttachmentParamsResult': {'additionalProperties': False,
                                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                         'result': {'$ref': '#/definitions/FilesystemAttachmentParams'}},
                                                          'required': ['result'],
                                                          'type': 'object'},
                     'FilesystemAttachmentParamsResults': {'additionalProperties': False,
                                                           'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemAttachmentParamsResult'},
                                                                                      'type': 'array'}},
                                                           'type': 'object'},
                     'FilesystemAttachmentResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'result': {'$ref': '#/definitions/FilesystemAttachment'}},
                                                    'required': ['result'],
                                                    'type': 'object'},
                     'FilesystemAttachmentResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemAttachmentResult'},
                                                                                'type': 'array'}},
                                                     'type': 'object'},
                     'FilesystemAttachments': {'additionalProperties': False,
                                               'properties': {'filesystem-attachments': {'items': {'$ref': '#/definitions/FilesystemAttachment'},
                                                                                         'type': 'array'}},
                                               'required': ['filesystem-attachments'],
                                               'type': 'object'},
                     'FilesystemInfo': {'additionalProperties': False,
                                        'properties': {'filesystem-id': {'type': 'string'},
                                                       'pool': {'type': 'string'},
                                                       'size': {'type': 'integer'}},
                                        'required': ['filesystem-id',
                                                     'pool',
                                                     'size'],
                                        'type': 'object'},
                     'FilesystemParams': {'additionalProperties': False,
                                          'properties': {'attachment': {'$ref': '#/definitions/FilesystemAttachmentParams'},
                                                         'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                     'type': 'object'}},
                                                                        'type': 'object'},
                                                         'filesystem-tag': {'type': 'string'},
                                                         'provider': {'type': 'string'},
                                                         'size': {'type': 'integer'},
                                                         'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                         'volume-tag': {'type': 'string'}},
                                          'required': ['filesystem-tag',
                                                       'size',
                                                       'provider'],
                                          'type': 'object'},
                     'FilesystemParamsResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/FilesystemParams'}},
                                                'required': ['result'],
                                                'type': 'object'},
                     'FilesystemParamsResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemParamsResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'FilesystemResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'result': {'$ref': '#/definitions/Filesystem'}},
                                          'required': ['result'],
                                          'type': 'object'},
                     'FilesystemResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemResult'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'Filesystems': {'additionalProperties': False,
                                     'properties': {'filesystems': {'items': {'$ref': '#/definitions/Filesystem'},
                                                                    'type': 'array'}},
                                     'required': ['filesystems'],
                                     'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineStorageId': {'additionalProperties': False,
                                          'properties': {'attachment-tag': {'type': 'string'},
                                                         'machine-tag': {'type': 'string'}},
                                          'required': ['machine-tag',
                                                       'attachment-tag'],
                                          'type': 'object'},
                     'MachineStorageIds': {'additionalProperties': False,
                                           'properties': {'ids': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                  'type': 'array'}},
                                           'required': ['ids'],
                                           'type': 'object'},
                     'MachineStorageIdsWatchResult': {'additionalProperties': False,
                                                      'properties': {'changes': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                                 'type': 'array'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'watcher-id': {'type': 'string'}},
                                                      'required': ['watcher-id',
                                                                   'changes'],
                                                      'type': 'object'},
                     'MachineStorageIdsWatchResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/MachineStorageIdsWatchResult'},
                                                                                  'type': 'array'}},
                                                       'required': ['results'],
                                                       'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'RemoveFilesystemParams': {'additionalProperties': False,
                                                'properties': {'destroy': {'type': 'boolean'},
                                                               'filesystem-id': {'type': 'string'},
                                                               'provider': {'type': 'string'}},
                                                'required': ['provider',
                                                             'filesystem-id'],
                                                'type': 'object'},
                     'RemoveFilesystemParamsResult': {'additionalProperties': False,
                                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                     'result': {'$ref': '#/definitions/RemoveFilesystemParams'}},
                                                      'required': ['result'],
                                                      'type': 'object'},
                     'RemoveFilesystemParamsResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/RemoveFilesystemParamsResult'},
                                                                                  'type': 'array'}},
                                                       'type': 'object'},
                     'RemoveVolumeParams': {'additionalProperties': False,
                                            'properties': {'destroy': {'type': 'boolean'},
                                                           'provider': {'type': 'string'},
                                                           'volume-id': {'type': 'string'}},
                                            'required': ['provider', 'volume-id'],
                                            'type': 'object'},
                     'RemoveVolumeParamsResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'result': {'$ref': '#/definitions/RemoveVolumeParams'}},
                                                  'required': ['result'],
                                                  'type': 'object'},
                     'RemoveVolumeParamsResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/RemoveVolumeParamsResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'Volume': {'additionalProperties': False,
                                'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                               'volume-tag': {'type': 'string'}},
                                'required': ['volume-tag', 'info'],
                                'type': 'object'},
                     'VolumeAttachment': {'additionalProperties': False,
                                          'properties': {'info': {'$ref': '#/definitions/VolumeAttachmentInfo'},
                                                         'machine-tag': {'type': 'string'},
                                                         'volume-tag': {'type': 'string'}},
                                          'required': ['volume-tag',
                                                       'machine-tag',
                                                       'info'],
                                          'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeAttachmentParams': {'additionalProperties': False,
                                                'properties': {'instance-id': {'type': 'string'},
                                                               'machine-tag': {'type': 'string'},
                                                               'provider': {'type': 'string'},
                                                               'read-only': {'type': 'boolean'},
                                                               'volume-id': {'type': 'string'},
                                                               'volume-tag': {'type': 'string'}},
                                                'required': ['volume-tag',
                                                             'machine-tag',
                                                             'provider'],
                                                'type': 'object'},
                     'VolumeAttachmentParamsResult': {'additionalProperties': False,
                                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                     'result': {'$ref': '#/definitions/VolumeAttachmentParams'}},
                                                      'required': ['result'],
                                                      'type': 'object'},
                     'VolumeAttachmentParamsResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/VolumeAttachmentParamsResult'},
                                                                                  'type': 'array'}},
                                                       'type': 'object'},
                     'VolumeAttachmentPlan': {'additionalProperties': False,
                                              'properties': {'block-device': {'$ref': '#/definitions/BlockDevice'},
                                                             'life': {'type': 'string'},
                                                             'machine-tag': {'type': 'string'},
                                                             'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                             'volume-tag': {'type': 'string'}},
                                              'required': ['volume-tag',
                                                           'machine-tag',
                                                           'plan-info'],
                                              'type': 'object'},
                     'VolumeAttachmentPlanInfo': {'additionalProperties': False,
                                                  'properties': {'device-attributes': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                       'type': 'object'},
                                                                 'device-type': {'type': 'string'}},
                                                  'type': 'object'},
                     'VolumeAttachmentPlanResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'result': {'$ref': '#/definitions/VolumeAttachmentPlan'}},
                                                    'required': ['result'],
                                                    'type': 'object'},
                     'VolumeAttachmentPlanResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/VolumeAttachmentPlanResult'},
                                                                                'type': 'array'}},
                                                     'type': 'object'},
                     'VolumeAttachmentPlans': {'additionalProperties': False,
                                               'properties': {'volume-plans': {'items': {'$ref': '#/definitions/VolumeAttachmentPlan'},
                                                                               'type': 'array'}},
                                               'required': ['volume-plans'],
                                               'type': 'object'},
                     'VolumeAttachmentResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/VolumeAttachment'}},
                                                'required': ['result'],
                                                'type': 'object'},
                     'VolumeAttachmentResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/VolumeAttachmentResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'VolumeAttachments': {'additionalProperties': False,
                                           'properties': {'volume-attachments': {'items': {'$ref': '#/definitions/VolumeAttachment'},
                                                                                 'type': 'array'}},
                                           'required': ['volume-attachments'],
                                           'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'},
                     'VolumeParams': {'additionalProperties': False,
                                      'properties': {'attachment': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                     'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'},
                                                     'provider': {'type': 'string'},
                                                     'size': {'type': 'integer'},
                                                     'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                              'type': 'object'},
                                                     'volume-tag': {'type': 'string'}},
                                      'required': ['volume-tag',
                                                   'size',
                                                   'provider'],
                                      'type': 'object'},
                     'VolumeParamsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'result': {'$ref': '#/definitions/VolumeParams'}},
                                            'required': ['result'],
                                            'type': 'object'},
                     'VolumeParamsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/VolumeParamsResult'},
                                                                        'type': 'array'}},
                                             'type': 'object'},
                     'VolumeResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'$ref': '#/definitions/Volume'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'VolumeResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/VolumeResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'Volumes': {'additionalProperties': False,
                                 'properties': {'volumes': {'items': {'$ref': '#/definitions/Volume'},
                                                            'type': 'array'}},
                                 'required': ['volumes'],
                                 'type': 'object'}},
     'properties': {'AttachmentLife': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                      'Result': {'$ref': '#/definitions/LifeResults'}},
                                       'type': 'object'},
                    'CreateVolumeAttachmentPlans': {'properties': {'Params': {'$ref': '#/definitions/VolumeAttachmentPlans'},
                                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                    'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'FilesystemAttachmentParams': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                                  'Result': {'$ref': '#/definitions/FilesystemAttachmentParamsResults'}},
                                                   'type': 'object'},
                    'FilesystemAttachments': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                             'Result': {'$ref': '#/definitions/FilesystemAttachmentResults'}},
                                              'type': 'object'},
                    'FilesystemParams': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/FilesystemParamsResults'}},
                                         'type': 'object'},
                    'Filesystems': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/FilesystemResults'}},
                                    'type': 'object'},
                    'InstanceId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'RemoveAttachment': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'RemoveFilesystemParams': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/RemoveFilesystemParamsResults'}},
                                               'type': 'object'},
                    'RemoveVolumeAttachmentPlan': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                   'type': 'object'},
                    'RemoveVolumeParams': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/RemoveVolumeParamsResults'}},
                                           'type': 'object'},
                    'SetFilesystemAttachmentInfo': {'properties': {'Params': {'$ref': '#/definitions/FilesystemAttachments'},
                                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                    'type': 'object'},
                    'SetFilesystemInfo': {'properties': {'Params': {'$ref': '#/definitions/Filesystems'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetVolumeAttachmentInfo': {'properties': {'Params': {'$ref': '#/definitions/VolumeAttachments'},
                                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                'type': 'object'},
                    'SetVolumeAttachmentPlanBlockInfo': {'properties': {'Params': {'$ref': '#/definitions/VolumeAttachmentPlans'},
                                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                         'type': 'object'},
                    'SetVolumeInfo': {'properties': {'Params': {'$ref': '#/definitions/Volumes'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'VolumeAttachmentParams': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                              'Result': {'$ref': '#/definitions/VolumeAttachmentParamsResults'}},
                                               'type': 'object'},
                    'VolumeAttachmentPlans': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                             'Result': {'$ref': '#/definitions/VolumeAttachmentPlanResults'}},
                                              'type': 'object'},
                    'VolumeAttachments': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                         'Result': {'$ref': '#/definitions/VolumeAttachmentResults'}},
                                          'type': 'object'},
                    'VolumeBlockDevices': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                          'Result': {'$ref': '#/definitions/BlockDeviceResults'}},
                                           'type': 'object'},
                    'VolumeParams': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/VolumeParamsResults'}},
                                     'type': 'object'},
                    'Volumes': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/VolumeResults'}},
                                'type': 'object'},
                    'WatchApplications': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                          'type': 'object'},
                    'WatchBlockDevices': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                          'type': 'object'},
                    'WatchFilesystemAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResults'}},
                                                   'type': 'object'},
                    'WatchFilesystems': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                         'type': 'object'},
                    'WatchMachines': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                      'type': 'object'},
                    'WatchVolumeAttachmentPlans': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResults'}},
                                                   'type': 'object'},
                    'WatchVolumeAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResults'}},
                                               'type': 'object'},
                    'WatchVolumes': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                     'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(LifeResults)
    async def AttachmentLife(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~LifeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='AttachmentLife',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def CreateVolumeAttachmentPlans(self, volume_plans):
        '''
        volume_plans : typing.Sequence[~VolumeAttachmentPlan]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='CreateVolumeAttachmentPlans',
                   version=4,
                   params=_params)
        _params['volume-plans'] = volume_plans
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='EnsureDead',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemAttachmentParamsResults)
    async def FilesystemAttachmentParams(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~FilesystemAttachmentParamsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='FilesystemAttachmentParams',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemAttachmentResults)
    async def FilesystemAttachments(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~FilesystemAttachmentResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='FilesystemAttachments',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemParamsResults)
    async def FilesystemParams(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~FilesystemParamsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='FilesystemParams',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemResults)
    async def Filesystems(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~FilesystemResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Filesystems',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def InstanceId(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='InstanceId',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~LifeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Life',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Remove',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveAttachment(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='RemoveAttachment',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoveFilesystemParamsResults)
    async def RemoveFilesystemParams(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~RemoveFilesystemParamsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='RemoveFilesystemParams',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveVolumeAttachmentPlan(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='RemoveVolumeAttachmentPlan',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoveVolumeParamsResults)
    async def RemoveVolumeParams(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~RemoveVolumeParamsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='RemoveVolumeParams',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetFilesystemAttachmentInfo(self, filesystem_attachments):
        '''
        filesystem_attachments : typing.Sequence[~FilesystemAttachment]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetFilesystemAttachmentInfo',
                   version=4,
                   params=_params)
        _params['filesystem-attachments'] = filesystem_attachments
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetFilesystemInfo(self, filesystems):
        '''
        filesystems : typing.Sequence[~Filesystem]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetFilesystemInfo',
                   version=4,
                   params=_params)
        _params['filesystems'] = filesystems
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetVolumeAttachmentInfo(self, volume_attachments):
        '''
        volume_attachments : typing.Sequence[~VolumeAttachment]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetVolumeAttachmentInfo',
                   version=4,
                   params=_params)
        _params['volume-attachments'] = volume_attachments
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetVolumeAttachmentPlanBlockInfo(self, volume_plans):
        '''
        volume_plans : typing.Sequence[~VolumeAttachmentPlan]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetVolumeAttachmentPlanBlockInfo',
                   version=4,
                   params=_params)
        _params['volume-plans'] = volume_plans
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetVolumeInfo(self, volumes):
        '''
        volumes : typing.Sequence[~Volume]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetVolumeInfo',
                   version=4,
                   params=_params)
        _params['volumes'] = volumes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='UpdateStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeAttachmentParamsResults)
    async def VolumeAttachmentParams(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~VolumeAttachmentParamsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeAttachmentParams',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeAttachmentPlanResults)
    async def VolumeAttachmentPlans(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~VolumeAttachmentPlanResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeAttachmentPlans',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeAttachmentResults)
    async def VolumeAttachments(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~VolumeAttachmentResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeAttachments',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BlockDeviceResults)
    async def VolumeBlockDevices(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~BlockDeviceResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeBlockDevices',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeParamsResults)
    async def VolumeParams(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~VolumeParamsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeParams',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeResults)
    async def Volumes(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~VolumeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Volumes',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchApplications(self):
        '''

        Returns -> typing.Union[typing.Sequence[str], _ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchApplications',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchBlockDevices(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchBlockDevices',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineStorageIdsWatchResults)
    async def WatchFilesystemAttachments(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MachineStorageIdsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchFilesystemAttachments',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchFilesystems(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchFilesystems',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMachines(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchMachines',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineStorageIdsWatchResults)
    async def WatchVolumeAttachmentPlans(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MachineStorageIdsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchVolumeAttachmentPlans',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineStorageIdsWatchResults)
    async def WatchVolumeAttachments(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MachineStorageIdsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchVolumeAttachments',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchVolumes(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchVolumes',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class UniterFacade(Type):
    name = 'Uniter'
    version = 4
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Action': {'additionalProperties': False,
                                'properties': {'name': {'type': 'string'},
                                               'parameters': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                               'receiver': {'type': 'string'},
                                               'tag': {'type': 'string'}},
                                'required': ['tag', 'receiver', 'name'],
                                'type': 'object'},
                     'ActionExecutionResult': {'additionalProperties': False,
                                               'properties': {'action-tag': {'type': 'string'},
                                                              'message': {'type': 'string'},
                                                              'results': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'},
                                                              'status': {'type': 'string'}},
                                               'required': ['action-tag', 'status'],
                                               'type': 'object'},
                     'ActionExecutionResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/ActionExecutionResult'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'ActionResult': {'additionalProperties': False,
                                      'properties': {'action': {'$ref': '#/definitions/Action'},
                                                     'completed': {'format': 'date-time',
                                                                   'type': 'string'},
                                                     'enqueued': {'format': 'date-time',
                                                                  'type': 'string'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'message': {'type': 'string'},
                                                     'output': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'started': {'format': 'date-time',
                                                                 'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'type': 'object'},
                     'ActionResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'ApplicationStatusResult': {'additionalProperties': False,
                                                 'properties': {'application': {'$ref': '#/definitions/StatusResult'},
                                                                'error': {'$ref': '#/definitions/Error'},
                                                                'units': {'patternProperties': {'.*': {'$ref': '#/definitions/StatusResult'}},
                                                                          'type': 'object'}},
                                                 'required': ['application',
                                                              'units'],
                                                 'type': 'object'},
                     'ApplicationStatusResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationStatusResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BoolResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/BoolResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'CharmURL': {'additionalProperties': False,
                                  'properties': {'url': {'type': 'string'}},
                                  'required': ['url'],
                                  'type': 'object'},
                     'CharmURLs': {'additionalProperties': False,
                                   'properties': {'urls': {'items': {'$ref': '#/definitions/CharmURL'},
                                                           'type': 'array'}},
                                   'required': ['urls'],
                                   'type': 'object'},
                     'ConfigSettingsResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                              'required': ['settings'],
                                              'type': 'object'},
                     'ConfigSettingsResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/ConfigSettingsResult'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'Endpoint': {'additionalProperties': False,
                                  'properties': {'application-name': {'type': 'string'},
                                                 'relation': {'$ref': '#/definitions/CharmRelation'}},
                                  'required': ['application-name', 'relation'],
                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'EntitiesCharmURL': {'additionalProperties': False,
                                          'properties': {'entities': {'items': {'$ref': '#/definitions/EntityCharmURL'},
                                                                      'type': 'array'}},
                                          'required': ['entities'],
                                          'type': 'object'},
                     'EntitiesPortRanges': {'additionalProperties': False,
                                            'properties': {'entities': {'items': {'$ref': '#/definitions/EntityPortRange'},
                                                                        'type': 'array'}},
                                            'required': ['entities'],
                                            'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityCharmURL': {'additionalProperties': False,
                                        'properties': {'charm-url': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'charm-url'],
                                        'type': 'object'},
                     'EntityPortRange': {'additionalProperties': False,
                                         'properties': {'from-port': {'type': 'integer'},
                                                        'protocol': {'type': 'string'},
                                                        'tag': {'type': 'string'},
                                                        'to-port': {'type': 'integer'}},
                                         'required': ['tag',
                                                      'protocol',
                                                      'from-port',
                                                      'to-port'],
                                         'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'EntityWorkloadVersion': {'additionalProperties': False,
                                               'properties': {'tag': {'type': 'string'},
                                                              'workload-version': {'type': 'string'}},
                                               'required': ['tag',
                                                            'workload-version'],
                                               'type': 'object'},
                     'EntityWorkloadVersions': {'additionalProperties': False,
                                                'properties': {'entities': {'items': {'$ref': '#/definitions/EntityWorkloadVersion'},
                                                                            'type': 'array'}},
                                                'required': ['entities'],
                                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'GetLeadershipSettingsBulkResults': {'additionalProperties': False,
                                                          'properties': {'results': {'items': {'$ref': '#/definitions/GetLeadershipSettingsResult'},
                                                                                     'type': 'array'}},
                                                          'required': ['results'],
                                                          'type': 'object'},
                     'GetLeadershipSettingsResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                 'type': 'object'}},
                                                     'required': ['settings'],
                                                     'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'}},
                                  'required': ['Address', 'port'],
                                  'type': 'object'},
                     'IntResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'type': 'integer'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'IntResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/IntResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachinePortRange': {'additionalProperties': False,
                                          'properties': {'port-range': {'$ref': '#/definitions/PortRange'},
                                                         'relation-tag': {'type': 'string'},
                                                         'unit-tag': {'type': 'string'}},
                                          'required': ['unit-tag',
                                                       'relation-tag',
                                                       'port-range'],
                                          'type': 'object'},
                     'MachinePortsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'ports': {'items': {'$ref': '#/definitions/MachinePortRange'},
                                                                     'type': 'array'}},
                                            'required': ['ports'],
                                            'type': 'object'},
                     'MachinePortsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/MachinePortsResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'MergeLeadershipSettingsBulkParams': {'additionalProperties': False,
                                                           'properties': {'params': {'items': {'$ref': '#/definitions/MergeLeadershipSettingsParam'},
                                                                                     'type': 'array'}},
                                                           'required': ['params'],
                                                           'type': 'object'},
                     'MergeLeadershipSettingsParam': {'additionalProperties': False,
                                                      'properties': {'application-tag': {'type': 'string'},
                                                                     'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                  'type': 'object'}},
                                                      'required': ['application-tag',
                                                                   'settings'],
                                                      'type': 'object'},
                     'MeterStatusResult': {'additionalProperties': False,
                                           'properties': {'code': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'type': 'string'}},
                                           'required': ['code', 'info'],
                                           'type': 'object'},
                     'MeterStatusResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/MeterStatusResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Metric': {'additionalProperties': False,
                                'properties': {'key': {'type': 'string'},
                                               'time': {'format': 'date-time',
                                                        'type': 'string'},
                                               'value': {'type': 'string'}},
                                'required': ['key', 'value', 'time'],
                                'type': 'object'},
                     'MetricBatch': {'additionalProperties': False,
                                     'properties': {'charm-url': {'type': 'string'},
                                                    'created': {'format': 'date-time',
                                                                'type': 'string'},
                                                    'metrics': {'items': {'$ref': '#/definitions/Metric'},
                                                                'type': 'array'},
                                                    'uuid': {'type': 'string'}},
                                     'required': ['uuid',
                                                  'charm-url',
                                                  'created',
                                                  'metrics'],
                                     'type': 'object'},
                     'MetricBatchParam': {'additionalProperties': False,
                                          'properties': {'batch': {'$ref': '#/definitions/MetricBatch'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'batch'],
                                          'type': 'object'},
                     'MetricBatchParams': {'additionalProperties': False,
                                           'properties': {'batches': {'items': {'$ref': '#/definitions/MetricBatchParam'},
                                                                      'type': 'array'}},
                                           'required': ['batches'],
                                           'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ModelResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'name': {'type': 'string'},
                                                    'uuid': {'type': 'string'}},
                                     'required': ['name', 'uuid'],
                                     'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'PortRange': {'additionalProperties': False,
                                   'properties': {'from-port': {'type': 'integer'},
                                                  'protocol': {'type': 'string'},
                                                  'to-port': {'type': 'integer'}},
                                   'required': ['from-port', 'to-port', 'protocol'],
                                   'type': 'object'},
                     'RelationIds': {'additionalProperties': False,
                                     'properties': {'relation-ids': {'items': {'type': 'integer'},
                                                                     'type': 'array'}},
                                     'required': ['relation-ids'],
                                     'type': 'object'},
                     'RelationResult': {'additionalProperties': False,
                                        'properties': {'endpoint': {'$ref': '#/definitions/Endpoint'},
                                                       'error': {'$ref': '#/definitions/Error'},
                                                       'id': {'type': 'integer'},
                                                       'key': {'type': 'string'},
                                                       'life': {'type': 'string'}},
                                        'required': ['life',
                                                     'id',
                                                     'key',
                                                     'endpoint'],
                                        'type': 'object'},
                     'RelationResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/RelationResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'RelationUnit': {'additionalProperties': False,
                                      'properties': {'relation': {'type': 'string'},
                                                     'unit': {'type': 'string'}},
                                      'required': ['relation', 'unit'],
                                      'type': 'object'},
                     'RelationUnitPair': {'additionalProperties': False,
                                          'properties': {'local-unit': {'type': 'string'},
                                                         'relation': {'type': 'string'},
                                                         'remote-unit': {'type': 'string'}},
                                          'required': ['relation',
                                                       'local-unit',
                                                       'remote-unit'],
                                          'type': 'object'},
                     'RelationUnitPairs': {'additionalProperties': False,
                                           'properties': {'relation-unit-pairs': {'items': {'$ref': '#/definitions/RelationUnitPair'},
                                                                                  'type': 'array'}},
                                           'required': ['relation-unit-pairs'],
                                           'type': 'object'},
                     'RelationUnitSettings': {'additionalProperties': False,
                                              'properties': {'relation': {'type': 'string'},
                                                             'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'},
                                                             'unit': {'type': 'string'}},
                                              'required': ['relation',
                                                           'unit',
                                                           'settings'],
                                              'type': 'object'},
                     'RelationUnits': {'additionalProperties': False,
                                       'properties': {'relation-units': {'items': {'$ref': '#/definitions/RelationUnit'},
                                                                         'type': 'array'}},
                                       'required': ['relation-units'],
                                       'type': 'object'},
                     'RelationUnitsChange': {'additionalProperties': False,
                                             'properties': {'changed': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitSettings'}},
                                                                        'type': 'object'},
                                                            'departed': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                             'required': ['changed'],
                                             'type': 'object'},
                     'RelationUnitsSettings': {'additionalProperties': False,
                                               'properties': {'relation-units': {'items': {'$ref': '#/definitions/RelationUnitSettings'},
                                                                                 'type': 'array'}},
                                               'required': ['relation-units'],
                                               'type': 'object'},
                     'RelationUnitsWatchResult': {'additionalProperties': False,
                                                  'properties': {'changes': {'$ref': '#/definitions/RelationUnitsChange'},
                                                                 'error': {'$ref': '#/definitions/Error'},
                                                                 'watcher-id': {'type': 'string'}},
                                                  'required': ['watcher-id',
                                                               'changes'],
                                                  'type': 'object'},
                     'RelationUnitsWatchResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/RelationUnitsWatchResult'},
                                                                              'type': 'array'}},
                                                   'required': ['results'],
                                                   'type': 'object'},
                     'ResolvedModeResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'mode': {'type': 'string'}},
                                            'required': ['mode'],
                                            'type': 'object'},
                     'ResolvedModeResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/ResolvedModeResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'SettingsResult': {'additionalProperties': False,
                                        'properties': {'error': {'$ref': '#/definitions/Error'},
                                                       'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                    'type': 'object'}},
                                        'required': ['settings'],
                                        'type': 'object'},
                     'SettingsResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/SettingsResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'StatusResult': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'id': {'type': 'string'},
                                                     'info': {'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['id',
                                                   'life',
                                                   'status',
                                                   'info',
                                                   'data',
                                                   'since'],
                                      'type': 'object'},
                     'StatusResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StatusResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StorageAddParams': {'additionalProperties': False,
                                          'properties': {'name': {'type': 'string'},
                                                         'storage': {'$ref': '#/definitions/StorageConstraints'},
                                                         'unit': {'type': 'string'}},
                                          'required': ['unit', 'name', 'storage'],
                                          'type': 'object'},
                     'StorageAttachment': {'additionalProperties': False,
                                           'properties': {'kind': {'type': 'integer'},
                                                          'life': {'type': 'string'},
                                                          'location': {'type': 'string'},
                                                          'owner-tag': {'type': 'string'},
                                                          'storage-tag': {'type': 'string'},
                                                          'unit-tag': {'type': 'string'}},
                                           'required': ['storage-tag',
                                                        'owner-tag',
                                                        'unit-tag',
                                                        'kind',
                                                        'location',
                                                        'life'],
                                           'type': 'object'},
                     'StorageAttachmentId': {'additionalProperties': False,
                                             'properties': {'storage-tag': {'type': 'string'},
                                                            'unit-tag': {'type': 'string'}},
                                             'required': ['storage-tag',
                                                          'unit-tag'],
                                             'type': 'object'},
                     'StorageAttachmentIds': {'additionalProperties': False,
                                              'properties': {'ids': {'items': {'$ref': '#/definitions/StorageAttachmentId'},
                                                                     'type': 'array'}},
                                              'required': ['ids'],
                                              'type': 'object'},
                     'StorageAttachmentIdsResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'result': {'$ref': '#/definitions/StorageAttachmentIds'}},
                                                    'required': ['result'],
                                                    'type': 'object'},
                     'StorageAttachmentIdsResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/StorageAttachmentIdsResult'},
                                                                                'type': 'array'}},
                                                     'type': 'object'},
                     'StorageAttachmentResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/StorageAttachment'}},
                                                 'required': ['result'],
                                                 'type': 'object'},
                     'StorageAttachmentResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/StorageAttachmentResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StoragesAddParams': {'additionalProperties': False,
                                           'properties': {'storages': {'items': {'$ref': '#/definitions/StorageAddParams'},
                                                                       'type': 'array'}},
                                           'required': ['storages'],
                                           'type': 'object'},
                     'StringBoolResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'ok': {'type': 'boolean'},
                                                         'result': {'type': 'string'}},
                                          'required': ['result', 'ok'],
                                          'type': 'object'},
                     'StringBoolResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/StringBoolResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'UnitNetworkConfig': {'additionalProperties': False,
                                           'properties': {'binding-name': {'type': 'string'},
                                                          'unit-tag': {'type': 'string'}},
                                           'required': ['unit-tag', 'binding-name'],
                                           'type': 'object'},
                     'UnitNetworkConfigResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'info': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                         'type': 'array'}},
                                                 'required': ['info'],
                                                 'type': 'object'},
                     'UnitNetworkConfigResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/UnitNetworkConfigResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'UnitSettings': {'additionalProperties': False,
                                      'properties': {'version': {'type': 'integer'}},
                                      'required': ['version'],
                                      'type': 'object'},
                     'UnitsNetworkConfig': {'additionalProperties': False,
                                            'properties': {'args': {'items': {'$ref': '#/definitions/UnitNetworkConfig'},
                                                                    'type': 'array'}},
                                            'required': ['args'],
                                            'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'Actions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'AddMetricBatches': {'properties': {'Params': {'$ref': '#/definitions/MetricBatchParams'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'AddUnitStorage': {'properties': {'Params': {'$ref': '#/definitions/StoragesAddParams'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'AllMachinePorts': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/MachinePortsResults'}},
                                        'type': 'object'},
                    'ApplicationStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ApplicationStatusResults'}},
                                          'type': 'object'},
                    'AssignedMachine': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/StringResults'}},
                                        'type': 'object'},
                    'AvailabilityZone': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/StringResults'}},
                                         'type': 'object'},
                    'BeginActions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'CharmArchiveSha256': {'properties': {'Params': {'$ref': '#/definitions/CharmURLs'},
                                                          'Result': {'$ref': '#/definitions/StringResults'}},
                                           'type': 'object'},
                    'CharmModifiedVersion': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                            'Result': {'$ref': '#/definitions/IntResults'}},
                                             'type': 'object'},
                    'CharmURL': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                'Result': {'$ref': '#/definitions/StringBoolResults'}},
                                 'type': 'object'},
                    'ClearResolved': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'ClosePorts': {'properties': {'Params': {'$ref': '#/definitions/EntitiesPortRanges'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'ConfigSettings': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/ConfigSettingsResults'}},
                                       'type': 'object'},
                    'CurrentModel': {'properties': {'Result': {'$ref': '#/definitions/ModelResult'}},
                                     'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'DestroyAllSubordinates': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'DestroyUnitStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                      'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'EnterScope': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'FinishActions': {'properties': {'Params': {'$ref': '#/definitions/ActionExecutionResults'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'GetMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/MeterStatusResults'}},
                                       'type': 'object'},
                    'GetPrincipal': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/StringBoolResults'}},
                                     'type': 'object'},
                    'HasSubordinates': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/BoolResults'}},
                                        'type': 'object'},
                    'JoinedRelations': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/StringsResults'}},
                                        'type': 'object'},
                    'LeaveScope': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'Merge': {'properties': {'Params': {'$ref': '#/definitions/MergeLeadershipSettingsBulkParams'},
                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                              'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'NetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/UnitsNetworkConfig'},
                                                     'Result': {'$ref': '#/definitions/UnitNetworkConfigResults'}},
                                      'type': 'object'},
                    'OpenPorts': {'properties': {'Params': {'$ref': '#/definitions/EntitiesPortRanges'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'PrivateAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StringResults'}},
                                       'type': 'object'},
                    'ProviderType': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'PublicAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/StringResults'}},
                                      'type': 'object'},
                    'Read': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/GetLeadershipSettingsBulkResults'}},
                             'type': 'object'},
                    'ReadRemoteSettings': {'properties': {'Params': {'$ref': '#/definitions/RelationUnitPairs'},
                                                          'Result': {'$ref': '#/definitions/SettingsResults'}},
                                           'type': 'object'},
                    'ReadSettings': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                    'Result': {'$ref': '#/definitions/SettingsResults'}},
                                     'type': 'object'},
                    'Relation': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                'Result': {'$ref': '#/definitions/RelationResults'}},
                                 'type': 'object'},
                    'RelationById': {'properties': {'Params': {'$ref': '#/definitions/RelationIds'},
                                                    'Result': {'$ref': '#/definitions/RelationResults'}},
                                     'type': 'object'},
                    'RemoveStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                 'type': 'object'},
                    'RequestReboot': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'Resolved': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                'Result': {'$ref': '#/definitions/ResolvedModeResults'}},
                                 'type': 'object'},
                    'SetAgentStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'SetApplicationStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'SetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/EntitiesCharmURL'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetUnitStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'SetWorkloadVersion': {'properties': {'Params': {'$ref': '#/definitions/EntityWorkloadVersions'},
                                                          'Result': {'$ref': '#/definitions/ErrorResults'}},
                                           'type': 'object'},
                    'StorageAttachmentLife': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                             'Result': {'$ref': '#/definitions/LifeResults'}},
                                              'type': 'object'},
                    'StorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                          'Result': {'$ref': '#/definitions/StorageAttachmentResults'}},
                                           'type': 'object'},
                    'UnitStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StatusResults'}},
                                   'type': 'object'},
                    'UnitStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/StorageAttachmentIdsResults'}},
                                               'type': 'object'},
                    'UpdateSettings': {'properties': {'Params': {'$ref': '#/definitions/RelationUnitsSettings'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'Watch': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchActionNotifications': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                 'type': 'object'},
                    'WatchApplicationRelations': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                  'type': 'object'},
                    'WatchConfigSettings': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                            'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'},
                    'WatchLeadershipSettings': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                'type': 'object'},
                    'WatchMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                         'type': 'object'},
                    'WatchRelationUnits': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                          'Result': {'$ref': '#/definitions/RelationUnitsWatchResults'}},
                                           'type': 'object'},
                    'WatchStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                               'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                'type': 'object'},
                    'WatchUnitAddresses': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                           'type': 'object'},
                    'WatchUnitStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                   'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                    'type': 'object'},
                    'WorkloadVersion': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/StringResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), typing.Sequence[str]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='APIAddresses',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> typing.Sequence[~HostPort]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='APIHostPorts',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Actions(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Actions',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def AddMetricBatches(self, batches):
        '''
        batches : typing.Sequence[~MetricBatchParam]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AddMetricBatches',
                   version=4,
                   params=_params)
        _params['batches'] = batches
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def AddUnitStorage(self, storages):
        '''
        storages : typing.Sequence[~StorageAddParams]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AddUnitStorage',
                   version=4,
                   params=_params)
        _params['storages'] = storages
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachinePortsResults)
    async def AllMachinePorts(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MachinePortsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AllMachinePorts',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationStatusResults)
    async def ApplicationStatus(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ApplicationStatusResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ApplicationStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def AssignedMachine(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AssignedMachine',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def AvailabilityZone(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AvailabilityZone',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def BeginActions(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='BeginActions',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> typing.Sequence[int]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CACert',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def CharmArchiveSha256(self, urls):
        '''
        urls : typing.Sequence[~CharmURL]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CharmArchiveSha256',
                   version=4,
                   params=_params)
        _params['urls'] = urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IntResults)
    async def CharmModifiedVersion(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~IntResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CharmModifiedVersion',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringBoolResults)
    async def CharmURL(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringBoolResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CharmURL',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ClearResolved(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ClearResolved',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ClosePorts(self, entities):
        '''
        entities : typing.Sequence[~EntityPortRange]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ClosePorts',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConfigSettingsResults)
    async def ConfigSettings(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ConfigSettingsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ConfigSettings',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelResult)
    async def CurrentModel(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CurrentModel',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Destroy(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Destroy',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyAllSubordinates(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='DestroyAllSubordinates',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyUnitStorageAttachments(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='DestroyUnitStorageAttachments',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='EnsureDead',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnterScope(self, relation_units):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='EnterScope',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def FinishActions(self, results):
        '''
        results : typing.Sequence[~ActionExecutionResult]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='FinishActions',
                   version=4,
                   params=_params)
        _params['results'] = results
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MeterStatusResults)
    async def GetMeterStatus(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MeterStatusResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='GetMeterStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringBoolResults)
    async def GetPrincipal(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringBoolResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='GetPrincipal',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResults)
    async def HasSubordinates(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~BoolResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='HasSubordinates',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def JoinedRelations(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='JoinedRelations',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def LeaveScope(self, relation_units):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='LeaveScope',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~LifeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Life',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Merge(self, params):
        '''
        params : typing.Sequence[~MergeLeadershipSettingsParam]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Merge',
                   version=4,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ModelConfig',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ModelUUID',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UnitNetworkConfigResults)
    async def NetworkConfig(self, args):
        '''
        args : typing.Sequence[~UnitNetworkConfig]
        Returns -> typing.Sequence[~UnitNetworkConfigResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='NetworkConfig',
                   version=4,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def OpenPorts(self, entities):
        '''
        entities : typing.Sequence[~EntityPortRange]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='OpenPorts',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def PrivateAddress(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='PrivateAddress',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ProviderType(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ProviderType',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def PublicAddress(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='PublicAddress',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetLeadershipSettingsBulkResults)
    async def Read(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~GetLeadershipSettingsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Read',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SettingsResults)
    async def ReadRemoteSettings(self, relation_unit_pairs):
        '''
        relation_unit_pairs : typing.Sequence[~RelationUnitPair]
        Returns -> typing.Sequence[~SettingsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ReadRemoteSettings',
                   version=4,
                   params=_params)
        _params['relation-unit-pairs'] = relation_unit_pairs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SettingsResults)
    async def ReadSettings(self, relation_units):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> typing.Sequence[~SettingsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ReadSettings',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationResults)
    async def Relation(self, relation_units):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> typing.Sequence[~RelationResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Relation',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationResults)
    async def RelationById(self, relation_ids):
        '''
        relation_ids : typing.Sequence[int]
        Returns -> typing.Sequence[~RelationResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='RelationById',
                   version=4,
                   params=_params)
        _params['relation-ids'] = relation_ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveStorageAttachments(self, ids):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='RemoveStorageAttachments',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RequestReboot(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='RequestReboot',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ResolvedModeResults)
    async def Resolved(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ResolvedModeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Resolved',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetAgentStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetAgentStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetApplicationStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetApplicationStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetCharmURL(self, entities):
        '''
        entities : typing.Sequence[~EntityCharmURL]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetCharmURL',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetUnitStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetUnitStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetWorkloadVersion(self, entities):
        '''
        entities : typing.Sequence[~EntityWorkloadVersion]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetWorkloadVersion',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def StorageAttachmentLife(self, ids):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> typing.Sequence[~LifeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='StorageAttachmentLife',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageAttachmentResults)
    async def StorageAttachments(self, ids):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> typing.Sequence[~StorageAttachmentResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='StorageAttachments',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def UnitStatus(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StatusResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='UnitStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageAttachmentIdsResults)
    async def UnitStorageAttachments(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StorageAttachmentIdsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='UnitStorageAttachments',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateSettings(self, relation_units):
        '''
        relation_units : typing.Sequence[~RelationUnitSettings]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='UpdateSettings',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Watch',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchAPIHostPorts',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchActionNotifications(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchActionNotifications',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchApplicationRelations(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchApplicationRelations',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchConfigSettings(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchConfigSettings',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchForModelConfigChanges',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchLeadershipSettings(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchLeadershipSettings',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMeterStatus(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchMeterStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationUnitsWatchResults)
    async def WatchRelationUnits(self, relation_units):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> typing.Sequence[~RelationUnitsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchRelationUnits',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchStorageAttachments(self, ids):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchStorageAttachments',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchUnitAddresses(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchUnitAddresses',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchUnitStorageAttachments(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchUnitStorageAttachments',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def WorkloadVersion(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WorkloadVersion',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply
