# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client._definitions import *
from juju.client.facade import ReturnMapping, Type


class ActionFacade(Type):
    name = 'Action'
    version = 3
    schema =     {'definitions': {'Action': {'additionalProperties': False,
                                'properties': {'name': {'type': 'string'},
                                               'parameters': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                               'receiver': {'type': 'string'},
                                               'tag': {'type': 'string'}},
                                'required': ['tag', 'receiver', 'name'],
                                'type': 'object'},
                     'ActionResult': {'additionalProperties': False,
                                      'properties': {'action': {'$ref': '#/definitions/Action'},
                                                     'completed': {'format': 'date-time',
                                                                   'type': 'string'},
                                                     'enqueued': {'format': 'date-time',
                                                                  'type': 'string'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'message': {'type': 'string'},
                                                     'output': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'started': {'format': 'date-time',
                                                                 'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'type': 'object'},
                     'ActionResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ActionSpec': {'additionalProperties': False,
                                    'properties': {'description': {'type': 'string'},
                                                   'params': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'}},
                                    'required': ['description', 'params'],
                                    'type': 'object'},
                     'Actions': {'additionalProperties': False,
                                 'properties': {'actions': {'items': {'$ref': '#/definitions/Action'},
                                                            'type': 'array'}},
                                 'type': 'object'},
                     'ActionsByName': {'additionalProperties': False,
                                       'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'},
                                                      'error': {'$ref': '#/definitions/Error'},
                                                      'name': {'type': 'string'}},
                                       'type': 'object'},
                     'ActionsByNames': {'additionalProperties': False,
                                        'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByName'},
                                                                   'type': 'array'}},
                                        'type': 'object'},
                     'ActionsByReceiver': {'additionalProperties': False,
                                           'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                      'type': 'array'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'receiver': {'type': 'string'}},
                                           'type': 'object'},
                     'ActionsByReceivers': {'additionalProperties': False,
                                            'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByReceiver'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'ApplicationCharmActionsResult': {'additionalProperties': False,
                                                       'properties': {'actions': {'patternProperties': {'.*': {'$ref': '#/definitions/ActionSpec'}},
                                                                                  'type': 'object'},
                                                                      'application-tag': {'type': 'string'},
                                                                      'error': {'$ref': '#/definitions/Error'}},
                                                       'type': 'object'},
                     'ApplicationsCharmActionsResults': {'additionalProperties': False,
                                                         'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationCharmActionsResult'},
                                                                                    'type': 'array'}},
                                                         'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'FindActionsByNames': {'additionalProperties': False,
                                            'properties': {'names': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                            'type': 'object'},
                     'FindTags': {'additionalProperties': False,
                                  'properties': {'prefixes': {'items': {'type': 'string'},
                                                              'type': 'array'}},
                                  'required': ['prefixes'],
                                  'type': 'object'},
                     'FindTagsResults': {'additionalProperties': False,
                                         'properties': {'matches': {'patternProperties': {'.*': {'items': {'$ref': '#/definitions/Entity'},
                                                                                                 'type': 'array'}},
                                                                    'type': 'object'}},
                                         'required': ['matches'],
                                         'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RunParams': {'additionalProperties': False,
                                   'properties': {'applications': {'items': {'type': 'string'},
                                                                   'type': 'array'},
                                                  'commands': {'type': 'string'},
                                                  'machines': {'items': {'type': 'string'},
                                                               'type': 'array'},
                                                  'timeout': {'type': 'integer'},
                                                  'units': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                   'required': ['commands', 'timeout'],
                                   'type': 'object'}},
     'properties': {'Actions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'ApplicationsCharmsActions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/ApplicationsCharmActionsResults'}},
                                                  'type': 'object'},
                    'Cancel': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ActionResults'}},
                               'type': 'object'},
                    'Enqueue': {'properties': {'Params': {'$ref': '#/definitions/Actions'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'FindActionTagsByPrefix': {'properties': {'Params': {'$ref': '#/definitions/FindTags'},
                                                              'Result': {'$ref': '#/definitions/FindTagsResults'}},
                                               'type': 'object'},
                    'FindActionsByNames': {'properties': {'Params': {'$ref': '#/definitions/FindActionsByNames'},
                                                          'Result': {'$ref': '#/definitions/ActionsByNames'}},
                                           'type': 'object'},
                    'ListAll': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                'type': 'object'},
                    'ListCompleted': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                      'type': 'object'},
                    'ListPending': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                    'type': 'object'},
                    'ListRunning': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                    'type': 'object'},
                    'Run': {'properties': {'Params': {'$ref': '#/definitions/RunParams'},
                                           'Result': {'$ref': '#/definitions/ActionResults'}},
                            'type': 'object'},
                    'RunOnAllMachines': {'properties': {'Params': {'$ref': '#/definitions/RunParams'},
                                                        'Result': {'$ref': '#/definitions/ActionResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ActionResults)
    async def Actions(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Actions',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationsCharmActionsResults)
    async def ApplicationsCharmsActions(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ApplicationCharmActionsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ApplicationsCharmsActions',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Cancel(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Cancel',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Enqueue(self, actions):
        '''
        actions : typing.Sequence[~Action]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Enqueue',
                   version=3,
                   params=_params)
        _params['actions'] = actions
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindTagsResults)
    async def FindActionTagsByPrefix(self, prefixes):
        '''
        prefixes : typing.Sequence[str]
        Returns -> typing.Sequence[~Entity]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='FindActionTagsByPrefix',
                   version=3,
                   params=_params)
        _params['prefixes'] = prefixes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByNames)
    async def FindActionsByNames(self, names):
        '''
        names : typing.Sequence[str]
        Returns -> typing.Sequence[~ActionsByName]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='FindActionsByNames',
                   version=3,
                   params=_params)
        _params['names'] = names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListAll(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionsByReceiver]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListAll',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListCompleted(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionsByReceiver]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListCompleted',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListPending(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionsByReceiver]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListPending',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListRunning(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionsByReceiver]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListRunning',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Run(self, applications, commands, machines, timeout, units):
        '''
        applications : typing.Sequence[str]
        commands : str
        machines : typing.Sequence[str]
        timeout : int
        units : typing.Sequence[str]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Run',
                   version=3,
                   params=_params)
        _params['applications'] = applications
        _params['commands'] = commands
        _params['machines'] = machines
        _params['timeout'] = timeout
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def RunOnAllMachines(self, applications, commands, machines, timeout, units):
        '''
        applications : typing.Sequence[str]
        commands : str
        machines : typing.Sequence[str]
        timeout : int
        units : typing.Sequence[str]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='RunOnAllMachines',
                   version=3,
                   params=_params)
        _params['applications'] = applications
        _params['commands'] = commands
        _params['machines'] = machines
        _params['timeout'] = timeout
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



class ApplicationFacade(Type):
    name = 'Application'
    version = 3
    schema =     {'definitions': {'AddApplicationUnits': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'num-units': {'type': 'integer'},
                                                            'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                          'type': 'array'}},
                                             'required': ['application',
                                                          'num-units',
                                                          'placement'],
                                             'type': 'object'},
                     'AddApplicationUnitsResults': {'additionalProperties': False,
                                                    'properties': {'units': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                                    'required': ['units'],
                                                    'type': 'object'},
                     'AddRelation': {'additionalProperties': False,
                                     'properties': {'endpoints': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                     'required': ['endpoints'],
                                     'type': 'object'},
                     'AddRelationResults': {'additionalProperties': False,
                                            'properties': {'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                                         'type': 'object'}},
                                            'required': ['endpoints'],
                                            'type': 'object'},
                     'ApplicationCharmRelations': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'ApplicationCharmRelationsResults': {'additionalProperties': False,
                                                          'properties': {'charm-relations': {'items': {'type': 'string'},
                                                                                             'type': 'array'}},
                                                          'required': ['charm-relations'],
                                                          'type': 'object'},
                     'ApplicationDeploy': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'channel': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                          'config-yaml': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'num-units': {'type': 'integer'},
                                                          'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                        'type': 'array'},
                                                          'resources': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'}},
                                           'required': ['application',
                                                        'series',
                                                        'charm-url',
                                                        'channel',
                                                        'num-units',
                                                        'config-yaml',
                                                        'constraints'],
                                           'type': 'object'},
                     'ApplicationDestroy': {'additionalProperties': False,
                                            'properties': {'application': {'type': 'string'}},
                                            'required': ['application'],
                                            'type': 'object'},
                     'ApplicationExpose': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'}},
                                           'required': ['application'],
                                           'type': 'object'},
                     'ApplicationGet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'}},
                                        'required': ['application'],
                                        'type': 'object'},
                     'ApplicationGetResults': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'charm': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'constraints': {'$ref': '#/definitions/Value'},
                                                              'series': {'type': 'string'}},
                                               'required': ['application',
                                                            'charm',
                                                            'config',
                                                            'constraints',
                                                            'series'],
                                               'type': 'object'},
                     'ApplicationMetricCredential': {'additionalProperties': False,
                                                     'properties': {'application': {'type': 'string'},
                                                                    'metrics-credentials': {'items': {'type': 'integer'},
                                                                                            'type': 'array'}},
                                                     'required': ['application',
                                                                  'metrics-credentials'],
                                                     'type': 'object'},
                     'ApplicationMetricCredentials': {'additionalProperties': False,
                                                      'properties': {'creds': {'items': {'$ref': '#/definitions/ApplicationMetricCredential'},
                                                                               'type': 'array'}},
                                                      'required': ['creds'],
                                                      'type': 'object'},
                     'ApplicationSet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'options': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'}},
                                        'required': ['application', 'options'],
                                        'type': 'object'},
                     'ApplicationSetCharm': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'channel': {'type': 'string'},
                                                            'charm-url': {'type': 'string'},
                                                            'config-settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                            'config-settings-yaml': {'type': 'string'},
                                                            'force-series': {'type': 'boolean'},
                                                            'force-units': {'type': 'boolean'},
                                                            'resource-ids': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                            'storage-constraints': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageConstraints'}},
                                                                                    'type': 'object'}},
                                             'required': ['application',
                                                          'charm-url',
                                                          'channel',
                                                          'force-units',
                                                          'force-series'],
                                             'type': 'object'},
                     'ApplicationUnexpose': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'}},
                                             'required': ['application'],
                                             'type': 'object'},
                     'ApplicationUnset': {'additionalProperties': False,
                                          'properties': {'application': {'type': 'string'},
                                                         'options': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                          'required': ['application', 'options'],
                                          'type': 'object'},
                     'ApplicationUpdate': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'force-charm-url': {'type': 'boolean'},
                                                          'force-series': {'type': 'boolean'},
                                                          'min-units': {'type': 'integer'},
                                                          'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                       'type': 'object'},
                                                          'settings-yaml': {'type': 'string'}},
                                           'required': ['application',
                                                        'charm-url',
                                                        'force-charm-url',
                                                        'force-series',
                                                        'settings-yaml'],
                                           'type': 'object'},
                     'ApplicationsDeploy': {'additionalProperties': False,
                                            'properties': {'applications': {'items': {'$ref': '#/definitions/ApplicationDeploy'},
                                                                            'type': 'array'}},
                                            'required': ['applications'],
                                            'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'DestroyApplicationUnits': {'additionalProperties': False,
                                                 'properties': {'unit-names': {'items': {'type': 'string'},
                                                                               'type': 'array'}},
                                                 'required': ['unit-names'],
                                                 'type': 'object'},
                     'DestroyRelation': {'additionalProperties': False,
                                         'properties': {'endpoints': {'items': {'type': 'string'},
                                                                      'type': 'array'}},
                                         'required': ['endpoints'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'GetApplicationConstraints': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'GetConstraintsResults': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'AddRelation': {'properties': {'Params': {'$ref': '#/definitions/AddRelation'},
                                                   'Result': {'$ref': '#/definitions/AddRelationResults'}},
                                    'type': 'object'},
                    'AddUnits': {'properties': {'Params': {'$ref': '#/definitions/AddApplicationUnits'},
                                                'Result': {'$ref': '#/definitions/AddApplicationUnitsResults'}},
                                 'type': 'object'},
                    'CharmRelations': {'properties': {'Params': {'$ref': '#/definitions/ApplicationCharmRelations'},
                                                      'Result': {'$ref': '#/definitions/ApplicationCharmRelationsResults'}},
                                       'type': 'object'},
                    'Deploy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationsDeploy'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationDestroy'}},
                                'type': 'object'},
                    'DestroyRelation': {'properties': {'Params': {'$ref': '#/definitions/DestroyRelation'}},
                                        'type': 'object'},
                    'DestroyUnits': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationUnits'}},
                                     'type': 'object'},
                    'Expose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationExpose'}},
                               'type': 'object'},
                    'Get': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                           'Result': {'$ref': '#/definitions/ApplicationGetResults'}},
                            'type': 'object'},
                    'GetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                                   'Result': {'$ref': '#/definitions/StringResult'}},
                                    'type': 'object'},
                    'GetConstraints': {'properties': {'Params': {'$ref': '#/definitions/GetApplicationConstraints'},
                                                      'Result': {'$ref': '#/definitions/GetConstraintsResults'}},
                                       'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSet'}},
                            'type': 'object'},
                    'SetCharm': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSetCharm'}},
                                 'type': 'object'},
                    'SetConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                       'type': 'object'},
                    'SetMetricCredentials': {'properties': {'Params': {'$ref': '#/definitions/ApplicationMetricCredentials'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'Unexpose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnexpose'}},
                                 'type': 'object'},
                    'Unset': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnset'}},
                              'type': 'object'},
                    'Update': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUpdate'}},
                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddRelationResults)
    async def AddRelation(self, endpoints):
        '''
        endpoints : typing.Sequence[str]
        Returns -> typing.Mapping[str, ~CharmRelation]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddRelation',
                   version=3,
                   params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddApplicationUnitsResults)
    async def AddUnits(self, application, num_units, placement):
        '''
        application : str
        num_units : int
        placement : typing.Sequence[~Placement]
        Returns -> typing.Sequence[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddUnits',
                   version=3,
                   params=_params)
        _params['application'] = application
        _params['num-units'] = num_units
        _params['placement'] = placement
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationCharmRelationsResults)
    async def CharmRelations(self, application):
        '''
        application : str
        Returns -> typing.Sequence[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmRelations',
                   version=3,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Deploy(self, applications):
        '''
        applications : typing.Sequence[~ApplicationDeploy]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Deploy',
                   version=3,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Destroy(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Destroy',
                   version=3,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyRelation(self, endpoints):
        '''
        endpoints : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyRelation',
                   version=3,
                   params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyUnits(self, unit_names):
        '''
        unit_names : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnits',
                   version=3,
                   params=_params)
        _params['unit-names'] = unit_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Expose(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Expose',
                   version=3,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetResults)
    async def Get(self, application):
        '''
        application : str
        Returns -> typing.Union[str, typing.Mapping[str, typing.Any], _ForwardRef('Value')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Get',
                   version=3,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def GetCharmURL(self, application):
        '''
        application : str
        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetCharmURL',
                   version=3,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetConstraintsResults)
    async def GetConstraints(self, application):
        '''
        application : str
        Returns -> Value
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConstraints',
                   version=3,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Set(self, application, options):
        '''
        application : str
        options : typing.Mapping[str, str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Set',
                   version=3,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetCharm(self, application, channel, charm_url, config_settings, config_settings_yaml, force_series, force_units, resource_ids, storage_constraints):
        '''
        application : str
        channel : str
        charm_url : str
        config_settings : typing.Mapping[str, str]
        config_settings_yaml : str
        force_series : bool
        force_units : bool
        resource_ids : typing.Mapping[str, str]
        storage_constraints : typing.Mapping[str, ~StorageConstraints]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetCharm',
                   version=3,
                   params=_params)
        _params['application'] = application
        _params['channel'] = channel
        _params['charm-url'] = charm_url
        _params['config-settings'] = config_settings
        _params['config-settings-yaml'] = config_settings_yaml
        _params['force-series'] = force_series
        _params['force-units'] = force_units
        _params['resource-ids'] = resource_ids
        _params['storage-constraints'] = storage_constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetConstraints(self, application, constraints):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetConstraints',
                   version=3,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMetricCredentials(self, creds):
        '''
        creds : typing.Sequence[~ApplicationMetricCredential]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetMetricCredentials',
                   version=3,
                   params=_params)
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unexpose(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unexpose',
                   version=3,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unset(self, application, options):
        '''
        application : str
        options : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unset',
                   version=3,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Update(self, application, charm_url, constraints, force_charm_url, force_series, min_units, settings, settings_yaml):
        '''
        application : str
        charm_url : str
        constraints : Value
        force_charm_url : bool
        force_series : bool
        min_units : int
        settings : typing.Mapping[str, str]
        settings_yaml : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Update',
                   version=3,
                   params=_params)
        _params['application'] = application
        _params['charm-url'] = charm_url
        _params['constraints'] = constraints
        _params['force-charm-url'] = force_charm_url
        _params['force-series'] = force_series
        _params['min-units'] = min_units
        _params['settings'] = settings
        _params['settings-yaml'] = settings_yaml
        reply = await self.rpc(msg)
        return reply



class CloudFacade(Type):
    name = 'Cloud'
    version = 3
    schema =     {'definitions': {'AddCloudArgs': {'additionalProperties': False,
                                      'properties': {'cloud': {'$ref': '#/definitions/Cloud'},
                                                     'name': {'type': 'string'}},
                                      'required': ['cloud', 'name'],
                                      'type': 'object'},
                     'Cloud': {'additionalProperties': False,
                               'properties': {'auth-types': {'items': {'type': 'string'},
                                                             'type': 'array'},
                                              'ca-certificates': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                              'endpoint': {'type': 'string'},
                                              'identity-endpoint': {'type': 'string'},
                                              'regions': {'items': {'$ref': '#/definitions/CloudRegion'},
                                                          'type': 'array'},
                                              'storage-endpoint': {'type': 'string'},
                                              'type': {'type': 'string'}},
                               'required': ['type'],
                               'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudCredentialArg': {'additionalProperties': False,
                                            'properties': {'cloud-name': {'type': 'string'},
                                                           'credential-name': {'type': 'string'}},
                                            'required': ['cloud-name',
                                                         'credential-name'],
                                            'type': 'object'},
                     'CloudCredentialArgs': {'additionalProperties': False,
                                             'properties': {'credentials': {'items': {'$ref': '#/definitions/CloudCredentialArg'},
                                                                            'type': 'array'},
                                                            'include-secrets': {'type': 'boolean'}},
                                             'required': ['include-secrets'],
                                             'type': 'object'},
                     'CloudCredentialResult': {'additionalProperties': False,
                                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                                              'result': {'$ref': '#/definitions/CloudCredential'}},
                                               'type': 'object'},
                     'CloudCredentialResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/CloudCredentialResult'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'CloudDetails': {'additionalProperties': False,
                                      'properties': {'auth-types': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                     'endpoint': {'type': 'string'},
                                                     'identity-endpoint': {'type': 'string'},
                                                     'regions': {'items': {'$ref': '#/definitions/CloudRegion'},
                                                                 'type': 'array'},
                                                     'storage-endpoint': {'type': 'string'},
                                                     'type': {'type': 'string'}},
                                      'required': ['type'],
                                      'type': 'object'},
                     'CloudInfo': {'additionalProperties': False,
                                   'properties': {'CloudDetails': {'$ref': '#/definitions/CloudDetails'},
                                                  'users': {'items': {'$ref': '#/definitions/CloudUserInfo'},
                                                            'type': 'array'}},
                                   'required': ['CloudDetails', 'users'],
                                   'type': 'object'},
                     'CloudInfoResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudInfo'}},
                                         'type': 'object'},
                     'CloudInfoResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudInfoResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'CloudInstanceTypesConstraint': {'additionalProperties': False,
                                                      'properties': {'cloud-tag': {'type': 'string'},
                                                                     'constraints': {'$ref': '#/definitions/Value'},
                                                                     'region': {'type': 'string'}},
                                                      'required': ['cloud-tag',
                                                                   'region'],
                                                      'type': 'object'},
                     'CloudInstanceTypesConstraints': {'additionalProperties': False,
                                                       'properties': {'constraints': {'items': {'$ref': '#/definitions/CloudInstanceTypesConstraint'},
                                                                                      'type': 'array'}},
                                                       'required': ['constraints'],
                                                       'type': 'object'},
                     'CloudRegion': {'additionalProperties': False,
                                     'properties': {'endpoint': {'type': 'string'},
                                                    'identity-endpoint': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'storage-endpoint': {'type': 'string'}},
                                     'required': ['name'],
                                     'type': 'object'},
                     'CloudResult': {'additionalProperties': False,
                                     'properties': {'cloud': {'$ref': '#/definitions/Cloud'},
                                                    'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'CloudResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/CloudResult'},
                                                                 'type': 'array'}},
                                      'type': 'object'},
                     'CloudUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'access'],
                                       'type': 'object'},
                     'CloudsResult': {'additionalProperties': False,
                                      'properties': {'clouds': {'patternProperties': {'.*': {'$ref': '#/definitions/Cloud'}},
                                                                'type': 'object'}},
                                      'type': 'object'},
                     'ControllerCredentialInfo': {'additionalProperties': False,
                                                  'properties': {'content': {'$ref': '#/definitions/CredentialContent'},
                                                                 'models': {'items': {'$ref': '#/definitions/ModelAccess'},
                                                                            'type': 'array'}},
                                                  'type': 'object'},
                     'CredentialContent': {'additionalProperties': False,
                                           'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                    'type': 'object'},
                                                          'auth-type': {'type': 'string'},
                                                          'cloud': {'type': 'string'},
                                                          'name': {'type': 'string'}},
                                           'required': ['name',
                                                        'cloud',
                                                        'auth-type'],
                                           'type': 'object'},
                     'CredentialContentResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/ControllerCredentialInfo'}},
                                                 'type': 'object'},
                     'CredentialContentResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/CredentialContentResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'InstanceType': {'additionalProperties': False,
                                      'properties': {'arches': {'items': {'type': 'string'},
                                                                'type': 'array'},
                                                     'cost': {'type': 'integer'},
                                                     'cpu-cores': {'type': 'integer'},
                                                     'deprecated': {'type': 'boolean'},
                                                     'memory': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'root-disk': {'type': 'integer'},
                                                     'virt-type': {'type': 'string'}},
                                      'required': ['arches', 'cpu-cores', 'memory'],
                                      'type': 'object'},
                     'InstanceTypesResult': {'additionalProperties': False,
                                             'properties': {'cost-currency': {'type': 'string'},
                                                            'cost-divisor': {'type': 'integer'},
                                                            'cost-unit': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'instance-types': {'items': {'$ref': '#/definitions/InstanceType'},
                                                                               'type': 'array'}},
                                             'type': 'object'},
                     'InstanceTypesResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/InstanceTypesResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'ListCloudInfo': {'additionalProperties': False,
                                       'properties': {'CloudDetails': {'$ref': '#/definitions/CloudDetails'},
                                                      'user-access': {'type': 'string'}},
                                       'required': ['CloudDetails', 'user-access'],
                                       'type': 'object'},
                     'ListCloudInfoResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/ListCloudInfo'}},
                                             'type': 'object'},
                     'ListCloudInfoResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ListCloudInfoResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'ListCloudsRequest': {'additionalProperties': False,
                                           'properties': {'all': {'type': 'boolean'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag'],
                                           'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelAccess': {'additionalProperties': False,
                                     'properties': {'access': {'type': 'string'},
                                                    'model': {'type': 'string'}},
                                     'type': 'object'},
                     'ModifyCloudAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'cloud-tag': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'cloud-tag',
                                                        'action',
                                                        'access'],
                                           'type': 'object'},
                     'ModifyCloudAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyCloudAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'RevokeCredentialArg': {'additionalProperties': False,
                                             'properties': {'force': {'type': 'boolean'},
                                                            'tag': {'type': 'string'}},
                                             'required': ['tag', 'force'],
                                             'type': 'object'},
                     'RevokeCredentialArgs': {'additionalProperties': False,
                                              'properties': {'credentials': {'items': {'$ref': '#/definitions/RevokeCredentialArg'},
                                                                             'type': 'array'}},
                                              'required': ['credentials'],
                                              'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'TaggedCredential': {'additionalProperties': False,
                                          'properties': {'credential': {'$ref': '#/definitions/CloudCredential'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'credential'],
                                          'type': 'object'},
                     'TaggedCredentials': {'additionalProperties': False,
                                           'properties': {'credentials': {'items': {'$ref': '#/definitions/TaggedCredential'},
                                                                          'type': 'array'}},
                                           'type': 'object'},
                     'UpdateCredentialArgs': {'additionalProperties': False,
                                              'properties': {'credentials': {'items': {'$ref': '#/definitions/TaggedCredential'},
                                                                             'type': 'array'},
                                                             'force': {'type': 'boolean'}},
                                              'required': ['credentials', 'force'],
                                              'type': 'object'},
                     'UpdateCredentialModelResult': {'additionalProperties': False,
                                                     'properties': {'errors': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                               'type': 'array'},
                                                                    'name': {'type': 'string'},
                                                                    'uuid': {'type': 'string'}},
                                                     'required': ['uuid', 'name'],
                                                     'type': 'object'},
                     'UpdateCredentialResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'models': {'items': {'$ref': '#/definitions/UpdateCredentialModelResult'},
                                                                          'type': 'array'},
                                                               'tag': {'type': 'string'}},
                                                'required': ['tag'],
                                                'type': 'object'},
                     'UpdateCredentialResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/UpdateCredentialResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'UserCloud': {'additionalProperties': False,
                                   'properties': {'cloud-tag': {'type': 'string'},
                                                  'user-tag': {'type': 'string'}},
                                   'required': ['user-tag', 'cloud-tag'],
                                   'type': 'object'},
                     'UserClouds': {'additionalProperties': False,
                                    'properties': {'user-clouds': {'items': {'$ref': '#/definitions/UserCloud'},
                                                                   'type': 'array'}},
                                    'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'AddCloud': {'properties': {'Params': {'$ref': '#/definitions/AddCloudArgs'}},
                                 'type': 'object'},
                    'AddCredentials': {'properties': {'Params': {'$ref': '#/definitions/TaggedCredentials'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'CheckCredentialsModels': {'properties': {'Params': {'$ref': '#/definitions/TaggedCredentials'},
                                                              'Result': {'$ref': '#/definitions/UpdateCredentialResults'}},
                                               'type': 'object'},
                    'Cloud': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/CloudResults'}},
                              'type': 'object'},
                    'CloudInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudInfoResults'}},
                                  'type': 'object'},
                    'Clouds': {'properties': {'Result': {'$ref': '#/definitions/CloudsResult'}},
                               'type': 'object'},
                    'Credential': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/CloudCredentialResults'}},
                                   'type': 'object'},
                    'CredentialContents': {'properties': {'Params': {'$ref': '#/definitions/CloudCredentialArgs'},
                                                          'Result': {'$ref': '#/definitions/CredentialContentResults'}},
                                           'type': 'object'},
                    'DefaultCloud': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'InstanceTypes': {'properties': {'Params': {'$ref': '#/definitions/CloudInstanceTypesConstraints'},
                                                     'Result': {'$ref': '#/definitions/InstanceTypesResults'}},
                                      'type': 'object'},
                    'ListCloudInfo': {'properties': {'Params': {'$ref': '#/definitions/ListCloudsRequest'},
                                                     'Result': {'$ref': '#/definitions/ListCloudInfoResults'}},
                                      'type': 'object'},
                    'ModifyCloudAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyCloudAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'RemoveClouds': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'RevokeCredentialsCheckModels': {'properties': {'Params': {'$ref': '#/definitions/RevokeCredentialArgs'},
                                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                     'type': 'object'},
                    'UpdateCredentialsCheckModels': {'properties': {'Params': {'$ref': '#/definitions/UpdateCredentialArgs'},
                                                                    'Result': {'$ref': '#/definitions/UpdateCredentialResults'}},
                                                     'type': 'object'},
                    'UserCredentials': {'properties': {'Params': {'$ref': '#/definitions/UserClouds'},
                                                       'Result': {'$ref': '#/definitions/StringsResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def AddCloud(self, cloud, name):
        '''
        cloud : Cloud
        name : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='AddCloud',
                   version=3,
                   params=_params)
        _params['cloud'] = cloud
        _params['name'] = name
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def AddCredentials(self, credentials):
        '''
        credentials : typing.Sequence[~TaggedCredential]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='AddCredentials',
                   version=3,
                   params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpdateCredentialResults)
    async def CheckCredentialsModels(self, credentials):
        '''
        credentials : typing.Sequence[~TaggedCredential]
        Returns -> typing.Sequence[~UpdateCredentialResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='CheckCredentialsModels',
                   version=3,
                   params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudResults)
    async def Cloud(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~CloudResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Cloud',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudInfoResults)
    async def CloudInfo(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~CloudInfoResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='CloudInfo',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudsResult)
    async def Clouds(self):
        '''

        Returns -> typing.Mapping[str, ~Cloud]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Clouds',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudCredentialResults)
    async def Credential(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~CloudCredentialResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Credential',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CredentialContentResults)
    async def CredentialContents(self, credentials, include_secrets):
        '''
        credentials : typing.Sequence[~CloudCredentialArg]
        include_secrets : bool
        Returns -> typing.Sequence[~CredentialContentResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='CredentialContents',
                   version=3,
                   params=_params)
        _params['credentials'] = credentials
        _params['include-secrets'] = include_secrets
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def DefaultCloud(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='DefaultCloud',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InstanceTypesResults)
    async def InstanceTypes(self, constraints):
        '''
        constraints : typing.Sequence[~CloudInstanceTypesConstraint]
        Returns -> typing.Sequence[~InstanceTypesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='InstanceTypes',
                   version=3,
                   params=_params)
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListCloudInfoResults)
    async def ListCloudInfo(self, all_, user_tag):
        '''
        all_ : bool
        user_tag : str
        Returns -> typing.Sequence[~ListCloudInfoResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='ListCloudInfo',
                   version=3,
                   params=_params)
        _params['all'] = all_
        _params['user-tag'] = user_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyCloudAccess(self, changes):
        '''
        changes : typing.Sequence[~ModifyCloudAccess]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='ModifyCloudAccess',
                   version=3,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveClouds(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='RemoveClouds',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RevokeCredentialsCheckModels(self, credentials):
        '''
        credentials : typing.Sequence[~RevokeCredentialArg]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='RevokeCredentialsCheckModels',
                   version=3,
                   params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpdateCredentialResults)
    async def UpdateCredentialsCheckModels(self, credentials, force):
        '''
        credentials : typing.Sequence[~TaggedCredential]
        force : bool
        Returns -> typing.Sequence[~UpdateCredentialResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='UpdateCredentialsCheckModels',
                   version=3,
                   params=_params)
        _params['credentials'] = credentials
        _params['force'] = force
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def UserCredentials(self, user_clouds):
        '''
        user_clouds : typing.Sequence[~UserCloud]
        Returns -> typing.Sequence[~StringsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='UserCredentials',
                   version=3,
                   params=_params)
        _params['user-clouds'] = user_clouds
        reply = await self.rpc(msg)
        return reply



class ControllerFacade(Type):
    name = 'Controller'
    version = 3
    schema =     {'definitions': {'AllWatcherId': {'additionalProperties': False,
                                      'properties': {'watcher-id': {'type': 'string'}},
                                      'required': ['watcher-id'],
                                      'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudSpec': {'additionalProperties': False,
                                   'properties': {'credential': {'$ref': '#/definitions/CloudCredential'},
                                                  'endpoint': {'type': 'string'},
                                                  'identity-endpoint': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'region': {'type': 'string'},
                                                  'storage-endpoint': {'type': 'string'},
                                                  'type': {'type': 'string'}},
                                   'required': ['type', 'name'],
                                   'type': 'object'},
                     'CloudSpecResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudSpec'}},
                                         'type': 'object'},
                     'CloudSpecResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudSpecResult'},
                                                                     'type': 'array'}},
                                          'type': 'object'},
                     'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'DestroyControllerArgs': {'additionalProperties': False,
                                               'properties': {'destroy-models': {'type': 'boolean'}},
                                               'required': ['destroy-models'],
                                               'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostedModelConfig': {'additionalProperties': False,
                                           'properties': {'cloud-spec': {'$ref': '#/definitions/CloudSpec'},
                                                          'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'name': {'type': 'string'},
                                                          'owner': {'type': 'string'}},
                                           'required': ['name', 'owner'],
                                           'type': 'object'},
                     'HostedModelConfigsResults': {'additionalProperties': False,
                                                   'properties': {'models': {'items': {'$ref': '#/definitions/HostedModelConfig'},
                                                                             'type': 'array'}},
                                                   'required': ['models'],
                                                   'type': 'object'},
                     'InitiateMigrationArgs': {'additionalProperties': False,
                                               'properties': {'specs': {'items': {'$ref': '#/definitions/MigrationSpec'},
                                                                        'type': 'array'}},
                                               'required': ['specs'],
                                               'type': 'object'},
                     'InitiateMigrationResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'migration-id': {'type': 'string'},
                                                                'model-tag': {'type': 'string'}},
                                                 'required': ['model-tag',
                                                              'migration-id'],
                                                 'type': 'object'},
                     'InitiateMigrationResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/InitiateMigrationResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MigrationSpec': {'additionalProperties': False,
                                       'properties': {'model-tag': {'type': 'string'},
                                                      'target-info': {'$ref': '#/definitions/MigrationTargetInfo'}},
                                       'required': ['model-tag', 'target-info'],
                                       'type': 'object'},
                     'MigrationTargetInfo': {'additionalProperties': False,
                                             'properties': {'addrs': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                            'auth-tag': {'type': 'string'},
                                                            'ca-cert': {'type': 'string'},
                                                            'controller-tag': {'type': 'string'},
                                                            'macaroons': {'type': 'string'},
                                                            'password': {'type': 'string'}},
                                             'required': ['controller-tag',
                                                          'addrs',
                                                          'ca-cert',
                                                          'auth-tag'],
                                             'type': 'object'},
                     'Model': {'additionalProperties': False,
                               'properties': {'name': {'type': 'string'},
                                              'owner-tag': {'type': 'string'},
                                              'uuid': {'type': 'string'}},
                               'required': ['name', 'uuid', 'owner-tag'],
                               'type': 'object'},
                     'ModelBlockInfo': {'additionalProperties': False,
                                        'properties': {'blocks': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                       'model-uuid': {'type': 'string'},
                                                       'name': {'type': 'string'},
                                                       'owner-tag': {'type': 'string'}},
                                        'required': ['name',
                                                     'model-uuid',
                                                     'owner-tag',
                                                     'blocks'],
                                        'type': 'object'},
                     'ModelBlockInfoList': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelBlockInfo'},
                                                                      'type': 'array'}},
                                            'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelStatus': {'additionalProperties': False,
                                     'properties': {'application-count': {'type': 'integer'},
                                                    'hosted-machine-count': {'type': 'integer'},
                                                    'life': {'type': 'string'},
                                                    'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                                 'type': 'array'},
                                                    'model-tag': {'type': 'string'},
                                                    'owner-tag': {'type': 'string'}},
                                     'required': ['model-tag',
                                                  'life',
                                                  'hosted-machine-count',
                                                  'application-count',
                                                  'owner-tag'],
                                     'type': 'object'},
                     'ModelStatusResults': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelStatus'},
                                                                      'type': 'array'}},
                                            'required': ['models'],
                                            'type': 'object'},
                     'ModelTag': {'additionalProperties': False, 'type': 'object'},
                     'ModifyControllerAccess': {'additionalProperties': False,
                                                'properties': {'access': {'type': 'string'},
                                                               'action': {'type': 'string'},
                                                               'user-tag': {'type': 'string'}},
                                                'required': ['user-tag',
                                                             'action',
                                                             'access'],
                                                'type': 'object'},
                     'ModifyControllerAccessRequest': {'additionalProperties': False,
                                                       'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyControllerAccess'},
                                                                                  'type': 'array'}},
                                                       'required': ['changes'],
                                                       'type': 'object'},
                     'RemoveBlocksArgs': {'additionalProperties': False,
                                          'properties': {'all': {'type': 'boolean'}},
                                          'required': ['all'],
                                          'type': 'object'},
                     'UserAccess': {'additionalProperties': False,
                                    'properties': {'access': {'type': 'string'},
                                                   'user-tag': {'type': 'string'}},
                                    'required': ['user-tag', 'access'],
                                    'type': 'object'},
                     'UserAccessResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'result': {'$ref': '#/definitions/UserAccess'}},
                                          'type': 'object'},
                     'UserAccessResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/UserAccessResult'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'UserModel': {'additionalProperties': False,
                                   'properties': {'last-connection': {'format': 'date-time',
                                                                      'type': 'string'},
                                                  'model': {'$ref': '#/definitions/Model'}},
                                   'required': ['model', 'last-connection'],
                                   'type': 'object'},
                     'UserModelList': {'additionalProperties': False,
                                       'properties': {'user-models': {'items': {'$ref': '#/definitions/UserModel'},
                                                                      'type': 'array'}},
                                       'required': ['user-models'],
                                       'type': 'object'}},
     'properties': {'AllModels': {'properties': {'Result': {'$ref': '#/definitions/UserModelList'}},
                                  'type': 'object'},
                    'CloudSpec': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudSpecResults'}},
                                  'type': 'object'},
                    'ControllerConfig': {'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'DestroyController': {'properties': {'Params': {'$ref': '#/definitions/DestroyControllerArgs'}},
                                          'type': 'object'},
                    'GetCloudSpec': {'properties': {'Params': {'$ref': '#/definitions/ModelTag'},
                                                    'Result': {'$ref': '#/definitions/CloudSpecResult'}},
                                     'type': 'object'},
                    'GetControllerAccess': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/UserAccessResults'}},
                                            'type': 'object'},
                    'HostedModelConfigs': {'properties': {'Result': {'$ref': '#/definitions/HostedModelConfigsResults'}},
                                           'type': 'object'},
                    'InitiateMigration': {'properties': {'Params': {'$ref': '#/definitions/InitiateMigrationArgs'},
                                                         'Result': {'$ref': '#/definitions/InitiateMigrationResults'}},
                                          'type': 'object'},
                    'ListBlockedModels': {'properties': {'Result': {'$ref': '#/definitions/ModelBlockInfoList'}},
                                          'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                    'type': 'object'},
                    'ModelStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ModelStatusResults'}},
                                    'type': 'object'},
                    'ModifyControllerAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyControllerAccessRequest'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'RemoveBlocks': {'properties': {'Params': {'$ref': '#/definitions/RemoveBlocksArgs'}},
                                     'type': 'object'},
                    'WatchAllModels': {'properties': {'Result': {'$ref': '#/definitions/AllWatcherId'}},
                                       'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(UserModelList)
    async def AllModels(self):
        '''

        Returns -> typing.Sequence[~UserModel]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='AllModels',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResults)
    async def CloudSpec(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~CloudSpecResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='CloudSpec',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''

        Returns -> typing.Mapping[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ControllerConfig',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyController(self, destroy_models):
        '''
        destroy_models : bool
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='DestroyController',
                   version=3,
                   params=_params)
        _params['destroy-models'] = destroy_models
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResult)
    async def GetCloudSpec(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), _ForwardRef('CloudSpec')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='GetCloudSpec',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserAccessResults)
    async def GetControllerAccess(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~UserAccessResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='GetControllerAccess',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(HostedModelConfigsResults)
    async def HostedModelConfigs(self):
        '''

        Returns -> typing.Sequence[~HostedModelConfig]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='HostedModelConfigs',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InitiateMigrationResults)
    async def InitiateMigration(self, specs):
        '''
        specs : typing.Sequence[~MigrationSpec]
        Returns -> typing.Sequence[~InitiateMigrationResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='InitiateMigration',
                   version=3,
                   params=_params)
        _params['specs'] = specs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelBlockInfoList)
    async def ListBlockedModels(self):
        '''

        Returns -> typing.Sequence[~ModelBlockInfo]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ListBlockedModels',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResults)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping[str, ~ConfigValue]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModelConfig',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelStatusResults)
    async def ModelStatus(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ModelStatus]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModelStatus',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyControllerAccess(self, changes):
        '''
        changes : typing.Sequence[~ModifyControllerAccess]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModifyControllerAccess',
                   version=3,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def RemoveBlocks(self, all_):
        '''
        all_ : bool
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='RemoveBlocks',
                   version=3,
                   params=_params)
        _params['all'] = all_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AllWatcherId)
    async def WatchAllModels(self):
        '''

        Returns -> str
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='WatchAllModels',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class FirewallerFacade(Type):
    name = 'Firewaller'
    version = 3
    schema =     {'definitions': {'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BoolResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/BoolResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudSpec': {'additionalProperties': False,
                                   'properties': {'credential': {'$ref': '#/definitions/CloudCredential'},
                                                  'endpoint': {'type': 'string'},
                                                  'identity-endpoint': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'region': {'type': 'string'},
                                                  'storage-endpoint': {'type': 'string'},
                                                  'type': {'type': 'string'}},
                                   'required': ['type', 'name'],
                                   'type': 'object'},
                     'CloudSpecResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudSpec'}},
                                         'type': 'object'},
                     'CloudSpecResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudSpecResult'},
                                                                     'type': 'array'}},
                                          'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachinePortRange': {'additionalProperties': False,
                                          'properties': {'port-range': {'$ref': '#/definitions/PortRange'},
                                                         'relation-tag': {'type': 'string'},
                                                         'unit-tag': {'type': 'string'}},
                                          'required': ['unit-tag',
                                                       'relation-tag',
                                                       'port-range'],
                                          'type': 'object'},
                     'MachinePorts': {'additionalProperties': False,
                                      'properties': {'machine-tag': {'type': 'string'},
                                                     'subnet-tag': {'type': 'string'}},
                                      'required': ['machine-tag', 'subnet-tag'],
                                      'type': 'object'},
                     'MachinePortsParams': {'additionalProperties': False,
                                            'properties': {'params': {'items': {'$ref': '#/definitions/MachinePorts'},
                                                                      'type': 'array'}},
                                            'required': ['params'],
                                            'type': 'object'},
                     'MachinePortsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'ports': {'items': {'$ref': '#/definitions/MachinePortRange'},
                                                                     'type': 'array'}},
                                            'required': ['ports'],
                                            'type': 'object'},
                     'MachinePortsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/MachinePortsResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ModelTag': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'PortRange': {'additionalProperties': False,
                                   'properties': {'from-port': {'type': 'integer'},
                                                  'protocol': {'type': 'string'},
                                                  'to-port': {'type': 'integer'}},
                                   'required': ['from-port', 'to-port', 'protocol'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'}},
     'properties': {'CloudSpec': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudSpecResults'}},
                                  'type': 'object'},
                    'GetAssignedMachine': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/StringResults'}},
                                           'type': 'object'},
                    'GetCloudSpec': {'properties': {'Params': {'$ref': '#/definitions/ModelTag'},
                                                    'Result': {'$ref': '#/definitions/CloudSpecResult'}},
                                     'type': 'object'},
                    'GetExposed': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/BoolResults'}},
                                   'type': 'object'},
                    'GetMachineActiveSubnets': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/StringsResults'}},
                                                'type': 'object'},
                    'GetMachinePorts': {'properties': {'Params': {'$ref': '#/definitions/MachinePortsParams'},
                                                       'Result': {'$ref': '#/definitions/MachinePortsResults'}},
                                        'type': 'object'},
                    'InstanceId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'Watch': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'},
                    'WatchModelMachines': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                           'type': 'object'},
                    'WatchOpenedPorts': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                         'type': 'object'},
                    'WatchUnits': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(CloudSpecResults)
    async def CloudSpec(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~CloudSpecResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='CloudSpec',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def GetAssignedMachine(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='GetAssignedMachine',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResult)
    async def GetCloudSpec(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), _ForwardRef('CloudSpec')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='GetCloudSpec',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResults)
    async def GetExposed(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~BoolResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='GetExposed',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def GetMachineActiveSubnets(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='GetMachineActiveSubnets',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachinePortsResults)
    async def GetMachinePorts(self, params):
        '''
        params : typing.Sequence[~MachinePorts]
        Returns -> typing.Sequence[~MachinePortsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='GetMachinePorts',
                   version=3,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def InstanceId(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='InstanceId',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~LifeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='Life',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='ModelConfig',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='Watch',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='WatchForModelConfigChanges',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchModelMachines(self):
        '''

        Returns -> typing.Union[typing.Sequence[str], _ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='WatchModelMachines',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchOpenedPorts(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='WatchOpenedPorts',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchUnits(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Firewaller',
                   request='WatchUnits',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class ImageMetadataFacade(Type):
    name = 'ImageMetadata'
    version = 3
    schema =     {'properties': {'UpdateFromPublishedImages': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def UpdateFromPublishedImages(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata',
                   request='UpdateFromPublishedImages',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class InstancePollerFacade(Type):
    name = 'InstancePoller'
    version = 3
    schema =     {'definitions': {'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BoolResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/BoolResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineAddresses': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'addresses'],
                                          'type': 'object'},
                     'MachineAddressesResult': {'additionalProperties': False,
                                                'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                             'type': 'array'},
                                                               'error': {'$ref': '#/definitions/Error'}},
                                                'required': ['addresses'],
                                                'type': 'object'},
                     'MachineAddressesResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/MachineAddressesResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'SetMachinesAddresses': {'additionalProperties': False,
                                              'properties': {'machine-addresses': {'items': {'$ref': '#/definitions/MachineAddresses'},
                                                                                   'type': 'array'}},
                                              'required': ['machine-addresses'],
                                              'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StatusResult': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'id': {'type': 'string'},
                                                     'info': {'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['id',
                                                   'life',
                                                   'status',
                                                   'info',
                                                   'data',
                                                   'since'],
                                      'type': 'object'},
                     'StatusResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StatusResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'AreManuallyProvisioned': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/BoolResults'}},
                                               'type': 'object'},
                    'InstanceId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'InstanceStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StatusResults'}},
                                       'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ProviderAddresses': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/MachineAddressesResults'}},
                                          'type': 'object'},
                    'SetInstanceStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetProviderAddresses': {'properties': {'Params': {'$ref': '#/definitions/SetMachinesAddresses'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'Status': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/StatusResults'}},
                               'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'},
                    'WatchModelMachines': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BoolResults)
    async def AreManuallyProvisioned(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~BoolResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='AreManuallyProvisioned',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def InstanceId(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='InstanceId',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def InstanceStatus(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StatusResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='InstanceStatus',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~LifeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='Life',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='ModelConfig',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineAddressesResults)
    async def ProviderAddresses(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MachineAddressesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='ProviderAddresses',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetInstanceStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='SetInstanceStatus',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetProviderAddresses(self, machine_addresses):
        '''
        machine_addresses : typing.Sequence[~MachineAddresses]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='SetProviderAddresses',
                   version=3,
                   params=_params)
        _params['machine-addresses'] = machine_addresses
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def Status(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StatusResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='Status',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='WatchForModelConfigChanges',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchModelMachines(self):
        '''

        Returns -> typing.Union[typing.Sequence[str], _ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='WatchModelMachines',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class MachineManagerFacade(Type):
    name = 'MachineManager'
    version = 3
    schema =     {'definitions': {'AddMachineParams': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'container-type': {'type': 'string'},
                                                         'disks': {'items': {'$ref': '#/definitions/Constraints'},
                                                                   'type': 'array'},
                                                         'hardware-characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                         'instance-id': {'type': 'string'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'nonce': {'type': 'string'},
                                                         'parent-id': {'type': 'string'},
                                                         'placement': {'$ref': '#/definitions/Placement'},
                                                         'series': {'type': 'string'}},
                                          'required': ['series',
                                                       'constraints',
                                                       'jobs',
                                                       'parent-id',
                                                       'container-type',
                                                       'instance-id',
                                                       'nonce',
                                                       'hardware-characteristics',
                                                       'addresses'],
                                          'type': 'object'},
                     'AddMachines': {'additionalProperties': False,
                                     'properties': {'params': {'items': {'$ref': '#/definitions/AddMachineParams'},
                                                               'type': 'array'}},
                                     'required': ['params'],
                                     'type': 'object'},
                     'AddMachinesResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'machine': {'type': 'string'}},
                                           'required': ['machine'],
                                           'type': 'object'},
                     'AddMachinesResults': {'additionalProperties': False,
                                            'properties': {'machines': {'items': {'$ref': '#/definitions/AddMachinesResult'},
                                                                        'type': 'array'}},
                                            'required': ['machines'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'DestroyMachineInfo': {'additionalProperties': False,
                                            'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                 'type': 'array'},
                                                           'destroyed-units': {'items': {'$ref': '#/definitions/Entity'},
                                                                               'type': 'array'},
                                                           'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                'type': 'array'}},
                                            'type': 'object'},
                     'DestroyMachineResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'info': {'$ref': '#/definitions/DestroyMachineInfo'}},
                                              'type': 'object'},
                     'DestroyMachineResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/DestroyMachineResult'},
                                                                          'type': 'array'}},
                                               'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'InstanceType': {'additionalProperties': False,
                                      'properties': {'arches': {'items': {'type': 'string'},
                                                                'type': 'array'},
                                                     'cost': {'type': 'integer'},
                                                     'cpu-cores': {'type': 'integer'},
                                                     'deprecated': {'type': 'boolean'},
                                                     'memory': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'root-disk': {'type': 'integer'},
                                                     'virt-type': {'type': 'string'}},
                                      'required': ['arches', 'cpu-cores', 'memory'],
                                      'type': 'object'},
                     'InstanceTypesResult': {'additionalProperties': False,
                                             'properties': {'cost-currency': {'type': 'string'},
                                                            'cost-divisor': {'type': 'integer'},
                                                            'cost-unit': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'instance-types': {'items': {'$ref': '#/definitions/InstanceType'},
                                                                               'type': 'array'}},
                                             'type': 'object'},
                     'InstanceTypesResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/InstanceTypesResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelInstanceTypesConstraint': {'additionalProperties': False,
                                                      'properties': {'value': {'$ref': '#/definitions/Value'}},
                                                      'type': 'object'},
                     'ModelInstanceTypesConstraints': {'additionalProperties': False,
                                                       'properties': {'constraints': {'items': {'$ref': '#/definitions/ModelInstanceTypesConstraint'},
                                                                                      'type': 'array'}},
                                                       'required': ['constraints'],
                                                       'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'AddMachines': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                   'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                    'type': 'object'},
                    'DestroyMachine': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/DestroyMachineResults'}},
                                       'type': 'object'},
                    'ForceDestroyMachine': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/DestroyMachineResults'}},
                                            'type': 'object'},
                    'InstanceTypes': {'properties': {'Params': {'$ref': '#/definitions/ModelInstanceTypesConstraints'},
                                                     'Result': {'$ref': '#/definitions/InstanceTypesResults'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddMachinesResults)
    async def AddMachines(self, params):
        '''
        params : typing.Sequence[~AddMachineParams]
        Returns -> typing.Sequence[~AddMachinesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='AddMachines',
                   version=3,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyMachineResults)
    async def DestroyMachine(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~DestroyMachineResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='DestroyMachine',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyMachineResults)
    async def ForceDestroyMachine(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~DestroyMachineResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='ForceDestroyMachine',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InstanceTypesResults)
    async def InstanceTypes(self, constraints):
        '''
        constraints : typing.Sequence[~ModelInstanceTypesConstraint]
        Returns -> typing.Sequence[~InstanceTypesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='InstanceTypes',
                   version=3,
                   params=_params)
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



class ModelManagerFacade(Type):
    name = 'ModelManager'
    version = 3
    schema =     {'definitions': {'DumpModelRequest': {'additionalProperties': False,
                                          'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                      'type': 'array'},
                                                         'simplified': {'type': 'boolean'}},
                                          'required': ['entities', 'simplified'],
                                          'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MapResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                          'type': 'object'}},
                                                             'type': 'object'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'MapResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/MapResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'Model': {'additionalProperties': False,
                               'properties': {'name': {'type': 'string'},
                                              'owner-tag': {'type': 'string'},
                                              'uuid': {'type': 'string'}},
                               'required': ['name', 'uuid', 'owner-tag'],
                               'type': 'object'},
                     'ModelCreateArgs': {'additionalProperties': False,
                                         'properties': {'cloud-tag': {'type': 'string'},
                                                        'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                'type': 'object'}},
                                                                   'type': 'object'},
                                                        'credential': {'type': 'string'},
                                                        'name': {'type': 'string'},
                                                        'owner-tag': {'type': 'string'},
                                                        'region': {'type': 'string'}},
                                         'required': ['name', 'owner-tag'],
                                         'type': 'object'},
                     'ModelDefaultValues': {'additionalProperties': False,
                                            'properties': {'cloud-region': {'type': 'string'},
                                                           'cloud-tag': {'type': 'string'},
                                                           'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                   'type': 'object'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelDefaults': {'additionalProperties': False,
                                       'properties': {'controller': {'additionalProperties': True,
                                                                     'type': 'object'},
                                                      'default': {'additionalProperties': True,
                                                                  'type': 'object'},
                                                      'regions': {'items': {'$ref': '#/definitions/RegionDefaults'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ModelDefaultsResult': {'additionalProperties': False,
                                             'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ModelDefaults'}},
                                                                       'type': 'object'}},
                                             'required': ['config'],
                                             'type': 'object'},
                     'ModelInfo': {'additionalProperties': False,
                                   'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                  'cloud-credential-tag': {'type': 'string'},
                                                  'cloud-region': {'type': 'string'},
                                                  'cloud-tag': {'type': 'string'},
                                                  'controller-uuid': {'type': 'string'},
                                                  'default-series': {'type': 'string'},
                                                  'life': {'type': 'string'},
                                                  'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                               'type': 'array'},
                                                  'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                  'name': {'type': 'string'},
                                                  'owner-tag': {'type': 'string'},
                                                  'provider-type': {'type': 'string'},
                                                  'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                  'status': {'$ref': '#/definitions/EntityStatus'},
                                                  'users': {'items': {'$ref': '#/definitions/ModelUserInfo'},
                                                            'type': 'array'},
                                                  'uuid': {'type': 'string'}},
                                   'required': ['name',
                                                'uuid',
                                                'controller-uuid',
                                                'cloud-tag',
                                                'owner-tag',
                                                'life',
                                                'users',
                                                'machines',
                                                'sla',
                                                'agent-version'],
                                   'type': 'object'},
                     'ModelInfoResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/ModelInfo'}},
                                         'type': 'object'},
                     'ModelInfoResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/ModelInfoResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelMigrationStatus': {'additionalProperties': False,
                                              'properties': {'end': {'format': 'date-time',
                                                                     'type': 'string'},
                                                             'start': {'format': 'date-time',
                                                                       'type': 'string'},
                                                             'status': {'type': 'string'}},
                                              'required': ['status', 'start'],
                                              'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelStatus': {'additionalProperties': False,
                                     'properties': {'application-count': {'type': 'integer'},
                                                    'hosted-machine-count': {'type': 'integer'},
                                                    'life': {'type': 'string'},
                                                    'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                                 'type': 'array'},
                                                    'model-tag': {'type': 'string'},
                                                    'owner-tag': {'type': 'string'}},
                                     'required': ['model-tag',
                                                  'life',
                                                  'hosted-machine-count',
                                                  'application-count',
                                                  'owner-tag'],
                                     'type': 'object'},
                     'ModelStatusResults': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelStatus'},
                                                                      'type': 'array'}},
                                            'required': ['models'],
                                            'type': 'object'},
                     'ModelUnsetKeys': {'additionalProperties': False,
                                        'properties': {'cloud-region': {'type': 'string'},
                                                       'cloud-tag': {'type': 'string'},
                                                       'keys': {'items': {'type': 'string'},
                                                                'type': 'array'}},
                                        'required': ['keys'],
                                        'type': 'object'},
                     'ModelUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'last-connection': {'format': 'date-time',
                                                                          'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'last-connection',
                                                    'access'],
                                       'type': 'object'},
                     'ModifyModelAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'model-tag': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'action',
                                                        'access',
                                                        'model-tag'],
                                           'type': 'object'},
                     'ModifyModelAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyModelAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'RegionDefaults': {'additionalProperties': False,
                                        'properties': {'region-name': {'type': 'string'},
                                                       'value': {'additionalProperties': True,
                                                                 'type': 'object'}},
                                        'required': ['region-name', 'value'],
                                        'type': 'object'},
                     'SetModelDefaults': {'additionalProperties': False,
                                          'properties': {'config': {'items': {'$ref': '#/definitions/ModelDefaultValues'},
                                                                    'type': 'array'}},
                                          'required': ['config'],
                                          'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'UnsetModelDefaults': {'additionalProperties': False,
                                            'properties': {'keys': {'items': {'$ref': '#/definitions/ModelUnsetKeys'},
                                                                    'type': 'array'}},
                                            'required': ['keys'],
                                            'type': 'object'},
                     'UserModel': {'additionalProperties': False,
                                   'properties': {'last-connection': {'format': 'date-time',
                                                                      'type': 'string'},
                                                  'model': {'$ref': '#/definitions/Model'}},
                                   'required': ['model', 'last-connection'],
                                   'type': 'object'},
                     'UserModelList': {'additionalProperties': False,
                                       'properties': {'user-models': {'items': {'$ref': '#/definitions/UserModel'},
                                                                      'type': 'array'}},
                                       'required': ['user-models'],
                                       'type': 'object'}},
     'properties': {'CreateModel': {'properties': {'Params': {'$ref': '#/definitions/ModelCreateArgs'},
                                                   'Result': {'$ref': '#/definitions/ModelInfo'}},
                                    'type': 'object'},
                    'DestroyModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'DumpModels': {'properties': {'Params': {'$ref': '#/definitions/DumpModelRequest'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'DumpModelsDB': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/MapResults'}},
                                     'type': 'object'},
                    'ListModels': {'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                  'Result': {'$ref': '#/definitions/UserModelList'}},
                                   'type': 'object'},
                    'ModelDefaults': {'properties': {'Result': {'$ref': '#/definitions/ModelDefaultsResult'}},
                                      'type': 'object'},
                    'ModelInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/ModelInfoResults'}},
                                  'type': 'object'},
                    'ModelStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ModelStatusResults'}},
                                    'type': 'object'},
                    'ModifyModelAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyModelAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetModelDefaults': {'properties': {'Params': {'$ref': '#/definitions/SetModelDefaults'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'UnsetModelDefaults': {'properties': {'Params': {'$ref': '#/definitions/UnsetModelDefaults'},
                                                          'Result': {'$ref': '#/definitions/ErrorResults'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelInfo)
    async def CreateModel(self, cloud_tag, config, credential, name, owner_tag, region):
        '''
        cloud_tag : str
        config : typing.Mapping[str, typing.Any]
        credential : str
        name : str
        owner_tag : str
        region : str
        Returns -> typing.Union[_ForwardRef('Number'), str, typing.Sequence[~ModelMachineInfo], _ForwardRef('ModelMigrationStatus'), _ForwardRef('ModelSLAInfo'), _ForwardRef('EntityStatus'), typing.Sequence[~ModelUserInfo]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='CreateModel',
                   version=3,
                   params=_params)
        _params['cloud-tag'] = cloud_tag
        _params['config'] = config
        _params['credential'] = credential
        _params['name'] = name
        _params['owner-tag'] = owner_tag
        _params['region'] = region
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyModels(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DestroyModels',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def DumpModels(self, entities, simplified):
        '''
        entities : typing.Sequence[~Entity]
        simplified : bool
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DumpModels',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        _params['simplified'] = simplified
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MapResults)
    async def DumpModelsDB(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MapResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DumpModelsDB',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserModelList)
    async def ListModels(self, tag):
        '''
        tag : str
        Returns -> typing.Sequence[~UserModel]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ListModels',
                   version=3,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelDefaultsResult)
    async def ModelDefaults(self):
        '''

        Returns -> typing.Mapping[str, ~ModelDefaults]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelDefaults',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfoResults)
    async def ModelInfo(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ModelInfoResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelInfo',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelStatusResults)
    async def ModelStatus(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ModelStatus]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelStatus',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyModelAccess(self, changes):
        '''
        changes : typing.Sequence[~ModifyModelAccess]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModifyModelAccess',
                   version=3,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModelDefaults(self, config):
        '''
        config : typing.Sequence[~ModelDefaultValues]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='SetModelDefaults',
                   version=3,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UnsetModelDefaults(self, keys):
        '''
        keys : typing.Sequence[~ModelUnsetKeys]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='UnsetModelDefaults',
                   version=3,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



class ProvisionerFacade(Type):
    name = 'Provisioner'
    version = 3
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Series': {'type': 'string'}},
                                'required': ['Number', 'Series', 'Arch'],
                                'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'CloudImageMetadata': {'additionalProperties': False,
                                            'properties': {'arch': {'type': 'string'},
                                                           'image-id': {'type': 'string'},
                                                           'priority': {'type': 'integer'},
                                                           'region': {'type': 'string'},
                                                           'root-storage-size': {'type': 'integer'},
                                                           'root-storage-type': {'type': 'string'},
                                                           'series': {'type': 'string'},
                                                           'source': {'type': 'string'},
                                                           'stream': {'type': 'string'},
                                                           'version': {'type': 'string'},
                                                           'virt-type': {'type': 'string'}},
                                            'required': ['image-id',
                                                         'region',
                                                         'version',
                                                         'series',
                                                         'arch',
                                                         'source',
                                                         'priority'],
                                            'type': 'object'},
                     'ConstraintsResult': {'additionalProperties': False,
                                           'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['constraints'],
                                           'type': 'object'},
                     'ConstraintsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/ConstraintsResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ContainerConfig': {'additionalProperties': False,
                                         'properties': {'UpdateBehavior': {'$ref': '#/definitions/UpdateBehavior'},
                                                        'apt-mirror': {'type': 'string'},
                                                        'apt-proxy': {'$ref': '#/definitions/Settings'},
                                                        'authorized-keys': {'type': 'string'},
                                                        'provider-type': {'type': 'string'},
                                                        'proxy': {'$ref': '#/definitions/Settings'},
                                                        'ssl-hostname-verification': {'type': 'boolean'}},
                                         'required': ['provider-type',
                                                      'authorized-keys',
                                                      'ssl-hostname-verification',
                                                      'proxy',
                                                      'apt-proxy',
                                                      'apt-mirror',
                                                      'UpdateBehavior'],
                                         'type': 'object'},
                     'ContainerManagerConfig': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'ContainerManagerConfigParams': {'additionalProperties': False,
                                                      'properties': {'type': {'type': 'string'}},
                                                      'required': ['type'],
                                                      'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'DeviceBridgeInfo': {'additionalProperties': False,
                                          'properties': {'bridge-name': {'type': 'string'},
                                                         'host-device-name': {'type': 'string'}},
                                          'required': ['host-device-name',
                                                       'bridge-name'],
                                          'type': 'object'},
                     'DistributionGroupResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'items': {'type': 'string'},
                                                                           'type': 'array'}},
                                                 'required': ['result'],
                                                 'type': 'object'},
                     'DistributionGroupResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/DistributionGroupResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FindToolsParams': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'major': {'type': 'integer'},
                                                        'minor': {'type': 'integer'},
                                                        'number': {'$ref': '#/definitions/Number'},
                                                        'series': {'type': 'string'}},
                                         'required': ['number',
                                                      'major',
                                                      'minor',
                                                      'arch',
                                                      'series'],
                                         'type': 'object'},
                     'FindToolsResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'list': {'items': {'$ref': '#/definitions/Tools'},
                                                                 'type': 'array'}},
                                         'required': ['list'],
                                         'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'HostNetworkChange': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'new-bridges': {'items': {'$ref': '#/definitions/DeviceBridgeInfo'},
                                                                          'type': 'array'},
                                                          'reconfigure-delay': {'type': 'integer'}},
                                           'required': ['new-bridges',
                                                        'reconfigure-delay'],
                                           'type': 'object'},
                     'HostNetworkChangeResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/HostNetworkChange'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'}},
                                  'required': ['Address', 'port'],
                                  'type': 'object'},
                     'InstanceInfo': {'additionalProperties': False,
                                      'properties': {'characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                     'instance-id': {'type': 'string'},
                                                     'network-config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                        'type': 'array'},
                                                     'nonce': {'type': 'string'},
                                                     'tag': {'type': 'string'},
                                                     'volume-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentInfo'}},
                                                                            'type': 'object'},
                                                     'volumes': {'items': {'$ref': '#/definitions/Volume'},
                                                                 'type': 'array'}},
                                      'required': ['tag',
                                                   'instance-id',
                                                   'nonce',
                                                   'characteristics',
                                                   'volumes',
                                                   'volume-attachments',
                                                   'network-config'],
                                      'type': 'object'},
                     'InstancesInfo': {'additionalProperties': False,
                                       'properties': {'machines': {'items': {'$ref': '#/definitions/InstanceInfo'},
                                                                   'type': 'array'}},
                                       'required': ['machines'],
                                       'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineContainers': {'additionalProperties': False,
                                           'properties': {'container-types': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                          'machine-tag': {'type': 'string'}},
                                           'required': ['machine-tag',
                                                        'container-types'],
                                           'type': 'object'},
                     'MachineContainersParams': {'additionalProperties': False,
                                                 'properties': {'params': {'items': {'$ref': '#/definitions/MachineContainers'},
                                                                           'type': 'array'}},
                                                 'required': ['params'],
                                                 'type': 'object'},
                     'MachineNetworkConfigResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'info': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                            'type': 'array'}},
                                                    'required': ['info'],
                                                    'type': 'object'},
                     'MachineNetworkConfigResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/MachineNetworkConfigResult'},
                                                                                'type': 'array'}},
                                                     'required': ['results'],
                                                     'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'ProvisioningInfo': {'additionalProperties': False,
                                          'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                         'controller-config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                            'type': 'object'}},
                                                                               'type': 'object'},
                                                         'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                               'type': 'object'},
                                                         'image-metadata': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                            'type': 'array'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'placement': {'type': 'string'},
                                                         'series': {'type': 'string'},
                                                         'subnets-to-zones': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                           'type': 'array'}},
                                                                              'type': 'object'},
                                                         'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                         'volume-attachments': {'items': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                                                'type': 'array'},
                                                         'volumes': {'items': {'$ref': '#/definitions/VolumeParams'},
                                                                     'type': 'array'}},
                                          'required': ['constraints',
                                                       'series',
                                                       'placement',
                                                       'jobs'],
                                          'type': 'object'},
                     'ProvisioningInfoResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/ProvisioningInfo'}},
                                                'required': ['result'],
                                                'type': 'object'},
                     'ProvisioningInfoResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/ProvisioningInfoResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'SetMachineNetworkConfig': {'additionalProperties': False,
                                                 'properties': {'config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                           'type': 'array'},
                                                                'tag': {'type': 'string'}},
                                                 'required': ['tag', 'config'],
                                                 'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'Settings': {'additionalProperties': False,
                                  'properties': {'AutoNoProxy': {'type': 'string'},
                                                 'Ftp': {'type': 'string'},
                                                 'Http': {'type': 'string'},
                                                 'Https': {'type': 'string'},
                                                 'NoProxy': {'type': 'string'}},
                                  'required': ['Http',
                                               'Https',
                                               'Ftp',
                                               'NoProxy',
                                               'AutoNoProxy'],
                                  'type': 'object'},
                     'StatusResult': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'id': {'type': 'string'},
                                                     'info': {'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['id',
                                                   'life',
                                                   'status',
                                                   'info',
                                                   'data',
                                                   'since'],
                                      'type': 'object'},
                     'StatusResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StatusResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'Tools': {'additionalProperties': False,
                               'properties': {'sha256': {'type': 'string'},
                                              'size': {'type': 'integer'},
                                              'url': {'type': 'string'},
                                              'version': {'$ref': '#/definitions/Binary'}},
                               'required': ['version', 'url', 'size'],
                               'type': 'object'},
                     'ToolsResult': {'additionalProperties': False,
                                     'properties': {'disable-ssl-hostname-verification': {'type': 'boolean'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'tools': {'items': {'$ref': '#/definitions/Tools'},
                                                              'type': 'array'}},
                                     'required': ['tools',
                                                  'disable-ssl-hostname-verification'],
                                     'type': 'object'},
                     'ToolsResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ToolsResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'UpdateBehavior': {'additionalProperties': False,
                                        'properties': {'enable-os-refresh-update': {'type': 'boolean'},
                                                       'enable-os-upgrade': {'type': 'boolean'}},
                                        'required': ['enable-os-refresh-update',
                                                     'enable-os-upgrade'],
                                        'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'},
                     'Volume': {'additionalProperties': False,
                                'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                               'volume-tag': {'type': 'string'}},
                                'required': ['volume-tag', 'info'],
                                'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeAttachmentParams': {'additionalProperties': False,
                                                'properties': {'instance-id': {'type': 'string'},
                                                               'machine-tag': {'type': 'string'},
                                                               'provider': {'type': 'string'},
                                                               'read-only': {'type': 'boolean'},
                                                               'volume-id': {'type': 'string'},
                                                               'volume-tag': {'type': 'string'}},
                                                'required': ['volume-tag',
                                                             'machine-tag',
                                                             'provider'],
                                                'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'},
                     'VolumeParams': {'additionalProperties': False,
                                      'properties': {'attachment': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                     'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'},
                                                     'provider': {'type': 'string'},
                                                     'size': {'type': 'integer'},
                                                     'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                              'type': 'object'},
                                                     'volume-tag': {'type': 'string'}},
                                      'required': ['volume-tag',
                                                   'size',
                                                   'provider'],
                                      'type': 'object'},
                     'WatchContainer': {'additionalProperties': False,
                                        'properties': {'container-type': {'type': 'string'},
                                                       'machine-tag': {'type': 'string'}},
                                        'required': ['machine-tag',
                                                     'container-type'],
                                        'type': 'object'},
                     'WatchContainers': {'additionalProperties': False,
                                         'properties': {'params': {'items': {'$ref': '#/definitions/WatchContainer'},
                                                                   'type': 'array'}},
                                         'required': ['params'],
                                         'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'Constraints': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ConstraintsResults'}},
                                    'type': 'object'},
                    'ContainerConfig': {'properties': {'Result': {'$ref': '#/definitions/ContainerConfig'}},
                                        'type': 'object'},
                    'ContainerManagerConfig': {'properties': {'Params': {'$ref': '#/definitions/ContainerManagerConfigParams'},
                                                              'Result': {'$ref': '#/definitions/ContainerManagerConfig'}},
                                               'type': 'object'},
                    'ControllerConfig': {'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'DistributionGroup': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/DistributionGroupResults'}},
                                          'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'FindTools': {'properties': {'Params': {'$ref': '#/definitions/FindToolsParams'},
                                                 'Result': {'$ref': '#/definitions/FindToolsResult'}},
                                  'type': 'object'},
                    'GetContainerInterfaceInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/MachineNetworkConfigResults'}},
                                                  'type': 'object'},
                    'HostChangesForContainers': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/HostNetworkChangeResults'}},
                                                 'type': 'object'},
                    'InstanceId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'InstanceStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StatusResults'}},
                                       'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'MachinesWithTransientErrors': {'properties': {'Result': {'$ref': '#/definitions/StatusResults'}},
                                                    'type': 'object'},
                    'MarkMachinesForRemoval': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'PrepareContainerInterfaceInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                     'Result': {'$ref': '#/definitions/MachineNetworkConfigResults'}},
                                                      'type': 'object'},
                    'ProvisioningInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/ProvisioningInfoResults'}},
                                         'type': 'object'},
                    'ReleaseContainerAddresses': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                  'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Series': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/StringResults'}},
                               'type': 'object'},
                    'SetHostMachineNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                    'type': 'object'},
                    'SetInstanceInfo': {'properties': {'Params': {'$ref': '#/definitions/InstancesInfo'},
                                                       'Result': {'$ref': '#/definitions/ErrorResults'}},
                                        'type': 'object'},
                    'SetInstanceStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetObservedNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                 'type': 'object'},
                    'SetPasswords': {'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'SetProviderNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                 'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetSupportedContainers': {'properties': {'Params': {'$ref': '#/definitions/MachineContainersParams'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'StateAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                       'type': 'object'},
                    'Status': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/StatusResults'}},
                               'type': 'object'},
                    'Tools': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/ToolsResults'}},
                              'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchAllContainers': {'properties': {'Params': {'$ref': '#/definitions/WatchContainers'},
                                                          'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                           'type': 'object'},
                    'WatchContainers': {'properties': {'Params': {'$ref': '#/definitions/WatchContainers'},
                                                       'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                        'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'},
                    'WatchMachineErrorRetry': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                               'type': 'object'},
                    'WatchModelMachines': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), typing.Sequence[str]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='APIAddresses',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> typing.Sequence[~HostPort]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='APIHostPorts',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> typing.Sequence[int]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='CACert',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConstraintsResults)
    async def Constraints(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ConstraintsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Constraints',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerConfig)
    async def ContainerConfig(self):
        '''

        Returns -> typing.Union[_ForwardRef('UpdateBehavior'), str, _ForwardRef('Settings'), bool]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ContainerConfig',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerManagerConfig)
    async def ContainerManagerConfig(self, type_):
        '''
        type_ : str
        Returns -> typing.Mapping[str, str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ContainerManagerConfig',
                   version=3,
                   params=_params)
        _params['type'] = type_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''

        Returns -> typing.Mapping[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ControllerConfig',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DistributionGroupResults)
    async def DistributionGroup(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~DistributionGroupResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='DistributionGroup',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='EnsureDead',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindToolsResult)
    async def FindTools(self, arch, major, minor, number, series):
        '''
        arch : str
        major : int
        minor : int
        number : Number
        series : str
        Returns -> typing.Union[_ForwardRef('Error'), typing.Sequence[~Tools]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='FindTools',
                   version=3,
                   params=_params)
        _params['arch'] = arch
        _params['major'] = major
        _params['minor'] = minor
        _params['number'] = number
        _params['series'] = series
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineNetworkConfigResults)
    async def GetContainerInterfaceInfo(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MachineNetworkConfigResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='GetContainerInterfaceInfo',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(HostNetworkChangeResults)
    async def HostChangesForContainers(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~HostNetworkChange]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='HostChangesForContainers',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def InstanceId(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='InstanceId',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def InstanceStatus(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StatusResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='InstanceStatus',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~LifeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Life',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def MachinesWithTransientErrors(self):
        '''

        Returns -> typing.Sequence[~StatusResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='MachinesWithTransientErrors',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def MarkMachinesForRemoval(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='MarkMachinesForRemoval',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ModelConfig',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ModelUUID',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineNetworkConfigResults)
    async def PrepareContainerInterfaceInfo(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MachineNetworkConfigResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='PrepareContainerInterfaceInfo',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProvisioningInfoResults)
    async def ProvisioningInfo(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ProvisioningInfoResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ProvisioningInfo',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ReleaseContainerAddresses(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ReleaseContainerAddresses',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Remove',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def Series(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Series',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetHostMachineNetworkConfig(self, config, tag):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetHostMachineNetworkConfig',
                   version=3,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetInstanceInfo(self, machines):
        '''
        machines : typing.Sequence[~InstanceInfo]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetInstanceInfo',
                   version=3,
                   params=_params)
        _params['machines'] = machines
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetInstanceStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetInstanceStatus',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetObservedNetworkConfig(self, config, tag):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetObservedNetworkConfig',
                   version=3,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes):
        '''
        changes : typing.Sequence[~EntityPassword]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetPasswords',
                   version=3,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetProviderNetworkConfig(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetProviderNetworkConfig',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetStatus',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetSupportedContainers(self, params):
        '''
        params : typing.Sequence[~MachineContainers]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetSupportedContainers',
                   version=3,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResult)
    async def StateAddresses(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), typing.Sequence[str]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='StateAddresses',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def Status(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StatusResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Status',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ToolsResults)
    async def Tools(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ToolsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Tools',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='UpdateStatus',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchAPIHostPorts',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchAllContainers(self, params):
        '''
        params : typing.Sequence[~WatchContainer]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchAllContainers',
                   version=3,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchContainers(self, params):
        '''
        params : typing.Sequence[~WatchContainer]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchContainers',
                   version=3,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchForModelConfigChanges',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchMachineErrorRetry(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchMachineErrorRetry',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchModelMachines(self):
        '''

        Returns -> typing.Union[typing.Sequence[str], _ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchModelMachines',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class SpacesFacade(Type):
    name = 'Spaces'
    version = 3
    schema =     {'definitions': {'CreateSpaceParams': {'additionalProperties': False,
                                           'properties': {'provider-id': {'type': 'string'},
                                                          'public': {'type': 'boolean'},
                                                          'space-tag': {'type': 'string'},
                                                          'subnet-tags': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                           'required': ['subnet-tags',
                                                        'space-tag',
                                                        'public'],
                                           'type': 'object'},
                     'CreateSpacesParams': {'additionalProperties': False,
                                            'properties': {'spaces': {'items': {'$ref': '#/definitions/CreateSpaceParams'},
                                                                      'type': 'array'}},
                                            'required': ['spaces'],
                                            'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSpacesResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/Space'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Space': {'additionalProperties': False,
                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                              'name': {'type': 'string'},
                                              'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                          'type': 'array'}},
                               'required': ['name', 'subnets'],
                               'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'}},
     'properties': {'CreateSpaces': {'properties': {'Params': {'$ref': '#/definitions/CreateSpacesParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListSpaces': {'properties': {'Result': {'$ref': '#/definitions/ListSpacesResults'}},
                                   'type': 'object'},
                    'ReloadSpaces': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def CreateSpaces(self, spaces):
        '''
        spaces : typing.Sequence[~CreateSpaceParams]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='CreateSpaces',
                   version=3,
                   params=_params)
        _params['spaces'] = spaces
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSpacesResults)
    async def ListSpaces(self):
        '''

        Returns -> typing.Sequence[~Space]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='ListSpaces',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ReloadSpaces(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='ReloadSpaces',
                   version=3,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class StorageFacade(Type):
    name = 'Storage'
    version = 3
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FilesystemAttachmentDetails': {'additionalProperties': False,
                                                     'properties': {'FilesystemAttachmentInfo': {'$ref': '#/definitions/FilesystemAttachmentInfo'},
                                                                    'life': {'type': 'string'}},
                                                     'required': ['FilesystemAttachmentInfo'],
                                                     'type': 'object'},
                     'FilesystemAttachmentInfo': {'additionalProperties': False,
                                                  'properties': {'mount-point': {'type': 'string'},
                                                                 'read-only': {'type': 'boolean'}},
                                                  'type': 'object'},
                     'FilesystemDetails': {'additionalProperties': False,
                                           'properties': {'filesystem-tag': {'type': 'string'},
                                                          'info': {'$ref': '#/definitions/FilesystemInfo'},
                                                          'life': {'type': 'string'},
                                                          'machine-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/FilesystemAttachmentDetails'}},
                                                                                  'type': 'object'},
                                                          'status': {'$ref': '#/definitions/EntityStatus'},
                                                          'storage': {'$ref': '#/definitions/StorageDetails'},
                                                          'volume-tag': {'type': 'string'}},
                                           'required': ['filesystem-tag',
                                                        'info',
                                                        'status'],
                                           'type': 'object'},
                     'FilesystemDetailsListResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'result': {'items': {'$ref': '#/definitions/FilesystemDetails'},
                                                                               'type': 'array'}},
                                                     'type': 'object'},
                     'FilesystemDetailsListResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemDetailsListResult'},
                                                                                 'type': 'array'}},
                                                      'type': 'object'},
                     'FilesystemFilter': {'additionalProperties': False,
                                          'properties': {'machines': {'items': {'type': 'string'},
                                                                      'type': 'array'}},
                                          'type': 'object'},
                     'FilesystemFilters': {'additionalProperties': False,
                                           'properties': {'filters': {'items': {'$ref': '#/definitions/FilesystemFilter'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'FilesystemInfo': {'additionalProperties': False,
                                        'properties': {'filesystem-id': {'type': 'string'},
                                                       'pool': {'type': 'string'},
                                                       'size': {'type': 'integer'}},
                                        'required': ['filesystem-id',
                                                     'pool',
                                                     'size'],
                                        'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'StorageAddParams': {'additionalProperties': False,
                                          'properties': {'name': {'type': 'string'},
                                                         'storage': {'$ref': '#/definitions/StorageConstraints'},
                                                         'unit': {'type': 'string'}},
                                          'required': ['unit', 'name', 'storage'],
                                          'type': 'object'},
                     'StorageAttachmentDetails': {'additionalProperties': False,
                                                  'properties': {'life': {'type': 'string'},
                                                                 'location': {'type': 'string'},
                                                                 'machine-tag': {'type': 'string'},
                                                                 'storage-tag': {'type': 'string'},
                                                                 'unit-tag': {'type': 'string'}},
                                                  'required': ['storage-tag',
                                                               'unit-tag',
                                                               'machine-tag'],
                                                  'type': 'object'},
                     'StorageAttachmentId': {'additionalProperties': False,
                                             'properties': {'storage-tag': {'type': 'string'},
                                                            'unit-tag': {'type': 'string'}},
                                             'required': ['storage-tag',
                                                          'unit-tag'],
                                             'type': 'object'},
                     'StorageAttachmentIds': {'additionalProperties': False,
                                              'properties': {'ids': {'items': {'$ref': '#/definitions/StorageAttachmentId'},
                                                                     'type': 'array'}},
                                              'required': ['ids'],
                                              'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StorageDetails': {'additionalProperties': False,
                                        'properties': {'attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageAttachmentDetails'}},
                                                                       'type': 'object'},
                                                       'kind': {'type': 'integer'},
                                                       'life': {'type': 'string'},
                                                       'owner-tag': {'type': 'string'},
                                                       'persistent': {'type': 'boolean'},
                                                       'status': {'$ref': '#/definitions/EntityStatus'},
                                                       'storage-tag': {'type': 'string'}},
                                        'required': ['storage-tag',
                                                     'owner-tag',
                                                     'kind',
                                                     'status',
                                                     'persistent'],
                                        'type': 'object'},
                     'StorageDetailsListResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'result': {'items': {'$ref': '#/definitions/StorageDetails'},
                                                                            'type': 'array'}},
                                                  'type': 'object'},
                     'StorageDetailsListResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/StorageDetailsListResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'StorageDetailsResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'result': {'$ref': '#/definitions/StorageDetails'}},
                                              'type': 'object'},
                     'StorageDetailsResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/StorageDetailsResult'},
                                                                          'type': 'array'}},
                                               'type': 'object'},
                     'StorageFilter': {'additionalProperties': False,
                                       'type': 'object'},
                     'StorageFilters': {'additionalProperties': False,
                                        'properties': {'filters': {'items': {'$ref': '#/definitions/StorageFilter'},
                                                                   'type': 'array'}},
                                        'type': 'object'},
                     'StoragePool': {'additionalProperties': False,
                                     'properties': {'attrs': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                    'name': {'type': 'string'},
                                                    'provider': {'type': 'string'}},
                                     'required': ['name', 'provider', 'attrs'],
                                     'type': 'object'},
                     'StoragePoolFilter': {'additionalProperties': False,
                                           'properties': {'names': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                          'providers': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                           'type': 'object'},
                     'StoragePoolFilters': {'additionalProperties': False,
                                            'properties': {'filters': {'items': {'$ref': '#/definitions/StoragePoolFilter'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'StoragePoolsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'storage-pools': {'items': {'$ref': '#/definitions/StoragePool'},
                                                                             'type': 'array'}},
                                            'type': 'object'},
                     'StoragePoolsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StoragePoolsResult'},
                                                                        'type': 'array'}},
                                             'type': 'object'},
                     'StoragesAddParams': {'additionalProperties': False,
                                           'properties': {'storages': {'items': {'$ref': '#/definitions/StorageAddParams'},
                                                                       'type': 'array'}},
                                           'required': ['storages'],
                                           'type': 'object'},
                     'VolumeAttachmentDetails': {'additionalProperties': False,
                                                 'properties': {'VolumeAttachmentInfo': {'$ref': '#/definitions/VolumeAttachmentInfo'},
                                                                'life': {'type': 'string'}},
                                                 'required': ['VolumeAttachmentInfo'],
                                                 'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeDetails': {'additionalProperties': False,
                                       'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                                      'life': {'type': 'string'},
                                                      'machine-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentDetails'}},
                                                                              'type': 'object'},
                                                      'status': {'$ref': '#/definitions/EntityStatus'},
                                                      'storage': {'$ref': '#/definitions/StorageDetails'},
                                                      'volume-tag': {'type': 'string'}},
                                       'required': ['volume-tag', 'info', 'status'],
                                       'type': 'object'},
                     'VolumeDetailsListResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'items': {'$ref': '#/definitions/VolumeDetails'},
                                                                           'type': 'array'}},
                                                 'type': 'object'},
                     'VolumeDetailsListResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/VolumeDetailsListResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'VolumeFilter': {'additionalProperties': False,
                                      'properties': {'machines': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'type': 'object'},
                     'VolumeFilters': {'additionalProperties': False,
                                       'properties': {'filters': {'items': {'$ref': '#/definitions/VolumeFilter'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'}},
     'properties': {'AddToUnit': {'properties': {'Params': {'$ref': '#/definitions/StoragesAddParams'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'Attach': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'CreatePool': {'properties': {'Params': {'$ref': '#/definitions/StoragePool'}},
                                   'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'Detach': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'ListFilesystems': {'properties': {'Params': {'$ref': '#/definitions/FilesystemFilters'},
                                                       'Result': {'$ref': '#/definitions/FilesystemDetailsListResults'}},
                                        'type': 'object'},
                    'ListPools': {'properties': {'Params': {'$ref': '#/definitions/StoragePoolFilters'},
                                                 'Result': {'$ref': '#/definitions/StoragePoolsResults'}},
                                  'type': 'object'},
                    'ListStorageDetails': {'properties': {'Params': {'$ref': '#/definitions/StorageFilters'},
                                                          'Result': {'$ref': '#/definitions/StorageDetailsListResults'}},
                                           'type': 'object'},
                    'ListVolumes': {'properties': {'Params': {'$ref': '#/definitions/VolumeFilters'},
                                                   'Result': {'$ref': '#/definitions/VolumeDetailsListResults'}},
                                    'type': 'object'},
                    'StorageDetails': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StorageDetailsResults'}},
                                       'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddToUnit(self, storages):
        '''
        storages : typing.Sequence[~StorageAddParams]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='AddToUnit',
                   version=3,
                   params=_params)
        _params['storages'] = storages
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Attach(self, ids):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Attach',
                   version=3,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def CreatePool(self, attrs, name, provider):
        '''
        attrs : typing.Mapping[str, typing.Any]
        name : str
        provider : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='CreatePool',
                   version=3,
                   params=_params)
        _params['attrs'] = attrs
        _params['name'] = name
        _params['provider'] = provider
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Destroy(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Destroy',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Detach(self, ids):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Detach',
                   version=3,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemDetailsListResults)
    async def ListFilesystems(self, filters):
        '''
        filters : typing.Sequence[~FilesystemFilter]
        Returns -> typing.Sequence[~FilesystemDetailsListResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListFilesystems',
                   version=3,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StoragePoolsResults)
    async def ListPools(self, filters):
        '''
        filters : typing.Sequence[~StoragePoolFilter]
        Returns -> typing.Sequence[~StoragePoolsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListPools',
                   version=3,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageDetailsListResults)
    async def ListStorageDetails(self, filters):
        '''
        filters : typing.Sequence[~StorageFilter]
        Returns -> typing.Sequence[~StorageDetailsListResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListStorageDetails',
                   version=3,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeDetailsListResults)
    async def ListVolumes(self, filters):
        '''
        filters : typing.Sequence[~VolumeFilter]
        Returns -> typing.Sequence[~VolumeDetailsListResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListVolumes',
                   version=3,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageDetailsResults)
    async def StorageDetails(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StorageDetailsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='StorageDetails',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class StorageProvisionerFacade(Type):
    name = 'StorageProvisioner'
    version = 3
    schema =     {'definitions': {'BlockDevice': {'additionalProperties': False,
                                     'properties': {'BusAddress': {'type': 'string'},
                                                    'DeviceLinks': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                    'DeviceName': {'type': 'string'},
                                                    'FilesystemType': {'type': 'string'},
                                                    'HardwareId': {'type': 'string'},
                                                    'InUse': {'type': 'boolean'},
                                                    'Label': {'type': 'string'},
                                                    'MountPoint': {'type': 'string'},
                                                    'Size': {'type': 'integer'},
                                                    'UUID': {'type': 'string'},
                                                    'WWN': {'type': 'string'}},
                                     'required': ['DeviceName',
                                                  'DeviceLinks',
                                                  'Label',
                                                  'UUID',
                                                  'HardwareId',
                                                  'WWN',
                                                  'BusAddress',
                                                  'Size',
                                                  'FilesystemType',
                                                  'InUse',
                                                  'MountPoint'],
                                     'type': 'object'},
                     'BlockDeviceResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'result': {'$ref': '#/definitions/BlockDevice'}},
                                           'required': ['result'],
                                           'type': 'object'},
                     'BlockDeviceResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/BlockDeviceResult'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Filesystem': {'additionalProperties': False,
                                    'properties': {'filesystem-tag': {'type': 'string'},
                                                   'info': {'$ref': '#/definitions/FilesystemInfo'},
                                                   'volume-tag': {'type': 'string'}},
                                    'required': ['filesystem-tag', 'info'],
                                    'type': 'object'},
                     'FilesystemAttachment': {'additionalProperties': False,
                                              'properties': {'filesystem-tag': {'type': 'string'},
                                                             'info': {'$ref': '#/definitions/FilesystemAttachmentInfo'},
                                                             'machine-tag': {'type': 'string'}},
                                              'required': ['filesystem-tag',
                                                           'machine-tag',
                                                           'info'],
                                              'type': 'object'},
                     'FilesystemAttachmentInfo': {'additionalProperties': False,
                                                  'properties': {'mount-point': {'type': 'string'},
                                                                 'read-only': {'type': 'boolean'}},
                                                  'type': 'object'},
                     'FilesystemAttachmentParams': {'additionalProperties': False,
                                                    'properties': {'filesystem-id': {'type': 'string'},
                                                                   'filesystem-tag': {'type': 'string'},
                                                                   'instance-id': {'type': 'string'},
                                                                   'machine-tag': {'type': 'string'},
                                                                   'mount-point': {'type': 'string'},
                                                                   'provider': {'type': 'string'},
                                                                   'read-only': {'type': 'boolean'}},
                                                    'required': ['filesystem-tag',
                                                                 'machine-tag',
                                                                 'provider'],
                                                    'type': 'object'},
                     'FilesystemAttachmentParamsResult': {'additionalProperties': False,
                                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                         'result': {'$ref': '#/definitions/FilesystemAttachmentParams'}},
                                                          'required': ['result'],
                                                          'type': 'object'},
                     'FilesystemAttachmentParamsResults': {'additionalProperties': False,
                                                           'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemAttachmentParamsResult'},
                                                                                      'type': 'array'}},
                                                           'type': 'object'},
                     'FilesystemAttachmentResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'result': {'$ref': '#/definitions/FilesystemAttachment'}},
                                                    'required': ['result'],
                                                    'type': 'object'},
                     'FilesystemAttachmentResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemAttachmentResult'},
                                                                                'type': 'array'}},
                                                     'type': 'object'},
                     'FilesystemAttachments': {'additionalProperties': False,
                                               'properties': {'filesystem-attachments': {'items': {'$ref': '#/definitions/FilesystemAttachment'},
                                                                                         'type': 'array'}},
                                               'required': ['filesystem-attachments'],
                                               'type': 'object'},
                     'FilesystemInfo': {'additionalProperties': False,
                                        'properties': {'filesystem-id': {'type': 'string'},
                                                       'pool': {'type': 'string'},
                                                       'size': {'type': 'integer'}},
                                        'required': ['filesystem-id',
                                                     'pool',
                                                     'size'],
                                        'type': 'object'},
                     'FilesystemParams': {'additionalProperties': False,
                                          'properties': {'attachment': {'$ref': '#/definitions/FilesystemAttachmentParams'},
                                                         'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                     'type': 'object'}},
                                                                        'type': 'object'},
                                                         'filesystem-tag': {'type': 'string'},
                                                         'provider': {'type': 'string'},
                                                         'size': {'type': 'integer'},
                                                         'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                         'volume-tag': {'type': 'string'}},
                                          'required': ['filesystem-tag',
                                                       'size',
                                                       'provider'],
                                          'type': 'object'},
                     'FilesystemParamsResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/FilesystemParams'}},
                                                'required': ['result'],
                                                'type': 'object'},
                     'FilesystemParamsResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemParamsResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'FilesystemResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'result': {'$ref': '#/definitions/Filesystem'}},
                                          'required': ['result'],
                                          'type': 'object'},
                     'FilesystemResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemResult'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'Filesystems': {'additionalProperties': False,
                                     'properties': {'filesystems': {'items': {'$ref': '#/definitions/Filesystem'},
                                                                    'type': 'array'}},
                                     'required': ['filesystems'],
                                     'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineStorageId': {'additionalProperties': False,
                                          'properties': {'attachment-tag': {'type': 'string'},
                                                         'machine-tag': {'type': 'string'}},
                                          'required': ['machine-tag',
                                                       'attachment-tag'],
                                          'type': 'object'},
                     'MachineStorageIds': {'additionalProperties': False,
                                           'properties': {'ids': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                  'type': 'array'}},
                                           'required': ['ids'],
                                           'type': 'object'},
                     'MachineStorageIdsWatchResult': {'additionalProperties': False,
                                                      'properties': {'changes': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                                 'type': 'array'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'watcher-id': {'type': 'string'}},
                                                      'required': ['watcher-id',
                                                                   'changes'],
                                                      'type': 'object'},
                     'MachineStorageIdsWatchResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/MachineStorageIdsWatchResult'},
                                                                                  'type': 'array'}},
                                                       'required': ['results'],
                                                       'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'Volume': {'additionalProperties': False,
                                'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                               'volume-tag': {'type': 'string'}},
                                'required': ['volume-tag', 'info'],
                                'type': 'object'},
                     'VolumeAttachment': {'additionalProperties': False,
                                          'properties': {'info': {'$ref': '#/definitions/VolumeAttachmentInfo'},
                                                         'machine-tag': {'type': 'string'},
                                                         'volume-tag': {'type': 'string'}},
                                          'required': ['volume-tag',
                                                       'machine-tag',
                                                       'info'],
                                          'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeAttachmentParams': {'additionalProperties': False,
                                                'properties': {'instance-id': {'type': 'string'},
                                                               'machine-tag': {'type': 'string'},
                                                               'provider': {'type': 'string'},
                                                               'read-only': {'type': 'boolean'},
                                                               'volume-id': {'type': 'string'},
                                                               'volume-tag': {'type': 'string'}},
                                                'required': ['volume-tag',
                                                             'machine-tag',
                                                             'provider'],
                                                'type': 'object'},
                     'VolumeAttachmentParamsResult': {'additionalProperties': False,
                                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                     'result': {'$ref': '#/definitions/VolumeAttachmentParams'}},
                                                      'required': ['result'],
                                                      'type': 'object'},
                     'VolumeAttachmentParamsResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/VolumeAttachmentParamsResult'},
                                                                                  'type': 'array'}},
                                                       'type': 'object'},
                     'VolumeAttachmentResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/VolumeAttachment'}},
                                                'required': ['result'],
                                                'type': 'object'},
                     'VolumeAttachmentResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/VolumeAttachmentResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'VolumeAttachments': {'additionalProperties': False,
                                           'properties': {'volume-attachments': {'items': {'$ref': '#/definitions/VolumeAttachment'},
                                                                                 'type': 'array'}},
                                           'required': ['volume-attachments'],
                                           'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'},
                     'VolumeParams': {'additionalProperties': False,
                                      'properties': {'attachment': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                     'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'},
                                                     'provider': {'type': 'string'},
                                                     'size': {'type': 'integer'},
                                                     'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                              'type': 'object'},
                                                     'volume-tag': {'type': 'string'}},
                                      'required': ['volume-tag',
                                                   'size',
                                                   'provider'],
                                      'type': 'object'},
                     'VolumeParamsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'result': {'$ref': '#/definitions/VolumeParams'}},
                                            'required': ['result'],
                                            'type': 'object'},
                     'VolumeParamsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/VolumeParamsResult'},
                                                                        'type': 'array'}},
                                             'type': 'object'},
                     'VolumeResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'$ref': '#/definitions/Volume'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'VolumeResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/VolumeResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'Volumes': {'additionalProperties': False,
                                 'properties': {'volumes': {'items': {'$ref': '#/definitions/Volume'},
                                                            'type': 'array'}},
                                 'required': ['volumes'],
                                 'type': 'object'}},
     'properties': {'AttachmentLife': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                      'Result': {'$ref': '#/definitions/LifeResults'}},
                                       'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'FilesystemAttachmentParams': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                                  'Result': {'$ref': '#/definitions/FilesystemAttachmentParamsResults'}},
                                                   'type': 'object'},
                    'FilesystemAttachments': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                             'Result': {'$ref': '#/definitions/FilesystemAttachmentResults'}},
                                              'type': 'object'},
                    'FilesystemParams': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/FilesystemParamsResults'}},
                                         'type': 'object'},
                    'Filesystems': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/FilesystemResults'}},
                                    'type': 'object'},
                    'InstanceId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'RemoveAttachment': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'SetFilesystemAttachmentInfo': {'properties': {'Params': {'$ref': '#/definitions/FilesystemAttachments'},
                                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                    'type': 'object'},
                    'SetFilesystemInfo': {'properties': {'Params': {'$ref': '#/definitions/Filesystems'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetVolumeAttachmentInfo': {'properties': {'Params': {'$ref': '#/definitions/VolumeAttachments'},
                                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                'type': 'object'},
                    'SetVolumeInfo': {'properties': {'Params': {'$ref': '#/definitions/Volumes'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'VolumeAttachmentParams': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                              'Result': {'$ref': '#/definitions/VolumeAttachmentParamsResults'}},
                                               'type': 'object'},
                    'VolumeAttachments': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                         'Result': {'$ref': '#/definitions/VolumeAttachmentResults'}},
                                          'type': 'object'},
                    'VolumeBlockDevices': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                          'Result': {'$ref': '#/definitions/BlockDeviceResults'}},
                                           'type': 'object'},
                    'VolumeParams': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/VolumeParamsResults'}},
                                     'type': 'object'},
                    'Volumes': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/VolumeResults'}},
                                'type': 'object'},
                    'WatchBlockDevices': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                          'type': 'object'},
                    'WatchFilesystemAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResults'}},
                                                   'type': 'object'},
                    'WatchFilesystems': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                         'type': 'object'},
                    'WatchMachines': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                      'type': 'object'},
                    'WatchVolumeAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResults'}},
                                               'type': 'object'},
                    'WatchVolumes': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                     'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(LifeResults)
    async def AttachmentLife(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~LifeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='AttachmentLife',
                   version=3,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='EnsureDead',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemAttachmentParamsResults)
    async def FilesystemAttachmentParams(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~FilesystemAttachmentParamsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='FilesystemAttachmentParams',
                   version=3,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemAttachmentResults)
    async def FilesystemAttachments(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~FilesystemAttachmentResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='FilesystemAttachments',
                   version=3,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemParamsResults)
    async def FilesystemParams(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~FilesystemParamsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='FilesystemParams',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemResults)
    async def Filesystems(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~FilesystemResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Filesystems',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def InstanceId(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='InstanceId',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~LifeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Life',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Remove',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveAttachment(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='RemoveAttachment',
                   version=3,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetFilesystemAttachmentInfo(self, filesystem_attachments):
        '''
        filesystem_attachments : typing.Sequence[~FilesystemAttachment]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetFilesystemAttachmentInfo',
                   version=3,
                   params=_params)
        _params['filesystem-attachments'] = filesystem_attachments
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetFilesystemInfo(self, filesystems):
        '''
        filesystems : typing.Sequence[~Filesystem]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetFilesystemInfo',
                   version=3,
                   params=_params)
        _params['filesystems'] = filesystems
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetStatus',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetVolumeAttachmentInfo(self, volume_attachments):
        '''
        volume_attachments : typing.Sequence[~VolumeAttachment]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetVolumeAttachmentInfo',
                   version=3,
                   params=_params)
        _params['volume-attachments'] = volume_attachments
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetVolumeInfo(self, volumes):
        '''
        volumes : typing.Sequence[~Volume]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetVolumeInfo',
                   version=3,
                   params=_params)
        _params['volumes'] = volumes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='UpdateStatus',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeAttachmentParamsResults)
    async def VolumeAttachmentParams(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~VolumeAttachmentParamsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeAttachmentParams',
                   version=3,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeAttachmentResults)
    async def VolumeAttachments(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~VolumeAttachmentResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeAttachments',
                   version=3,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BlockDeviceResults)
    async def VolumeBlockDevices(self, ids):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> typing.Sequence[~BlockDeviceResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeBlockDevices',
                   version=3,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeParamsResults)
    async def VolumeParams(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~VolumeParamsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeParams',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeResults)
    async def Volumes(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~VolumeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Volumes',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchBlockDevices(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchBlockDevices',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineStorageIdsWatchResults)
    async def WatchFilesystemAttachments(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MachineStorageIdsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchFilesystemAttachments',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchFilesystems(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchFilesystems',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMachines(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchMachines',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineStorageIdsWatchResults)
    async def WatchVolumeAttachments(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MachineStorageIdsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchVolumeAttachments',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchVolumes(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~StringsWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchVolumes',
                   version=3,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply
