# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client._definitions import *
from juju.client.facade import ReturnMapping, Type


class ActionFacade(Type):
    name = 'Action'
    version = 2
    schema =     {'definitions': {'Action': {'additionalProperties': False,
                                'properties': {'name': {'type': 'string'},
                                               'parameters': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                               'receiver': {'type': 'string'},
                                               'tag': {'type': 'string'}},
                                'required': ['tag', 'receiver', 'name'],
                                'type': 'object'},
                     'ActionResult': {'additionalProperties': False,
                                      'properties': {'action': {'$ref': '#/definitions/Action'},
                                                     'completed': {'format': 'date-time',
                                                                   'type': 'string'},
                                                     'enqueued': {'format': 'date-time',
                                                                  'type': 'string'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'message': {'type': 'string'},
                                                     'output': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'started': {'format': 'date-time',
                                                                 'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'type': 'object'},
                     'ActionResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ActionSpec': {'additionalProperties': False,
                                    'properties': {'description': {'type': 'string'},
                                                   'params': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'}},
                                    'required': ['description', 'params'],
                                    'type': 'object'},
                     'Actions': {'additionalProperties': False,
                                 'properties': {'actions': {'items': {'$ref': '#/definitions/Action'},
                                                            'type': 'array'}},
                                 'type': 'object'},
                     'ActionsByName': {'additionalProperties': False,
                                       'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'},
                                                      'error': {'$ref': '#/definitions/Error'},
                                                      'name': {'type': 'string'}},
                                       'type': 'object'},
                     'ActionsByNames': {'additionalProperties': False,
                                        'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByName'},
                                                                   'type': 'array'}},
                                        'type': 'object'},
                     'ActionsByReceiver': {'additionalProperties': False,
                                           'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                      'type': 'array'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'receiver': {'type': 'string'}},
                                           'type': 'object'},
                     'ActionsByReceivers': {'additionalProperties': False,
                                            'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByReceiver'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'ApplicationCharmActionsResult': {'additionalProperties': False,
                                                       'properties': {'actions': {'patternProperties': {'.*': {'$ref': '#/definitions/ActionSpec'}},
                                                                                  'type': 'object'},
                                                                      'application-tag': {'type': 'string'},
                                                                      'error': {'$ref': '#/definitions/Error'}},
                                                       'type': 'object'},
                     'ApplicationsCharmActionsResults': {'additionalProperties': False,
                                                         'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationCharmActionsResult'},
                                                                                    'type': 'array'}},
                                                         'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'FindActionsByNames': {'additionalProperties': False,
                                            'properties': {'names': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                            'type': 'object'},
                     'FindTags': {'additionalProperties': False,
                                  'properties': {'prefixes': {'items': {'type': 'string'},
                                                              'type': 'array'}},
                                  'required': ['prefixes'],
                                  'type': 'object'},
                     'FindTagsResults': {'additionalProperties': False,
                                         'properties': {'matches': {'patternProperties': {'.*': {'items': {'$ref': '#/definitions/Entity'},
                                                                                                 'type': 'array'}},
                                                                    'type': 'object'}},
                                         'required': ['matches'],
                                         'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RunParams': {'additionalProperties': False,
                                   'properties': {'applications': {'items': {'type': 'string'},
                                                                   'type': 'array'},
                                                  'commands': {'type': 'string'},
                                                  'machines': {'items': {'type': 'string'},
                                                               'type': 'array'},
                                                  'timeout': {'type': 'integer'},
                                                  'units': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                   'required': ['commands', 'timeout'],
                                   'type': 'object'}},
     'properties': {'Actions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'ApplicationsCharmsActions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/ApplicationsCharmActionsResults'}},
                                                  'type': 'object'},
                    'Cancel': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ActionResults'}},
                               'type': 'object'},
                    'Enqueue': {'properties': {'Params': {'$ref': '#/definitions/Actions'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'FindActionTagsByPrefix': {'properties': {'Params': {'$ref': '#/definitions/FindTags'},
                                                              'Result': {'$ref': '#/definitions/FindTagsResults'}},
                                               'type': 'object'},
                    'FindActionsByNames': {'properties': {'Params': {'$ref': '#/definitions/FindActionsByNames'},
                                                          'Result': {'$ref': '#/definitions/ActionsByNames'}},
                                           'type': 'object'},
                    'ListAll': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                'type': 'object'},
                    'ListCompleted': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                      'type': 'object'},
                    'ListPending': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                    'type': 'object'},
                    'ListRunning': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                    'type': 'object'},
                    'Run': {'properties': {'Params': {'$ref': '#/definitions/RunParams'},
                                           'Result': {'$ref': '#/definitions/ActionResults'}},
                            'type': 'object'},
                    'RunOnAllMachines': {'properties': {'Params': {'$ref': '#/definitions/RunParams'},
                                                        'Result': {'$ref': '#/definitions/ActionResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ActionResults)
    async def Actions(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Actions',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationsCharmActionsResults)
    async def ApplicationsCharmsActions(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ApplicationCharmActionsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ApplicationsCharmsActions',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Cancel(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Cancel',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Enqueue(self, actions):
        '''
        actions : typing.Sequence[~Action]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Enqueue',
                   version=2,
                   params=_params)
        _params['actions'] = actions
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindTagsResults)
    async def FindActionTagsByPrefix(self, prefixes):
        '''
        prefixes : typing.Sequence[str]
        Returns -> typing.Sequence[~Entity]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='FindActionTagsByPrefix',
                   version=2,
                   params=_params)
        _params['prefixes'] = prefixes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByNames)
    async def FindActionsByNames(self, names):
        '''
        names : typing.Sequence[str]
        Returns -> typing.Sequence[~ActionsByName]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='FindActionsByNames',
                   version=2,
                   params=_params)
        _params['names'] = names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListAll(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionsByReceiver]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListAll',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListCompleted(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionsByReceiver]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListCompleted',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListPending(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionsByReceiver]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListPending',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListRunning(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ActionsByReceiver]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListRunning',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Run(self, applications, commands, machines, timeout, units):
        '''
        applications : typing.Sequence[str]
        commands : str
        machines : typing.Sequence[str]
        timeout : int
        units : typing.Sequence[str]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Run',
                   version=2,
                   params=_params)
        _params['applications'] = applications
        _params['commands'] = commands
        _params['machines'] = machines
        _params['timeout'] = timeout
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def RunOnAllMachines(self, applications, commands, machines, timeout, units):
        '''
        applications : typing.Sequence[str]
        commands : str
        machines : typing.Sequence[str]
        timeout : int
        units : typing.Sequence[str]
        Returns -> typing.Sequence[~ActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='RunOnAllMachines',
                   version=2,
                   params=_params)
        _params['applications'] = applications
        _params['commands'] = commands
        _params['machines'] = machines
        _params['timeout'] = timeout
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



class AgentFacade(Type):
    name = 'Agent'
    version = 2
    schema =     {'definitions': {'AgentGetEntitiesResult': {'additionalProperties': False,
                                                'properties': {'container-type': {'type': 'string'},
                                                               'error': {'$ref': '#/definitions/Error'},
                                                               'jobs': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                               'life': {'type': 'string'}},
                                                'required': ['life',
                                                             'jobs',
                                                             'container-type'],
                                                'type': 'object'},
                     'AgentGetEntitiesResults': {'additionalProperties': False,
                                                 'properties': {'entities': {'items': {'$ref': '#/definitions/AgentGetEntitiesResult'},
                                                                             'type': 'array'}},
                                                 'required': ['entities'],
                                                 'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudSpec': {'additionalProperties': False,
                                   'properties': {'cacertificates': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                  'credential': {'$ref': '#/definitions/CloudCredential'},
                                                  'endpoint': {'type': 'string'},
                                                  'identity-endpoint': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'region': {'type': 'string'},
                                                  'storage-endpoint': {'type': 'string'},
                                                  'type': {'type': 'string'}},
                                   'required': ['type', 'name'],
                                   'type': 'object'},
                     'CloudSpecResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudSpec'}},
                                         'type': 'object'},
                     'CloudSpecResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudSpecResult'},
                                                                     'type': 'array'}},
                                          'type': 'object'},
                     'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'IsMasterResult': {'additionalProperties': False,
                                        'properties': {'master': {'type': 'boolean'}},
                                        'required': ['master'],
                                        'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ModelTag': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'StateServingInfo': {'additionalProperties': False,
                                          'properties': {'api-port': {'type': 'integer'},
                                                         'ca-private-key': {'type': 'string'},
                                                         'cert': {'type': 'string'},
                                                         'controller-api-port': {'type': 'integer'},
                                                         'private-key': {'type': 'string'},
                                                         'shared-secret': {'type': 'string'},
                                                         'state-port': {'type': 'integer'},
                                                         'system-identity': {'type': 'string'}},
                                          'required': ['api-port',
                                                       'state-port',
                                                       'cert',
                                                       'private-key',
                                                       'ca-private-key',
                                                       'shared-secret',
                                                       'system-identity'],
                                          'type': 'object'}},
     'properties': {'ClearReboot': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'CloudSpec': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudSpecResults'}},
                                  'type': 'object'},
                    'ControllerAPIInfoForModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'GetCloudSpec': {'properties': {'Params': {'$ref': '#/definitions/ModelTag'},
                                                    'Result': {'$ref': '#/definitions/CloudSpecResult'}},
                                     'type': 'object'},
                    'GetEntities': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/AgentGetEntitiesResults'}},
                                    'type': 'object'},
                    'IsMaster': {'properties': {'Result': {'$ref': '#/definitions/IsMasterResult'}},
                                 'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'SetPasswords': {'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'StateServingInfo': {'properties': {'Result': {'$ref': '#/definitions/StateServingInfo'}},
                                         'type': 'object'},
                    'WatchCredentials': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                         'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ClearReboot(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='ClearReboot',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResults)
    async def CloudSpec(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~CloudSpecResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='CloudSpec',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ControllerAPIInfoResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='ControllerAPIInfoForModels',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''

        Returns -> typing.Mapping[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='ControllerConfig',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResult)
    async def GetCloudSpec(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), _ForwardRef('CloudSpec')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='GetCloudSpec',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AgentGetEntitiesResults)
    async def GetEntities(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~AgentGetEntitiesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='GetEntities',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IsMasterResult)
    async def IsMaster(self):
        '''

        Returns -> bool
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='IsMaster',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='ModelConfig',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes):
        '''
        changes : typing.Sequence[~EntityPassword]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='SetPasswords',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StateServingInfo)
    async def StateServingInfo(self):
        '''

        Returns -> typing.Union[int, str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='StateServingInfo',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchCredentials(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='WatchCredentials',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='WatchForModelConfigChanges',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class AllModelWatcherFacade(Type):
    name = 'AllModelWatcher'
    version = 2
    schema =     {'definitions': {'AllWatcherNextResults': {'additionalProperties': False,
                                               'properties': {'deltas': {'items': {'$ref': '#/definitions/Delta'},
                                                                         'type': 'array'}},
                                               'required': ['deltas'],
                                               'type': 'object'},
                     'Delta': {'additionalProperties': False,
                               'properties': {'entity': {'additionalProperties': True,
                                                         'type': 'object'},
                                              'removed': {'type': 'boolean'}},
                               'required': ['removed', 'entity'],
                               'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/AllWatcherNextResults'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AllWatcherNextResults)
    async def Next(self):
        '''

        Returns -> typing.Sequence[~Delta]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AllModelWatcher',
                   request='Next',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AllModelWatcher',
                   request='Stop',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class AnnotationsFacade(Type):
    name = 'Annotations'
    version = 2
    schema =     {'definitions': {'AnnotationsGetResult': {'additionalProperties': False,
                                              'properties': {'annotations': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                             'entity': {'type': 'string'},
                                                             'error': {'$ref': '#/definitions/ErrorResult'}},
                                              'required': ['entity', 'annotations'],
                                              'type': 'object'},
                     'AnnotationsGetResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/AnnotationsGetResult'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'AnnotationsSet': {'additionalProperties': False,
                                        'properties': {'annotations': {'items': {'$ref': '#/definitions/EntityAnnotations'},
                                                                       'type': 'array'}},
                                        'required': ['annotations'],
                                        'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityAnnotations': {'additionalProperties': False,
                                           'properties': {'annotations': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'},
                                                          'entity': {'type': 'string'}},
                                           'required': ['entity', 'annotations'],
                                           'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'Get': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                           'Result': {'$ref': '#/definitions/AnnotationsGetResults'}},
                            'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/AnnotationsSet'},
                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AnnotationsGetResults)
    async def Get(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~AnnotationsGetResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Annotations',
                   request='Get',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Set(self, annotations):
        '''
        annotations : typing.Sequence[~EntityAnnotations]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Annotations',
                   request='Set',
                   version=2,
                   params=_params)
        _params['annotations'] = annotations
        reply = await self.rpc(msg)
        return reply



class ApplicationFacade(Type):
    name = 'Application'
    version = 2
    schema =     {'definitions': {'AddApplicationUnits': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'num-units': {'type': 'integer'},
                                                            'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                          'type': 'array'}},
                                             'required': ['application',
                                                          'num-units',
                                                          'placement'],
                                             'type': 'object'},
                     'AddApplicationUnitsResults': {'additionalProperties': False,
                                                    'properties': {'units': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                                    'required': ['units'],
                                                    'type': 'object'},
                     'AddRelation': {'additionalProperties': False,
                                     'properties': {'endpoints': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                     'required': ['endpoints'],
                                     'type': 'object'},
                     'AddRelationResults': {'additionalProperties': False,
                                            'properties': {'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                                         'type': 'object'}},
                                            'required': ['endpoints'],
                                            'type': 'object'},
                     'ApplicationCharmRelations': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'ApplicationCharmRelationsResults': {'additionalProperties': False,
                                                          'properties': {'charm-relations': {'items': {'type': 'string'},
                                                                                             'type': 'array'}},
                                                          'required': ['charm-relations'],
                                                          'type': 'object'},
                     'ApplicationDeploy': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'channel': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                          'config-yaml': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'num-units': {'type': 'integer'},
                                                          'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                        'type': 'array'},
                                                          'resources': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'}},
                                           'required': ['application',
                                                        'series',
                                                        'charm-url',
                                                        'channel',
                                                        'num-units',
                                                        'config-yaml',
                                                        'constraints'],
                                           'type': 'object'},
                     'ApplicationDestroy': {'additionalProperties': False,
                                            'properties': {'application': {'type': 'string'}},
                                            'required': ['application'],
                                            'type': 'object'},
                     'ApplicationExpose': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'}},
                                           'required': ['application'],
                                           'type': 'object'},
                     'ApplicationGet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'}},
                                        'required': ['application'],
                                        'type': 'object'},
                     'ApplicationGetResults': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'charm': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'constraints': {'$ref': '#/definitions/Value'},
                                                              'series': {'type': 'string'}},
                                               'required': ['application',
                                                            'charm',
                                                            'config',
                                                            'constraints',
                                                            'series'],
                                               'type': 'object'},
                     'ApplicationMetricCredential': {'additionalProperties': False,
                                                     'properties': {'application': {'type': 'string'},
                                                                    'metrics-credentials': {'items': {'type': 'integer'},
                                                                                            'type': 'array'}},
                                                     'required': ['application',
                                                                  'metrics-credentials'],
                                                     'type': 'object'},
                     'ApplicationMetricCredentials': {'additionalProperties': False,
                                                      'properties': {'creds': {'items': {'$ref': '#/definitions/ApplicationMetricCredential'},
                                                                               'type': 'array'}},
                                                      'required': ['creds'],
                                                      'type': 'object'},
                     'ApplicationSet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'options': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'}},
                                        'required': ['application', 'options'],
                                        'type': 'object'},
                     'ApplicationSetCharm': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'channel': {'type': 'string'},
                                                            'charm-url': {'type': 'string'},
                                                            'config-settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                            'config-settings-yaml': {'type': 'string'},
                                                            'force-series': {'type': 'boolean'},
                                                            'force-units': {'type': 'boolean'},
                                                            'resource-ids': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                            'storage-constraints': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageConstraints'}},
                                                                                    'type': 'object'}},
                                             'required': ['application',
                                                          'charm-url',
                                                          'channel',
                                                          'force-units',
                                                          'force-series'],
                                             'type': 'object'},
                     'ApplicationUnexpose': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'}},
                                             'required': ['application'],
                                             'type': 'object'},
                     'ApplicationUnset': {'additionalProperties': False,
                                          'properties': {'application': {'type': 'string'},
                                                         'options': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                          'required': ['application', 'options'],
                                          'type': 'object'},
                     'ApplicationUpdate': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'force-charm-url': {'type': 'boolean'},
                                                          'force-series': {'type': 'boolean'},
                                                          'min-units': {'type': 'integer'},
                                                          'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                       'type': 'object'},
                                                          'settings-yaml': {'type': 'string'}},
                                           'required': ['application',
                                                        'charm-url',
                                                        'force-charm-url',
                                                        'force-series',
                                                        'settings-yaml'],
                                           'type': 'object'},
                     'ApplicationsDeploy': {'additionalProperties': False,
                                            'properties': {'applications': {'items': {'$ref': '#/definitions/ApplicationDeploy'},
                                                                            'type': 'array'}},
                                            'required': ['applications'],
                                            'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'DestroyApplicationUnits': {'additionalProperties': False,
                                                 'properties': {'unit-names': {'items': {'type': 'string'},
                                                                               'type': 'array'}},
                                                 'required': ['unit-names'],
                                                 'type': 'object'},
                     'DestroyRelation': {'additionalProperties': False,
                                         'properties': {'endpoints': {'items': {'type': 'string'},
                                                                      'type': 'array'}},
                                         'required': ['endpoints'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'GetApplicationConstraints': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'GetConstraintsResults': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'AddRelation': {'properties': {'Params': {'$ref': '#/definitions/AddRelation'},
                                                   'Result': {'$ref': '#/definitions/AddRelationResults'}},
                                    'type': 'object'},
                    'AddUnits': {'properties': {'Params': {'$ref': '#/definitions/AddApplicationUnits'},
                                                'Result': {'$ref': '#/definitions/AddApplicationUnitsResults'}},
                                 'type': 'object'},
                    'CharmRelations': {'properties': {'Params': {'$ref': '#/definitions/ApplicationCharmRelations'},
                                                      'Result': {'$ref': '#/definitions/ApplicationCharmRelationsResults'}},
                                       'type': 'object'},
                    'Deploy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationsDeploy'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationDestroy'}},
                                'type': 'object'},
                    'DestroyRelation': {'properties': {'Params': {'$ref': '#/definitions/DestroyRelation'}},
                                        'type': 'object'},
                    'DestroyUnits': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationUnits'}},
                                     'type': 'object'},
                    'Expose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationExpose'}},
                               'type': 'object'},
                    'Get': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                           'Result': {'$ref': '#/definitions/ApplicationGetResults'}},
                            'type': 'object'},
                    'GetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                                   'Result': {'$ref': '#/definitions/StringResult'}},
                                    'type': 'object'},
                    'GetConstraints': {'properties': {'Params': {'$ref': '#/definitions/GetApplicationConstraints'},
                                                      'Result': {'$ref': '#/definitions/GetConstraintsResults'}},
                                       'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSet'}},
                            'type': 'object'},
                    'SetCharm': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSetCharm'}},
                                 'type': 'object'},
                    'SetConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                       'type': 'object'},
                    'SetMetricCredentials': {'properties': {'Params': {'$ref': '#/definitions/ApplicationMetricCredentials'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'Unexpose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnexpose'}},
                                 'type': 'object'},
                    'Unset': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnset'}},
                              'type': 'object'},
                    'Update': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUpdate'}},
                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddRelationResults)
    async def AddRelation(self, endpoints):
        '''
        endpoints : typing.Sequence[str]
        Returns -> typing.Mapping[str, ~CharmRelation]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddRelation',
                   version=2,
                   params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddApplicationUnitsResults)
    async def AddUnits(self, application, num_units, placement):
        '''
        application : str
        num_units : int
        placement : typing.Sequence[~Placement]
        Returns -> typing.Sequence[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddUnits',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['num-units'] = num_units
        _params['placement'] = placement
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationCharmRelationsResults)
    async def CharmRelations(self, application):
        '''
        application : str
        Returns -> typing.Sequence[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmRelations',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Deploy(self, applications):
        '''
        applications : typing.Sequence[~ApplicationDeploy]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Deploy',
                   version=2,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Destroy(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Destroy',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyRelation(self, endpoints):
        '''
        endpoints : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyRelation',
                   version=2,
                   params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyUnits(self, unit_names):
        '''
        unit_names : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnits',
                   version=2,
                   params=_params)
        _params['unit-names'] = unit_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Expose(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Expose',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetResults)
    async def Get(self, application):
        '''
        application : str
        Returns -> typing.Union[str, typing.Mapping[str, typing.Any], _ForwardRef('Value')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Get',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def GetCharmURL(self, application):
        '''
        application : str
        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetCharmURL',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetConstraintsResults)
    async def GetConstraints(self, application):
        '''
        application : str
        Returns -> Value
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConstraints',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Set(self, application, options):
        '''
        application : str
        options : typing.Mapping[str, str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Set',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetCharm(self, application, channel, charm_url, config_settings, config_settings_yaml, force_series, force_units, resource_ids, storage_constraints):
        '''
        application : str
        channel : str
        charm_url : str
        config_settings : typing.Mapping[str, str]
        config_settings_yaml : str
        force_series : bool
        force_units : bool
        resource_ids : typing.Mapping[str, str]
        storage_constraints : typing.Mapping[str, ~StorageConstraints]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetCharm',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['channel'] = channel
        _params['charm-url'] = charm_url
        _params['config-settings'] = config_settings
        _params['config-settings-yaml'] = config_settings_yaml
        _params['force-series'] = force_series
        _params['force-units'] = force_units
        _params['resource-ids'] = resource_ids
        _params['storage-constraints'] = storage_constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetConstraints(self, application, constraints):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetConstraints',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMetricCredentials(self, creds):
        '''
        creds : typing.Sequence[~ApplicationMetricCredential]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetMetricCredentials',
                   version=2,
                   params=_params)
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unexpose(self, application):
        '''
        application : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unexpose',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unset(self, application, options):
        '''
        application : str
        options : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unset',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Update(self, application, charm_url, constraints, force_charm_url, force_series, min_units, settings, settings_yaml):
        '''
        application : str
        charm_url : str
        constraints : Value
        force_charm_url : bool
        force_series : bool
        min_units : int
        settings : typing.Mapping[str, str]
        settings_yaml : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Update',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['charm-url'] = charm_url
        _params['constraints'] = constraints
        _params['force-charm-url'] = force_charm_url
        _params['force-series'] = force_series
        _params['min-units'] = min_units
        _params['settings'] = settings
        _params['settings-yaml'] = settings_yaml
        reply = await self.rpc(msg)
        return reply



class ApplicationOffersFacade(Type):
    name = 'ApplicationOffers'
    version = 2
    schema =     {'definitions': {'AddApplicationOffer': {'additionalProperties': False,
                                             'properties': {'application-description': {'type': 'string'},
                                                            'application-name': {'type': 'string'},
                                                            'endpoints': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'},
                                                            'model-tag': {'type': 'string'},
                                                            'offer-name': {'type': 'string'}},
                                             'required': ['model-tag',
                                                          'offer-name',
                                                          'application-name',
                                                          'application-description',
                                                          'endpoints'],
                                             'type': 'object'},
                     'AddApplicationOffers': {'additionalProperties': False,
                                              'properties': {'Offers': {'items': {'$ref': '#/definitions/AddApplicationOffer'},
                                                                        'type': 'array'}},
                                              'required': ['Offers'],
                                              'type': 'object'},
                     'ApplicationOfferAdminDetails': {'additionalProperties': False,
                                                      'properties': {'ApplicationOfferDetails': {'$ref': '#/definitions/ApplicationOfferDetails'},
                                                                     'application-name': {'type': 'string'},
                                                                     'charm-url': {'type': 'string'},
                                                                     'connections': {'items': {'$ref': '#/definitions/OfferConnection'},
                                                                                     'type': 'array'}},
                                                      'required': ['ApplicationOfferDetails',
                                                                   'application-name',
                                                                   'charm-url'],
                                                      'type': 'object'},
                     'ApplicationOfferDetails': {'additionalProperties': False,
                                                 'properties': {'application-description': {'type': 'string'},
                                                                'bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                                'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                              'type': 'array'},
                                                                'offer-name': {'type': 'string'},
                                                                'offer-url': {'type': 'string'},
                                                                'offer-uuid': {'type': 'string'},
                                                                'source-model-tag': {'type': 'string'},
                                                                'spaces': {'items': {'$ref': '#/definitions/RemoteSpace'},
                                                                           'type': 'array'},
                                                                'users': {'items': {'$ref': '#/definitions/OfferUserDetails'},
                                                                          'type': 'array'}},
                                                 'required': ['source-model-tag',
                                                              'offer-uuid',
                                                              'offer-url',
                                                              'offer-name',
                                                              'application-description'],
                                                 'type': 'object'},
                     'ApplicationOfferResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/ApplicationOfferAdminDetails'}},
                                                'type': 'object'},
                     'ApplicationOffersResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationOfferResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'ConsumeOfferDetails': {'additionalProperties': False,
                                             'properties': {'external-controller': {'$ref': '#/definitions/ExternalControllerInfo'},
                                                            'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                            'offer': {'$ref': '#/definitions/ApplicationOfferDetails'}},
                                             'type': 'object'},
                     'ConsumeOfferDetailsResult': {'additionalProperties': False,
                                                   'properties': {'ConsumeOfferDetails': {'$ref': '#/definitions/ConsumeOfferDetails'},
                                                                  'error': {'$ref': '#/definitions/Error'}},
                                                   'required': ['ConsumeOfferDetails'],
                                                   'type': 'object'},
                     'ConsumeOfferDetailsResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/ConsumeOfferDetailsResult'},
                                                                               'type': 'array'}},
                                                    'type': 'object'},
                     'DestroyApplicationOffers': {'additionalProperties': False,
                                                  'properties': {'force': {'type': 'boolean'},
                                                                 'offer-urls': {'items': {'type': 'string'},
                                                                                'type': 'array'}},
                                                  'required': ['offer-urls'],
                                                  'type': 'object'},
                     'EndpointFilterAttributes': {'additionalProperties': False,
                                                  'properties': {'interface': {'type': 'string'},
                                                                 'name': {'type': 'string'},
                                                                 'role': {'type': 'string'}},
                                                  'required': ['role',
                                                               'interface',
                                                               'name'],
                                                  'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ExternalControllerInfo': {'additionalProperties': False,
                                                'properties': {'addrs': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                               'ca-cert': {'type': 'string'},
                                                               'controller-alias': {'type': 'string'},
                                                               'controller-tag': {'type': 'string'}},
                                                'required': ['controller-tag',
                                                             'controller-alias',
                                                             'addrs',
                                                             'ca-cert'],
                                                'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModifyOfferAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'offer-url': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'action',
                                                        'access',
                                                        'offer-url'],
                                           'type': 'object'},
                     'ModifyOfferAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyOfferAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'OfferConnection': {'additionalProperties': False,
                                         'properties': {'endpoint': {'type': 'string'},
                                                        'ingress-subnets': {'items': {'type': 'string'},
                                                                            'type': 'array'},
                                                        'relation-id': {'type': 'integer'},
                                                        'source-model-tag': {'type': 'string'},
                                                        'status': {'$ref': '#/definitions/EntityStatus'},
                                                        'username': {'type': 'string'}},
                                         'required': ['source-model-tag',
                                                      'relation-id',
                                                      'username',
                                                      'endpoint',
                                                      'status',
                                                      'ingress-subnets'],
                                         'type': 'object'},
                     'OfferFilter': {'additionalProperties': False,
                                     'properties': {'allowed-users': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                    'application-description': {'type': 'string'},
                                                    'application-name': {'type': 'string'},
                                                    'application-user': {'type': 'string'},
                                                    'connected-users': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                    'endpoints': {'items': {'$ref': '#/definitions/EndpointFilterAttributes'},
                                                                  'type': 'array'},
                                                    'model-name': {'type': 'string'},
                                                    'offer-name': {'type': 'string'},
                                                    'owner-name': {'type': 'string'}},
                                     'required': ['owner-name',
                                                  'model-name',
                                                  'offer-name',
                                                  'application-name',
                                                  'application-description',
                                                  'application-user',
                                                  'endpoints',
                                                  'connected-users',
                                                  'allowed-users'],
                                     'type': 'object'},
                     'OfferFilters': {'additionalProperties': False,
                                      'properties': {'Filters': {'items': {'$ref': '#/definitions/OfferFilter'},
                                                                 'type': 'array'}},
                                      'required': ['Filters'],
                                      'type': 'object'},
                     'OfferURLs': {'additionalProperties': False,
                                   'properties': {'offer-urls': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                   'type': 'object'},
                     'OfferUserDetails': {'additionalProperties': False,
                                          'properties': {'access': {'type': 'string'},
                                                         'display-name': {'type': 'string'},
                                                         'user': {'type': 'string'}},
                                          'required': ['user',
                                                       'display-name',
                                                       'access'],
                                          'type': 'object'},
                     'QueryApplicationOffersResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationOfferAdminDetails'},
                                                                                  'type': 'array'}},
                                                       'required': ['results'],
                                                       'type': 'object'},
                     'RemoteApplicationInfo': {'additionalProperties': False,
                                               'properties': {'description': {'type': 'string'},
                                                              'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                            'type': 'array'},
                                                              'icon-url-path': {'type': 'string'},
                                                              'model-tag': {'type': 'string'},
                                                              'name': {'type': 'string'},
                                                              'offer-url': {'type': 'string'},
                                                              'source-model-label': {'type': 'string'}},
                                               'required': ['model-tag',
                                                            'name',
                                                            'description',
                                                            'offer-url',
                                                            'endpoints',
                                                            'icon-url-path'],
                                               'type': 'object'},
                     'RemoteApplicationInfoResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'result': {'$ref': '#/definitions/RemoteApplicationInfo'}},
                                                     'type': 'object'},
                     'RemoteApplicationInfoResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/RemoteApplicationInfoResult'},
                                                                                 'type': 'array'}},
                                                      'required': ['results'],
                                                      'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'RemoteSpace': {'additionalProperties': False,
                                     'properties': {'cloud-type': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'provider-attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                         'type': 'object'}},
                                                                            'type': 'object'},
                                                    'provider-id': {'type': 'string'},
                                                    'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                                'type': 'array'}},
                                     'required': ['cloud-type',
                                                  'name',
                                                  'provider-id',
                                                  'provider-attributes',
                                                  'subnets'],
                                     'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'}},
     'properties': {'ApplicationOffers': {'properties': {'Params': {'$ref': '#/definitions/OfferURLs'},
                                                         'Result': {'$ref': '#/definitions/ApplicationOffersResults'}},
                                          'type': 'object'},
                    'DestroyOffers': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationOffers'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'FindApplicationOffers': {'properties': {'Params': {'$ref': '#/definitions/OfferFilters'},
                                                             'Result': {'$ref': '#/definitions/QueryApplicationOffersResults'}},
                                              'type': 'object'},
                    'GetConsumeDetails': {'properties': {'Params': {'$ref': '#/definitions/OfferURLs'},
                                                         'Result': {'$ref': '#/definitions/ConsumeOfferDetailsResults'}},
                                          'type': 'object'},
                    'ListApplicationOffers': {'properties': {'Params': {'$ref': '#/definitions/OfferFilters'},
                                                             'Result': {'$ref': '#/definitions/QueryApplicationOffersResults'}},
                                              'type': 'object'},
                    'ModifyOfferAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyOfferAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'Offer': {'properties': {'Params': {'$ref': '#/definitions/AddApplicationOffers'},
                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                              'type': 'object'},
                    'RemoteApplicationInfo': {'properties': {'Params': {'$ref': '#/definitions/OfferURLs'},
                                                             'Result': {'$ref': '#/definitions/RemoteApplicationInfoResults'}},
                                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ApplicationOffersResults)
    async def ApplicationOffers(self, offer_urls):
        '''
        offer_urls : typing.Sequence[str]
        Returns -> typing.Sequence[~ApplicationOfferResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='ApplicationOffers',
                   version=2,
                   params=_params)
        _params['offer-urls'] = offer_urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyOffers(self, force, offer_urls):
        '''
        force : bool
        offer_urls : typing.Sequence[str]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='DestroyOffers',
                   version=2,
                   params=_params)
        _params['force'] = force
        _params['offer-urls'] = offer_urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(QueryApplicationOffersResults)
    async def FindApplicationOffers(self, filters):
        '''
        filters : typing.Sequence[~OfferFilter]
        Returns -> typing.Sequence[~ApplicationOfferAdminDetails]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='FindApplicationOffers',
                   version=2,
                   params=_params)
        _params['Filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConsumeOfferDetailsResults)
    async def GetConsumeDetails(self, offer_urls):
        '''
        offer_urls : typing.Sequence[str]
        Returns -> typing.Sequence[~ConsumeOfferDetailsResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='GetConsumeDetails',
                   version=2,
                   params=_params)
        _params['offer-urls'] = offer_urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(QueryApplicationOffersResults)
    async def ListApplicationOffers(self, filters):
        '''
        filters : typing.Sequence[~OfferFilter]
        Returns -> typing.Sequence[~ApplicationOfferAdminDetails]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='ListApplicationOffers',
                   version=2,
                   params=_params)
        _params['Filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyOfferAccess(self, changes):
        '''
        changes : typing.Sequence[~ModifyOfferAccess]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='ModifyOfferAccess',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Offer(self, offers):
        '''
        offers : typing.Sequence[~AddApplicationOffer]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='Offer',
                   version=2,
                   params=_params)
        _params['Offers'] = offers
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoteApplicationInfoResults)
    async def RemoteApplicationInfo(self, offer_urls):
        '''
        offer_urls : typing.Sequence[str]
        Returns -> typing.Sequence[~RemoteApplicationInfoResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='RemoteApplicationInfo',
                   version=2,
                   params=_params)
        _params['offer-urls'] = offer_urls
        reply = await self.rpc(msg)
        return reply



class BackupsFacade(Type):
    name = 'Backups'
    version = 2
    schema =     {'definitions': {'BackupsCreateArgs': {'additionalProperties': False,
                                           'properties': {'keep-copy': {'type': 'boolean'},
                                                          'no-download': {'type': 'boolean'},
                                                          'notes': {'type': 'string'}},
                                           'required': ['notes',
                                                        'keep-copy',
                                                        'no-download'],
                                           'type': 'object'},
                     'BackupsInfoArgs': {'additionalProperties': False,
                                         'properties': {'id': {'type': 'string'}},
                                         'required': ['id'],
                                         'type': 'object'},
                     'BackupsListArgs': {'additionalProperties': False,
                                         'type': 'object'},
                     'BackupsListResult': {'additionalProperties': False,
                                           'properties': {'list': {'items': {'$ref': '#/definitions/BackupsMetadataResult'},
                                                                   'type': 'array'}},
                                           'required': ['list'],
                                           'type': 'object'},
                     'BackupsMetadataResult': {'additionalProperties': False,
                                               'properties': {'ca-cert': {'type': 'string'},
                                                              'ca-private-key': {'type': 'string'},
                                                              'checksum': {'type': 'string'},
                                                              'checksum-format': {'type': 'string'},
                                                              'filename': {'type': 'string'},
                                                              'finished': {'format': 'date-time',
                                                                           'type': 'string'},
                                                              'hostname': {'type': 'string'},
                                                              'id': {'type': 'string'},
                                                              'machine': {'type': 'string'},
                                                              'model': {'type': 'string'},
                                                              'notes': {'type': 'string'},
                                                              'series': {'type': 'string'},
                                                              'size': {'type': 'integer'},
                                                              'started': {'format': 'date-time',
                                                                          'type': 'string'},
                                                              'stored': {'format': 'date-time',
                                                                         'type': 'string'},
                                                              'version': {'$ref': '#/definitions/Number'}},
                                               'required': ['id',
                                                            'checksum',
                                                            'checksum-format',
                                                            'size',
                                                            'stored',
                                                            'started',
                                                            'finished',
                                                            'notes',
                                                            'model',
                                                            'machine',
                                                            'hostname',
                                                            'version',
                                                            'series',
                                                            'ca-cert',
                                                            'ca-private-key',
                                                            'filename'],
                                               'type': 'object'},
                     'BackupsRemoveArgs': {'additionalProperties': False,
                                           'properties': {'ids': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                           'required': ['ids'],
                                           'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'RestoreArgs': {'additionalProperties': False,
                                     'properties': {'backup-id': {'type': 'string'}},
                                     'required': ['backup-id'],
                                     'type': 'object'}},
     'properties': {'Create': {'properties': {'Params': {'$ref': '#/definitions/BackupsCreateArgs'},
                                              'Result': {'$ref': '#/definitions/BackupsMetadataResult'}},
                               'type': 'object'},
                    'FinishRestore': {'type': 'object'},
                    'Info': {'properties': {'Params': {'$ref': '#/definitions/BackupsInfoArgs'},
                                            'Result': {'$ref': '#/definitions/BackupsMetadataResult'}},
                             'type': 'object'},
                    'List': {'properties': {'Params': {'$ref': '#/definitions/BackupsListArgs'},
                                            'Result': {'$ref': '#/definitions/BackupsListResult'}},
                             'type': 'object'},
                    'PrepareRestore': {'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/BackupsRemoveArgs'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Restore': {'properties': {'Params': {'$ref': '#/definitions/RestoreArgs'}},
                                'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BackupsMetadataResult)
    async def Create(self, notes):
        '''
        notes : str
        Returns -> typing.Union[str, int, _ForwardRef('Number')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Create',
                   version=2,
                   params=_params)
        _params['notes'] = notes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def FinishRestore(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='FinishRestore',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BackupsMetadataResult)
    async def Info(self, id_):
        '''
        id_ : str
        Returns -> typing.Union[str, int, _ForwardRef('Number')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Info',
                   version=2,
                   params=_params)
        _params['id'] = id_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BackupsListResult)
    async def List(self):
        '''

        Returns -> typing.Sequence[~BackupsMetadataResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='List',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def PrepareRestore(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='PrepareRestore',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, id_):
        '''
        id_ : str
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Remove',
                   version=2,
                   params=_params)
        _params['id'] = id_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Restore(self, backup_id):
        '''
        backup_id : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Restore',
                   version=2,
                   params=_params)
        _params['backup-id'] = backup_id
        reply = await self.rpc(msg)
        return reply



class BlockFacade(Type):
    name = 'Block'
    version = 2
    schema =     {'definitions': {'Block': {'additionalProperties': False,
                               'properties': {'id': {'type': 'string'},
                                              'message': {'type': 'string'},
                                              'tag': {'type': 'string'},
                                              'type': {'type': 'string'}},
                               'required': ['id', 'tag', 'type'],
                               'type': 'object'},
                     'BlockResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'result': {'$ref': '#/definitions/Block'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'BlockResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/BlockResult'},
                                                                 'type': 'array'}},
                                      'type': 'object'},
                     'BlockSwitchParams': {'additionalProperties': False,
                                           'properties': {'message': {'type': 'string'},
                                                          'type': {'type': 'string'}},
                                           'required': ['type'],
                                           'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'List': {'properties': {'Result': {'$ref': '#/definitions/BlockResults'}},
                             'type': 'object'},
                    'SwitchBlockOff': {'properties': {'Params': {'$ref': '#/definitions/BlockSwitchParams'},
                                                      'Result': {'$ref': '#/definitions/ErrorResult'}},
                                       'type': 'object'},
                    'SwitchBlockOn': {'properties': {'Params': {'$ref': '#/definitions/BlockSwitchParams'},
                                                     'Result': {'$ref': '#/definitions/ErrorResult'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BlockResults)
    async def List(self):
        '''

        Returns -> typing.Sequence[~BlockResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Block',
                   request='List',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResult)
    async def SwitchBlockOff(self, message, type_):
        '''
        message : str
        type_ : str
        Returns -> Error
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Block',
                   request='SwitchBlockOff',
                   version=2,
                   params=_params)
        _params['message'] = message
        _params['type'] = type_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResult)
    async def SwitchBlockOn(self, message, type_):
        '''
        message : str
        type_ : str
        Returns -> Error
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Block',
                   request='SwitchBlockOn',
                   version=2,
                   params=_params)
        _params['message'] = message
        _params['type'] = type_
        reply = await self.rpc(msg)
        return reply



class BundleFacade(Type):
    name = 'Bundle'
    version = 2
    schema =     {'definitions': {'BundleChange': {'additionalProperties': False,
                                      'properties': {'args': {'items': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                              'type': 'array'},
                                                     'id': {'type': 'string'},
                                                     'method': {'type': 'string'},
                                                     'requires': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['id',
                                                   'method',
                                                   'args',
                                                   'requires'],
                                      'type': 'object'},
                     'BundleChangesParams': {'additionalProperties': False,
                                             'properties': {'bundleURL': {'type': 'string'},
                                                            'yaml': {'type': 'string'}},
                                             'required': ['yaml', 'bundleURL'],
                                             'type': 'object'},
                     'BundleChangesResults': {'additionalProperties': False,
                                              'properties': {'changes': {'items': {'$ref': '#/definitions/BundleChange'},
                                                                         'type': 'array'},
                                                             'errors': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                              'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'}},
     'properties': {'ExportBundle': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'GetChanges': {'properties': {'Params': {'$ref': '#/definitions/BundleChangesParams'},
                                                  'Result': {'$ref': '#/definitions/BundleChangesResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringResult)
    async def ExportBundle(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Bundle',
                   request='ExportBundle',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BundleChangesResults)
    async def GetChanges(self, yaml):
        '''
        yaml : str
        Returns -> typing.Union[typing.Sequence[~BundleChange], typing.Sequence[str]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Bundle',
                   request='GetChanges',
                   version=2,
                   params=_params)
        _params['yaml'] = yaml
        reply = await self.rpc(msg)
        return reply



class CharmRevisionUpdaterFacade(Type):
    name = 'CharmRevisionUpdater'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'UpdateLatestRevisions': {'properties': {'Result': {'$ref': '#/definitions/ErrorResult'}},
                                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def UpdateLatestRevisions(self):
        '''

        Returns -> Error
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CharmRevisionUpdater',
                   request='UpdateLatestRevisions',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CharmsFacade(Type):
    name = 'Charms'
    version = 2
    schema =     {'definitions': {'CharmActionSpec': {'additionalProperties': False,
                                         'properties': {'description': {'type': 'string'},
                                                        'params': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                'type': 'object'}},
                                                                   'type': 'object'}},
                                         'required': ['description', 'params'],
                                         'type': 'object'},
                     'CharmActions': {'additionalProperties': False,
                                      'properties': {'specs': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmActionSpec'}},
                                                               'type': 'object'}},
                                      'type': 'object'},
                     'CharmDevice': {'additionalProperties': False,
                                     'properties': {'CountMax': {'type': 'integer'},
                                                    'CountMin': {'type': 'integer'},
                                                    'Description': {'type': 'string'},
                                                    'Name': {'type': 'string'},
                                                    'Type': {'type': 'string'}},
                                     'required': ['Name',
                                                  'Description',
                                                  'Type',
                                                  'CountMin',
                                                  'CountMax'],
                                     'type': 'object'},
                     'CharmInfo': {'additionalProperties': False,
                                   'properties': {'actions': {'$ref': '#/definitions/CharmActions'},
                                                  'config': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmOption'}},
                                                             'type': 'object'},
                                                  'lxd-profile': {'$ref': '#/definitions/CharmLXDProfile'},
                                                  'meta': {'$ref': '#/definitions/CharmMeta'},
                                                  'metrics': {'$ref': '#/definitions/CharmMetrics'},
                                                  'revision': {'type': 'integer'},
                                                  'url': {'type': 'string'}},
                                   'required': ['revision', 'url', 'config'],
                                   'type': 'object'},
                     'CharmLXDProfile': {'additionalProperties': False,
                                         'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'},
                                                        'description': {'type': 'string'},
                                                        'devices': {'patternProperties': {'.*': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'}},
                                         'required': ['config',
                                                      'description',
                                                      'devices'],
                                         'type': 'object'},
                     'CharmMeta': {'additionalProperties': False,
                                   'properties': {'categories': {'items': {'type': 'string'},
                                                                 'type': 'array'},
                                                  'description': {'type': 'string'},
                                                  'devices': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmDevice'}},
                                                              'type': 'object'},
                                                  'extra-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                  'min-juju-version': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'payload-classes': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmPayloadClass'}},
                                                                      'type': 'object'},
                                                  'peers': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                            'type': 'object'},
                                                  'provides': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                               'type': 'object'},
                                                  'requires': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                               'type': 'object'},
                                                  'resources': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmResourceMeta'}},
                                                                'type': 'object'},
                                                  'series': {'items': {'type': 'string'},
                                                             'type': 'array'},
                                                  'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmStorage'}},
                                                              'type': 'object'},
                                                  'subordinate': {'type': 'boolean'},
                                                  'summary': {'type': 'string'},
                                                  'tags': {'items': {'type': 'string'},
                                                           'type': 'array'},
                                                  'terms': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                   'required': ['name',
                                                'summary',
                                                'description',
                                                'subordinate'],
                                   'type': 'object'},
                     'CharmMetric': {'additionalProperties': False,
                                     'properties': {'description': {'type': 'string'},
                                                    'type': {'type': 'string'}},
                                     'required': ['type', 'description'],
                                     'type': 'object'},
                     'CharmMetrics': {'additionalProperties': False,
                                      'properties': {'metrics': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmMetric'}},
                                                                 'type': 'object'},
                                                     'plan': {'$ref': '#/definitions/CharmPlan'}},
                                      'required': ['metrics', 'plan'],
                                      'type': 'object'},
                     'CharmOption': {'additionalProperties': False,
                                     'properties': {'default': {'additionalProperties': True,
                                                                'type': 'object'},
                                                    'description': {'type': 'string'},
                                                    'type': {'type': 'string'}},
                                     'required': ['type'],
                                     'type': 'object'},
                     'CharmPayloadClass': {'additionalProperties': False,
                                           'properties': {'name': {'type': 'string'},
                                                          'type': {'type': 'string'}},
                                           'required': ['name', 'type'],
                                           'type': 'object'},
                     'CharmPlan': {'additionalProperties': False,
                                   'properties': {'required': {'type': 'boolean'}},
                                   'required': ['required'],
                                   'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'CharmResourceMeta': {'additionalProperties': False,
                                           'properties': {'description': {'type': 'string'},
                                                          'name': {'type': 'string'},
                                                          'path': {'type': 'string'},
                                                          'type': {'type': 'string'}},
                                           'required': ['name',
                                                        'type',
                                                        'path',
                                                        'description'],
                                           'type': 'object'},
                     'CharmStorage': {'additionalProperties': False,
                                      'properties': {'count-max': {'type': 'integer'},
                                                     'count-min': {'type': 'integer'},
                                                     'description': {'type': 'string'},
                                                     'location': {'type': 'string'},
                                                     'minimum-size': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'properties': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                     'read-only': {'type': 'boolean'},
                                                     'shared': {'type': 'boolean'},
                                                     'type': {'type': 'string'}},
                                      'required': ['name',
                                                   'description',
                                                   'type',
                                                   'shared',
                                                   'read-only',
                                                   'count-min',
                                                   'count-max',
                                                   'minimum-size'],
                                      'type': 'object'},
                     'CharmURL': {'additionalProperties': False,
                                  'properties': {'url': {'type': 'string'}},
                                  'required': ['url'],
                                  'type': 'object'},
                     'CharmsList': {'additionalProperties': False,
                                    'properties': {'names': {'items': {'type': 'string'},
                                                             'type': 'array'}},
                                    'required': ['names'],
                                    'type': 'object'},
                     'CharmsListResult': {'additionalProperties': False,
                                          'properties': {'charm-urls': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                          'required': ['charm-urls'],
                                          'type': 'object'},
                     'IsMeteredResult': {'additionalProperties': False,
                                         'properties': {'metered': {'type': 'boolean'}},
                                         'required': ['metered'],
                                         'type': 'object'}},
     'properties': {'CharmInfo': {'properties': {'Params': {'$ref': '#/definitions/CharmURL'},
                                                 'Result': {'$ref': '#/definitions/CharmInfo'}},
                                  'type': 'object'},
                    'IsMetered': {'properties': {'Params': {'$ref': '#/definitions/CharmURL'},
                                                 'Result': {'$ref': '#/definitions/IsMeteredResult'}},
                                  'type': 'object'},
                    'List': {'properties': {'Params': {'$ref': '#/definitions/CharmsList'},
                                            'Result': {'$ref': '#/definitions/CharmsListResult'}},
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(CharmInfo)
    async def CharmInfo(self, url):
        '''
        url : str
        Returns -> typing.Union[_ForwardRef('CharmActions'), typing.Mapping[str, ~CharmOption], _ForwardRef('CharmMeta'), _ForwardRef('CharmMetrics'), int, str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Charms',
                   request='CharmInfo',
                   version=2,
                   params=_params)
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IsMeteredResult)
    async def IsMetered(self, url):
        '''
        url : str
        Returns -> bool
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Charms',
                   request='IsMetered',
                   version=2,
                   params=_params)
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CharmsListResult)
    async def List(self, names):
        '''
        names : typing.Sequence[str]
        Returns -> typing.Sequence[str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Charms',
                   request='List',
                   version=2,
                   params=_params)
        _params['names'] = names
        reply = await self.rpc(msg)
        return reply



class CleanerFacade(Type):
    name = 'Cleaner'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'}},
     'properties': {'Cleanup': {'type': 'object'},
                    'WatchCleanups': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Cleanup(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cleaner',
                   request='Cleanup',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchCleanups(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cleaner',
                   request='WatchCleanups',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ClientFacade(Type):
    name = 'Client'
    version = 2
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'AddCharm': {'additionalProperties': False,
                                  'properties': {'channel': {'type': 'string'},
                                                 'force': {'type': 'boolean'},
                                                 'url': {'type': 'string'}},
                                  'required': ['url', 'channel', 'force'],
                                  'type': 'object'},
                     'AddCharmWithAuthorization': {'additionalProperties': False,
                                                   'properties': {'channel': {'type': 'string'},
                                                                  'force': {'type': 'boolean'},
                                                                  'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                                  'url': {'type': 'string'}},
                                                   'required': ['url',
                                                                'channel',
                                                                'macaroon',
                                                                'force'],
                                                   'type': 'object'},
                     'AddMachineParams': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'container-type': {'type': 'string'},
                                                         'disks': {'items': {'$ref': '#/definitions/Constraints'},
                                                                   'type': 'array'},
                                                         'hardware-characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                         'instance-id': {'type': 'string'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'nonce': {'type': 'string'},
                                                         'parent-id': {'type': 'string'},
                                                         'placement': {'$ref': '#/definitions/Placement'},
                                                         'series': {'type': 'string'}},
                                          'required': ['series',
                                                       'constraints',
                                                       'jobs',
                                                       'parent-id',
                                                       'container-type',
                                                       'instance-id',
                                                       'nonce',
                                                       'hardware-characteristics',
                                                       'addresses'],
                                          'type': 'object'},
                     'AddMachines': {'additionalProperties': False,
                                     'properties': {'params': {'items': {'$ref': '#/definitions/AddMachineParams'},
                                                               'type': 'array'}},
                                     'required': ['params'],
                                     'type': 'object'},
                     'AddMachinesResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'machine': {'type': 'string'}},
                                           'required': ['machine'],
                                           'type': 'object'},
                     'AddMachinesResults': {'additionalProperties': False,
                                            'properties': {'machines': {'items': {'$ref': '#/definitions/AddMachinesResult'},
                                                                        'type': 'array'}},
                                            'required': ['machines'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'AgentVersionResult': {'additionalProperties': False,
                                            'properties': {'version': {'$ref': '#/definitions/Number'}},
                                            'required': ['version'],
                                            'type': 'object'},
                     'AllWatcherId': {'additionalProperties': False,
                                      'properties': {'watcher-id': {'type': 'string'}},
                                      'required': ['watcher-id'],
                                      'type': 'object'},
                     'ApplicationOfferStatus': {'additionalProperties': False,
                                                'properties': {'active-connected-count': {'type': 'integer'},
                                                               'application-name': {'type': 'string'},
                                                               'charm': {'type': 'string'},
                                                               'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/RemoteEndpoint'}},
                                                                             'type': 'object'},
                                                               'err': {'additionalProperties': True,
                                                                       'type': 'object'},
                                                               'offer-name': {'type': 'string'},
                                                               'total-connected-count': {'type': 'integer'}},
                                                'required': ['offer-name',
                                                             'application-name',
                                                             'charm',
                                                             'endpoints',
                                                             'active-connected-count',
                                                             'total-connected-count'],
                                                'type': 'object'},
                     'ApplicationStatus': {'additionalProperties': False,
                                           'properties': {'can-upgrade-to': {'type': 'string'},
                                                          'charm': {'type': 'string'},
                                                          'charm-verion': {'type': 'string'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'err': {'additionalProperties': True,
                                                                  'type': 'object'},
                                                          'exposed': {'type': 'boolean'},
                                                          'int': {'type': 'integer'},
                                                          'life': {'type': 'string'},
                                                          'meter-statuses': {'patternProperties': {'.*': {'$ref': '#/definitions/MeterStatus'}},
                                                                             'type': 'object'},
                                                          'provider-id': {'type': 'string'},
                                                          'public-address': {'type': 'string'},
                                                          'relations': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                     'type': 'array'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'status': {'$ref': '#/definitions/DetailedStatus'},
                                                          'string': {'type': 'string'},
                                                          'subordinate-to': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                          'units': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitStatus'}},
                                                                    'type': 'object'},
                                                          'workload-version': {'type': 'string'}},
                                           'required': ['charm',
                                                        'series',
                                                        'exposed',
                                                        'life',
                                                        'relations',
                                                        'can-upgrade-to',
                                                        'subordinate-to',
                                                        'units',
                                                        'meter-statuses',
                                                        'status',
                                                        'workload-version',
                                                        'charm-verion',
                                                        'endpoint-bindings',
                                                        'public-address'],
                                           'type': 'object'},
                     'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Series': {'type': 'string'}},
                                'required': ['Number', 'Series', 'Arch'],
                                'type': 'object'},
                     'BundleChange': {'additionalProperties': False,
                                      'properties': {'args': {'items': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                              'type': 'array'},
                                                     'id': {'type': 'string'},
                                                     'method': {'type': 'string'},
                                                     'requires': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['id',
                                                   'method',
                                                   'args',
                                                   'requires'],
                                      'type': 'object'},
                     'BundleChangesParams': {'additionalProperties': False,
                                             'properties': {'bundleURL': {'type': 'string'},
                                                            'yaml': {'type': 'string'}},
                                             'required': ['yaml', 'bundleURL'],
                                             'type': 'object'},
                     'BundleChangesResults': {'additionalProperties': False,
                                              'properties': {'changes': {'items': {'$ref': '#/definitions/BundleChange'},
                                                                         'type': 'array'},
                                                             'errors': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                              'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'DestroyMachines': {'additionalProperties': False,
                                         'properties': {'force': {'type': 'boolean'},
                                                        'machine-names': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                         'required': ['machine-names', 'force'],
                                         'type': 'object'},
                     'DetailedStatus': {'additionalProperties': False,
                                        'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                       'err': {'additionalProperties': True,
                                                               'type': 'object'},
                                                       'info': {'type': 'string'},
                                                       'kind': {'type': 'string'},
                                                       'life': {'type': 'string'},
                                                       'since': {'format': 'date-time',
                                                                 'type': 'string'},
                                                       'status': {'type': 'string'},
                                                       'version': {'type': 'string'}},
                                        'required': ['status',
                                                     'info',
                                                     'data',
                                                     'since',
                                                     'kind',
                                                     'version',
                                                     'life'],
                                        'type': 'object'},
                     'EndpointStatus': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'},
                                                       'subordinate': {'type': 'boolean'}},
                                        'required': ['application',
                                                     'name',
                                                     'role',
                                                     'subordinate'],
                                        'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FindToolsParams': {'additionalProperties': False,
                                         'properties': {'agentstream': {'type': 'string'},
                                                        'arch': {'type': 'string'},
                                                        'major': {'type': 'integer'},
                                                        'minor': {'type': 'integer'},
                                                        'number': {'$ref': '#/definitions/Number'},
                                                        'series': {'type': 'string'}},
                                         'required': ['number',
                                                      'major',
                                                      'minor',
                                                      'arch',
                                                      'series',
                                                      'agentstream'],
                                         'type': 'object'},
                     'FindToolsResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'list': {'items': {'$ref': '#/definitions/Tools'},
                                                                 'type': 'array'}},
                                         'required': ['list'],
                                         'type': 'object'},
                     'FullStatus': {'additionalProperties': False,
                                    'properties': {'applications': {'patternProperties': {'.*': {'$ref': '#/definitions/ApplicationStatus'}},
                                                                    'type': 'object'},
                                                   'controller-timestamp': {'format': 'date-time',
                                                                            'type': 'string'},
                                                   'machines': {'patternProperties': {'.*': {'$ref': '#/definitions/MachineStatus'}},
                                                                'type': 'object'},
                                                   'model': {'$ref': '#/definitions/ModelStatusInfo'},
                                                   'offers': {'patternProperties': {'.*': {'$ref': '#/definitions/ApplicationOfferStatus'}},
                                                              'type': 'object'},
                                                   'relations': {'items': {'$ref': '#/definitions/RelationStatus'},
                                                                 'type': 'array'},
                                                   'remote-applications': {'patternProperties': {'.*': {'$ref': '#/definitions/RemoteApplicationStatus'}},
                                                                           'type': 'object'}},
                                    'required': ['model',
                                                 'machines',
                                                 'applications',
                                                 'remote-applications',
                                                 'offers',
                                                 'relations',
                                                 'controller-timestamp'],
                                    'type': 'object'},
                     'GetConstraintsResults': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'History': {'additionalProperties': False,
                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                'statuses': {'items': {'$ref': '#/definitions/DetailedStatus'},
                                                             'type': 'array'}},
                                 'required': ['statuses'],
                                 'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'}},
                                  'required': ['Address', 'port'],
                                  'type': 'object'},
                     'LXDProfile': {'additionalProperties': False,
                                    'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                              'type': 'object'},
                                                   'description': {'type': 'string'},
                                                   'devices': {'patternProperties': {'.*': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                            'type': 'object'}},
                                                               'type': 'object'}},
                                    'required': ['config',
                                                 'description',
                                                 'devices'],
                                    'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MachineStatus': {'additionalProperties': False,
                                       'properties': {'agent-status': {'$ref': '#/definitions/DetailedStatus'},
                                                      'constraints': {'type': 'string'},
                                                      'containers': {'patternProperties': {'.*': {'$ref': '#/definitions/MachineStatus'}},
                                                                     'type': 'object'},
                                                      'dns-name': {'type': 'string'},
                                                      'hardware': {'type': 'string'},
                                                      'has-vote': {'type': 'boolean'},
                                                      'id': {'type': 'string'},
                                                      'instance-id': {'type': 'string'},
                                                      'instance-status': {'$ref': '#/definitions/DetailedStatus'},
                                                      'ip-addresses': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                      'jobs': {'items': {'type': 'string'},
                                                               'type': 'array'},
                                                      'lxd-profiles': {'patternProperties': {'.*': {'$ref': '#/definitions/LXDProfile'}},
                                                                       'type': 'object'},
                                                      'network-interfaces': {'patternProperties': {'.*': {'$ref': '#/definitions/NetworkInterface'}},
                                                                             'type': 'object'},
                                                      'series': {'type': 'string'},
                                                      'wants-vote': {'type': 'boolean'}},
                                       'required': ['agent-status',
                                                    'instance-status',
                                                    'dns-name',
                                                    'instance-id',
                                                    'series',
                                                    'id',
                                                    'containers',
                                                    'constraints',
                                                    'hardware',
                                                    'jobs',
                                                    'has-vote',
                                                    'wants-vote'],
                                       'type': 'object'},
                     'MeterStatus': {'additionalProperties': False,
                                     'properties': {'color': {'type': 'string'},
                                                    'message': {'type': 'string'}},
                                     'required': ['color', 'message'],
                                     'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelInfo': {'additionalProperties': False,
                                   'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                  'cloud-credential-tag': {'type': 'string'},
                                                  'cloud-region': {'type': 'string'},
                                                  'cloud-tag': {'type': 'string'},
                                                  'controller-uuid': {'type': 'string'},
                                                  'default-series': {'type': 'string'},
                                                  'life': {'type': 'string'},
                                                  'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                               'type': 'array'},
                                                  'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                  'name': {'type': 'string'},
                                                  'owner-tag': {'type': 'string'},
                                                  'provider-type': {'type': 'string'},
                                                  'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                  'status': {'$ref': '#/definitions/EntityStatus'},
                                                  'type': {'type': 'string'},
                                                  'users': {'items': {'$ref': '#/definitions/ModelUserInfo'},
                                                            'type': 'array'},
                                                  'uuid': {'type': 'string'}},
                                   'required': ['name',
                                                'type',
                                                'uuid',
                                                'controller-uuid',
                                                'cloud-tag',
                                                'owner-tag',
                                                'life',
                                                'users',
                                                'machines',
                                                'sla',
                                                'agent-version'],
                                   'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'message': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelMigrationStatus': {'additionalProperties': False,
                                              'properties': {'end': {'format': 'date-time',
                                                                     'type': 'string'},
                                                             'start': {'format': 'date-time',
                                                                       'type': 'string'},
                                                             'status': {'type': 'string'}},
                                              'required': ['status', 'start'],
                                              'type': 'object'},
                     'ModelSLA': {'additionalProperties': False,
                                  'properties': {'ModelSLAInfo': {'$ref': '#/definitions/ModelSLAInfo'},
                                                 'creds': {'items': {'type': 'integer'},
                                                           'type': 'array'}},
                                  'required': ['ModelSLAInfo', 'creds'],
                                  'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelSet': {'additionalProperties': False,
                                  'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                         'type': 'object'}},
                                                            'type': 'object'}},
                                  'required': ['config'],
                                  'type': 'object'},
                     'ModelStatusInfo': {'additionalProperties': False,
                                         'properties': {'available-version': {'type': 'string'},
                                                        'cloud-tag': {'type': 'string'},
                                                        'meter-status': {'$ref': '#/definitions/MeterStatus'},
                                                        'model-status': {'$ref': '#/definitions/DetailedStatus'},
                                                        'name': {'type': 'string'},
                                                        'region': {'type': 'string'},
                                                        'sla': {'type': 'string'},
                                                        'type': {'type': 'string'},
                                                        'version': {'type': 'string'}},
                                         'required': ['name',
                                                      'type',
                                                      'cloud-tag',
                                                      'version',
                                                      'available-version',
                                                      'model-status',
                                                      'meter-status',
                                                      'sla'],
                                         'type': 'object'},
                     'ModelUnset': {'additionalProperties': False,
                                    'properties': {'keys': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['keys'],
                                    'type': 'object'},
                     'ModelUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'last-connection': {'format': 'date-time',
                                                                          'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'last-connection',
                                                    'access'],
                                       'type': 'object'},
                     'ModelUserInfoResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/ModelUserInfo'}},
                                             'type': 'object'},
                     'ModelUserInfoResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ModelUserInfoResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'NetworkInterface': {'additionalProperties': False,
                                          'properties': {'dns-nameservers': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                         'gateway': {'type': 'string'},
                                                         'ip-addresses': {'items': {'type': 'string'},
                                                                          'type': 'array'},
                                                         'is-up': {'type': 'boolean'},
                                                         'mac-address': {'type': 'string'},
                                                         'space': {'type': 'string'}},
                                          'required': ['ip-addresses',
                                                       'mac-address',
                                                       'is-up'],
                                          'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'PrivateAddress': {'additionalProperties': False,
                                        'properties': {'target': {'type': 'string'}},
                                        'required': ['target'],
                                        'type': 'object'},
                     'PrivateAddressResults': {'additionalProperties': False,
                                               'properties': {'private-address': {'type': 'string'}},
                                               'required': ['private-address'],
                                               'type': 'object'},
                     'ProvisioningScriptParams': {'additionalProperties': False,
                                                  'properties': {'data-dir': {'type': 'string'},
                                                                 'disable-package-commands': {'type': 'boolean'},
                                                                 'machine-id': {'type': 'string'},
                                                                 'nonce': {'type': 'string'}},
                                                  'required': ['machine-id',
                                                               'nonce',
                                                               'data-dir',
                                                               'disable-package-commands'],
                                                  'type': 'object'},
                     'ProvisioningScriptResult': {'additionalProperties': False,
                                                  'properties': {'script': {'type': 'string'}},
                                                  'required': ['script'],
                                                  'type': 'object'},
                     'PublicAddress': {'additionalProperties': False,
                                       'properties': {'target': {'type': 'string'}},
                                       'required': ['target'],
                                       'type': 'object'},
                     'PublicAddressResults': {'additionalProperties': False,
                                              'properties': {'public-address': {'type': 'string'}},
                                              'required': ['public-address'],
                                              'type': 'object'},
                     'RelationStatus': {'additionalProperties': False,
                                        'properties': {'endpoints': {'items': {'$ref': '#/definitions/EndpointStatus'},
                                                                     'type': 'array'},
                                                       'id': {'type': 'integer'},
                                                       'interface': {'type': 'string'},
                                                       'key': {'type': 'string'},
                                                       'scope': {'type': 'string'},
                                                       'status': {'$ref': '#/definitions/DetailedStatus'}},
                                        'required': ['id',
                                                     'key',
                                                     'interface',
                                                     'scope',
                                                     'endpoints',
                                                     'status'],
                                        'type': 'object'},
                     'RemoteApplicationStatus': {'additionalProperties': False,
                                                 'properties': {'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                              'type': 'array'},
                                                                'err': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                                'life': {'type': 'string'},
                                                                'offer-name': {'type': 'string'},
                                                                'offer-url': {'type': 'string'},
                                                                'relations': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                           'type': 'array'}},
                                                                              'type': 'object'},
                                                                'status': {'$ref': '#/definitions/DetailedStatus'}},
                                                 'required': ['offer-url',
                                                              'offer-name',
                                                              'endpoints',
                                                              'life',
                                                              'relations',
                                                              'status'],
                                                 'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'ResolveCharmResult': {'additionalProperties': False,
                                            'properties': {'error': {'type': 'string'},
                                                           'url': {'type': 'string'}},
                                            'type': 'object'},
                     'ResolveCharmResults': {'additionalProperties': False,
                                             'properties': {'urls': {'items': {'$ref': '#/definitions/ResolveCharmResult'},
                                                                     'type': 'array'}},
                                             'required': ['urls'],
                                             'type': 'object'},
                     'ResolveCharms': {'additionalProperties': False,
                                       'properties': {'references': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                       'required': ['references'],
                                       'type': 'object'},
                     'Resolved': {'additionalProperties': False,
                                  'properties': {'retry': {'type': 'boolean'},
                                                 'unit-name': {'type': 'string'}},
                                  'required': ['unit-name', 'retry'],
                                  'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'SetModelAgentVersion': {'additionalProperties': False,
                                              'properties': {'force': {'type': 'boolean'},
                                                             'version': {'$ref': '#/definitions/Number'}},
                                              'required': ['version'],
                                              'type': 'object'},
                     'StatusHistoryFilter': {'additionalProperties': False,
                                             'properties': {'date': {'format': 'date-time',
                                                                     'type': 'string'},
                                                            'delta': {'type': 'integer'},
                                                            'exclude': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                            'size': {'type': 'integer'}},
                                             'required': ['size',
                                                          'date',
                                                          'delta',
                                                          'exclude'],
                                             'type': 'object'},
                     'StatusHistoryRequest': {'additionalProperties': False,
                                              'properties': {'filter': {'$ref': '#/definitions/StatusHistoryFilter'},
                                                             'historyKind': {'type': 'string'},
                                                             'size': {'type': 'integer'},
                                                             'tag': {'type': 'string'}},
                                              'required': ['historyKind',
                                                           'size',
                                                           'filter',
                                                           'tag'],
                                              'type': 'object'},
                     'StatusHistoryRequests': {'additionalProperties': False,
                                               'properties': {'requests': {'items': {'$ref': '#/definitions/StatusHistoryRequest'},
                                                                           'type': 'array'}},
                                               'required': ['requests'],
                                               'type': 'object'},
                     'StatusHistoryResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'history': {'$ref': '#/definitions/History'}},
                                             'required': ['history'],
                                             'type': 'object'},
                     'StatusHistoryResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/StatusHistoryResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'StatusParams': {'additionalProperties': False,
                                      'properties': {'patterns': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['patterns'],
                                      'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Tools': {'additionalProperties': False,
                               'properties': {'sha256': {'type': 'string'},
                                              'size': {'type': 'integer'},
                                              'url': {'type': 'string'},
                                              'version': {'$ref': '#/definitions/Binary'}},
                               'required': ['version', 'url', 'size'],
                               'type': 'object'},
                     'UnitStatus': {'additionalProperties': False,
                                    'properties': {'address': {'type': 'string'},
                                                   'agent-status': {'$ref': '#/definitions/DetailedStatus'},
                                                   'charm': {'type': 'string'},
                                                   'leader': {'type': 'boolean'},
                                                   'machine': {'type': 'string'},
                                                   'opened-ports': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                   'provider-id': {'type': 'string'},
                                                   'public-address': {'type': 'string'},
                                                   'subordinates': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitStatus'}},
                                                                    'type': 'object'},
                                                   'workload-status': {'$ref': '#/definitions/DetailedStatus'},
                                                   'workload-version': {'type': 'string'}},
                                    'required': ['agent-status',
                                                 'workload-status',
                                                 'workload-version',
                                                 'machine',
                                                 'opened-ports',
                                                 'public-address',
                                                 'charm',
                                                 'subordinates'],
                                    'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'AbortCurrentUpgrade': {'type': 'object'},
                    'AddCharm': {'properties': {'Params': {'$ref': '#/definitions/AddCharm'}},
                                 'type': 'object'},
                    'AddCharmWithAuthorization': {'properties': {'Params': {'$ref': '#/definitions/AddCharmWithAuthorization'}},
                                                  'type': 'object'},
                    'AddMachines': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                   'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                    'type': 'object'},
                    'AddMachinesV2': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                     'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                      'type': 'object'},
                    'AgentVersion': {'properties': {'Result': {'$ref': '#/definitions/AgentVersionResult'}},
                                     'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'DestroyMachines': {'properties': {'Params': {'$ref': '#/definitions/DestroyMachines'}},
                                        'type': 'object'},
                    'FindTools': {'properties': {'Params': {'$ref': '#/definitions/FindToolsParams'},
                                                 'Result': {'$ref': '#/definitions/FindToolsResult'}},
                                  'type': 'object'},
                    'FullStatus': {'properties': {'Params': {'$ref': '#/definitions/StatusParams'},
                                                  'Result': {'$ref': '#/definitions/FullStatus'}},
                                   'type': 'object'},
                    'GetBundleChanges': {'properties': {'Params': {'$ref': '#/definitions/BundleChangesParams'},
                                                        'Result': {'$ref': '#/definitions/BundleChangesResults'}},
                                         'type': 'object'},
                    'GetModelConstraints': {'properties': {'Result': {'$ref': '#/definitions/GetConstraintsResults'}},
                                            'type': 'object'},
                    'InjectMachines': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                      'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                       'type': 'object'},
                    'ModelGet': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                 'type': 'object'},
                    'ModelInfo': {'properties': {'Result': {'$ref': '#/definitions/ModelInfo'}},
                                  'type': 'object'},
                    'ModelSet': {'properties': {'Params': {'$ref': '#/definitions/ModelSet'}},
                                 'type': 'object'},
                    'ModelUnset': {'properties': {'Params': {'$ref': '#/definitions/ModelUnset'}},
                                   'type': 'object'},
                    'ModelUserInfo': {'properties': {'Result': {'$ref': '#/definitions/ModelUserInfoResults'}},
                                      'type': 'object'},
                    'PrivateAddress': {'properties': {'Params': {'$ref': '#/definitions/PrivateAddress'},
                                                      'Result': {'$ref': '#/definitions/PrivateAddressResults'}},
                                       'type': 'object'},
                    'ProvisioningScript': {'properties': {'Params': {'$ref': '#/definitions/ProvisioningScriptParams'},
                                                          'Result': {'$ref': '#/definitions/ProvisioningScriptResult'}},
                                           'type': 'object'},
                    'PublicAddress': {'properties': {'Params': {'$ref': '#/definitions/PublicAddress'},
                                                     'Result': {'$ref': '#/definitions/PublicAddressResults'}},
                                      'type': 'object'},
                    'ResolveCharms': {'properties': {'Params': {'$ref': '#/definitions/ResolveCharms'},
                                                     'Result': {'$ref': '#/definitions/ResolveCharmResults'}},
                                      'type': 'object'},
                    'Resolved': {'properties': {'Params': {'$ref': '#/definitions/Resolved'}},
                                 'type': 'object'},
                    'RetryProvisioning': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SLALevel': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                 'type': 'object'},
                    'SetModelAgentVersion': {'properties': {'Params': {'$ref': '#/definitions/SetModelAgentVersion'}},
                                             'type': 'object'},
                    'SetModelConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                            'type': 'object'},
                    'SetSLALevel': {'properties': {'Params': {'$ref': '#/definitions/ModelSLA'}},
                                    'type': 'object'},
                    'StatusHistory': {'properties': {'Params': {'$ref': '#/definitions/StatusHistoryRequests'},
                                                     'Result': {'$ref': '#/definitions/StatusHistoryResults'}},
                                      'type': 'object'},
                    'WatchAll': {'properties': {'Result': {'$ref': '#/definitions/AllWatcherId'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> typing.Sequence[~HostPort]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='APIHostPorts',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AbortCurrentUpgrade(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AbortCurrentUpgrade',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AddCharm(self, channel, url):
        '''
        channel : str
        url : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddCharm',
                   version=2,
                   params=_params)
        _params['channel'] = channel
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AddCharmWithAuthorization(self, channel, macaroon, url):
        '''
        channel : str
        macaroon : Macaroon
        url : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddCharmWithAuthorization',
                   version=2,
                   params=_params)
        _params['channel'] = channel
        _params['macaroon'] = macaroon
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def AddMachines(self, params):
        '''
        params : typing.Sequence[~AddMachineParams]
        Returns -> typing.Sequence[~AddMachinesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddMachines',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def AddMachinesV2(self, params):
        '''
        params : typing.Sequence[~AddMachineParams]
        Returns -> typing.Sequence[~AddMachinesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddMachinesV2',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AgentVersionResult)
    async def AgentVersion(self):
        '''

        Returns -> Number
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AgentVersion',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> typing.Sequence[int]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='CACert',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyMachines(self, force, machine_names):
        '''
        force : bool
        machine_names : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='DestroyMachines',
                   version=2,
                   params=_params)
        _params['force'] = force
        _params['machine-names'] = machine_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindToolsResult)
    async def FindTools(self, arch, major, minor, number, series):
        '''
        arch : str
        major : int
        minor : int
        number : Number
        series : str
        Returns -> typing.Union[_ForwardRef('Error'), typing.Sequence[~Tools]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='FindTools',
                   version=2,
                   params=_params)
        _params['arch'] = arch
        _params['major'] = major
        _params['minor'] = minor
        _params['number'] = number
        _params['series'] = series
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FullStatus)
    async def FullStatus(self, patterns):
        '''
        patterns : typing.Sequence[str]
        Returns -> typing.Union[typing.Mapping[str, ~ApplicationStatus], str, typing.Mapping[str, ~MachineStatus], _ForwardRef('ModelStatusInfo'), typing.Mapping[str, ~ApplicationOfferStatus], typing.Sequence[~RelationStatus], typing.Mapping[str, ~RemoteApplicationStatus]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='FullStatus',
                   version=2,
                   params=_params)
        _params['patterns'] = patterns
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BundleChangesResults)
    async def GetBundleChanges(self, yaml):
        '''
        yaml : str
        Returns -> typing.Union[typing.Sequence[~BundleChange], typing.Sequence[str]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='GetBundleChanges',
                   version=2,
                   params=_params)
        _params['yaml'] = yaml
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetConstraintsResults)
    async def GetModelConstraints(self):
        '''

        Returns -> Value
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='GetModelConstraints',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def InjectMachines(self, params):
        '''
        params : typing.Sequence[~AddMachineParams]
        Returns -> typing.Sequence[~AddMachinesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='InjectMachines',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResults)
    async def ModelGet(self):
        '''

        Returns -> typing.Mapping[str, ~ConfigValue]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelGet',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfo)
    async def ModelInfo(self):
        '''

        Returns -> typing.Union[_ForwardRef('Number'), str, typing.Sequence[~ModelMachineInfo], _ForwardRef('ModelMigrationStatus'), _ForwardRef('ModelSLAInfo'), _ForwardRef('EntityStatus'), typing.Sequence[~ModelUserInfo]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelInfo',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelSet(self, config):
        '''
        config : typing.Mapping[str, typing.Any]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelSet',
                   version=2,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelUnset(self, keys):
        '''
        keys : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelUnset',
                   version=2,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelUserInfoResults)
    async def ModelUserInfo(self):
        '''

        Returns -> typing.Sequence[~ModelUserInfoResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelUserInfo',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PrivateAddressResults)
    async def PrivateAddress(self, target):
        '''
        target : str
        Returns -> str
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='PrivateAddress',
                   version=2,
                   params=_params)
        _params['target'] = target
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProvisioningScriptResult)
    async def ProvisioningScript(self, data_dir, disable_package_commands, machine_id, nonce):
        '''
        data_dir : str
        disable_package_commands : bool
        machine_id : str
        nonce : str
        Returns -> str
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ProvisioningScript',
                   version=2,
                   params=_params)
        _params['data-dir'] = data_dir
        _params['disable-package-commands'] = disable_package_commands
        _params['machine-id'] = machine_id
        _params['nonce'] = nonce
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PublicAddressResults)
    async def PublicAddress(self, target):
        '''
        target : str
        Returns -> str
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='PublicAddress',
                   version=2,
                   params=_params)
        _params['target'] = target
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ResolveCharmResults)
    async def ResolveCharms(self, references):
        '''
        references : typing.Sequence[str]
        Returns -> typing.Sequence[~ResolveCharmResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ResolveCharms',
                   version=2,
                   params=_params)
        _params['references'] = references
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Resolved(self, retry, unit_name):
        '''
        retry : bool
        unit_name : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='Resolved',
                   version=2,
                   params=_params)
        _params['retry'] = retry
        _params['unit-name'] = unit_name
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RetryProvisioning(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='RetryProvisioning',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def SLALevel(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SLALevel',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetModelAgentVersion(self, version):
        '''
        version : Number
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SetModelAgentVersion',
                   version=2,
                   params=_params)
        _params['version'] = version
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetModelConstraints(self, application, constraints):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SetModelConstraints',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetSLALevel(self, creds, level):
        '''
        creds : typing.Sequence[int]
        level : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SetSLALevel',
                   version=2,
                   params=_params)
        _params['creds'] = creds
        _params['level'] = level
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusHistoryResults)
    async def StatusHistory(self, requests):
        '''
        requests : typing.Sequence[~StatusHistoryRequest]
        Returns -> typing.Sequence[~StatusHistoryResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='StatusHistory',
                   version=2,
                   params=_params)
        _params['requests'] = requests
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AllWatcherId)
    async def WatchAll(self):
        '''

        Returns -> str
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='WatchAll',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CredentialValidatorFacade(Type):
    name = 'CredentialValidator'
    version = 2
    schema =     {'definitions': {'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'InvalidateCredentialArg': {'additionalProperties': False,
                                                 'properties': {'reason': {'type': 'string'}},
                                                 'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelCredential': {'additionalProperties': False,
                                         'properties': {'credential-tag': {'type': 'string'},
                                                        'exists': {'type': 'boolean'},
                                                        'model-tag': {'type': 'string'},
                                                        'valid': {'type': 'boolean'}},
                                         'required': ['model-tag',
                                                      'credential-tag'],
                                         'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'}},
     'properties': {'InvalidateModelCredential': {'properties': {'Params': {'$ref': '#/definitions/InvalidateCredentialArg'},
                                                                 'Result': {'$ref': '#/definitions/ErrorResult'}},
                                                  'type': 'object'},
                    'ModelCredential': {'properties': {'Result': {'$ref': '#/definitions/ModelCredential'}},
                                        'type': 'object'},
                    'WatchCredential': {'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                       'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                        'type': 'object'},
                    'WatchModelCredential': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def InvalidateModelCredential(self, reason):
        '''
        reason : str
        Returns -> Error
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CredentialValidator',
                   request='InvalidateModelCredential',
                   version=2,
                   params=_params)
        _params['reason'] = reason
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelCredential)
    async def ModelCredential(self):
        '''

        Returns -> typing.Union[str, bool]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CredentialValidator',
                   request='ModelCredential',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchCredential(self, tag):
        '''
        tag : str
        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CredentialValidator',
                   request='WatchCredential',
                   version=2,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchModelCredential(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CredentialValidator',
                   request='WatchModelCredential',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class DiscoverSpacesFacade(Type):
    name = 'DiscoverSpaces'
    version = 2
    schema =     {'definitions': {'AddSubnetParams': {'additionalProperties': False,
                                         'properties': {'provider-network-id': {'type': 'string'},
                                                        'space-tag': {'type': 'string'},
                                                        'subnet-provider-id': {'type': 'string'},
                                                        'subnet-tag': {'type': 'string'},
                                                        'vlan-tag': {'type': 'integer'},
                                                        'zones': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                         'required': ['space-tag'],
                                         'type': 'object'},
                     'AddSubnetsParams': {'additionalProperties': False,
                                          'properties': {'subnets': {'items': {'$ref': '#/definitions/AddSubnetParams'},
                                                                     'type': 'array'}},
                                          'required': ['subnets'],
                                          'type': 'object'},
                     'CreateSpaceParams': {'additionalProperties': False,
                                           'properties': {'provider-id': {'type': 'string'},
                                                          'public': {'type': 'boolean'},
                                                          'space-tag': {'type': 'string'},
                                                          'subnet-tags': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                           'required': ['subnet-tags',
                                                        'space-tag',
                                                        'public'],
                                           'type': 'object'},
                     'CreateSpacesParams': {'additionalProperties': False,
                                            'properties': {'spaces': {'items': {'$ref': '#/definitions/CreateSpaceParams'},
                                                                      'type': 'array'}},
                                            'required': ['spaces'],
                                            'type': 'object'},
                     'DiscoverSpacesResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/ProviderSpace'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSubnetsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/Subnet'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ProviderSpace': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'name': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                                  'type': 'array'}},
                                       'required': ['name',
                                                    'provider-id',
                                                    'subnets'],
                                       'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'SubnetsFilters': {'additionalProperties': False,
                                        'properties': {'space-tag': {'type': 'string'},
                                                       'zone': {'type': 'string'}},
                                        'type': 'object'}},
     'properties': {'AddSubnets': {'properties': {'Params': {'$ref': '#/definitions/AddSubnetsParams'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'CreateSpaces': {'properties': {'Params': {'$ref': '#/definitions/CreateSpacesParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListSpaces': {'properties': {'Result': {'$ref': '#/definitions/DiscoverSpacesResults'}},
                                   'type': 'object'},
                    'ListSubnets': {'properties': {'Params': {'$ref': '#/definitions/SubnetsFilters'},
                                                   'Result': {'$ref': '#/definitions/ListSubnetsResults'}},
                                    'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddSubnets(self, subnets):
        '''
        subnets : typing.Sequence[~AddSubnetParams]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces',
                   request='AddSubnets',
                   version=2,
                   params=_params)
        _params['subnets'] = subnets
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def CreateSpaces(self, spaces):
        '''
        spaces : typing.Sequence[~CreateSpaceParams]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces',
                   request='CreateSpaces',
                   version=2,
                   params=_params)
        _params['spaces'] = spaces
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DiscoverSpacesResults)
    async def ListSpaces(self):
        '''

        Returns -> typing.Sequence[~ProviderSpace]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces',
                   request='ListSpaces',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSubnetsResults)
    async def ListSubnets(self, space_tag, zone):
        '''
        space_tag : str
        zone : str
        Returns -> typing.Sequence[~Subnet]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces',
                   request='ListSubnets',
                   version=2,
                   params=_params)
        _params['space-tag'] = space_tag
        _params['zone'] = zone
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces',
                   request='ModelConfig',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class DiskManagerFacade(Type):
    name = 'DiskManager'
    version = 2
    schema =     {'definitions': {'BlockDevice': {'additionalProperties': False,
                                     'properties': {'BusAddress': {'type': 'string'},
                                                    'DeviceLinks': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                    'DeviceName': {'type': 'string'},
                                                    'FilesystemType': {'type': 'string'},
                                                    'HardwareId': {'type': 'string'},
                                                    'InUse': {'type': 'boolean'},
                                                    'Label': {'type': 'string'},
                                                    'MountPoint': {'type': 'string'},
                                                    'Size': {'type': 'integer'},
                                                    'UUID': {'type': 'string'},
                                                    'WWN': {'type': 'string'}},
                                     'required': ['DeviceName',
                                                  'DeviceLinks',
                                                  'Label',
                                                  'UUID',
                                                  'HardwareId',
                                                  'WWN',
                                                  'BusAddress',
                                                  'Size',
                                                  'FilesystemType',
                                                  'InUse',
                                                  'MountPoint'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineBlockDevices': {'additionalProperties': False,
                                             'properties': {'block-devices': {'items': {'$ref': '#/definitions/BlockDevice'},
                                                                              'type': 'array'},
                                                            'machine': {'type': 'string'}},
                                             'required': ['machine'],
                                             'type': 'object'},
                     'SetMachineBlockDevices': {'additionalProperties': False,
                                                'properties': {'machine-block-devices': {'items': {'$ref': '#/definitions/MachineBlockDevices'},
                                                                                         'type': 'array'}},
                                                'required': ['machine-block-devices'],
                                                'type': 'object'}},
     'properties': {'SetMachineBlockDevices': {'properties': {'Params': {'$ref': '#/definitions/SetMachineBlockDevices'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def SetMachineBlockDevices(self, machine_block_devices):
        '''
        machine_block_devices : typing.Sequence[~MachineBlockDevices]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiskManager',
                   request='SetMachineBlockDevices',
                   version=2,
                   params=_params)
        _params['machine-block-devices'] = machine_block_devices
        reply = await self.rpc(msg)
        return reply



class EntityWatcherFacade(Type):
    name = 'EntityWatcher'
    version = 2
    schema =     {'definitions': {'EntitiesWatchResult': {'additionalProperties': False,
                                             'properties': {'changes': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'watcher-id': {'type': 'string'}},
                                             'required': ['watcher-id'],
                                             'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/EntitiesWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(EntitiesWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[typing.Sequence[str], _ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='EntityWatcher',
                   request='Next',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='EntityWatcher',
                   request='Stop',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class FilesystemAttachmentsWatcherFacade(Type):
    name = 'FilesystemAttachmentsWatcher'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineStorageId': {'additionalProperties': False,
                                          'properties': {'attachment-tag': {'type': 'string'},
                                                         'machine-tag': {'type': 'string'}},
                                          'required': ['machine-tag',
                                                       'attachment-tag'],
                                          'type': 'object'},
                     'MachineStorageIdsWatchResult': {'additionalProperties': False,
                                                      'properties': {'changes': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                                 'type': 'array'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'watcher-id': {'type': 'string'}},
                                                      'required': ['watcher-id',
                                                                   'changes'],
                                                      'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MachineStorageIdsWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[typing.Sequence[~MachineStorageId], _ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='FilesystemAttachmentsWatcher',
                   request='Next',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='FilesystemAttachmentsWatcher',
                   request='Stop',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class HighAvailabilityFacade(Type):
    name = 'HighAvailability'
    version = 2
    schema =     {'definitions': {'Address': {'additionalProperties': False,
                                 'properties': {'Scope': {'type': 'string'},
                                                'SpaceName': {'type': 'string'},
                                                'SpaceProviderId': {'type': 'string'},
                                                'Type': {'type': 'string'},
                                                'Value': {'type': 'string'}},
                                 'required': ['Value',
                                              'Type',
                                              'Scope',
                                              'SpaceName',
                                              'SpaceProviderId'],
                                 'type': 'object'},
                     'ControllersChangeResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/ControllersChanges'}},
                                                 'required': ['result'],
                                                 'type': 'object'},
                     'ControllersChangeResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllersChangeResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllersChanges': {'additionalProperties': False,
                                            'properties': {'added': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                           'converted': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                           'demoted': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'maintained': {'items': {'type': 'string'},
                                                                          'type': 'array'},
                                                           'promoted': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                           'removed': {'items': {'type': 'string'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'ControllersSpec': {'additionalProperties': False,
                                         'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                        'num-controllers': {'type': 'integer'},
                                                        'placement': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                        'series': {'type': 'string'}},
                                         'required': ['num-controllers'],
                                         'type': 'object'},
                     'ControllersSpecs': {'additionalProperties': False,
                                          'properties': {'specs': {'items': {'$ref': '#/definitions/ControllersSpec'},
                                                                   'type': 'array'}},
                                          'required': ['specs'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'HAMember': {'additionalProperties': False,
                                  'properties': {'public-address': {'$ref': '#/definitions/Address'},
                                                 'series': {'type': 'string'},
                                                 'tag': {'type': 'string'}},
                                  'required': ['tag', 'public-address', 'series'],
                                  'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Member': {'additionalProperties': False,
                                'properties': {'Address': {'type': 'string'},
                                               'Id': {'type': 'integer'},
                                               'Priority': {'type': 'number'},
                                               'Tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                        'type': 'object'},
                                               'Votes': {'type': 'integer'}},
                                'required': ['Id',
                                             'Address',
                                             'Priority',
                                             'Tags',
                                             'Votes'],
                                'type': 'object'},
                     'MongoUpgradeResults': {'additionalProperties': False,
                                             'properties': {'ha-members': {'items': {'$ref': '#/definitions/HAMember'},
                                                                           'type': 'array'},
                                                            'master': {'$ref': '#/definitions/HAMember'},
                                                            'rs-members': {'items': {'$ref': '#/definitions/Member'},
                                                                           'type': 'array'}},
                                             'required': ['rs-members',
                                                          'master',
                                                          'ha-members'],
                                             'type': 'object'},
                     'MongoVersion': {'additionalProperties': False,
                                      'properties': {'engine': {'type': 'string'},
                                                     'major': {'type': 'integer'},
                                                     'minor': {'type': 'integer'},
                                                     'patch': {'type': 'string'}},
                                      'required': ['major',
                                                   'minor',
                                                   'patch',
                                                   'engine'],
                                      'type': 'object'},
                     'ResumeReplicationParams': {'additionalProperties': False,
                                                 'properties': {'members': {'items': {'$ref': '#/definitions/Member'},
                                                                            'type': 'array'}},
                                                 'required': ['members'],
                                                 'type': 'object'},
                     'UpgradeMongoParams': {'additionalProperties': False,
                                            'properties': {'target': {'$ref': '#/definitions/MongoVersion'}},
                                            'required': ['target'],
                                            'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'EnableHA': {'properties': {'Params': {'$ref': '#/definitions/ControllersSpecs'},
                                                'Result': {'$ref': '#/definitions/ControllersChangeResults'}},
                                 'type': 'object'},
                    'ResumeHAReplicationAfterUpgrade': {'properties': {'Params': {'$ref': '#/definitions/ResumeReplicationParams'}},
                                                        'type': 'object'},
                    'StopHAReplicationForUpgrade': {'properties': {'Params': {'$ref': '#/definitions/UpgradeMongoParams'},
                                                                   'Result': {'$ref': '#/definitions/MongoUpgradeResults'}},
                                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ControllersChangeResults)
    async def EnableHA(self, specs):
        '''
        specs : typing.Sequence[~ControllersSpec]
        Returns -> typing.Sequence[~ControllersChangeResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='HighAvailability',
                   request='EnableHA',
                   version=2,
                   params=_params)
        _params['specs'] = specs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ResumeHAReplicationAfterUpgrade(self, members):
        '''
        members : typing.Sequence[~Member]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='HighAvailability',
                   request='ResumeHAReplicationAfterUpgrade',
                   version=2,
                   params=_params)
        _params['members'] = members
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MongoUpgradeResults)
    async def StopHAReplicationForUpgrade(self, target):
        '''
        target : MongoVersion
        Returns -> typing.Union[typing.Sequence[~HAMember], _ForwardRef('HAMember'), typing.Sequence[~Member]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='HighAvailability',
                   request='StopHAReplicationForUpgrade',
                   version=2,
                   params=_params)
        _params['target'] = target
        reply = await self.rpc(msg)
        return reply



class ImageManagerFacade(Type):
    name = 'ImageManager'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ImageFilterParams': {'additionalProperties': False,
                                           'properties': {'images': {'items': {'$ref': '#/definitions/ImageSpec'},
                                                                     'type': 'array'}},
                                           'required': ['images'],
                                           'type': 'object'},
                     'ImageMetadata': {'additionalProperties': False,
                                       'properties': {'arch': {'type': 'string'},
                                                      'created': {'format': 'date-time',
                                                                  'type': 'string'},
                                                      'kind': {'type': 'string'},
                                                      'series': {'type': 'string'},
                                                      'url': {'type': 'string'}},
                                       'required': ['kind',
                                                    'arch',
                                                    'series',
                                                    'url',
                                                    'created'],
                                       'type': 'object'},
                     'ImageSpec': {'additionalProperties': False,
                                   'properties': {'arch': {'type': 'string'},
                                                  'kind': {'type': 'string'},
                                                  'series': {'type': 'string'}},
                                   'required': ['kind', 'arch', 'series'],
                                   'type': 'object'},
                     'ListImageResult': {'additionalProperties': False,
                                         'properties': {'result': {'items': {'$ref': '#/definitions/ImageMetadata'},
                                                                   'type': 'array'}},
                                         'required': ['result'],
                                         'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'DeleteImages': {'properties': {'Params': {'$ref': '#/definitions/ImageFilterParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListImages': {'properties': {'Params': {'$ref': '#/definitions/ImageFilterParams'},
                                                  'Result': {'$ref': '#/definitions/ListImageResult'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def DeleteImages(self, images):
        '''
        images : typing.Sequence[~ImageSpec]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageManager',
                   request='DeleteImages',
                   version=2,
                   params=_params)
        _params['images'] = images
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListImageResult)
    async def ListImages(self, images):
        '''
        images : typing.Sequence[~ImageSpec]
        Returns -> typing.Sequence[~ImageMetadata]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageManager',
                   request='ListImages',
                   version=2,
                   params=_params)
        _params['images'] = images
        reply = await self.rpc(msg)
        return reply



class ImageMetadataFacade(Type):
    name = 'ImageMetadata'
    version = 2
    schema =     {'definitions': {'CloudImageMetadata': {'additionalProperties': False,
                                            'properties': {'arch': {'type': 'string'},
                                                           'image-id': {'type': 'string'},
                                                           'priority': {'type': 'integer'},
                                                           'region': {'type': 'string'},
                                                           'root-storage-size': {'type': 'integer'},
                                                           'root-storage-type': {'type': 'string'},
                                                           'series': {'type': 'string'},
                                                           'source': {'type': 'string'},
                                                           'stream': {'type': 'string'},
                                                           'version': {'type': 'string'},
                                                           'virt-type': {'type': 'string'}},
                                            'required': ['image-id',
                                                         'region',
                                                         'version',
                                                         'series',
                                                         'arch',
                                                         'source',
                                                         'priority'],
                                            'type': 'object'},
                     'CloudImageMetadataList': {'additionalProperties': False,
                                                'properties': {'metadata': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                            'type': 'array'}},
                                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ImageMetadataFilter': {'additionalProperties': False,
                                             'properties': {'arches': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                            'region': {'type': 'string'},
                                                            'root-storage-type': {'type': 'string'},
                                                            'series': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                            'stream': {'type': 'string'},
                                                            'virt-type': {'type': 'string'}},
                                             'type': 'object'},
                     'ListCloudImageMetadataResult': {'additionalProperties': False,
                                                      'properties': {'result': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                                'type': 'array'}},
                                                      'required': ['result'],
                                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MetadataImageIds': {'additionalProperties': False,
                                          'properties': {'image-ids': {'items': {'type': 'string'},
                                                                       'type': 'array'}},
                                          'required': ['image-ids'],
                                          'type': 'object'},
                     'MetadataSaveParams': {'additionalProperties': False,
                                            'properties': {'metadata': {'items': {'$ref': '#/definitions/CloudImageMetadataList'},
                                                                        'type': 'array'}},
                                            'type': 'object'}},
     'properties': {'Delete': {'properties': {'Params': {'$ref': '#/definitions/MetadataImageIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'List': {'properties': {'Params': {'$ref': '#/definitions/ImageMetadataFilter'},
                                            'Result': {'$ref': '#/definitions/ListCloudImageMetadataResult'}},
                             'type': 'object'},
                    'Save': {'properties': {'Params': {'$ref': '#/definitions/MetadataSaveParams'},
                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                             'type': 'object'},
                    'UpdateFromPublishedImages': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def Delete(self, image_ids):
        '''
        image_ids : typing.Sequence[str]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata',
                   request='Delete',
                   version=2,
                   params=_params)
        _params['image-ids'] = image_ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListCloudImageMetadataResult)
    async def List(self, arches, region, root_storage_type, series, stream, virt_type):
        '''
        arches : typing.Sequence[str]
        region : str
        root_storage_type : str
        series : typing.Sequence[str]
        stream : str
        virt_type : str
        Returns -> typing.Sequence[~CloudImageMetadata]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata',
                   request='List',
                   version=2,
                   params=_params)
        _params['arches'] = arches
        _params['region'] = region
        _params['root-storage-type'] = root_storage_type
        _params['series'] = series
        _params['stream'] = stream
        _params['virt-type'] = virt_type
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Save(self, metadata):
        '''
        metadata : typing.Sequence[~CloudImageMetadataList]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata',
                   request='Save',
                   version=2,
                   params=_params)
        _params['metadata'] = metadata
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def UpdateFromPublishedImages(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata',
                   request='UpdateFromPublishedImages',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class LeadershipServiceFacade(Type):
    name = 'LeadershipService'
    version = 2
    schema =     {'definitions': {'ApplicationTag': {'additionalProperties': False,
                                        'properties': {'Name': {'type': 'string'}},
                                        'required': ['Name'],
                                        'type': 'object'},
                     'ClaimLeadershipBulkParams': {'additionalProperties': False,
                                                   'properties': {'params': {'items': {'$ref': '#/definitions/ClaimLeadershipParams'},
                                                                             'type': 'array'}},
                                                   'required': ['params'],
                                                   'type': 'object'},
                     'ClaimLeadershipBulkResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                               'type': 'array'}},
                                                    'required': ['results'],
                                                    'type': 'object'},
                     'ClaimLeadershipParams': {'additionalProperties': False,
                                               'properties': {'application-tag': {'type': 'string'},
                                                              'duration': {'type': 'number'},
                                                              'unit-tag': {'type': 'string'}},
                                               'required': ['application-tag',
                                                            'unit-tag',
                                                            'duration'],
                                               'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'}},
     'properties': {'BlockUntilLeadershipReleased': {'properties': {'Params': {'$ref': '#/definitions/ApplicationTag'},
                                                                    'Result': {'$ref': '#/definitions/ErrorResult'}},
                                                     'type': 'object'},
                    'ClaimLeadership': {'properties': {'Params': {'$ref': '#/definitions/ClaimLeadershipBulkParams'},
                                                       'Result': {'$ref': '#/definitions/ClaimLeadershipBulkResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def BlockUntilLeadershipReleased(self, name):
        '''
        name : str
        Returns -> Error
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LeadershipService',
                   request='BlockUntilLeadershipReleased',
                   version=2,
                   params=_params)
        _params['Name'] = name
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ClaimLeadershipBulkResults)
    async def ClaimLeadership(self, params):
        '''
        params : typing.Sequence[~ClaimLeadershipParams]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LeadershipService',
                   request='ClaimLeadership',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



class MachineManagerFacade(Type):
    name = 'MachineManager'
    version = 2
    schema =     {'definitions': {'AddMachineParams': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'container-type': {'type': 'string'},
                                                         'disks': {'items': {'$ref': '#/definitions/Constraints'},
                                                                   'type': 'array'},
                                                         'hardware-characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                         'instance-id': {'type': 'string'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'nonce': {'type': 'string'},
                                                         'parent-id': {'type': 'string'},
                                                         'placement': {'$ref': '#/definitions/Placement'},
                                                         'series': {'type': 'string'}},
                                          'required': ['series',
                                                       'constraints',
                                                       'jobs',
                                                       'parent-id',
                                                       'container-type',
                                                       'instance-id',
                                                       'nonce',
                                                       'hardware-characteristics',
                                                       'addresses'],
                                          'type': 'object'},
                     'AddMachines': {'additionalProperties': False,
                                     'properties': {'params': {'items': {'$ref': '#/definitions/AddMachineParams'},
                                                               'type': 'array'}},
                                     'required': ['params'],
                                     'type': 'object'},
                     'AddMachinesResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'machine': {'type': 'string'}},
                                           'required': ['machine'],
                                           'type': 'object'},
                     'AddMachinesResults': {'additionalProperties': False,
                                            'properties': {'machines': {'items': {'$ref': '#/definitions/AddMachinesResult'},
                                                                        'type': 'array'}},
                                            'required': ['machines'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'InstanceType': {'additionalProperties': False,
                                      'properties': {'arches': {'items': {'type': 'string'},
                                                                'type': 'array'},
                                                     'cost': {'type': 'integer'},
                                                     'cpu-cores': {'type': 'integer'},
                                                     'deprecated': {'type': 'boolean'},
                                                     'memory': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'root-disk': {'type': 'integer'},
                                                     'virt-type': {'type': 'string'}},
                                      'required': ['arches', 'cpu-cores', 'memory'],
                                      'type': 'object'},
                     'InstanceTypesResult': {'additionalProperties': False,
                                             'properties': {'cost-currency': {'type': 'string'},
                                                            'cost-divisor': {'type': 'integer'},
                                                            'cost-unit': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'instance-types': {'items': {'$ref': '#/definitions/InstanceType'},
                                                                               'type': 'array'}},
                                             'type': 'object'},
                     'InstanceTypesResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/InstanceTypesResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelInstanceTypesConstraint': {'additionalProperties': False,
                                                      'properties': {'value': {'$ref': '#/definitions/Value'}},
                                                      'type': 'object'},
                     'ModelInstanceTypesConstraints': {'additionalProperties': False,
                                                       'properties': {'constraints': {'items': {'$ref': '#/definitions/ModelInstanceTypesConstraint'},
                                                                                      'type': 'array'}},
                                                       'required': ['constraints'],
                                                       'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'AddMachines': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                   'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                    'type': 'object'},
                    'InstanceTypes': {'properties': {'Params': {'$ref': '#/definitions/ModelInstanceTypesConstraints'},
                                                     'Result': {'$ref': '#/definitions/InstanceTypesResults'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddMachinesResults)
    async def AddMachines(self, params):
        '''
        params : typing.Sequence[~AddMachineParams]
        Returns -> typing.Sequence[~AddMachinesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='AddMachines',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InstanceTypesResults)
    async def InstanceTypes(self, constraints):
        '''
        constraints : typing.Sequence[~ModelInstanceTypesConstraint]
        Returns -> typing.Sequence[~InstanceTypesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='InstanceTypes',
                   version=2,
                   params=_params)
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



class MetricsAdderFacade(Type):
    name = 'MetricsAdder'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Metric': {'additionalProperties': False,
                                'properties': {'key': {'type': 'string'},
                                               'labels': {'patternProperties': {'.*': {'type': 'string'}},
                                                          'type': 'object'},
                                               'time': {'format': 'date-time',
                                                        'type': 'string'},
                                               'value': {'type': 'string'}},
                                'required': ['key', 'value', 'time'],
                                'type': 'object'},
                     'MetricBatch': {'additionalProperties': False,
                                     'properties': {'charm-url': {'type': 'string'},
                                                    'created': {'format': 'date-time',
                                                                'type': 'string'},
                                                    'metrics': {'items': {'$ref': '#/definitions/Metric'},
                                                                'type': 'array'},
                                                    'uuid': {'type': 'string'}},
                                     'required': ['uuid',
                                                  'charm-url',
                                                  'created',
                                                  'metrics'],
                                     'type': 'object'},
                     'MetricBatchParam': {'additionalProperties': False,
                                          'properties': {'batch': {'$ref': '#/definitions/MetricBatch'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'batch'],
                                          'type': 'object'},
                     'MetricBatchParams': {'additionalProperties': False,
                                           'properties': {'batches': {'items': {'$ref': '#/definitions/MetricBatchParam'},
                                                                      'type': 'array'}},
                                           'required': ['batches'],
                                           'type': 'object'}},
     'properties': {'AddMetricBatches': {'properties': {'Params': {'$ref': '#/definitions/MetricBatchParams'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddMetricBatches(self, batches):
        '''
        batches : typing.Sequence[~MetricBatchParam]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsAdder',
                   request='AddMetricBatches',
                   version=2,
                   params=_params)
        _params['batches'] = batches
        reply = await self.rpc(msg)
        return reply



class MetricsDebugFacade(Type):
    name = 'MetricsDebug'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityMetrics': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'metrics': {'items': {'$ref': '#/definitions/MetricResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MeterStatusParam': {'additionalProperties': False,
                                          'properties': {'code': {'type': 'string'},
                                                         'info': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'code'],
                                          'type': 'object'},
                     'MeterStatusParams': {'additionalProperties': False,
                                           'properties': {'statues': {'items': {'$ref': '#/definitions/MeterStatusParam'},
                                                                      'type': 'array'}},
                                           'required': ['statues'],
                                           'type': 'object'},
                     'MetricResult': {'additionalProperties': False,
                                      'properties': {'key': {'type': 'string'},
                                                     'labels': {'patternProperties': {'.*': {'type': 'string'}},
                                                                'type': 'object'},
                                                     'time': {'format': 'date-time',
                                                              'type': 'string'},
                                                     'unit': {'type': 'string'},
                                                     'value': {'type': 'string'}},
                                      'required': ['time',
                                                   'key',
                                                   'value',
                                                   'unit',
                                                   'labels'],
                                      'type': 'object'},
                     'MetricResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/EntityMetrics'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'}},
     'properties': {'GetMetrics': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/MetricResults'}},
                                   'type': 'object'},
                    'SetMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/MeterStatusParams'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MetricResults)
    async def GetMetrics(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~EntityMetrics]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsDebug',
                   request='GetMetrics',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMeterStatus(self, statues):
        '''
        statues : typing.Sequence[~MeterStatusParam]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsDebug',
                   request='SetMeterStatus',
                   version=2,
                   params=_params)
        _params['statues'] = statues
        reply = await self.rpc(msg)
        return reply



class ModelConfigFacade(Type):
    name = 'ModelConfig'
    version = 2
    schema =     {'definitions': {'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelSLA': {'additionalProperties': False,
                                  'properties': {'ModelSLAInfo': {'$ref': '#/definitions/ModelSLAInfo'},
                                                 'creds': {'items': {'type': 'integer'},
                                                           'type': 'array'}},
                                  'required': ['ModelSLAInfo', 'creds'],
                                  'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelSequencesResult': {'additionalProperties': False,
                                              'properties': {'sequences': {'patternProperties': {'.*': {'type': 'integer'}},
                                                                           'type': 'object'}},
                                              'required': ['sequences'],
                                              'type': 'object'},
                     'ModelSet': {'additionalProperties': False,
                                  'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                         'type': 'object'}},
                                                            'type': 'object'}},
                                  'required': ['config'],
                                  'type': 'object'},
                     'ModelUnset': {'additionalProperties': False,
                                    'properties': {'keys': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['keys'],
                                    'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'}},
     'properties': {'ModelGet': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                 'type': 'object'},
                    'ModelSet': {'properties': {'Params': {'$ref': '#/definitions/ModelSet'}},
                                 'type': 'object'},
                    'ModelUnset': {'properties': {'Params': {'$ref': '#/definitions/ModelUnset'}},
                                   'type': 'object'},
                    'SLALevel': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                 'type': 'object'},
                    'Sequences': {'properties': {'Result': {'$ref': '#/definitions/ModelSequencesResult'}},
                                  'type': 'object'},
                    'SetSLALevel': {'properties': {'Params': {'$ref': '#/definitions/ModelSLA'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelConfigResults)
    async def ModelGet(self):
        '''

        Returns -> typing.Mapping[str, ~ConfigValue]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='ModelGet',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelSet(self, config):
        '''
        config : typing.Mapping[str, typing.Any]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='ModelSet',
                   version=2,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelUnset(self, keys):
        '''
        keys : typing.Sequence[str]
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='ModelUnset',
                   version=2,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def SLALevel(self):
        '''

        Returns -> typing.Union[_ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='SLALevel',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelSequencesResult)
    async def Sequences(self):
        '''

        Returns -> typing.Mapping[str, int]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='Sequences',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetSLALevel(self, creds, level):
        '''
        creds : typing.Sequence[int]
        level : str
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='SetSLALevel',
                   version=2,
                   params=_params)
        _params['creds'] = creds
        _params['level'] = level
        reply = await self.rpc(msg)
        return reply



class ModelManagerFacade(Type):
    name = 'ModelManager'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MapResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                          'type': 'object'}},
                                                             'type': 'object'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'MapResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/MapResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'Model': {'additionalProperties': False,
                               'properties': {'name': {'type': 'string'},
                                              'owner-tag': {'type': 'string'},
                                              'uuid': {'type': 'string'}},
                               'required': ['name', 'uuid', 'owner-tag'],
                               'type': 'object'},
                     'ModelCreateArgs': {'additionalProperties': False,
                                         'properties': {'cloud-tag': {'type': 'string'},
                                                        'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                'type': 'object'}},
                                                                   'type': 'object'},
                                                        'credential': {'type': 'string'},
                                                        'name': {'type': 'string'},
                                                        'owner-tag': {'type': 'string'},
                                                        'region': {'type': 'string'}},
                                         'required': ['name', 'owner-tag'],
                                         'type': 'object'},
                     'ModelDefaultValues': {'additionalProperties': False,
                                            'properties': {'cloud-region': {'type': 'string'},
                                                           'cloud-tag': {'type': 'string'},
                                                           'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                   'type': 'object'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelDefaults': {'additionalProperties': False,
                                       'properties': {'controller': {'additionalProperties': True,
                                                                     'type': 'object'},
                                                      'default': {'additionalProperties': True,
                                                                  'type': 'object'},
                                                      'regions': {'items': {'$ref': '#/definitions/RegionDefaults'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ModelDefaultsResult': {'additionalProperties': False,
                                             'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ModelDefaults'}},
                                                                       'type': 'object'}},
                                             'required': ['config'],
                                             'type': 'object'},
                     'ModelInfo': {'additionalProperties': False,
                                   'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                  'cloud-credential-tag': {'type': 'string'},
                                                  'cloud-region': {'type': 'string'},
                                                  'cloud-tag': {'type': 'string'},
                                                  'controller-uuid': {'type': 'string'},
                                                  'default-series': {'type': 'string'},
                                                  'life': {'type': 'string'},
                                                  'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                               'type': 'array'},
                                                  'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                  'name': {'type': 'string'},
                                                  'owner-tag': {'type': 'string'},
                                                  'provider-type': {'type': 'string'},
                                                  'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                  'status': {'$ref': '#/definitions/EntityStatus'},
                                                  'users': {'items': {'$ref': '#/definitions/ModelUserInfo'},
                                                            'type': 'array'},
                                                  'uuid': {'type': 'string'}},
                                   'required': ['name',
                                                'uuid',
                                                'controller-uuid',
                                                'cloud-tag',
                                                'owner-tag',
                                                'life',
                                                'users',
                                                'machines',
                                                'sla',
                                                'agent-version'],
                                   'type': 'object'},
                     'ModelInfoResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/ModelInfo'}},
                                         'type': 'object'},
                     'ModelInfoResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/ModelInfoResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelMigrationStatus': {'additionalProperties': False,
                                              'properties': {'end': {'format': 'date-time',
                                                                     'type': 'string'},
                                                             'start': {'format': 'date-time',
                                                                       'type': 'string'},
                                                             'status': {'type': 'string'}},
                                              'required': ['status', 'start'],
                                              'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelStatus': {'additionalProperties': False,
                                     'properties': {'application-count': {'type': 'integer'},
                                                    'hosted-machine-count': {'type': 'integer'},
                                                    'life': {'type': 'string'},
                                                    'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                                 'type': 'array'},
                                                    'model-tag': {'type': 'string'},
                                                    'owner-tag': {'type': 'string'}},
                                     'required': ['model-tag',
                                                  'life',
                                                  'hosted-machine-count',
                                                  'application-count',
                                                  'owner-tag'],
                                     'type': 'object'},
                     'ModelStatusResults': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelStatus'},
                                                                      'type': 'array'}},
                                            'required': ['models'],
                                            'type': 'object'},
                     'ModelUnsetKeys': {'additionalProperties': False,
                                        'properties': {'cloud-region': {'type': 'string'},
                                                       'cloud-tag': {'type': 'string'},
                                                       'keys': {'items': {'type': 'string'},
                                                                'type': 'array'}},
                                        'required': ['keys'],
                                        'type': 'object'},
                     'ModelUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'last-connection': {'format': 'date-time',
                                                                          'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'last-connection',
                                                    'access'],
                                       'type': 'object'},
                     'ModifyModelAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'model-tag': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'action',
                                                        'access',
                                                        'model-tag'],
                                           'type': 'object'},
                     'ModifyModelAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyModelAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'RegionDefaults': {'additionalProperties': False,
                                        'properties': {'region-name': {'type': 'string'},
                                                       'value': {'additionalProperties': True,
                                                                 'type': 'object'}},
                                        'required': ['region-name', 'value'],
                                        'type': 'object'},
                     'SetModelDefaults': {'additionalProperties': False,
                                          'properties': {'config': {'items': {'$ref': '#/definitions/ModelDefaultValues'},
                                                                    'type': 'array'}},
                                          'required': ['config'],
                                          'type': 'object'},
                     'UnsetModelDefaults': {'additionalProperties': False,
                                            'properties': {'keys': {'items': {'$ref': '#/definitions/ModelUnsetKeys'},
                                                                    'type': 'array'}},
                                            'required': ['keys'],
                                            'type': 'object'},
                     'UserModel': {'additionalProperties': False,
                                   'properties': {'last-connection': {'format': 'date-time',
                                                                      'type': 'string'},
                                                  'model': {'$ref': '#/definitions/Model'}},
                                   'required': ['model', 'last-connection'],
                                   'type': 'object'},
                     'UserModelList': {'additionalProperties': False,
                                       'properties': {'user-models': {'items': {'$ref': '#/definitions/UserModel'},
                                                                      'type': 'array'}},
                                       'required': ['user-models'],
                                       'type': 'object'}},
     'properties': {'CreateModel': {'properties': {'Params': {'$ref': '#/definitions/ModelCreateArgs'},
                                                   'Result': {'$ref': '#/definitions/ModelInfo'}},
                                    'type': 'object'},
                    'DestroyModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'DumpModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/MapResults'}},
                                   'type': 'object'},
                    'DumpModelsDB': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/MapResults'}},
                                     'type': 'object'},
                    'ListModels': {'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                  'Result': {'$ref': '#/definitions/UserModelList'}},
                                   'type': 'object'},
                    'ModelDefaults': {'properties': {'Result': {'$ref': '#/definitions/ModelDefaultsResult'}},
                                      'type': 'object'},
                    'ModelInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/ModelInfoResults'}},
                                  'type': 'object'},
                    'ModelStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ModelStatusResults'}},
                                    'type': 'object'},
                    'ModifyModelAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyModelAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetModelDefaults': {'properties': {'Params': {'$ref': '#/definitions/SetModelDefaults'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'UnsetModelDefaults': {'properties': {'Params': {'$ref': '#/definitions/UnsetModelDefaults'},
                                                          'Result': {'$ref': '#/definitions/ErrorResults'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelInfo)
    async def CreateModel(self, cloud_tag, config, credential, name, owner_tag, region):
        '''
        cloud_tag : str
        config : typing.Mapping[str, typing.Any]
        credential : str
        name : str
        owner_tag : str
        region : str
        Returns -> typing.Union[_ForwardRef('Number'), str, typing.Sequence[~ModelMachineInfo], _ForwardRef('ModelMigrationStatus'), _ForwardRef('ModelSLAInfo'), _ForwardRef('EntityStatus'), typing.Sequence[~ModelUserInfo]]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='CreateModel',
                   version=2,
                   params=_params)
        _params['cloud-tag'] = cloud_tag
        _params['config'] = config
        _params['credential'] = credential
        _params['name'] = name
        _params['owner-tag'] = owner_tag
        _params['region'] = region
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyModels(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DestroyModels',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MapResults)
    async def DumpModels(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MapResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DumpModels',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MapResults)
    async def DumpModelsDB(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~MapResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DumpModelsDB',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserModelList)
    async def ListModels(self, tag):
        '''
        tag : str
        Returns -> typing.Sequence[~UserModel]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ListModels',
                   version=2,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelDefaultsResult)
    async def ModelDefaults(self):
        '''

        Returns -> typing.Mapping[str, ~ModelDefaults]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelDefaults',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfoResults)
    async def ModelInfo(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ModelInfoResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelInfo',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelStatusResults)
    async def ModelStatus(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ModelStatus]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelStatus',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyModelAccess(self, changes):
        '''
        changes : typing.Sequence[~ModifyModelAccess]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModifyModelAccess',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModelDefaults(self, config):
        '''
        config : typing.Sequence[~ModelDefaultValues]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='SetModelDefaults',
                   version=2,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UnsetModelDefaults(self, keys):
        '''
        keys : typing.Sequence[~ModelUnsetKeys]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='UnsetModelDefaults',
                   version=2,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



class ProxyUpdaterFacade(Type):
    name = 'ProxyUpdater'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ProxyConfig': {'additionalProperties': False,
                                     'properties': {'ftp': {'type': 'string'},
                                                    'http': {'type': 'string'},
                                                    'https': {'type': 'string'},
                                                    'no-proxy': {'type': 'string'}},
                                     'required': ['http',
                                                  'https',
                                                  'ftp',
                                                  'no-proxy'],
                                     'type': 'object'},
                     'ProxyConfigResult': {'additionalProperties': False,
                                           'properties': {'apt-proxy-settings': {'$ref': '#/definitions/ProxyConfig'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'juju-proxy-settings': {'$ref': '#/definitions/ProxyConfig'},
                                                          'legacy-proxy-settings': {'$ref': '#/definitions/ProxyConfig'},
                                                          'snap-proxy-settings': {'$ref': '#/definitions/ProxyConfig'},
                                                          'snap-store-assertions': {'type': 'string'},
                                                          'snap-store-id': {'type': 'string'}},
                                           'required': ['legacy-proxy-settings',
                                                        'juju-proxy-settings'],
                                           'type': 'object'},
                     'ProxyConfigResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/ProxyConfigResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'ProxyConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ProxyConfigResults'}},
                                    'type': 'object'},
                    'WatchForProxyConfigAndAPIHostPortChanges': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                                'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ProxyConfigResults)
    async def ProxyConfig(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ProxyConfigResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ProxyUpdater',
                   request='ProxyConfig',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchForProxyConfigAndAPIHostPortChanges(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~NotifyWatchResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ProxyUpdater',
                   request='WatchForProxyConfigAndAPIHostPortChanges',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class RebootFacade(Type):
    name = 'Reboot'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'RebootActionResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'result': {'type': 'string'}},
                                            'type': 'object'},
                     'RebootActionResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/RebootActionResult'},
                                                                        'type': 'array'}},
                                             'type': 'object'}},
     'properties': {'ClearReboot': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'GetRebootAction': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/RebootActionResults'}},
                                        'type': 'object'},
                    'RequestReboot': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'WatchForRebootEvent': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ClearReboot(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot',
                   request='ClearReboot',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RebootActionResults)
    async def GetRebootAction(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~RebootActionResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot',
                   request='GetRebootAction',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RequestReboot(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot',
                   request='RequestReboot',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForRebootEvent(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot',
                   request='WatchForRebootEvent',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ResumerFacade(Type):
    name = 'Resumer'
    version = 2
    schema =     {'properties': {'ResumeTransactions': {'type': 'object'}}, 'type': 'object'}
    

    @ReturnMapping(None)
    async def ResumeTransactions(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Resumer',
                   request='ResumeTransactions',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class SSHClientFacade(Type):
    name = 'SSHClient'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SSHAddressResult': {'additionalProperties': False,
                                          'properties': {'address': {'type': 'string'},
                                                         'error': {'$ref': '#/definitions/Error'}},
                                          'type': 'object'},
                     'SSHAddressResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/SSHAddressResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'SSHAddressesResult': {'additionalProperties': False,
                                            'properties': {'addresses': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'}},
                                            'required': ['addresses'],
                                            'type': 'object'},
                     'SSHAddressesResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/SSHAddressesResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'SSHProxyResult': {'additionalProperties': False,
                                        'properties': {'use-proxy': {'type': 'boolean'}},
                                        'required': ['use-proxy'],
                                        'type': 'object'},
                     'SSHPublicKeysResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'public-keys': {'items': {'type': 'string'},
                                                                            'type': 'array'}},
                                             'type': 'object'},
                     'SSHPublicKeysResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/SSHPublicKeysResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'}},
     'properties': {'AllAddresses': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/SSHAddressesResults'}},
                                     'type': 'object'},
                    'PrivateAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/SSHAddressResults'}},
                                       'type': 'object'},
                    'Proxy': {'properties': {'Result': {'$ref': '#/definitions/SSHProxyResult'}},
                              'type': 'object'},
                    'PublicAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/SSHAddressResults'}},
                                      'type': 'object'},
                    'PublicKeys': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/SSHPublicKeysResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(SSHAddressesResults)
    async def AllAddresses(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~SSHAddressesResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='AllAddresses',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHAddressResults)
    async def PrivateAddress(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~SSHAddressResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='PrivateAddress',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHProxyResult)
    async def Proxy(self):
        '''

        Returns -> bool
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='Proxy',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHAddressResults)
    async def PublicAddress(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~SSHAddressResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='PublicAddress',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHPublicKeysResults)
    async def PublicKeys(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~SSHPublicKeysResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='PublicKeys',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SingularFacade(Type):
    name = 'Singular'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SingularClaim': {'additionalProperties': False,
                                       'properties': {'claimant-tag': {'type': 'string'},
                                                      'duration': {'type': 'integer'},
                                                      'entity-tag': {'type': 'string'}},
                                       'required': ['entity-tag',
                                                    'claimant-tag',
                                                    'duration'],
                                       'type': 'object'},
                     'SingularClaims': {'additionalProperties': False,
                                        'properties': {'claims': {'items': {'$ref': '#/definitions/SingularClaim'},
                                                                  'type': 'array'}},
                                        'required': ['claims'],
                                        'type': 'object'}},
     'properties': {'Claim': {'properties': {'Params': {'$ref': '#/definitions/SingularClaims'},
                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                              'type': 'object'},
                    'Wait': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def Claim(self, claims):
        '''
        claims : typing.Sequence[~SingularClaim]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Singular',
                   request='Claim',
                   version=2,
                   params=_params)
        _params['claims'] = claims
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Wait(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Singular',
                   request='Wait',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SpacesFacade(Type):
    name = 'Spaces'
    version = 2
    schema =     {'definitions': {'CreateSpaceParams': {'additionalProperties': False,
                                           'properties': {'provider-id': {'type': 'string'},
                                                          'public': {'type': 'boolean'},
                                                          'space-tag': {'type': 'string'},
                                                          'subnet-tags': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                           'required': ['subnet-tags',
                                                        'space-tag',
                                                        'public'],
                                           'type': 'object'},
                     'CreateSpacesParams': {'additionalProperties': False,
                                            'properties': {'spaces': {'items': {'$ref': '#/definitions/CreateSpaceParams'},
                                                                      'type': 'array'}},
                                            'required': ['spaces'],
                                            'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSpacesResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/Space'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Space': {'additionalProperties': False,
                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                              'name': {'type': 'string'},
                                              'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                          'type': 'array'}},
                               'required': ['name', 'subnets'],
                               'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'}},
     'properties': {'CreateSpaces': {'properties': {'Params': {'$ref': '#/definitions/CreateSpacesParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListSpaces': {'properties': {'Result': {'$ref': '#/definitions/ListSpacesResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def CreateSpaces(self, spaces):
        '''
        spaces : typing.Sequence[~CreateSpaceParams]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='CreateSpaces',
                   version=2,
                   params=_params)
        _params['spaces'] = spaces
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSpacesResults)
    async def ListSpaces(self):
        '''

        Returns -> typing.Sequence[~Space]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='ListSpaces',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class StatusHistoryFacade(Type):
    name = 'StatusHistory'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'StatusHistoryPruneArgs': {'additionalProperties': False,
                                                'properties': {'max-history-mb': {'type': 'integer'},
                                                               'max-history-time': {'type': 'integer'}},
                                                'required': ['max-history-time',
                                                             'max-history-mb'],
                                                'type': 'object'}},
     'properties': {'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'Prune': {'properties': {'Params': {'$ref': '#/definitions/StatusHistoryPruneArgs'}},
                              'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> typing.Mapping[str, typing.Any]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StatusHistory',
                   request='ModelConfig',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Prune(self, max_history_mb, max_history_time):
        '''
        max_history_mb : int
        max_history_time : int
        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StatusHistory',
                   request='Prune',
                   version=2,
                   params=_params)
        _params['max-history-mb'] = max_history_mb
        _params['max-history-time'] = max_history_time
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> typing.Union[str, _ForwardRef('Error')]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StatusHistory',
                   request='WatchForModelConfigChanges',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class SubnetsFacade(Type):
    name = 'Subnets'
    version = 2
    schema =     {'definitions': {'AddSubnetParams': {'additionalProperties': False,
                                         'properties': {'provider-network-id': {'type': 'string'},
                                                        'space-tag': {'type': 'string'},
                                                        'subnet-provider-id': {'type': 'string'},
                                                        'subnet-tag': {'type': 'string'},
                                                        'vlan-tag': {'type': 'integer'},
                                                        'zones': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                         'required': ['space-tag'],
                                         'type': 'object'},
                     'AddSubnetsParams': {'additionalProperties': False,
                                          'properties': {'subnets': {'items': {'$ref': '#/definitions/AddSubnetParams'},
                                                                     'type': 'array'}},
                                          'required': ['subnets'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSubnetsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/Subnet'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SpaceResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'tag': {'type': 'string'}},
                                     'required': ['tag'],
                                     'type': 'object'},
                     'SpaceResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/SpaceResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'SubnetsFilters': {'additionalProperties': False,
                                        'properties': {'space-tag': {'type': 'string'},
                                                       'zone': {'type': 'string'}},
                                        'type': 'object'},
                     'ZoneResult': {'additionalProperties': False,
                                    'properties': {'available': {'type': 'boolean'},
                                                   'error': {'$ref': '#/definitions/Error'},
                                                   'name': {'type': 'string'}},
                                    'required': ['name', 'available'],
                                    'type': 'object'},
                     'ZoneResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/ZoneResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'}},
     'properties': {'AddSubnets': {'properties': {'Params': {'$ref': '#/definitions/AddSubnetsParams'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'AllSpaces': {'properties': {'Result': {'$ref': '#/definitions/SpaceResults'}},
                                  'type': 'object'},
                    'AllZones': {'properties': {'Result': {'$ref': '#/definitions/ZoneResults'}},
                                 'type': 'object'},
                    'ListSubnets': {'properties': {'Params': {'$ref': '#/definitions/SubnetsFilters'},
                                                   'Result': {'$ref': '#/definitions/ListSubnetsResults'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddSubnets(self, subnets):
        '''
        subnets : typing.Sequence[~AddSubnetParams]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='AddSubnets',
                   version=2,
                   params=_params)
        _params['subnets'] = subnets
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SpaceResults)
    async def AllSpaces(self):
        '''

        Returns -> typing.Sequence[~SpaceResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='AllSpaces',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ZoneResults)
    async def AllZones(self):
        '''

        Returns -> typing.Sequence[~ZoneResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='AllZones',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSubnetsResults)
    async def ListSubnets(self, space_tag, zone):
        '''
        space_tag : str
        zone : str
        Returns -> typing.Sequence[~Subnet]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='ListSubnets',
                   version=2,
                   params=_params)
        _params['space-tag'] = space_tag
        _params['zone'] = zone
        reply = await self.rpc(msg)
        return reply



class UserManagerFacade(Type):
    name = 'UserManager'
    version = 2
    schema =     {'definitions': {'AddUser': {'additionalProperties': False,
                                 'properties': {'display-name': {'type': 'string'},
                                                'password': {'type': 'string'},
                                                'username': {'type': 'string'}},
                                 'required': ['username', 'display-name'],
                                 'type': 'object'},
                     'AddUserResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'secret-key': {'items': {'type': 'integer'},
                                                                     'type': 'array'},
                                                      'tag': {'type': 'string'}},
                                       'type': 'object'},
                     'AddUserResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/AddUserResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'AddUsers': {'additionalProperties': False,
                                  'properties': {'users': {'items': {'$ref': '#/definitions/AddUser'},
                                                           'type': 'array'}},
                                  'required': ['users'],
                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'UserInfo': {'additionalProperties': False,
                                  'properties': {'access': {'type': 'string'},
                                                 'created-by': {'type': 'string'},
                                                 'date-created': {'format': 'date-time',
                                                                  'type': 'string'},
                                                 'disabled': {'type': 'boolean'},
                                                 'display-name': {'type': 'string'},
                                                 'last-connection': {'format': 'date-time',
                                                                     'type': 'string'},
                                                 'username': {'type': 'string'}},
                                  'required': ['username',
                                               'display-name',
                                               'access',
                                               'created-by',
                                               'date-created',
                                               'disabled'],
                                  'type': 'object'},
                     'UserInfoRequest': {'additionalProperties': False,
                                         'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                     'type': 'array'},
                                                        'include-disabled': {'type': 'boolean'}},
                                         'required': ['entities',
                                                      'include-disabled'],
                                         'type': 'object'},
                     'UserInfoResult': {'additionalProperties': False,
                                        'properties': {'error': {'$ref': '#/definitions/Error'},
                                                       'result': {'$ref': '#/definitions/UserInfo'}},
                                        'type': 'object'},
                     'UserInfoResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/UserInfoResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'}},
     'properties': {'AddUser': {'properties': {'Params': {'$ref': '#/definitions/AddUsers'},
                                               'Result': {'$ref': '#/definitions/AddUserResults'}},
                                'type': 'object'},
                    'DisableUser': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'EnableUser': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'RemoveUser': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'ResetPassword': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/AddUserResults'}},
                                      'type': 'object'},
                    'SetPassword': {'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'UserInfo': {'properties': {'Params': {'$ref': '#/definitions/UserInfoRequest'},
                                                'Result': {'$ref': '#/definitions/UserInfoResults'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddUserResults)
    async def AddUser(self, users):
        '''
        users : typing.Sequence[~AddUser]
        Returns -> typing.Sequence[~AddUserResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='AddUser',
                   version=2,
                   params=_params)
        _params['users'] = users
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DisableUser(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='DisableUser',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnableUser(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='EnableUser',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveUser(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='RemoveUser',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddUserResults)
    async def ResetPassword(self, entities):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> typing.Sequence[~AddUserResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='ResetPassword',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPassword(self, changes):
        '''
        changes : typing.Sequence[~EntityPassword]
        Returns -> typing.Sequence[~ErrorResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='SetPassword',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserInfoResults)
    async def UserInfo(self, entities, include_disabled):
        '''
        entities : typing.Sequence[~Entity]
        include_disabled : bool
        Returns -> typing.Sequence[~UserInfoResult]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='UserInfo',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        _params['include-disabled'] = include_disabled
        reply = await self.rpc(msg)
        return reply



class VolumeAttachmentsWatcherFacade(Type):
    name = 'VolumeAttachmentsWatcher'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineStorageId': {'additionalProperties': False,
                                          'properties': {'attachment-tag': {'type': 'string'},
                                                         'machine-tag': {'type': 'string'}},
                                          'required': ['machine-tag',
                                                       'attachment-tag'],
                                          'type': 'object'},
                     'MachineStorageIdsWatchResult': {'additionalProperties': False,
                                                      'properties': {'changes': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                                 'type': 'array'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'watcher-id': {'type': 'string'}},
                                                      'required': ['watcher-id',
                                                                   'changes'],
                                                      'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MachineStorageIdsWatchResult)
    async def Next(self):
        '''

        Returns -> typing.Union[typing.Sequence[~MachineStorageId], _ForwardRef('Error'), str]
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='VolumeAttachmentsWatcher',
                   request='Next',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''
        # map input types to rpc msg
        _params = dict()
        msg = dict(type='VolumeAttachmentsWatcher',
                   request='Stop',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply
