# Copyright 2017 iIntel Research and Development Ireland Limited
# *************************************************************

# This file is part of OSM Monitoring module
# All Rights Reserved to Intel Corporation

# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at

#         http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

# For those usages not covered by the Apache License, Version 2.0 please
# contact: helena.mcgough@intel.com or adrian.hoban@intel.com
##
"""Test that the correct responses are generated for each message."""

import logging

import unittest

import mock

from osm_mon.plugins.OpenStack import response as resp

log = logging.getLogger(__name__)


class TestOpenStackResponse(unittest.TestCase):
    """Tests for responses generated by the OpenStack plugins."""

    def setUp(self):
        """Setup for testing OpenStack plugin responses."""
        super(TestOpenStackResponse, self).setUp()
        self.plugin_resp = resp.OpenStack_Response()

    def test_invalid_key(self):
        """Test if an invalid key is entered for a response."""
        message = self.plugin_resp.generate_response("mock_invalid_key")
        self.assertEqual(message, None)

    @mock.patch.object(
        resp.OpenStack_Response, "alarm_list_response")
    def test_list_alarm_resp(self, alarm_list_resp):
        """Test out a function call for a list alarm response."""
        message = self.plugin_resp.generate_response("list_alarm_response")
        self.assertEqual(alarm_list_resp.return_value, message)

    @mock.patch.object(
        resp.OpenStack_Response, "list_metric_response")
    def test_list_metric_resp(self, metric_list_resp):
        """Test list metric response function call."""
        message = self.plugin_resp.generate_response("list_metric_response")
        self.assertEqual(message, metric_list_resp.return_value)

    @mock.patch.object(
        resp.OpenStack_Response, "delete_alarm_response")
    def test_delete_alarm_resp(self, del_alarm_resp):
        """Test delete alarm response function call."""
        message = self.plugin_resp.generate_response("delete_alarm_response")
        self.assertEqual(message, del_alarm_resp.return_value)

    @mock.patch.object(
        resp.OpenStack_Response, "delete_metric_response")
    def test_delete_metric_resp(self, del_metric_resp):
        """Test the response functionality of delete metric response."""
        message = self.plugin_resp.generate_response("delete_metric_response")
        self.assertEqual(message, del_metric_resp.return_value)

    @mock.patch.object(
        resp.OpenStack_Response, "create_alarm_response")
    def test_create_alarm_resp(self, config_alarm_resp):
        """Test create alarm response function call."""
        message = self.plugin_resp.generate_response("create_alarm_response")
        self.assertEqual(message, config_alarm_resp.return_value)

    @mock.patch.object(
        resp.OpenStack_Response, "metric_create_response")
    def test_create_metric_resp(self, config_metric_resp):
        """Test create metric response function call."""
        message = self.plugin_resp.generate_response("create_metric_response")
        self.assertEqual(message, config_metric_resp.return_value)

    @mock.patch.object(
        resp.OpenStack_Response, "update_alarm_response")
    def test_update_alarm_resp(self, up_alarm_resp):
        """Test update alarm response function call."""
        message = self.plugin_resp.generate_response("update_alarm_response")
        self.assertEqual(message, up_alarm_resp.return_value)

    @mock.patch.object(
        resp.OpenStack_Response, "update_metric_response")
    def test_update_metric_resp(self, up_metric_resp):
        """Test update metric response function call."""
        message = self.plugin_resp.generate_response("update_metric_response")
        self.assertEqual(message, up_metric_resp.return_value)

    @mock.patch.object(
        resp.OpenStack_Response, "notify_alarm")
    def test_notify_alarm(self, notify_alarm):
        """Test notify alarm response function call."""
        message = self.plugin_resp.generate_response("notify_alarm")
        self.assertEqual(message, notify_alarm.return_value)

    @mock.patch.object(
        resp.OpenStack_Response, "read_metric_data_response")
    def test_read_metric_data_resp(self, read_data_resp):
        """Test read metric data response function call."""
        message = self.plugin_resp.generate_response(
            "read_metric_data_response")
        self.assertEqual(message, read_data_resp.return_value)
