#######################################################################################
# Copyright ETSI Contributors and Others.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from temporalio import workflow

from osm_common.temporal.workflows.lcm import NsNoOpWorkflow
from osm_common.temporal.activities.lcm import NsLcmNoOp


@workflow.defn(name=NsNoOpWorkflow.__name__, sandboxed=False)
class NsNoOpWorkflowImpl(NsNoOpWorkflow):
    """
    This is a simple No Operation workflow that simply calls a No Operation
    activity.  It can be used as a placeholder when developing workflows.
    """

    @workflow.run
    async def wrap_nslcmop(self, workflow_input: NsNoOpWorkflow.Input) -> None:
        await super().wrap_nslcmop(workflow_input=workflow_input)

    async def run(self, workflow_input: NsNoOpWorkflow.Input) -> None:
        self.logger.debug(f"Called with: {workflow_input.nslcmop}")

        await workflow.execute_activity(
            activity=NsLcmNoOp.__name__,
            arg=workflow_input,
            activity_id=f"{NsLcmNoOp.__name__}-{self.op_id}",
            schedule_to_close_timeout=NsNoOpWorkflow.default_schedule_to_close_timeout,
            retry_policy=NsNoOpWorkflow.retry_policy,
        )
