# -*- coding: utf-8 -*-

##
# Copyright 2019 Tech Mahindra Limited
#
# All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
##

## Change log:
# 1. Feature 7829: Jayant Madavi, Mrityunjay Yadav : MY00514913@techmahindra.com : 06-aug-2019 : Improvement to the code, robot framework initial seed code.
##


*** Settings ***
Documentation    Test Suite to create and delete vim account
Library     Collections
Library     RequestsLibrary
Library     OperatingSystem
Resource    ../../lib/api/common.robot
Resource    ../../lib/api/vim_lib.robot
Resource    ../../resource/api/common.robot
Variables   ../../resource/api/variables.py

Suite Setup     Get Auth Token
Suite Teardown  Delete All Sessions


*** Variables ***
${vim_id}   ${EMPTY}


*** Test Cases ***
Create Vim Account
    [Tags]    comprehensive   api_vim_test
    [Template]  Create Vim
    ${vim name}     ${account type}     ${auth url}     ${user}     ${password}     ${tenant}       ${description}


Delete Vim Account
    [Tags]    comprehensive   api_vim_test
    [Template]  Delete Vim
    ${vim_id}
