<!--
 Copyright 2020 Canonical Ltd.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 For those usages not covered by the Apache License, Version 2.0 please
 contact: legal@canonical.com

 To get in touch with the maintainers, please contact:
 osm-charmers@lists.launchpad.net
-->

# Debugging Charmed OSM

This document aims to provide the OSM community an easy way of testing and debugging OSM.

Benefits:

- Use upstream published images for debugging: No need to build local images anymore.
- Easily configure modules for debugging_mode: `juju config <module> debug_mode=True debug_pubkey="ssh-rsa ..."`.
- Debug in K8s: All pods (the debugged ones and the rest) will be running always in K8s.
- Seemless setup: VSCode will connect through SSH to the pods.

## Install OSM

Download the installer:

```bash
wget http://osm-download.etsi.org/ftp/osm-10.0-ten/install_osm.sh
chmod +x install_osm.sh
```

Install OSM from master (tag=testing-daily):

```bash
./install_osm.sh -R testing-daily -r testing --charmed
```

Install OSM from a specific tag:

```bash
./install_osm.sh -R testing-daily -r testing --charmed --tag <X.Y.Z>
```

## Debugging

Once the Charmed OSM installation has finished, you can select which applications you want to run with the debug mode.

- lcm: `juju config lcm debug_mode=True  debug_pubkey="ssh-rsa ..."`
- mon: `juju config mon debug_mode=True debug_pubkey="ssh-rsa ..."`
- nbi: `juju config nbi debug_mode=True debug_pubkey="ssh-rsa ..."`
- ro: `juju config ro debug_mode=True debug_pubkey="ssh-rsa ..."`
- pol: `juju config pol debug_mode=True debug_pubkey="ssh-rsa ..."`

Enabling the debug_mode will put a `sleep infinity` as the entrypoint of the container. That way, we can later connect to the pod through SSH in VSCode, and run the entrypoint of the application from the debugger.

### Prepare pods

Preparing the pods includes setting up the ~/.ssh/config so the VSCode can easily discover which ssh hosts are available

Just execute:

```bash
./prepare_pods.sh
```

> NOTE: The public key that will be used will be `$HOME/.ssh/id_rsa.pub`. If you want to use a different one, add the absolute path to it as a first argument: `./prepare_pods.sh /path/to/key.pub`.

### Connect to Pods

In VScode, navigate to [Remote Explorer](https://code.visualstudio.com/docs/remote/ssh#_remember-hosts-and-advanced-settings), and select the pod to which you want to connect.

You should be able to see the following hosts in the Remote Explorer:

- lcm
- mon
- nbi
- ro
- pol

Right click on the host, and "Connect to host in a New Window".

### Add workspace

The `./prepare_pods.sh` script adds a workspace to the `/root` folder of each pod, with the following name: `<module>.code-workspace`.

In the window of the connected host, go to `File/Open Workspace...`. Then select the `<module>.code-workspace` file.

### Run and Debug

Go to extensions and install the Python extension. It will be installed in the remote pod.

Now we need to add a [debug configuration](https://code.visualstudio.com/docs/editor/debugging). For that, go to the Run and Debug tab, and click on `create a launch.json file`.

Now you will be asked to select a folder in your workspace. Select the folder of the main component:

- LCM: select osm_lcm
- MON: select osm_mon
- NBI: select osm_nbi
- RO: select osm_ng_ro
- POL: select osm_policy_module

Then select `Python` as the environment. And finally, select `Module` and enter the module of the component you are going to test (LCM example: osm_lcm.lcm)
