#!/bin/bash
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#

source ../common/track

RELEASE="ReleaseTEN"
OSM_DOCKER_TAG=latest
OSM_TRACK_INSTALLATION_ID="$(date +%s)-$(head /dev/urandom | tr -dc A-Za-z0-9 | head -c 16)"

track
track start
sleep 1
track start release $RELEASE
sleep 1
track start docker_tag $OSM_DOCKER_TAG none none
sleep 1
track start release $RELEASE none none docker_tag $OSM_DOCKER_TAG none none
sleep 1
track my-event my-op my-value "My comment" "tag1,tag2"
sleep 1
track my-second-event op1 value1 "My comment1 on second event" none op2 value2 "My comment2 on second event" none

